/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.IndexRouting;
import org.opensearch.client.opensearch.nodes.info.NodeInfoSettingsClusterElection;
import org.opensearch.client.opensearch.nodes.info.NodeInfoSettingsDeprecationIndexing;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeInfoSettingsCluster
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeInfoSettingsCluster> {
    @Nullable
    private final NodeInfoSettingsDeprecationIndexing deprecationIndexing;
    @Nullable
    private final NodeInfoSettingsClusterElection election;
    @Nonnull
    private final List<String> initialClusterManagerNodes;
    @Nonnull
    private final List<String> initialMasterNodes;
    @Nonnull
    private final String name;
    @Nullable
    private final IndexRouting routing;
    public static final JsonpDeserializer<NodeInfoSettingsCluster> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsCluster::setupNodeInfoSettingsClusterDeserializer);

    private NodeInfoSettingsCluster(Builder builder) {
        this.deprecationIndexing = builder.deprecationIndexing;
        this.election = builder.election;
        this.initialClusterManagerNodes = ApiTypeHelper.unmodifiable(builder.initialClusterManagerNodes);
        this.initialMasterNodes = ApiTypeHelper.unmodifiable(builder.initialMasterNodes);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.routing = builder.routing;
    }

    public static NodeInfoSettingsCluster of(Function<Builder, ObjectBuilder<NodeInfoSettingsCluster>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final NodeInfoSettingsDeprecationIndexing deprecationIndexing() {
        return this.deprecationIndexing;
    }

    @Nullable
    public final NodeInfoSettingsClusterElection election() {
        return this.election;
    }

    @Nonnull
    public final List<String> initialClusterManagerNodes() {
        return this.initialClusterManagerNodes;
    }

    @Nonnull
    public final List<String> initialMasterNodes() {
        return this.initialMasterNodes;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final IndexRouting routing() {
        return this.routing;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.deprecationIndexing != null) {
            generator.writeKey("deprecation_indexing");
            this.deprecationIndexing.serialize(generator, mapper);
        }
        if (this.election != null) {
            generator.writeKey("election");
            this.election.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.initialClusterManagerNodes)) {
            generator.writeKey("initial_cluster_manager_nodes");
            generator.writeStartArray();
            for (String item0 : this.initialClusterManagerNodes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.initialMasterNodes)) {
            generator.writeKey("initial_master_nodes");
            generator.writeStartArray();
            for (String item0 : this.initialMasterNodes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.routing != null) {
            generator.writeKey("routing");
            this.routing.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeInfoSettingsClusterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deprecationIndexing, NodeInfoSettingsDeprecationIndexing._DESERIALIZER, "deprecation_indexing");
        op.add(Builder::election, NodeInfoSettingsClusterElection._DESERIALIZER, "election");
        op.add(Builder::initialClusterManagerNodes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "initial_cluster_manager_nodes");
        op.add(Builder::initialMasterNodes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "initial_master_nodes");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::routing, IndexRouting._DESERIALIZER, "routing");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.deprecationIndexing);
        result = 31 * result + Objects.hashCode(this.election);
        result = 31 * result + Objects.hashCode(this.initialClusterManagerNodes);
        result = 31 * result + Objects.hashCode(this.initialMasterNodes);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.routing);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoSettingsCluster other = (NodeInfoSettingsCluster)o;
        return Objects.equals(this.deprecationIndexing, other.deprecationIndexing) && Objects.equals(this.election, other.election) && Objects.equals(this.initialClusterManagerNodes, other.initialClusterManagerNodes) && Objects.equals(this.initialMasterNodes, other.initialMasterNodes) && this.name.equals(other.name) && Objects.equals(this.routing, other.routing);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeInfoSettingsCluster> {
        @Nullable
        private NodeInfoSettingsDeprecationIndexing deprecationIndexing;
        @Nullable
        private NodeInfoSettingsClusterElection election;
        @Nullable
        private List<String> initialClusterManagerNodes;
        @Nullable
        private List<String> initialMasterNodes;
        private String name;
        @Nullable
        private IndexRouting routing;

        public Builder() {
        }

        private Builder(NodeInfoSettingsCluster o) {
            this.deprecationIndexing = o.deprecationIndexing;
            this.election = o.election;
            this.initialClusterManagerNodes = Builder._listCopy(o.initialClusterManagerNodes);
            this.initialMasterNodes = Builder._listCopy(o.initialMasterNodes);
            this.name = o.name;
            this.routing = o.routing;
        }

        private Builder(Builder o) {
            this.deprecationIndexing = o.deprecationIndexing;
            this.election = o.election;
            this.initialClusterManagerNodes = Builder._listCopy(o.initialClusterManagerNodes);
            this.initialMasterNodes = Builder._listCopy(o.initialMasterNodes);
            this.name = o.name;
            this.routing = o.routing;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder deprecationIndexing(@Nullable NodeInfoSettingsDeprecationIndexing value) {
            this.deprecationIndexing = value;
            return this;
        }

        @Nonnull
        public final Builder deprecationIndexing(Function<NodeInfoSettingsDeprecationIndexing.Builder, ObjectBuilder<NodeInfoSettingsDeprecationIndexing>> fn) {
            return this.deprecationIndexing(fn.apply(new NodeInfoSettingsDeprecationIndexing.Builder()).build());
        }

        @Nonnull
        public final Builder election(@Nullable NodeInfoSettingsClusterElection value) {
            this.election = value;
            return this;
        }

        @Nonnull
        public final Builder election(Function<NodeInfoSettingsClusterElection.Builder, ObjectBuilder<NodeInfoSettingsClusterElection>> fn) {
            return this.election(fn.apply(new NodeInfoSettingsClusterElection.Builder()).build());
        }

        @Nonnull
        public final Builder initialClusterManagerNodes(List<String> list) {
            this.initialClusterManagerNodes = Builder._listAddAll(this.initialClusterManagerNodes, list);
            return this;
        }

        @Nonnull
        public final Builder initialClusterManagerNodes(String value, String ... values) {
            this.initialClusterManagerNodes = Builder._listAdd(this.initialClusterManagerNodes, value, values);
            return this;
        }

        @Nonnull
        public final Builder initialMasterNodes(List<String> list) {
            this.initialMasterNodes = Builder._listAddAll(this.initialMasterNodes, list);
            return this;
        }

        @Nonnull
        public final Builder initialMasterNodes(String value, String ... values) {
            this.initialMasterNodes = Builder._listAdd(this.initialMasterNodes, value, values);
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder routing(@Nullable IndexRouting value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder routing(Function<IndexRouting.Builder, ObjectBuilder<IndexRouting>> fn) {
            return this.routing(fn.apply(new IndexRouting.Builder()).build());
        }

        @Override
        @Nonnull
        public NodeInfoSettingsCluster build() {
            this._checkSingleUse();
            return new NodeInfoSettingsCluster(this);
        }
    }
}

