/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_or extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u0b2b\u0b3f\u0b1c\u0b3f";
        final String metaValue_NR = "\u0b28\u0b3e\u0b09\u0b30\u0b41";
        final String metaValue_SO = "\u0b38\u0b4b\u0b2e\u0b3e\u0b32\u0b3f\u0b06";
        final String metaValue_TO = "\u0b1f\u0b4b\u0b19\u0b4d\u0b17\u0b3e";
        final String metaValue_TK = "\u0b1f\u0b4b\u0b15\u0b47\u0b32\u0b3e\u0b09";
        final String metaValue_TV = "\u0b24\u0b41\u0b2d\u0b3e\u0b32\u0b41";
        final String metaValue_ar = "\u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d";
        final String metaValue_ban = "\u0b2c\u0b3e\u0b32\u0b3f\u0b28\u0b40\u0b1c\u0b4d";
        final String metaValue_zbl = "\u0b2c\u0b4d\u0b32\u0b3f\u0b38\u0b3f\u0b2e\u0b4d\u0b2c\u0b32\u0b38\u0b4d";
        final String metaValue_ccp = "\u0b1a\u0b15\u0b2e\u0b3e";
        final String metaValue_ka = "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b5f";
        final String metaValue_got = "\u0b17\u0b4b\u0b25\u0b3f\u0b15\u0b4d";
        final String metaValue_el = "\u0b17\u0b4d\u0b30\u0b40\u0b15\u0b4d";
        final String metaValue_gu = "\u0b17\u0b41\u0b1c\u0b41\u0b30\u0b3e\u0b1f\u0b40";
        final String metaValue_jv = "\u0b1c\u0b3e\u0b2d\u0b3e\u0b28\u0b40\u0b1c\u0b4d";
        final String metaValue_ko = "\u0b15\u0b4b\u0b30\u0b3f\u0b06\u0b28\u0b4d";
        final String metaValue_lo = "\u0b32\u0b3e\u0b13";
        final String metaValue_la = "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d";
        final String metaValue_ml = "\u0b2e\u0b3e\u0b32\u0b3e\u0b5f\u0b32\u0b2e\u0b4d";
        final String metaValue_or = "\u0b13\u0b21\u0b3c\u0b3f\u0b06";
        final String metaValue_si = "\u0b38\u0b3f\u0b02\u0b39\u0b33";
        final String metaValue_su = "\u0b38\u0b41\u0b26\u0b3e\u0b28\u0b40\u0b1c\u0b4d";
        final String metaValue_ta = "\u0b24\u0b3e\u0b2e\u0b3f\u0b32\u0b4d";
        final String metaValue_te = "\u0b24\u0b47\u0b32\u0b41\u0b17\u0b41";
        final String metaValue_th = "\u0b25\u0b3e\u0b07";
        final String metaValue_cop = "\u0b15\u0b2a\u0b4d\u0b1f\u0b3f\u0b15\u0b4d";
        final Object[][] data = new Object[][] {
            { "001", "\u0b2c\u0b3f\u0b36\u0b4d\u0b71" },
            { "002", "\u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "003", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "005", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "009", "\u0b13\u0b38\u0b3f\u0b28\u0b3f\u0b06" },
            { "011", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "013", "\u0b2e\u0b27\u0b4d\u0b5f \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "014", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "015", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "017", "\u0b2e\u0b27\u0b4d\u0b5f \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "018", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23\u0b38\u0b4d\u0b25 \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "019", "\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "021", "\u0b09\u0b24\u0b4d\u0b24\u0b30\u0b38\u0b4d\u0b25 \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "029", "\u0b15\u0b3e\u0b30\u0b3f\u0b2c\u0b3f\u0b06\u0b28\u0b4d" },
            { "030", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b0f\u0b38\u0b3f\u0b06" },
            { "034", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b0f\u0b38\u0b3f\u0b06" },
            { "035", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b0f\u0b38\u0b3f\u0b06" },
            { "039", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "053", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b47\u0b38\u0b3f\u0b06" },
            { "054", "\u0b2e\u0b47\u0b32\u0b3e\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "057", "\u0b2e\u0b3e\u0b07\u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06\u0b28\u0b4d \u0b05\u0b1e\u0b4d\u0b1a\u0b33" },
            { "061", "\u0b2a\u0b32\u0b3f\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "142", "\u0b0f\u0b38\u0b3f\u0b06" },
            { "143", "\u0b2e\u0b27\u0b4d\u0b5f \u0b0f\u0b38\u0b3f\u0b06" },
            { "145", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b0f\u0b38\u0b3f\u0b06" },
            { "150", "\u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "151", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "154", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "155", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b4d" },
            { "202", "\u0b09\u0b2a-\u0b38\u0b3e\u0b39\u0b3e\u0b30\u0b3e \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "419", "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d\u200c \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "AC", "\u0b06\u0b38\u0b47\u0b28\u0b38\u0b3f\u0b05\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "AD", "\u0b06\u0b23\u0b4d\u0b21\u0b4b\u0b30\u0b3e" },
            { "AE", "\u0b38\u0b02\u0b2f\u0b41\u0b15\u0b4d\u0b24 \u0b06\u0b30\u0b2c \u0b0f\u0b2e\u0b3f\u0b30\u0b47\u0b1f\u0b38\u0b4d" },
            { "AF", "\u0b06\u0b2b\u0b17\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b4d" },
            { "AG", "\u0b06\u0b23\u0b4d\u0b1f\u0b3f\u0b17\u0b41\u0b06 \u0b0f\u0b2c\u0b02 \u0b2c\u0b3e\u0b30\u0b2c\u0b41\u0b26\u0b3e" },
            { "AI", "\u0b06\u0b19\u0b4d\u0b17\u0b41\u0b07\u0b32\u0b4d\u0b32\u0b3e" },
            { "AL", "\u0b06\u0b32\u0b2c\u0b3e\u0b28\u0b3f\u0b06" },
            { "AM", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b06" },
            { "AO", "\u0b06\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3e" },
            { "AQ", "\u0b06\u0b23\u0b4d\u0b1f\u0b3e\u0b30\u0b4d\u0b15\u0b3e\u0b1f\u0b3f\u0b15\u0b3e" },
            { "AR", "\u0b06\u0b30\u0b4d\u0b1c\u0b47\u0b23\u0b4d\u0b1f\u0b3f\u0b28\u0b3e" },
            { "AS", "\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e\u0b28\u0b4d \u0b38\u0b3e\u0b2e\u0b4b\u0b06" },
            { "AT", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3f\u0b06" },
            { "AU", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b3f\u0b06" },
            { "AW", "\u0b06\u0b30\u0b41\u0b2c\u0b3e" },
            { "AX", "\u0b05\u0b32\u0b3e\u0b23\u0b4d\u0b21 \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "AZ", "\u0b06\u0b1c\u0b47\u0b30\u0b2c\u0b3e\u0b07\u0b1c\u0b3e\u0b28\u0b4d" },
            { "BA", "\u0b2c\u0b4b\u0b38\u0b28\u0b3f\u0b06 \u0b0f\u0b2c\u0b02 \u0b39\u0b30\u0b4d\u0b1c\u0b17\u0b4b\u0b2d\u0b3f\u0b28\u0b3e" },
            { "BB", "\u0b2c\u0b3e\u0b30\u0b2c\u0b3e\u0b21\u0b4b\u0b38\u0b4d" },
            { "BD", "\u0b2c\u0b3e\u0b02\u0b32\u0b3e\u0b26\u0b47\u0b36" },
            { "BE", "\u0b2c\u0b47\u0b32\u0b1c\u0b3f\u0b5f\u0b2e\u0b4d" },
            { "BF", "\u0b2c\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b28\u0b3e \u0b2b\u0b3e\u0b38\u0b4b" },
            { "BG", "\u0b2c\u0b41\u0b32\u0b17\u0b47\u0b30\u0b3f\u0b06" },
            { "BH", "\u0b2c\u0b3e\u0b39\u0b3e\u0b30\u0b3f\u0b28\u0b4d" },
            { "BI", "\u0b2c\u0b41\u0b30\u0b41\u0b23\u0b4d\u0b21\u0b3f" },
            { "BJ", "\u0b2c\u0b47\u0b28\u0b3f\u0b28\u0b4d" },
            { "BL", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2c\u0b3e\u0b30\u0b4d\u0b25\u0b47\u0b32\u0b47\u0b2e\u0b3f" },
            { "BM", "\u0b2c\u0b30\u0b4d\u0b2e\u0b41\u0b21\u0b3e" },
            { "BN", "\u0b2c\u0b4d\u0b30\u0b41\u0b28\u0b47\u0b07" },
            { "BO", "\u0b2c\u0b4b\u0b32\u0b2d\u0b3f\u0b06" },
            { "BQ", "\u0b15\u0b3e\u0b30\u0b2c\u0b3f\u0b5f\u0b28\u0b4d\u200c \u0b28\u0b47\u0b26\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "BR", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b32\u0b4d" },
            { "BS", "\u0b2c\u0b3e\u0b39\u0b3e\u0b2e\u0b3e\u0b38\u0b4d" },
            { "BT", "\u0b2d\u0b41\u0b1f\u0b3e\u0b28" },
            { "BV", "\u0b2c\u0b4c\u0b2d\u0b47\u0b1f\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "BW", "\u0b2c\u0b4b\u0b1f\u0b38\u0b4d\u0b71\u0b3e\u0b28\u0b3e" },
            { "BY", "\u0b2c\u0b47\u0b32\u0b3e\u0b30\u0b41\u0b37\u0b4d" },
            { "BZ", "\u0b2c\u0b47\u0b32\u0b3f\u0b1c\u0b4d" },
            { "CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3e" },
            { "CC", "\u0b15\u0b4b\u0b15\u0b4b\u0b38\u0b4d (\u0b15\u0b40\u0b32\u0b3f\u0b02) \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "CD", "\u0b15\u0b19\u0b4d\u0b17\u0b4b (\u0b21\u0b3f\u0b06\u0b30\u0b38\u0b3f)" },
            { "CF", "\u0b2e\u0b27\u0b4d\u0b5f \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b40\u0b5f \u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23\u0b24\u0b28\u0b4d\u0b24\u0b4d\u0b30" },
            { "CG", "\u0b15\u0b19\u0b4d\u0b17\u0b4b-\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b2d\u0b3f\u0b32\u0b4d\u0b32\u0b47" },
            { "CH", "\u0b38\u0b4d\u0b71\u0b3f\u0b1c\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "CI", "\u0b15\u0b4b\u0b24\u0b4d \u0b21\u0b3f \u0b2d\u0b4d\u0b35\u0b3e\u0b30\u0b4d" },
            { "CK", "\u0b15\u0b41\u0b15\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "CL", "\u0b1a\u0b3f\u0b32\u0b4d\u0b32\u0b40" },
            { "CM", "\u0b15\u0b3e\u0b2e\u0b47\u0b30\u0b41\u0b28\u0b4d" },
            { "CN", "\u0b1a\u0b3f\u0b28\u0b4d" },
            { "CO", "\u0b15\u0b4b\u0b32\u0b2e\u0b4d\u0b2c\u0b3f\u0b06" },
            { "CP", "\u0b15\u0b4d\u0b32\u0b3f\u0b2a\u0b30\u0b1f\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "CR", "\u0b15\u0b4b\u0b37\u0b4d\u0b1f\u0b3e \u0b30\u0b3f\u0b15\u0b3e" },
            { "CU", "\u0b15\u0b4d\u0b71\u0b3f\u0b2c\u0b3e" },
            { "CV", "\u0b15\u0b47\u0b2a\u0b4d \u0b2d\u0b30\u0b4d\u0b26\u0b47" },
            { "CW", "\u0b15\u0b41\u0b30\u0b3e\u0b15\u0b3e\u0b13" },
            { "CX", "\u0b16\u0b4d\u0b30\u0b40\u0b37\u0b4d\u0b1f\u0b2e\u0b3e\u0b38 \u0b26\u0b4d\u0b71\u0b40\u0b2a" },
            { "CY", "\u0b38\u0b3e\u0b07\u0b2a\u0b4d\u0b30\u0b38\u0b4d" },
            { "CZ", "\u0b1a\u0b47\u0b1a\u0b3f\u0b06" },
            { "DE", "\u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b40" },
            { "DG", "\u0b21\u0b3f\u0b0f\u0b17\u0b4b \u0b17\u0b3e\u0b30\u0b4d\u0b38\u0b3f\u0b06" },
            { "DJ", "\u0b1c\u0b3f\u0b2c\u0b4b\u0b1f\u0b3f" },
            { "DK", "\u0b21\u0b47\u0b28\u0b2e\u0b3e\u0b30\u0b4d\u0b15" },
            { "DM", "\u0b21\u0b4b\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b3e" },
            { "DO", "\u0b21\u0b4b\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b3e\u0b28\u0b4d\u200c \u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23\u0b24\u0b28\u0b4d\u0b24\u0b4d\u0b30" },
            { "DZ", "\u0b06\u0b32\u0b1c\u0b47\u0b30\u0b3f\u0b06" },
            { "EA", "\u0b38\u0b3f\u0b09\u0b1f\u0b3e \u0b0f\u0b2c\u0b02 \u0b2e\u0b47\u0b32\u0b3f\u0b32\u0b3e" },
            { "EC", "\u0b07\u0b15\u0b4d\u0b71\u0b3e\u0b21\u0b4b\u0b30\u0b4d" },
            { "EE", "\u0b0f\u0b38\u0b4d\u0b24\u0b4b\u0b28\u0b3f\u0b06" },
            { "EG", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f" },
            { "EH", "\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b38\u0b3e\u0b39\u0b3e\u0b30\u0b3e" },
            { "ER", "\u0b07\u0b30\u0b3f\u0b1f\u0b4d\u0b30\u0b3f\u0b5f\u0b3e" },
            { "ES", "\u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b4d" },
            { "ET", "\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b06" },
            { "EU", "\u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b40\u0b5f \u0b38\u0b02\u0b18" },
            { "EZ", "\u0b5f\u0b41\u0b30\u0b4b\u0b15\u0b4d\u0b37\u0b47\u0b24\u0b4d\u0b30" },
            { "FI", "\u0b2b\u0b3f\u0b28\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "FJ", metaValue_FJ },
            { "FK", "\u0b2b\u0b15\u0b4d\u200c\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21 \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "FM", "\u0b2e\u0b3e\u0b07\u0b15\u0b4d\u0b30\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "FO", "\u0b2b\u0b3e\u0b30\u0b4b\u0b07 \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "FR", "\u0b2b\u0b4d\u0b30\u0b3e\u0b28\u0b4d\u0b38" },
            { "GA", "\u0b17\u0b3e\u0b2c\u0b4b\u0b28\u0b4d" },
            { "GB", "\u0b2f\u0b41\u0b15\u0b4d\u0b24\u0b30\u0b3e\u0b1c\u0b4d\u0b5f" },
            { "GD", "\u0b17\u0b4d\u0b30\u0b47\u0b28\u0b3e\u0b21\u0b3e" },
            { "GE", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06" },
            { "GF", "\u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a \u0b17\u0b41\u0b07\u0b28\u0b3e" },
            { "GG", "\u0b17\u0b41\u0b0f\u0b30\u0b28\u0b47\u0b38\u0b3f" },
            { "GH", "\u0b18\u0b3e\u0b28\u0b3e" },
            { "GI", "\u0b1c\u0b3f\u0b2c\u0b4d\u0b30\u0b3e\u0b32\u0b4d\u0b1f\u0b30\u0b4d" },
            { "GL", "\u0b17\u0b4d\u0b30\u0b40\u0b28\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "GM", "\u0b17\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b06" },
            { "GN", "\u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06" },
            { "GP", "\u0b17\u0b41\u0b06\u0b21\u0b47\u0b32\u0b4b\u0b2a\u0b4d" },
            { "GQ", "\u0b07\u0b15\u0b4d\u0b2c\u0b3e\u0b1f\u0b47\u0b30\u0b3f\u0b06\u0b32\u0b4d \u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06" },
            { "GR", "\u0b17\u0b4d\u0b30\u0b40\u0b38\u0b4d" },
            { "GS", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06 \u0b0f\u0b2c\u0b02 \u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b3e\u0b23\u0b4d\u0b21\u0b71\u0b3f\u0b1a\u0b4d \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "GT", "\u0b17\u0b41\u0b0f\u0b24\u0b2e\u0b3e\u0b32\u0b3e" },
            { "GU", "\u0b17\u0b41\u0b06\u0b2e\u0b4d" },
            { "GW", "\u0b17\u0b41\u0b07\u0b28\u0b3f\u0b06-\u0b2c\u0b3f\u0b38\u0b3e\u0b09" },
            { "GY", "\u0b17\u0b41\u0b07\u0b28\u0b3e" },
            { "HK", "\u0b39\u0b02 \u0b15\u0b02 \u0b0f\u0b38\u0b0f\u0b06\u0b30\u0b4d\u200c \u0b1a\u0b3e\u0b07\u0b28\u0b3e" },
            { "HM", "\u0b39\u0b3e\u0b30\u0b4d\u0b21\u0b4d\u200c \u0b0f\u0b2c\u0b02 \u0b2e\u0b4d\u0b5f\u0b3e\u0b15\u0b21\u0b4b\u0b28\u0b3e\u0b32\u0b4d\u0b21 \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "HN", "\u0b39\u0b4b\u0b23\u0b4d\u0b21\u0b41\u0b30\u0b3e\u0b38\u0b4d\u200c" },
            { "HR", "\u0b15\u0b4d\u0b30\u0b4b\u0b0f\u0b38\u0b3f\u0b06" },
            { "HT", "\u0b39\u0b3e\u0b07\u0b24\u0b3f" },
            { "HU", "\u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b40" },
            { "IC", "\u0b15\u0b47\u0b28\u0b47\u0b30\u0b40 \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "ID", "\u0b07\u0b23\u0b4d\u0b21\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "IE", "\u0b06\u0b5f\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "IL", "\u0b07\u0b38\u0b4d\u0b30\u0b3e\u0b0f\u0b32\u0b4d" },
            { "IM", "\u0b06\u0b07\u0b32\u0b4d\u200c \u0b05\u0b2b\u0b4d\u200c \u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b4d\u200c" },
            { "IN", "\u0b2d\u0b3e\u0b30\u0b24" },
            { "IO", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d\u200c \u0b2d\u0b3e\u0b30\u0b24 \u0b2e\u0b3e\u0b39\u0b3e\u0b38\u0b3e\u0b17\u0b30 \u0b15\u0b4d\u0b37\u0b47\u0b24\u0b4d\u0b30" },
            { "IQ", "\u0b07\u0b30\u0b3e\u0b15\u0b4d" },
            { "IR", "\u0b07\u0b30\u0b3e\u0b28" },
            { "IS", "\u0b06\u0b07\u0b38\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "IT", "\u0b07\u0b1f\u0b3e\u0b32\u0b40" },
            { "JE", "\u0b1c\u0b30\u0b4d\u0b38\u0b3f" },
            { "JM", "\u0b1c\u0b3e\u0b2e\u0b3e\u0b07\u0b15\u0b3e" },
            { "JO", "\u0b1c\u0b4b\u0b30\u0b4d\u0b21\u0b3e\u0b28\u0b4d" },
            { "JP", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28" },
            { "KE", "\u0b15\u0b47\u0b28\u0b3f\u0b5f\u0b3e" },
            { "KG", "\u0b15\u0b3f\u0b30\u0b4d\u0b17\u0b3f\u0b1c\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "KH", "\u0b15\u0b3e\u0b2e\u0b4d\u0b2c\u0b4b\u0b21\u0b3f\u0b06" },
            { "KI", "\u0b15\u0b3f\u0b30\u0b3f\u0b2c\u0b3e\u0b1f\u0b3f" },
            { "KM", "\u0b15\u0b4b\u0b2e\u0b4b\u0b30\u0b38\u0b4d" },
            { "KN", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b15\u0b3f\u0b1f\u0b38\u0b4d\u200c \u0b0f\u0b2c\u0b02 \u0b28\u0b47\u0b2d\u0b3f\u0b38\u0b4d\u200c" },
            { "KP", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b15\u0b4b\u0b30\u0b3f\u0b06" },
            { "KR", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b15\u0b4b\u0b30\u0b3f\u0b06" },
            { "KW", "\u0b15\u0b41\u0b0f\u0b24\u0b4d" },
            { "KY", "\u0b15\u0b47\u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "KZ", "\u0b15\u0b3e\u0b1c\u0b3e\u0b15\u0b3e\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "LA", "\u0b32\u0b3e\u0b13\u0b38\u0b4d" },
            { "LB", "\u0b32\u0b47\u0b2c\u0b3e\u0b28\u0b28\u0b4d" },
            { "LC", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b32\u0b41\u0b38\u0b3f\u0b06" },
            { "LI", "\u0b32\u0b3f\u0b1a\u0b47\u0b1f\u0b28\u0b37\u0b4d\u0b1f\u0b47\u0b07\u0b28\u0b4d" },
            { "LK", "\u0b36\u0b4d\u0b30\u0b40\u0b32\u0b19\u0b4d\u0b15\u0b3e" },
            { "LR", "\u0b32\u0b3e\u0b07\u0b2c\u0b47\u0b30\u0b3f\u0b06" },
            { "LS", "\u0b32\u0b47\u0b38\u0b4b\u0b25\u0b4b" },
            { "LT", "\u0b32\u0b3f\u0b25\u0b41\u0b06\u0b28\u0b3f\u0b06" },
            { "LU", "\u0b32\u0b15\u0b4d\u0b38\u0b47\u0b2e\u0b2c\u0b30\u0b4d\u0b17" },
            { "LV", "\u0b32\u0b3e\u0b1f\u0b2d\u0b3f\u0b06" },
            { "LY", "\u0b32\u0b3f\u0b2c\u0b4d\u0b5f\u0b3e" },
            { "MA", "\u0b2e\u0b4b\u0b30\u0b4b\u0b15\u0b4d\u0b15\u0b4b" },
            { "MC", "\u0b2e\u0b4b\u0b28\u0b3e\u0b15\u0b4b" },
            { "MD", "\u0b2e\u0b4b\u0b32\u0b21\u0b4b\u0b2d\u0b3e" },
            { "ME", "\u0b2e\u0b23\u0b4d\u0b1f\u0b47\u0b28\u0b3f\u0b17\u0b4d\u0b30\u0b4b" },
            { "MF", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b4d" },
            { "MG", "\u0b2e\u0b3e\u0b21\u0b3e\u0b17\u0b3e\u0b38\u0b4d\u0b15\u0b30\u0b4d" },
            { "MH", "\u0b2e\u0b3e\u0b30\u0b4d\u0b36\u0b3e\u0b32\u0b4d \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "MK", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b2e\u0b3e\u0b38\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06" },
            { "ML", "\u0b2e\u0b3e\u0b32\u0b3f" },
            { "MM", "\u0b2e\u0b3f\u0b06\u0b01\u0b2e\u0b3e\u0b30" },
            { "MN", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3f\u0b06" },
            { "MO", "\u0b2e\u0b3e\u0b15\u0b3e\u0b09 \u0b0f\u0b38\u0b0f\u0b06\u0b30\u0b4d\u200c \u0b1a\u0b3e\u0b07\u0b28\u0b3e" },
            { "MP", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b2e\u0b3e\u0b30\u0b3f\u0b06\u0b28\u0b3e \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "MQ", "\u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b3f\u0b15\u0b4d\u0b5f\u0b41" },
            { "MR", "\u0b2e\u0b4c\u0b30\u0b3f\u0b1f\u0b3e\u0b28\u0b3f\u0b06" },
            { "MS", "\u0b2e\u0b23\u0b4d\u0b1f\u0b47\u0b38\u0b47\u0b30\u0b3e\u0b1f\u0b4d" },
            { "MT", "\u0b2e\u0b3e\u0b32\u0b4d\u0b1f\u0b3e" },
            { "MU", "\u0b2e\u0b30\u0b3f\u0b38\u0b38" },
            { "MV", "\u0b2e\u0b3e\u0b32\u0b26\u0b3f\u0b2d\u0b38\u0b4d\u200c" },
            { "MW", "\u0b2e\u0b3e\u0b32\u0b71\u0b3f" },
            { "MX", "\u0b2e\u0b47\u0b15\u0b4d\u0b38\u0b3f\u0b15\u0b4b" },
            { "MY", "\u0b2e\u0b3e\u0b32\u0b47\u0b38\u0b3f\u0b06" },
            { "MZ", "\u0b2e\u0b4b\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b15\u0b4d\u200c" },
            { "NA", "\u0b28\u0b3e\u0b2e\u0b3f\u0b2c\u0b3f\u0b06" },
            { "NC", "\u0b28\u0b42\u0b24\u0b28 \u0b15\u0b3e\u0b32\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06" },
            { "NE", "\u0b28\u0b3e\u0b07\u0b1c\u0b30" },
            { "NF", "\u0b28\u0b30\u0b4d\u0b2b\u0b15\u0b4d \u0b26\u0b4d\u0b35\u0b40\u0b2a" },
            { "NG", "\u0b28\u0b3e\u0b07\u0b1c\u0b47\u0b30\u0b3f\u0b06" },
            { "NI", "\u0b28\u0b3f\u0b15\u0b3e\u0b30\u0b3e\u0b17\u0b41\u0b06" },
            { "NL", "\u0b28\u0b47\u0b26\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "NO", "\u0b28\u0b30\u0b71\u0b47" },
            { "NP", "\u0b28\u0b47\u0b2a\u0b3e\u0b33" },
            { "NR", metaValue_NR },
            { "NU", "\u0b28\u0b3f\u0b09" },
            { "NZ", "\u0b28\u0b4d\u0b5f\u0b41\u0b1c\u0b3f\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "OM", "\u0b13\u0b2e\u0b3e\u0b28\u0b4d" },
            { "PA", "\u0b2a\u0b3e\u0b28\u0b3e\u0b2e\u0b3e" },
            { "PE", "\u0b2a\u0b47\u0b30\u0b41" },
            { "PF", "\u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a \u0b2a\u0b32\u0b3f\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "PG", "\u0b2a\u0b2a\u0b41\u0b06 \u0b28\u0b4d\u0b5f\u0b41 \u0b17\u0b41\u0b0f\u0b28\u0b3f\u0b06" },
            { "PH", "\u0b2b\u0b3f\u0b32\u0b3f\u0b2a\u0b3e\u0b07\u0b28\u0b38\u0b4d" },
            { "PK", "\u0b2a\u0b3e\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "PL", "\u0b2a\u0b4b\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "PM", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2a\u0b3f\u0b0f\u0b30\u0b47 \u0b0f\u0b2c\u0b02 \u0b2e\u0b3f\u0b15\u0b4d\u0b71\u0b47\u0b32\u0b28\u0b4d\u200c" },
            { "PN", "\u0b2a\u0b3f\u0b1f\u0b15\u0b3e\u0b07\u0b30\u0b3f\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "PR", "\u0b2a\u0b41\u0b0f\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b4b \u0b30\u0b3f\u0b15\u0b4b" },
            { "PS", "\u0b2a\u0b3e\u0b32\u0b47\u0b37\u0b4d\u0b1f\u0b47\u0b28\u0b3f\u0b5f \u0b2d\u0b42\u0b2d\u0b3e\u0b17" },
            { "PT", "\u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b3e\u0b32\u0b4d" },
            { "PW", "\u0b2a\u0b3e\u0b32\u0b3e\u0b09" },
            { "PY", "\u0b2a\u0b3e\u0b30\u0b3e\u0b17\u0b41\u0b0f" },
            { "QA", "\u0b15\u0b24\u0b3e\u0b30\u0b4d" },
            { "QO", "\u0b38\u0b40\u0b2e\u0b3e\u0b28\u0b4d\u0b24\u0b2c\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b40 \u0b13\u0b38\u0b3f\u0b28\u0b3f\u0b06" },
            { "RE", "\u0b30\u0b3f\u0b5f\u0b41\u0b28\u0b3f\u0b05\u0b28\u0b4d" },
            { "RO", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b06" },
            { "RS", "\u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b06" },
            { "RU", "\u0b30\u0b41\u0b37\u0b3f\u0b06" },
            { "RW", "\u0b30\u0b3e\u0b71\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "SA", "\u0b38\u0b3e\u0b09\u0b26\u0b3f \u0b06\u0b30\u0b2c\u0b3f\u0b06" },
            { "SB", "\u0b38\u0b4b\u0b32\u0b4b\u0b2e\u0b28\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "SC", "\u0b38\u0b47\u0b1a\u0b47\u0b32\u0b38\u0b4d" },
            { "SD", "\u0b38\u0b41\u0b26\u0b3e\u0b28" },
            { "SE", "\u0b38\u0b4d\u0b71\u0b47\u0b21\u0b47\u0b28\u0b4d" },
            { "SG", "\u0b38\u0b3f\u0b19\u0b4d\u0b17\u0b3e\u0b2a\u0b41\u0b30\u0b4d" },
            { "SH", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b39\u0b47\u0b32\u0b47\u0b28\u0b3e" },
            { "SI", "\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b47\u0b28\u0b3f\u0b06" },
            { "SJ", "\u0b38\u0b3e\u0b32\u0b2c\u0b3e\u0b30\u0b4d\u0b21 \u0b0f\u0b2c\u0b02 \u0b1c\u0b3e\u0b28\u0b4d\u200c \u0b2e\u0b3e\u0b5f\u0b47\u0b28\u0b4d\u200c" },
            { "SK", "\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b3e\u0b15\u0b3f\u0b06" },
            { "SL", "\u0b38\u0b3f\u0b0f\u0b30\u0b3e \u0b32\u0b3f\u0b13\u0b28" },
            { "SM", "\u0b38\u0b3e\u0b28\u0b4d \u0b2e\u0b3e\u0b30\u0b3f\u0b28\u0b4b" },
            { "SN", "\u0b38\u0b47\u0b28\u0b47\u0b17\u0b3e\u0b32\u0b4d" },
            { "SO", metaValue_SO },
            { "SR", "\u0b38\u0b41\u0b30\u0b3f\u0b28\u0b3e\u0b2e" },
            { "SS", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b41\u0b26\u0b3e\u0b28" },
            { "ST", "\u0b38\u0b3e\u0b13 \u0b1f\u0b4b\u0b2e\u0b47 \u0b0f\u0b2c\u0b02 \u0b2a\u0b4d\u0b30\u0b3f\u0b28\u0b38\u0b3f\u0b2a\u0b3f" },
            { "SV", "\u0b0f\u0b32\u0b4d \u0b38\u0b3e\u0b32\u0b2d\u0b3e\u0b21\u0b4b\u0b30\u0b4d" },
            { "SX", "\u0b38\u0b3f\u0b23\u0b4d\u0b1f \u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b40\u0b28\u0b4d\u200c" },
            { "SY", "\u0b38\u0b3f\u0b30\u0b3f\u0b06" },
            { "SZ", "\u0b07\u0b38\u0b4d\u0b71\u0b3e\u0b24\u0b3f\u0b28\u0b40" },
            { "TA", "\u0b1f\u0b4d\u0b30\u0b3e\u0b07\u0b37\u0b4d\u0b1f\u0b28\u0b4d\u200c \u0b26\u0b3e \u0b15\u0b41\u0b28\u0b4d\u200c\u0b1a\u0b3e" },
            { "TC", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b38\u0b4d\u200c \u0b0f\u0b2c\u0b02 \u0b15\u0b3e\u0b07\u0b15\u0b4b\u0b38\u0b4d\u200c \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "TD", "\u0b1a\u0b3e\u0b26\u0b4d" },
            { "TF", "\u0b2b\u0b30\u0b3e\u0b38\u0b40 \u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b15\u0b4d\u0b37\u0b47\u0b24\u0b4d\u0b30" },
            { "TG", "\u0b1f\u0b4b\u0b17\u0b4b" },
            { "TH", "\u0b25\u0b3e\u0b07\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21" },
            { "TJ", "\u0b24\u0b3e\u0b1c\u0b3f\u0b15\u0b3f\u0b38\u0b4d\u0b25\u0b3e\u0b28\u0b4d" },
            { "TK", metaValue_TK },
            { "TL", "\u0b24\u0b3f\u0b2e\u0b4b\u0b30\u0b4d-\u0b32\u0b47\u0b37\u0b4d\u0b1f\u0b47" },
            { "TM", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b2e\u0b47\u0b28\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "TN", "\u0b1f\u0b4d\u0b5f\u0b41\u0b28\u0b3f\u0b38\u0b3f\u0b06" },
            { "TO", metaValue_TO },
            { "TR", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b40" },
            { "TT", "\u0b24\u0b4d\u0b30\u0b3f\u0b28\u0b3f\u0b26\u0b3e\u0b26\u0b4d \u0b0f\u0b2c\u0b02 \u0b1f\u0b4b\u0b2c\u0b3e\u0b17\u0b4b" },
            { "TV", metaValue_TV },
            { "TW", "\u0b24\u0b3e\u0b07\u0b71\u0b3e\u0b28" },
            { "TZ", "\u0b24\u0b3e\u0b1e\u0b4d\u0b1c\u0b3e\u0b28\u0b3f\u0b06" },
            { "UA", "\u0b5f\u0b41\u0b15\u0b4d\u0b30\u0b47\u0b28\u0b4d" },
            { "UG", "\u0b09\u0b17\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "UM", "\u0b2f\u0b41\u0b15\u0b4d\u0b24\u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30 \u0b06\u0b09\u0b1f\u0b4d\u200c\u0b32\u0b3e\u0b07\u0b19\u0b4d\u0b17 \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "UN", "\u0b1c\u0b3e\u0b24\u0b3f\u0b38\u0b02\u0b18" },
            { "US", "\u0b2f\u0b41\u0b15\u0b4d\u0b24 \u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30" },
            { "UY", "\u0b09\u0b30\u0b41\u0b17\u0b41\u0b0f" },
            { "UZ", "\u0b09\u0b1c\u0b2c\u0b47\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "VA", "\u0b2d\u0b3e\u0b1f\u0b3f\u0b15\u0b3e\u0b28\u0b4d \u0b38\u0b3f\u0b1f\u0b3f" },
            { "VC", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2d\u0b3f\u0b28\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b0f\u0b2c\u0b02 \u0b26\u0b3f \u0b17\u0b4d\u0b30\u0b47\u0b28\u0b3e\u0b21\u0b3f\u0b38\u0b4d" },
            { "VE", "\u0b2d\u0b47\u0b28\u0b47\u0b1c\u0b41\u0b0f\u0b32\u0b3e" },
            { "VG", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d\u200c \u0b2d\u0b30\u0b4d\u0b1c\u0b3f\u0b28\u0b4d \u0b26\u0b4d\u0b71\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "VI", "\u0b2f\u0b41\u0b15\u0b4d\u0b24\u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30 \u0b2d\u0b3f\u0b30\u0b4d\u0b1c\u0b3f\u0b28\u0b4d \u0b26\u0b4d\u0b35\u0b40\u0b2a\u0b2a\u0b41\u0b1e\u0b4d\u0b1c" },
            { "VN", "\u0b2d\u0b3f\u0b0f\u0b24\u0b28\u0b3e\u0b2e\u0b4d" },
            { "VU", "\u0b2d\u0b3e\u0b28\u0b41\u0b06\u0b24\u0b41" },
            { "WF", "\u0b71\u0b3e\u0b32\u0b3f\u0b38\u0b4d \u0b0f\u0b2c\u0b02 \u0b2b\u0b41\u0b24\u0b41\u0b28\u0b3e" },
            { "WS", "\u0b38\u0b3e\u0b2e\u0b4b\u0b06" },
            { "XA", "\u0b38\u0b3f\u0b5f\u0b41\u0b21\u0b4b-\u0b0f\u0b38\u0b47\u0b23\u0b4d\u0b1f" },
            { "XB", "\u0b38\u0b3f\u0b5f\u0b41\u0b21\u0b4b-\u0b2c\u0b3f\u0b21\u0b3f" },
            { "XK", "\u0b15\u0b4b\u0b38\u0b4b\u0b2d\u0b4b" },
            { "YE", "\u0b5f\u0b47\u0b2e\u0b47\u0b28\u0b4d" },
            { "YT", "\u0b2e\u0b3e\u0b5f\u0b4b\u0b1f\u0b47" },
            { "ZA", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "ZM", "\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b06" },
            { "ZW", "\u0b1c\u0b3f\u0b2e\u0b4d\u0b2c\u0b3e\u0b71\u0b47" },
            { "ZZ", "\u0b05\u0b1c\u0b23\u0b3e \u0b05\u0b1e\u0b4d\u0b1a\u0b33" },
            { "aa", "\u0b05\u0b2b\u0b3e\u0b30\u0b4d" },
            { "ab", "\u0b06\u0b2c\u0b4d\u0b16\u0b3e\u0b1c\u0b3f\u0b06\u0b28\u0b4d" },
            { "ae", "\u0b05\u0b2c\u0b47\u0b38\u0b4d\u0b24\u0b28" },
            { "af", "\u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b15\u0b40\u0b5f" },
            { "ak", "\u0b05\u0b15\u0b28\u0b4d" },
            { "am", "\u0b06\u0b2e\u0b39\u0b3e\u0b30\u0b15\u0b3f" },
            { "an", "\u0b06\u0b30\u0b4d\u0b17\u0b4b\u0b28\u0b40" },
            { "ar", metaValue_ar },
            { "as", "\u0b06\u0b38\u0b3e\u0b2e\u0b40\u0b5f" },
            { "av", "\u0b06\u0b2d\u0b3e\u0b30\u0b3f\u0b15\u0b4d" },
            { "ay", "\u0b06\u0b5f\u0b2e\u0b3e\u0b30\u0b3e" },
            { "az", "\u0b06\u0b1c\u0b47\u0b30\u0b2c\u0b3e\u0b07\u0b1c\u0b3e\u0b28\u0b3f" },
            { "ba", "\u0b2c\u0b3e\u0b36\u0b15\u0b3f\u0b30\u0b4d" },
            { "be", "\u0b2c\u0b47\u0b32\u0b3e\u0b30\u0b41\u0b37\u0b3f\u0b06\u0b28\u0b4d" },
            { "bg", "\u0b2c\u0b41\u0b32\u0b17\u0b47\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "bi", "\u0b2c\u0b3f\u0b38\u0b32\u0b3e\u0b2e\u0b3e" },
            { "bm", "\u0b2c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3e\u0b30\u0b3e" },
            { "bn", "\u0b2c\u0b19\u0b4d\u0b17\u0b33\u0b3e" },
            { "bo", "\u0b24\u0b3f\u0b2c\u0b4d\u0b2c\u0b24\u0b40\u0b5f" },
            { "br", "\u0b2c\u0b4d\u0b30\u0b47\u0b1f\u0b28\u0b4d" },
            { "bs", "\u0b2c\u0b4b\u0b38\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "ca", "\u0b15\u0b3e\u0b1f\u0b3e\u0b32\u0b3e\u0b28\u0b4d" },
            { "ce", "\u0b1a\u0b47\u0b1a\u0b28\u0b4d" },
            { "ch", "\u0b1a\u0b3e\u0b2e\u0b4b\u0b30\u0b4b" },
            { "co", "\u0b15\u0b4b\u0b30\u0b4d\u0b38\u0b3f\u0b15\u0b3e\u0b28\u0b4d" },
            { "cr", "\u0b15\u0b4d\u0b30\u0b40" },
            { "cs", "\u0b1a\u0b47\u0b15\u0b4d" },
            { "cu", "\u0b1a\u0b30\u0b4d\u0b1a\u0b4d\u0b1a \u0b38\u0b4d\u0b32\u0b3e\u0b2d\u0b3f\u0b15\u0b4d" },
            { "cv", "\u0b1a\u0b41\u0b2d\u0b3e\u0b36\u0b4d" },
            { "cy", "\u0b71\u0b47\u0b32\u0b4d\u0b38" },
            { "da", "\u0b21\u0b3e\u0b28\u0b4d\u0b28\u0b3f\u0b38\u0b4d" },
            { "de", "\u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28" },
            { "dv", "\u0b21\u0b3f\u0b2d\u0b47\u0b39\u0b40" },
            { "dz", "\u0b26\u0b21\u0b1c\u0b4b\u0b19\u0b4d\u0b17\u0b16\u0b3e" },
            { "ee", "\u0b07\u0b71\u0b47" },
            { "el", metaValue_el },
            { "en", "\u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "eo", "\u0b0f\u0b38\u0b4d\u0b2a\u0b3e\u0b30\u0b47\u0b23\u0b4d\u0b1f\u0b4b" },
            { "es", "\u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b3f\u0b5f" },
            { "et", "\u0b0f\u0b38\u0b4d\u0b24\u0b4b\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "eu", "\u0b2c\u0b3e\u0b38\u0b4d\u0b15\u0b4d\u0b71\u0b3f" },
            { "fa", "\u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "ff", "\u0b2b\u0b41\u0b32\u0b3e\u0b39" },
            { "fi", "\u0b2b\u0b3f\u0b28\u0b4d\u0b28\u0b3f\u0b38\u0b4d" },
            { "fj", metaValue_FJ },
            { "fo", "\u0b2b\u0b3e\u0b30\u0b4b\u0b0f\u0b38\u0b47" },
            { "fr", "\u0b2b\u0b30\u0b3e\u0b38\u0b40" },
            { "fy", "\u0b2a\u0b3e\u0b36\u0b4d\u0b1a\u0b3e\u0b24\u0b4d\u0b5f \u0b2b\u0b4d\u0b30\u0b3f\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "ga", "\u0b07\u0b30\u0b3f\u0b38\u0b4d" },
            { "gd", "\u0b38\u0b4d\u0b15\u0b1f\u0b3f\u0b38\u0b4d \u0b17\u0b3e\u0b0f\u0b32\u0b3f\u0b15\u0b4d" },
            { "gl", "\u0b17\u0b3e\u0b32\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "gn", "\u0b17\u0b41\u0b06\u0b30\u0b3e\u0b28\u0b40" },
            { "gu", metaValue_gu },
            { "gv", "\u0b2e\u0b3e\u0b01\u0b15\u0b4d\u0b38" },
            { "ha", "\u0b39\u0b4c\u0b38\u0b3e" },
            { "he", "\u0b39\u0b47\u0b2c\u0b4d\u0b30\u0b4d\u0b5f\u0b41" },
            { "hi", "\u0b39\u0b3f\u0b28\u0b4d\u0b26\u0b40" },
            { "ho", "\u0b39\u0b3f\u0b30\u0b3f \u0b2e\u0b4b\u0b1f\u0b41" },
            { "hr", "\u0b15\u0b4d\u0b30\u0b4b\u0b06\u0b1f\u0b3f\u0b06\u0b28\u0b4d" },
            { "ht", "\u0b39\u0b48\u0b24\u0b3e\u0b5f\u0b3f\u0b28\u0b4d" },
            { "hu", "\u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b40\u0b5f" },
            { "hy", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "hz", "\u0b39\u0b47\u0b30\u0b47\u0b30\u0b4b" },
            { "ia", "\u0b07\u0b30\u0b4d\u0b23\u0b4d\u0b1f\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b41\u0b06" },
            { "id", "\u0b07\u0b23\u0b4d\u0b21\u0b4b\u0b28\u0b47\u0b38\u0b40\u0b5f" },
            { "ie", "\u0b07\u0b30\u0b4d\u0b23\u0b4d\u0b1f\u0b30\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b41\u0b07" },
            { "ig", "\u0b07\u0b17\u0b2c\u0b4b" },
            { "ii", "\u0b38\u0b3f\u0b1a\u0b41\u0b06\u0b28\u0b4d \u0b5f\u0b40" },
            { "ik", "\u0b07\u0b28\u0b41\u0b2a\u0b3f\u0b5f\u0b3e\u0b15\u0b4d" },
            { "io", "\u0b07\u0b21\u0b4b" },
            { "is", "\u0b06\u0b07\u0b38\u0b32\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b15\u0b4d" },
            { "it", "\u0b07\u0b1f\u0b3e\u0b32\u0b40\u0b5f" },
            { "iu", "\u0b07\u0b28\u0b41\u0b15\u0b1f\u0b3f\u0b1f\u0b41\u0b24\u0b4d\u200c" },
            { "ja", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40" },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "\u0b15\u0b19\u0b4d\u0b17\u0b4b" },
            { "ki", "\u0b15\u0b40\u0b15\u0b41\u0b5f\u0b41" },
            { "kj", "\u0b15\u0b4d\u0b71\u0b3e\u0b28\u0b4d\u0b5f\u0b3e\u0b2e\u0b4d" },
            { "kk", "\u0b15\u0b3e\u0b1c\u0b3e\u0b15\u0b4d" },
            { "kl", "\u0b15\u0b3e\u0b32\u0b3e\u0b32\u0b3f\u0b38\u0b41\u0b1f\u0b4d" },
            { "km", "\u0b16\u0b3e\u0b2e\u0b47\u0b30\u0b4d" },
            { "kn", "\u0b15\u0b28\u0b4d\u0b28\u0b21" },
            { "ko", metaValue_ko },
            { "kr", "\u0b15\u0b28\u0b41\u0b30\u0b40" },
            { "ks", "\u0b15\u0b3e\u0b36\u0b4d\u0b2e\u0b3f\u0b30\u0b40" },
            { "ku", "\u0b15\u0b41\u0b30\u0b4d\u0b26\u0b4d\u0b26\u0b3f\u0b36\u0b4d" },
            { "kv", "\u0b15\u0b4b\u0b2e\u0b3f" },
            { "kw", "\u0b15\u0b4b\u0b30\u0b4d\u0b28\u0b3f\u0b38\u0b4d" },
            { "ky", "\u0b15\u0b40\u0b30\u0b17\u0b40\u0b1c\u0b4d" },
            { "la", metaValue_la },
            { "lb", "\u0b32\u0b15\u0b4d\u0b38\u0b47\u0b2e\u0b2c\u0b30\u0b4d\u0b17\u0b3f\u0b38\u0b4d" },
            { "lg", "\u0b17\u0b28\u0b4d\u0b26\u0b3e" },
            { "li", "\u0b32\u0b3f\u0b2e\u0b4d\u0b2c\u0b41\u0b30\u0b4d\u0b17\u0b3f\u0b38\u0b4d" },
            { "ln", "\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b3e\u0b32\u0b3e" },
            { "lo", metaValue_lo },
            { "lt", "\u0b32\u0b3f\u0b25\u0b41\u0b06\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "lu", "\u0b32\u0b4d\u0b5f\u0b41\u0b2c\u0b3e-\u0b15\u0b3e\u0b1f\u0b3e\u0b19\u0b4d\u0b17\u0b3e" },
            { "lv", "\u0b32\u0b3e\u0b1f\u0b2d\u0b3f\u0b06\u0b28\u0b4d" },
            { "mg", "\u0b2e\u0b3e\u0b32\u0b3e\u0b17\u0b3e\u0b38\u0b40" },
            { "mh", "\u0b2e\u0b3e\u0b30\u0b4d\u0b36\u0b3e\u0b32\u0b40\u0b1c\u0b4d" },
            { "mi", "\u0b2e\u0b3e\u0b13\u0b30\u0b40" },
            { "mk", "\u0b2e\u0b3e\u0b38\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "ml", metaValue_ml },
            { "mn", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b33\u0b3f\u0b5f" },
            { "mr", "\u0b2e\u0b30\u0b3e\u0b20\u0b40" },
            { "ms", "\u0b2e\u0b3e\u0b32\u0b5f" },
            { "mt", "\u0b2e\u0b3e\u0b32\u0b1f\u0b40\u0b1c\u0b4d" },
            { "my", "\u0b2c\u0b30\u0b4d\u0b2e\u0b40\u0b1c\u0b4d" },
            { "na", metaValue_NR },
            { "nb", "\u0b28\u0b30\u0b71\u0b47\u0b1c\u0b3f\u0b06\u0b28\u0b4d \u0b2c\u0b4b\u0b15\u0b2e\u0b32\u0b4d" },
            { "nd", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b28\u0b47\u0b21\u0b2c\u0b47\u0b32\u0b47" },
            { "ne", "\u0b28\u0b47\u0b2a\u0b3e\u0b33\u0b40" },
            { "ng", "\u0b21\u0b4b\u0b19\u0b4d\u0b17\u0b3e" },
            { "nl", "\u0b21\u0b1a\u0b4d" },
            { "nn", "\u0b28\u0b30\u0b71\u0b47\u0b1c\u0b3f\u0b06\u0b28\u0b4d \u0b28\u0b3f\u0b5f\u0b4b\u0b30\u0b4d\u0b38\u0b4d\u0b15" },
            { "no", "\u0b28\u0b30\u0b71\u0b47\u0b1c\u0b3f\u0b06\u0b28\u0b4d" },
            { "nr", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b28\u0b47\u0b21\u0b2c\u0b47\u0b32\u0b47" },
            { "nv", "\u0b28\u0b3e\u0b2d\u0b3e\u0b1c\u0b4b" },
            { "ny", "\u0b28\u0b3f\u0b5f\u0b3e\u0b1e\u0b4d\u0b1c" },
            { "oc", "\u0b13\u0b38\u0b3f\u0b1f\u0b3e\u0b28\u0b4d" },
            { "oj", "\u0b13\u0b1c\u0b3f\u0b71\u0b3e" },
            { "om", "\u0b13\u0b30\u0b4b\u0b2e\u0b4b" },
            { "or", metaValue_or },
            { "os", "\u0b13\u0b38\u0b47\u0b1f\u0b3f\u0b15\u0b4d" },
            { "pa", "\u0b2a\u0b1e\u0b4d\u0b1c\u0b3e\u0b2c\u0b40" },
            { "pi", "\u0b2a\u0b3e\u0b32\u0b3f" },
            { "pl", "\u0b2a\u0b4b\u0b32\u0b3f\u0b36\u0b4d" },
            { "ps", "\u0b2a\u0b3e\u0b38\u0b4d\u0b24\u0b4b" },
            { "pt", "\u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d\u200c" },
            { "qu", "\u0b15\u0b4d\u0b71\u0b47\u0b1a\u0b41\u0b06" },
            { "rm", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b36\u0b4d\u200c" },
            { "rn", "\u0b30\u0b41\u0b23\u0b4d\u0b21\u0b3f" },
            { "ro", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "ru", "\u0b30\u0b41\u0b37\u0b3f\u0b5f" },
            { "rw", "\u0b15\u0b3f\u0b28\u0b4d\u0b5f\u0b3e\u0b30\u0b71\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "sa", "\u0b38\u0b02\u0b38\u0b4d\u0b15\u0b43\u0b24" },
            { "sc", "\u0b38\u0b30\u0b4d\u0b26\u0b3f\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "sd", "\u0b38\u0b3f\u0b28\u0b4d\u0b27\u0b40" },
            { "se", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b38\u0b3e\u0b2e\u0b3f" },
            { "sg", "\u0b38\u0b3e\u0b19\u0b4d\u0b17\u0b4b" },
            { "sh", "\u0b38\u0b30\u0b4d\u0b2c\u0b4b-\u0b15\u0b4d\u0b30\u0b4b\u0b06\u0b1f\u0b3f\u0b06\u0b28\u0b4d" },
            { "si", metaValue_si },
            { "sk", "\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b3e\u0b15\u0b4d" },
            { "sl", "\u0b38\u0b4d\u0b32\u0b4b\u0b2d\u0b47\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "sm", "\u0b38\u0b3e\u0b2e\u0b4b\u0b06\u0b28\u0b4d" },
            { "sn", "\u0b36\u0b4b\u0b28\u0b3e" },
            { "so", metaValue_SO },
            { "sq", "\u0b06\u0b32\u0b2c\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "sr", "\u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b5f" },
            { "ss", "\u0b38\u0b4d\u0b35\u0b3e\u0b24\u0b3f" },
            { "st", "\u0b38\u0b47\u0b38\u0b4b\u0b25\u0b4b" },
            { "su", metaValue_su },
            { "sv", "\u0b38\u0b4d\u0b71\u0b47\u0b21\u0b3f\u0b38\u0b4d" },
            { "sw", "\u0b38\u0b4d\u0b71\u0b3e\u0b39\u0b3f\u0b32\u0b4d" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0b24\u0b3e\u0b1c\u0b3f\u0b15\u0b4d" },
            { "th", metaValue_th },
            { "ti", "\u0b1f\u0b4d\u0b30\u0b3f\u0b17\u0b3f\u0b28\u0b3f\u0b06" },
            { "tk", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b2e\u0b47\u0b28\u0b4d" },
            { "tl", "\u0b1f\u0b3e\u0b17\u0b3e\u0b32\u0b17\u0b4d" },
            { "tn", "\u0b38\u0b71\u0b3e\u0b28\u0b3e" },
            { "to", metaValue_TO },
            { "tr", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b38\u0b4d" },
            { "ts", "\u0b38\u0b4b\u0b19\u0b4d\u0b17\u0b3e" },
            { "tt", "\u0b24\u0b3e\u0b24\u0b3e\u0b30\u0b4d" },
            { "tw", "\u0b24\u0b4d\u0b71\u0b3f" },
            { "ty", "\u0b24\u0b3e\u0b39\u0b3f\u0b24\u0b3f\u0b06\u0b28\u0b4d" },
            { "ug", "\u0b5f\u0b41\u0b18\u0b41\u0b30\u0b4d" },
            { "uk", "\u0b5f\u0b41\u0b15\u0b4d\u0b30\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "ur", "\u0b09\u0b30\u0b4d\u0b26\u0b4d\u0b26\u0b41" },
            { "uz", "\u0b09\u0b1c\u0b2c\u0b47\u0b15\u0b4d" },
            { "ve", "\u0b2d\u0b47\u0b23\u0b4d\u0b21\u0b3e" },
            { "vi", "\u0b2d\u0b3f\u0b0f\u0b24\u0b28\u0b3e\u0b2e\u0b3f\u0b1c\u0b4d" },
            { "vo", "\u0b2c\u0b4b\u0b32\u0b3e\u0b2a\u0b41\u0b15" },
            { "wa", "\u0b71\u0b3e\u0b32\u0b41\u0b28\u0b4d" },
            { "wo", "\u0b71\u0b4b\u0b32\u0b2b\u0b4d" },
            { "xh", "\u0b16\u0b4b\u0b38\u0b3e" },
            { "yi", "\u0b5f\u0b3f\u0b21\u0b3f\u0b38\u0b4d" },
            { "yo", "\u0b5f\u0b4b\u0b30\u0b41\u0b2c\u0b3e" },
            { "za", "\u0b1c\u0b41\u0b06\u0b19\u0b4d\u0b17" },
            { "zh", "\u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c" },
            { "zu", "\u0b1c\u0b41\u0b32\u0b41" },
            { "ace", "\u0b06\u0b1a\u0b3e\u0b07\u0b28\u0b40\u0b1c\u0b4d" },
            { "ach", "\u0b06\u0b15\u0b4b\u0b32\u0b3f" },
            { "ada", "\u0b06\u0b26\u0b3e\u0b19\u0b4d\u0b17\u0b47\u0b2e\u0b4d" },
            { "ady", "\u0b05\u0b26\u0b4d\u0b5f\u0b18\u0b47" },
            { "afh", "\u0b06\u0b2b\u0b4d\u0b30\u0b3f\u0b39\u0b3f\u0b32\u0b3f" },
            { "agq", "\u0b06\u0b18\u0b47\u0b2e" },
            { "ain", "\u0b06\u0b07\u0b28\u0b41" },
            { "akk", "\u0b06\u0b15\u0b3e\u0b21\u0b3f\u0b06\u0b28\u0b4d" },
            { "ale", "\u0b06\u0b32\u0b47\u0b07\u0b1f\u0b41" },
            { "alt", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b06\u0b32\u0b4d\u0b1f\u0b3e\u0b07" },
            { "ang", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b07\u0b01\u0b30\u0b3e\u0b1c\u0b40" },
            { "ann", "\u0b05\u0b2c\u0b4b\u0b32\u0b3e" },
            { "anp", "\u0b05\u0b01\u0b17\u0b40\u0b15\u0b3e" },
            { "arc", "\u0b06\u0b30\u0b3e\u0b2e\u0b3e\u0b07\u0b15\u0b4d" },
            { "arn", "\u0b2e\u0b3e\u0b2a\u0b41\u0b1a\u0b47" },
            { "arp", "\u0b06\u0b30\u0b3e\u0b2a\u0b3e\u0b39\u0b4b" },
            { "ars", "\u0b28\u0b3e\u0b1c\u0b26\u0b3f \u0b06\u0b30\u0b2c\u0b3f\u0b15" },
            { "arw", "\u0b06\u0b30\u0b71\u0b15" },
            { "asa", "\u0b06\u0b38\u0b41" },
            { "ast", "\u0b06\u0b37\u0b4d\u0b1f\u0b41\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "atj", "\u0b06\u0b1f\u0b3f\u0b15\u0b3e\u0b2e\u0b47\u0b15\u0b4d\u0b71" },
            { "awa", "\u0b06\u0b71\u0b3e\u0b27\u0b3f" },
            { "bal", "\u0b2c\u0b3e\u0b32\u0b41\u0b1a\u0b3f" },
            { "ban", metaValue_ban },
            { "bas", "\u0b2c\u0b3e\u0b38\u0b3e" },
            { "bej", "\u0b2c\u0b47\u0b1c\u0b3e" },
            { "bem", "\u0b2c\u0b47\u0b2e\u0b4d\u0b2c\u0b3e" },
            { "bez", "\u0b2c\u0b47\u0b28\u0b3e" },
            { "bho", "\u0b2d\u0b4b\u0b1c\u0b2a\u0b41\u0b30\u0b40" },
            { "bik", "\u0b2c\u0b3f\u0b15\u0b4b\u0b32\u0b4d" },
            { "bin", "\u0b2c\u0b3f\u0b28\u0b3f" },
            { "bla", "\u0b38\u0b3f\u0b15\u0b38\u0b3f\u0b15\u0b3e" },
            { "bra", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b4d" },
            { "brx", "\u0b2c\u0b4b\u0b21\u0b4b" },
            { "bua", "\u0b2c\u0b41\u0b30\u0b3f\u0b06\u0b1f\u0b4d" },
            { "bug", "\u0b2c\u0b41\u0b17\u0b40\u0b28\u0b40\u0b1c\u0b4d" },
            { "byn", "\u0b2c\u0b4d\u0b32\u0b3f\u0b28\u0b4d" },
            { "cad", "\u0b15\u0b3e\u0b21\u0b4b" },
            { "car", "\u0b15\u0b3e\u0b30\u0b3f\u0b2c\u0b4d" },
            { "cay", "\u0b15\u0b3e\u0b5f\u0b41\u0b17\u0b3e" },
            { "cch", "\u0b06\u0b24\u0b4d\u0b38\u0b2e\u0b4d" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u0b38\u0b40\u0b2c\u0b41\u0b06\u0b28\u0b4b" },
            { "cgg", "\u0b1a\u0b3f\u0b17\u0b3e" },
            { "chb", "\u0b1a\u0b3f\u0b2c\u0b4d\u0b1a\u0b3e" },
            { "chg", "\u0b1b\u0b17\u0b24\u0b3e\u0b07" },
            { "chk", "\u0b1a\u0b41\u0b15\u0b40\u0b38\u0b47" },
            { "chm", "\u0b2e\u0b3e\u0b30\u0b40" },
            { "chn", "\u0b1a\u0b3f\u0b28\u0b41\u0b15\u0b4d \u0b1c\u0b3e\u0b30\u0b17\u0b3e\u0b01\u0b28\u0b4d" },
            { "cho", "\u0b1a\u0b4b\u0b1f\u0b71\u0b3e" },
            { "chp", "\u0b1a\u0b3f\u0b2a\u0b47\u0b71\u0b3e\u0b28\u0b4d" },
            { "chr", "\u0b1a\u0b47\u0b30\u0b4b\u0b15\u0b40" },
            { "chy", "\u0b1a\u0b47\u0b1a\u0b47\u0b28\u0b3e" },
            { "ckb", "\u0b15\u0b47\u0b28\u0b4d\u0b26\u0b4d\u0b30\u0b40\u0b5f \u0b15\u0b41\u0b30\u0b21\u0b3f\u0b38\u0b4d" },
            { "clc", "\u0b1a\u0b3f\u0b32\u0b15\u0b4b\u0b1f\u0b3f\u0b28\u0b4d" },
            { "cop", metaValue_cop },
            { "crg", "\u0b2e\u0b3f\u0b38\u0b3f\u0b2b" },
            { "crh", "\u0b15\u0b4d\u0b30\u0b40\u0b2e\u0b3f\u0b28\u0b4d \u0b24\u0b41\u0b30\u0b4d\u0b15\u0b40\u0b38\u0b4d" },
            { "crj", "\u0b38\u0b3e\u0b09\u0b25\u0b4d \u0b07\u0b37\u0b4d\u0b1f \u0b15\u0b4d\u0b30\u0b3f" },
            { "crk", "\u0b2a\u0b4d\u0b32\u0b47\u0b28\u0b4d\u0b38 \u0b15\u0b4d\u0b30\u0b3f" },
            { "crl", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b15\u0b4d\u0b30\u0b40" },
            { "crm", "\u0b2e\u0b41\u0b38\u0b47 \u0b15\u0b4d\u0b30\u0b40" },
            { "crr", "\u0b15\u0b3e\u0b30\u0b4b\u0b32\u0b3f\u0b28\u0b3e \u0b06\u0b32\u0b17\u0b4b\u0b28\u0b4d\u0b15\u0b3f\u0b06\u0b28\u0b4d" },
            { "crs", "\u0b38\u0b47\u0b38\u0b47\u0b32\u0b71\u0b3e \u0b15\u0b4d\u0b30\u0b47\u0b13\u0b32\u0b47 \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a\u0b4d" },
            { "csb", "\u0b15\u0b3e\u0b36\u0b41\u0b2c\u0b3f\u0b06\u0b28\u0b4d" },
            { "csw", "\u0b38\u0b4d\u0b71\u0b3e\u0b2e\u0b4d\u0b2a\u0b3f \u0b15\u0b4d\u0b30\u0b3f" },
            { "dak", "\u0b21\u0b3e\u0b15\u0b4b\u0b1f\u0b3e" },
            { "dar", "\u0b21\u0b3e\u0b30\u0b3e\u0b17\u0b4d\u0b71\u0b3e" },
            { "dav", "\u0b24\u0b3e\u0b07\u0b24\u0b3f" },
            { "del", "\u0b21\u0b47\u0b32\u0b3e\u0b71\u0b47\u0b30\u0b4d" },
            { "den", "\u0b38\u0b4d\u0b32\u0b47\u0b2d\u0b4d" },
            { "dgr", "\u0b21\u0b4b\u0b17\u0b4d\u0b30\u0b3f\u0b2c\u0b4d" },
            { "din", "\u0b26\u0b3f\u0b19\u0b4d\u0b15\u0b3e" },
            { "dje", "\u0b1c\u0b30\u0b4d\u0b2e\u0b3e" },
            { "doi", "\u0b21\u0b4b\u0b17\u0b4d\u0b30\u0b40" },
            { "dsb", "\u0b28\u0b3f\u0b2e\u0b4d\u0b28 \u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b06\u0b28\u0b4d\u200c" },
            { "dua", "\u0b21\u0b41\u0b06\u0b28\u0b3e" },
            { "dum", "\u0b2e\u0b27\u0b4d\u0b5f \u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b3e\u0b32\u0b40" },
            { "dyo", "\u0b1c\u0b4b\u0b32\u0b3e-\u0b2b\u0b4b\u0b28\u0b5f\u0b3f" },
            { "dyu", "\u0b21\u0b41\u0b06\u0b32\u0b3e" },
            { "dzg", "\u0b21\u0b3e\u0b1c\u0b3e\u0b17\u0b3e" },
            { "ebu", "\u0b0f\u0b2e\u0b4d\u0b35\u0b41" },
            { "efi", "\u0b0f\u0b2b\u0b3f\u0b15\u0b4d" },
            { "egy", "\u0b2a\u0b4d\u0b30\u0b3e\u0b1a\u0b40\u0b28\u0b4d \u0b2e\u0b3f\u0b36\u0b3f\u0b30\u0b3f" },
            { "eka", "\u0b0f\u0b15\u0b3e\u0b1c\u0b41\u0b15\u0b4d" },
            { "elx", "\u0b0f\u0b32\u0b3e\u0b2e\u0b3e\u0b07\u0b1f\u0b4d" },
            { "enm", "\u0b2e\u0b27\u0b4d\u0b5f \u0b07\u0b01\u0b30\u0b3e\u0b1c\u0b40" },
            { "ewo", "\u0b07\u0b71\u0b4b\u0b23\u0b4d\u0b21\u0b4b" },
            { "fan", "\u0b2b\u0b3e\u0b19\u0b4d\u0b17" },
            { "fat", "\u0b2b\u0b3e\u0b23\u0b4d\u0b1f\u0b3f" },
            { "fil", "\u0b2b\u0b3f\u0b32\u0b3f\u0b2a\u0b3f\u0b28\u0b4b" },
            { "fon", "\u0b2b\u0b28\u0b4d" },
            { "frc", "\u0b15\u0b3e\u0b1c\u0b41\u0b28\u0b4d \u0b2b\u0b30\u0b3e\u0b38\u0b40" },
            { "frm", "\u0b2e\u0b27\u0b4d\u0b5f \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a" },
            { "fro", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a" },
            { "frr", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b2b\u0b4d\u0b30\u0b3f\u0b38\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "frs", "\u0b2a\u0b42\u0b30\u0b4d\u0b2c \u0b2b\u0b4d\u0b30\u0b3f\u0b38\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "fur", "\u0b2b\u0b4d\u0b30\u0b3f\u0b5f\u0b41\u0b32\u0b40\u0b5f\u0b3e\u0b28\u0b4d" },
            { "gaa", "\u0b17\u0b3e" },
            { "gay", "\u0b17\u0b3e\u0b5f\u0b4b" },
            { "gba", "\u0b17\u0b2c\u0b3e\u0b5f\u0b3e" },
            { "gez", "\u0b17\u0b40\u0b1c\u0b4d" },
            { "gil", "\u0b1c\u0b3f\u0b2c\u0b4d\u0b30\u0b3e\u0b1f\u0b40\u0b1c\u0b4d" },
            { "gmh", "\u0b2e\u0b3f\u0b21\u0b3f\u0b32\u0b4d \u0b39\u0b3e\u0b07 \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "goh", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b39\u0b3e\u0b07 \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "gon", "\u0b17\u0b4b\u0b23\u0b4d\u0b21\u0b3f" },
            { "gor", "\u0b17\u0b4b\u0b30\u0b4b\u0b23\u0b4d\u0b1f\u0b3e\u0b32\u0b4b" },
            { "got", metaValue_got },
            { "grb", "\u0b17\u0b4d\u0b30\u0b47\u0b2c\u0b4b" },
            { "grc", "\u0b2a\u0b4d\u0b30\u0b3e\u0b1a\u0b40\u0b28\u0b4d \u0b5f\u0b41\u0b28\u0b3e\u0b28\u0b40" },
            { "gsw", "\u0b38\u0b41\u0b07\u0b38\u0b4d \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "guz", "\u0b17\u0b41\u0b38\u0b3f" },
            { "gwi", "\u0b17\u0b71\u0b3f\u0b1a\u2019\u0b07\u0b28\u0b4d" },
            { "hai", "\u0b39\u0b3e\u0b07\u0b21\u0b3e" },
            { "haw", "\u0b39\u0b3e\u0b71\u0b3e\u0b07\u0b28\u0b4d" },
            { "hax", "\u0b38\u0b3e\u0b09\u0b25\u0b4d \u0b39\u0b3e\u0b07\u0b21\u0b3e" },
            { "hil", "\u0b39\u0b3f\u0b32\u0b3f\u0b17\u0b48\u0b28\u0b28\u0b4d" },
            { "hit", "\u0b39\u0b3f\u0b24\u0b40\u0b24\u0b47" },
            { "hmn", "\u0b39\u0b01\u0b19\u0b4d\u0b17" },
            { "hsb", "\u0b09\u0b2a\u0b30 \u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b06\u0b28\u0b4d" },
            { "hup", "\u0b39\u0b41\u0b2a\u0b3e" },
            { "hur", "\u0b39\u0b3e\u0b32\u0b15\u0b4b\u0b2e\u0b47\u0b32\u0b47\u0b2e" },
            { "iba", "\u0b07\u0b2c\u0b3e\u0b28\u0b4d" },
            { "ibb", "\u0b07\u0b2c\u0b3f\u0b2c\u0b3f\u0b13" },
            { "ikt", "\u0b2a\u0b3e\u0b36\u0b4d\u0b1a\u0b3e\u0b24\u0b4d\u0b5f \u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3f\u0b5f \u0b07\u0b28\u0b41\u0b15\u0b4d\u0b1f\u0b3f\u0b1f" },
            { "ilo", "\u0b07\u0b32\u0b4b\u0b15\u0b4b" },
            { "inh", "\u0b07\u0b01\u0b19\u0b4d\u0b17\u0b41\u0b36\u0b4d" },
            { "jbo", "\u0b32\u0b4b\u0b1c\u0b2c\u0b3e\u0b28\u0b4d" },
            { "jgo", "\u0b28\u0b3e\u0b17\u0b4b\u0b2e\u0b4d\u0b35\u0b3e" },
            { "jmc", "\u0b2e\u0b3e\u0b1a\u0b47\u0b2e\u0b47" },
            { "jpr", "\u0b1c\u0b41\u0b21\u0b47\u0b13-\u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "jrb", "\u0b1c\u0b41\u0b21\u0b47\u0b13-\u0b06\u0b30\u0b2c\u0b40\u0b15\u0b4d" },
            { "kaa", "\u0b15\u0b3e\u0b30\u0b3e-\u0b15\u0b32\u0b4d\u0b2a\u0b15\u0b4d" },
            { "kab", "\u0b15\u0b2c\u0b3e\u0b07\u0b32\u0b4d" },
            { "kac", "\u0b15\u0b1a\u0b3f\u0b28\u0b4d" },
            { "kaj", "\u0b1c\u0b1c\u0b41" },
            { "kam", "\u0b15\u0b2e\u0b4d\u0b2c\u0b3e" },
            { "kaw", "\u0b15\u0b3e\u0b71\u0b3f" },
            { "kbd", "\u0b15\u0b3e\u0b2c\u0b3e\u0b30\u0b4d\u0b21\u0b3f\u0b06\u0b28\u0b4d" },
            { "kcg", "\u0b24\u0b4d\u0b5f\u0b3e\u0b2a\u0b4d" },
            { "kde", "\u0b2e\u0b3e\u0b15\u0b4b\u0b23\u0b4d\u0b21\u0b47" },
            { "kea", "\u0b15\u0b3e\u0b2c\u0b41\u0b2d\u0b47\u0b30\u0b21\u0b3f\u0b06\u0b28\u0b41" },
            { "kfo", "\u0b15\u0b4b\u0b30\u0b4b" },
            { "kgp", "\u0b15\u0b3e\u0b07\u0b19\u0b4d\u0b17\u0b3e\u0b02" },
            { "kha", "\u0b16\u0b3e\u0b38\u0b40" },
            { "kho", "\u0b16\u0b4b\u0b24\u0b3e\u0b28\u0b40\u0b1c\u0b4d" },
            { "khq", "\u0b15\u0b4b\u0b5f\u0b30\u0b3e \u0b1a\u0b3f\u0b28\u0b3f" },
            { "kkj", "\u0b15\u0b3e\u0b15\u0b4b" },
            { "kln", "\u0b15\u0b3e\u0b32\u0b47\u0b28\u0b1c\u0b3f\u0b28\u0b4d" },
            { "kmb", "\u0b15\u0b3f\u0b2e\u0b4d\u0b2c\u0b41\u0b23\u0b4d\u0b21\u0b41" },
            { "kok", "\u0b15\u0b4b\u0b19\u0b4d\u0b15\u0b23\u0b3f" },
            { "kos", "\u0b15\u0b4b\u0b38\u0b30\u0b48\u0b28\u0b4d" },
            { "kpe", "\u0b15\u0b48\u0b2a\u0b47\u0b32\u0b47" },
            { "krc", "\u0b15\u0b30\u0b3e\u0b1a\u0b5f-\u0b2c\u0b32\u0b4d\u0b15\u0b3e\u0b30" },
            { "krl", "\u0b15\u0b3e\u0b30\u0b47\u0b32\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "kru", "\u0b15\u0b41\u0b30\u0b41\u0b16" },
            { "ksb", "\u0b36\u0b3e\u0b2e\u0b2c\u0b3e\u0b32\u0b3e" },
            { "ksf", "\u0b2c\u0b3e\u0b2b\u0b32\u0b3e" },
            { "ksh", "\u0b15\u0b4b\u0b32\u0b4b\u0b2c\u0b28\u0b3f\u0b5f" },
            { "kum", "\u0b15\u0b41\u0b2e\u0b40\u0b15\u0b4d" },
            { "kut", "\u0b15\u0b41\u0b24\u0b47\u0b28\u0b3e\u0b09" },
            { "kwk", "\u0b15\u0b4d\u0b35\u0b3e\u0b15\u0b71\u0b3e\u0b32\u0b3e" },
            { "lad", "\u0b32\u0b3e\u0b26\u0b3f\u0b28\u0b4b" },
            { "lag", "\u0b32\u0b3e\u0b28\u0b17\u0b3f" },
            { "lah", "\u0b32\u0b3e\u0b39\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "lam", "\u0b32\u0b3e\u0b2e\u0b4d\u0b2c\u0b3e" },
            { "lez", "\u0b32\u0b47\u0b1c\u0b17\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "lil", "\u0b32\u0b3f\u0b32\u0b4d\u0b32\u0b41\u0b0f\u0b1f" },
            { "lkt", "\u0b32\u0b3e\u0b15\u0b4b\u0b1f\u0b3e" },
            { "lol", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b" },
            { "lou", "\u0b32\u0b4c\u0b38\u0b3f\u0b06\u0b28\u0b3e \u0b15\u0b4d\u0b30\u0b47\u0b13\u0b32\u0b47" },
            { "loz", "\u0b32\u0b4b\u0b1c\u0b3f" },
            { "lrc", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b32\u0b41\u0b30\u0b3f" },
            { "lsm", "\u0b38\u0b3e\u0b2e\u0b3f\u0b06" },
            { "lua", "\u0b32\u0b41\u0b2c\u0b3e-\u0b32\u0b41\u0b32\u0b41\u0b06" },
            { "lui", "\u0b32\u0b41\u0b07\u0b38\u0b47\u0b28\u0b4b" },
            { "lun", "\u0b32\u0b41\u0b23\u0b4d\u0b21\u0b3e" },
            { "luo", "\u0b32\u0b41\u0b13" },
            { "lus", "\u0b2e\u0b3f\u0b1c\u0b4b" },
            { "luy", "\u0b32\u0b41\u0b5f\u0b3f\u0b06" },
            { "mad", "\u0b2e\u0b3e\u0b26\u0b41\u0b30\u0b40\u0b38\u0b4d" },
            { "mag", "\u0b2e\u0b3e\u0b17\u0b3e\u0b39\u0b40" },
            { "mai", "\u0b2e\u0b48\u0b25\u0b3f\u0b33\u0b40" },
            { "mak", "\u0b2e\u0b15\u0b3e\u0b38\u0b30\u0b4d" },
            { "man", "\u0b2e\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b19\u0b4d\u0b17\u0b4b" },
            { "mas", "\u0b2e\u0b3e\u0b38\u0b3e\u0b07" },
            { "mdf", "\u0b2e\u0b4b\u0b15\u0b4d\u0b37" },
            { "mdr", "\u0b2e\u0b28\u0b4d\u0b26\u0b3e\u0b30" },
            { "men", "\u0b2e\u0b47\u0b28\u0b21\u0b47" },
            { "mer", "\u0b2e\u0b47\u0b30\u0b41" },
            { "mfe", "\u0b2e\u0b4b\u0b30\u0b3f\u0b38\u0b5f\u0b47\u0b28\u0b4d" },
            { "mga", "\u0b2e\u0b27\u0b4d\u0b5f \u0b07\u0b30\u0b3f\u0b36\u0b4d" },
            { "mgh", "\u0b2e\u0b16\u0b41\u0b71\u0b3e-\u0b2e\u0b47\u0b1f\u0b4d\u0b1f\u0b3e" },
            { "mgo", "\u0b2e\u0b47\u0b1f\u0b3e" },
            { "mic", "\u0b2e\u0b3f\u0b15\u0b2e\u0b4c\u0b15\u0b4d" },
            { "min", "\u0b2e\u0b3f\u0b28\u0b3e\u0b19\u0b4d\u0b17\u0b3e\u0b2c\u0b3e\u0b09" },
            { "mnc", "\u0b2e\u0b3e\u0b1e\u0b4d\u0b1a\u0b41" },
            { "mni", "\u0b2e\u0b23\u0b3f\u0b2a\u0b41\u0b30\u0b40" },
            { "moe", "\u0b07\u0b28\u0b4d\u0b28\u0b41-\u0b0f\u0b2e\u0b41\u0b28" },
            { "moh", "\u0b2e\u0b4b\u0b39\u0b4c\u0b15" },
            { "mos", "\u0b2e\u0b4b\u0b38\u0b3f" },
            { "mua", "\u0b2e\u0b41\u0b28\u0b21\u0b3e\u0b02" },
            { "mul", "\u0b2c\u0b3f\u0b2c\u0b3f\u0b27 \u0b2d\u0b3e\u0b37\u0b3e\u0b2e\u0b3e\u0b28" },
            { "mus", "\u0b15\u0b4d\u0b30\u0b40\u0b15\u0b4d" },
            { "mwl", "\u0b2e\u0b3f\u0b30\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b1c\u0b4d" },
            { "mwr", "\u0b2e\u0b3e\u0b30\u0b71\u0b3e\u0b30\u0b40" },
            { "myv", "\u0b0f\u0b30\u0b4d\u0b1c\u0b5f\u0b3e" },
            { "mzn", "\u0b2e\u0b3e\u0b1c\u0b3e\u0b28\u0b21\u0b47\u0b30\u0b3e\u0b28\u0b3f" },
            { "nap", "\u0b28\u0b40\u0b2a\u0b4b\u0b32\u0b3f\u0b1f\u0b3e\u0b28\u0b4d" },
            { "naq", "\u0b28\u0b3e\u0b2e\u0b3e" },
            { "nds", "\u0b32\u0b4b \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "new", "\u0b28\u0b47\u0b71\u0b3e\u0b30\u0b40" },
            { "nia", "\u0b28\u0b40\u0b5f\u0b3e\u0b38\u0b4d" },
            { "niu", "\u0b28\u0b3f\u0b5f\u0b41\u0b06\u0b28\u0b4d" },
            { "nmg", "\u0b15\u0b71\u0b3e\u0b38\u0b3f\u0b13" },
            { "nnh", "\u0b28\u0b3e\u0b17\u0b3f\u0b2e\u0b2c\u0b4b\u0b28\u0b4d" },
            { "nog", "\u0b28\u0b4b\u0b17\u0b3e\u0b07" },
            { "non", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b28\u0b30\u0b4d\u0b38" },
            { "nqo", "\u0b0f\u0b28\u0b15\u0b4b" },
            { "nso", "\u0b09\u0b24\u0b4d\u0b24\u0b30\u0b40 \u0b38\u0b4b\u0b25\u0b4b" },
            { "nus", "\u0b28\u0b41\u0b0f\u0b30" },
            { "nwc", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b28\u0b47\u0b71\u0b3e\u0b30\u0b40" },
            { "nym", "\u0b28\u0b4d\u0b5f\u0b3e\u0b2e\u0b71\u0b47\u0b1c\u0b40" },
            { "nyn", "\u0b28\u0b4d\u0b5f\u0b3e\u0b28\u0b15\u0b4b\u0b32\u0b4d" },
            { "nyo", "\u0b28\u0b4d\u0b5f\u0b3e\u0b30\u0b4b" },
            { "nzi", "\u0b1e\u0b4d\u0b1c\u0b3f\u0b2e\u0b3e" },
            { "ojb", "\u0b09\u0b24\u0b4d\u0b24\u0b30-\u0b2a\u0b36\u0b4d\u0b1a\u0b3f\u0b2e \u0b13\u0b1c\u0b3f\u0b2c\u0b4d\u0b35\u0b3e" },
            { "ojc", "\u0b15\u0b47\u0b28\u0b4d\u0b26\u0b4d\u0b30\u0b40\u0b5f \u0b13\u0b1c\u0b3f\u0b2c\u0b4d\u0b35\u0b3e" },
            { "ojs", "\u0b13\u0b1c\u0b3f-\u0b15\u0b4d\u0b30\u0b3f" },
            { "ojw", "\u0b2a\u0b3e\u0b36\u0b4d\u0b1a\u0b3e\u0b24\u0b4d\u0b5f \u0b13\u0b1c\u0b3f\u0b2c\u0b4d\u0b35\u0b3e" },
            { "oka", "\u0b13\u0b15\u0b3e\u0b28\u0b3e\u0b17\u0b3e\u0b28\u0b4d" },
            { "osa", "\u0b71\u0b4c\u0b38\u0b47\u0b1c\u0b4d" },
            { "ota", "\u0b13\u0b1f\u0b4d\u0b1f\u0b4b\u0b2e\u0b28\u0b4d \u0b24\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b38\u0b4d" },
            { "pag", "\u0b2a\u0b3e\u0b19\u0b4d\u0b17\u0b3e\u0b38\u0b3f\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "pal", "\u0b2a\u0b3e\u0b39\u0b4d\u0b32\u0b3e\u0b2d\u0b3f" },
            { "pam", "\u0b2a\u0b3e\u0b2e\u0b4d\u0b2a\u0b3e\u0b19\u0b4d\u0b17\u0b3e" },
            { "pap", "\u0b2a\u0b3e\u0b2a\u0b3f\u0b06\u0b2e\u0b47\u0b23\u0b4d\u0b1f\u0b4b" },
            { "pau", "\u0b2a\u0b3e\u0b32\u0b3e\u0b09\u0b06\u0b28\u0b4d" },
            { "pcm", "\u0b28\u0b3e\u0b07\u0b1c\u0b47\u0b30\u0b40\u0b5f \u0b2a\u0b3f\u0b21\u0b17\u0b3f\u0b28\u0b4d" },
            { "peo", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "phn", "\u0b2b\u0b4b\u0b28\u0b47\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "pis", "\u0b2a\u0b3f\u0b1c\u0b3f\u0b28\u0b4d" },
            { "pon", "\u0b2a\u0b4b\u0b39\u0b2a\u0b3f\u0b0f\u0b28\u0b4d" },
            { "pqm", "\u0b2e\u0b3e\u0b32\u0b3f\u0b38\u0b40\u0b1f-\u0b2a\u0b3e\u0b38\u0b2e\u0b15\u0b41\u0b05\u0b21\u0b4d\u0b21\u0b3f" },
            { "prg", "\u0b2a\u0b4d\u0b30\u0b41\u0b38\u0b3f\u0b5f" },
            { "pro", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b2a\u0b4d\u0b30\u0b47\u0b2d\u0b47\u0b28\u0b47\u0b38\u0b3f\u0b06\u0b32\u0b4d" },
            { "quc", "\u0b15\u0b3f\u0b1a\u0b47" },
            { "raj", "\u0b30\u0b3e\u0b1c\u0b38\u0b4d\u0b25\u0b3e\u0b28\u0b40" },
            { "rap", "\u0b30\u0b3e\u0b2a\u0b3e\u0b28\u0b41\u0b07" },
            { "rar", "\u0b30\u0b3e\u0b30\u0b4b\u0b24\u0b4b\u0b19\u0b4d\u0b17\u0b28\u0b4d" },
            { "rhg", "\u0b30\u0b4b\u0b39\u0b3f\u0b19\u0b4d\u0b17\u0b4d\u0b5f\u0b3e" },
            { "rof", "\u0b30\u0b4b\u0b2e\u0b4d\u0b2c\u0b4b" },
            { "rom", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f" },
            { "rup", "\u0b06\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "rwk", "\u0b06\u0b30\u0b21\u0b2c\u0b4d\u0b5f\u0b41\u0b0f" },
            { "sad", "\u0b38\u0b23\u0b4d\u0b21\u0b3e\u0b71\u0b47" },
            { "sah", "\u0b38\u0b3e\u0b16\u0b3e" },
            { "sam", "\u0b38\u0b3e\u0b2e\u0b4c\u0b30\u0b3f\u0b1f\u0b28\u0b4d \u0b06\u0b30\u0b2e\u0b3e\u0b07\u0b15\u0b4d" },
            { "saq", "\u0b38\u0b2e\u0b2c\u0b41\u0b30\u0b41" },
            { "sas", "\u0b38\u0b3e\u0b38\u0b3e\u0b15\u0b4d" },
            { "sat", "\u0b38\u0b3e\u0b28\u0b4d\u0b24\u0b3e\u0b33\u0b3f" },
            { "sba", "\u0b28\u0b17\u0b3e\u0b2e\u0b2c\u0b47" },
            { "sbp", "\u0b38\u0b3e\u0b28\u0b17\u0b41" },
            { "scn", "\u0b38\u0b3f\u0b36\u0b3f\u0b32\u0b3f\u0b06\u0b28\u0b4d" },
            { "sco", "\u0b38\u0b4d\u0b15\u0b1f\u0b38\u0b4d" },
            { "seh", "\u0b38\u0b47\u0b28\u0b3e" },
            { "sel", "\u0b38\u0b47\u0b32\u0b4d\u0b15\u0b2a\u0b4d" },
            { "ses", "\u0b15\u0b4b\u0b5f\u0b30\u0b3e \u0b38\u0b47\u0b28\u0b4d\u0b28\u0b3f" },
            { "sga", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b07\u0b30\u0b3f\u0b36\u0b4d" },
            { "shi", "\u0b24\u0b3e\u0b1a\u0b47\u0b32\u0b39\u0b3f\u0b1f\u0b4d" },
            { "shn", "\u0b36\u0b3e\u0b28\u0b4d" },
            { "sid", "\u0b38\u0b3f\u0b26\u0b3e\u0b2e\u0b4b" },
            { "slh", "\u0b38\u0b3e\u0b09\u0b25\u0b4d \u0b32\u0b41\u0b36\u0b4b\u0b38\u0b3f\u0b1f\u0b47\u0b21\u0b4d" },
            { "sma", "\u0b26\u0b15\u0b4d\u0b37\u0b3f\u0b23 \u0b38\u0b3e\u0b2e\u0b3f" },
            { "smj", "\u0b32\u0b41\u0b32\u0b47 \u0b38\u0b3e\u0b2e\u0b3f" },
            { "smn", "\u0b07\u0b28\u0b3e\u0b30\u0b40 \u0b38\u0b3e\u0b2e\u0b3f" },
            { "sms", "\u0b38\u0b4d\u0b15\u0b4b\u0b32\u0b4d\u0b1f \u0b38\u0b3e\u0b2e\u0b3f" },
            { "snk", "\u0b38\u0b4b\u0b28\u0b3f\u0b19\u0b4d\u0b15\u0b47" },
            { "sog", "\u0b38\u0b4b\u0b17\u0b21\u0b3f\u0b0f\u0b28\u0b4d" },
            { "srn", "\u0b36\u0b3e\u0b30\u0b3e\u0b28\u0b3e \u0b1f\u0b4b\u0b19\u0b4d\u0b17\u0b4b" },
            { "srr", "\u0b36\u0b47\u0b30\u0b47\u0b30\u0b4d" },
            { "ssy", "\u0b38\u0b39\u0b4b" },
            { "str", "\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3e\u0b07\u0b1f\u0b4d \u0b38\u0b3e\u0b32\u0b3f\u0b36\u0b4d" },
            { "suk", "\u0b38\u0b41\u0b15\u0b41\u0b2e\u0b3e" },
            { "sus", "\u0b36\u0b41\u0b36\u0b41" },
            { "sux", "\u0b38\u0b41\u0b2e\u0b47\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "swb", "\u0b15\u0b4b\u0b2e\u0b4b\u0b30\u0b3f\u0b5f" },
            { "syc", "\u0b15\u0b4d\u0b32\u0b3e\u0b38\u0b3f\u0b15\u0b3e\u0b32\u0b4d \u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "syr", "\u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "tce", "\u0b38\u0b3e\u0b09\u0b25\u0b4d \u0b1f\u0b1a\u0b4b\u0b28\u0b4d" },
            { "tem", "\u0b24\u0b3f\u0b2e\u0b28\u0b47" },
            { "teo", "\u0b24\u0b47\u0b38\u0b3e" },
            { "ter", "\u0b24\u0b47\u0b30\u0b47\u0b28\u0b4b" },
            { "tet", "\u0b24\u0b47\u0b24\u0b41\u0b2e\u0b4d" },
            { "tgx", "\u0b24\u0b3e\u0b17\u0b3f\u0b36" },
            { "tht", "\u0b24\u0b39\u0b32\u0b24\u0b3e\u0b28\u0b4d" },
            { "tig", "\u0b1f\u0b3e\u0b07\u0b17\u0b4d\u0b30\u0b47" },
            { "tiv", "\u0b24\u0b40\u0b2d\u0b4d" },
            { "tkl", metaValue_TK },
            { "tlh", "\u0b15\u0b4d\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b28\u0b4d" },
            { "tli", "\u0b24\u0b4d\u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b3f\u0b1f\u0b4d" },
            { "tmh", "\u0b24\u0b3e\u0b2e\u0b3e\u0b36\u0b47\u0b15\u0b4d" },
            { "tog", "\u0b28\u0b4d\u0b5f\u0b3e\u0b38\u0b3e \u0b1f\u0b4b\u0b19\u0b4d\u0b17\u0b4b" },
            { "tok", "\u0b1f\u0b4b\u0b15\u0b3f \u0b2a\u0b4b\u0b28\u0b3e" },
            { "tpi", "\u0b1f\u0b4b\u0b15\u0b4d \u0b2a\u0b3f\u0b38\u0b3f\u0b28\u0b4d" },
            { "trv", "\u0b24\u0b3e\u0b30\u0b4b\u0b15\u0b4b" },
            { "tsi", "\u0b24\u0b3f\u0b38\u0b3f\u0b2e\u0b3f\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "ttm", "\u0b09\u0b24\u0b4d\u0b24\u0b30 \u0b1f\u0b41\u0b1a\u0b4b\u0b28\u0b4d" },
            { "tum", "\u0b1f\u0b41\u0b2e\u0b4d\u0b2c\u0b41\u0b15\u0b3e" },
            { "tvl", metaValue_TV },
            { "twq", "\u0b24\u0b3e\u0b38\u0b3e\u0b71\u0b3e\u0b15\u0b4d" },
            { "tyv", "\u0b24\u0b41\u0b2d\u0b3f\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "tzm", "\u0b15\u0b47\u0b28\u0b4d\u0b26\u0b4d\u0b30\u0b40\u0b5f \u0b06\u0b1f\u0b32\u0b3e\u0b38\u0b4d \u0b1f\u0b3e\u0b2e\u0b3e\u0b1c\u0b3f\u0b18\u0b3e\u0b1f\u0b4d" },
            { "udm", "\u0b09\u0b26\u0b2e\u0b42\u0b30\u0b4d\u0b24\u0b4d\u0b24" },
            { "uga", "\u0b5f\u0b41\u0b17\u0b4b\u0b30\u0b1f\u0b3f\u0b15\u0b4d" },
            { "umb", "\u0b09\u0b2e\u0b4d\u0b2c\u0b41\u0b23\u0b4d\u0b21\u0b41" },
            { "und", "\u0b05\u0b1c\u0b23\u0b3e \u0b2d\u0b3e\u0b37\u0b3e" },
            { "vai", "\u0b2d\u0b3e\u0b07" },
            { "vot", "\u0b2d\u0b4b\u0b1f\u0b3f\u0b15\u0b4d" },
            { "vun", "\u0b2d\u0b41\u0b28\u0b1c\u0b4b" },
            { "wae", "\u0b71\u0b3e\u0b32\u0b38\u0b47\u0b30\u0b4d" },
            { "wal", "\u0b71\u0b3e\u0b32\u0b2e\u0b4b" },
            { "war", "\u0b71\u0b3e\u0b30\u0b48" },
            { "was", "\u0b71\u0b3e\u0b38\u0b4b" },
            { "wuu", "\u0b71\u0b41 \u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c" },
            { "xal", "\u0b15\u0b3e\u0b32\u0b4d\u0b2e\u0b40\u0b15\u0b4d" },
            { "xog", "\u0b38\u0b4b\u0b17\u0b3e" },
            { "yao", "\u0b5f\u0b3e\u0b13" },
            { "yap", "\u0b5f\u0b3e\u0b2a\u0b40\u0b38\u0b4d" },
            { "yav", "\u0b5f\u0b3e\u0b02\u0b2c\u0b47\u0b28\u0b4d" },
            { "ybb", "\u0b5f\u0b47\u0b2e\u0b2c\u0b3e" },
            { "yrl", "\u0b28\u0b3f\u0b19\u0b4d\u0b17\u0b3e\u0b1f\u0b41" },
            { "yue", "\u0b15\u0b3e\u0b28\u0b1f\u0b4b\u0b28\u0b47\u0b38\u0b47" },
            { "zap", "\u0b1c\u0b3e\u0b2a\u0b4b\u0b1f\u0b47\u0b15\u0b4d" },
            { "zbl", metaValue_zbl },
            { "zen", "\u0b1c\u0b47\u0b28\u0b3e\u0b17\u0b3e" },
            { "zgh", "\u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b2e\u0b30\u0b4b\u0b15\u0b3f\u0b5f \u0b24\u0b3e\u0b2e\u0b3e\u0b1c\u0b3f\u0b18\u0b3e\u0b1f\u0b4d" },
            { "zun", "\u0b1c\u0b41\u0b28\u0b40" },
            { "zxx", "\u0b15\u0b4c\u0b23\u0b38\u0b3f \u0b32\u0b3f\u0b19\u0b4d\u0b17\u0b41\u0b07\u0b37\u0b4d\u0b1f \u0b38\u0b3e\u0b2e\u0b17\u0b4d\u0b30\u0b40 \u0b28\u0b3e\u0b39\u0b3f\u0b01" },
            { "zza", "\u0b1c\u0b3e\u0b1c\u0b3e" },
            { "Adlm", "\u0b06\u0b21\u0b32\u0b2e\u0b4d" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0b06\u0b30\u0b3e\u0b28" },
            { "Armi", "\u0b07\u0b2e\u0b4d\u0b2a\u0b47\u0b30\u0b3f\u0b06\u0b32\u0b4d \u0b06\u0b30\u0b2e\u0b3f\u0b15\u0b4d" },
            { "Armn", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b40\u0b5f" },
            { "Avst", "\u0b06\u0b2c\u0b47\u0b38\u0b4d\u0b25\u0b3e\u0b28\u0b4d" },
            { "Bali", metaValue_ban },
            { "Batk", "\u0b2c\u0b3e\u0b1f\u0b3e\u0b15\u0b4d" },
            { "Beng", "\u0b2c\u0b19\u0b4d\u0b17\u0b3e\u0b33\u0b40" },
            { "Blis", metaValue_zbl },
            { "Bopo", "\u0b2c\u0b4b\u0b2a\u0b4b\u0b2e\u0b4b\u0b2b\u0b4b" },
            { "Brah", "\u0b2c\u0b4d\u0b30\u0b3e\u0b39\u0b4d\u0b2e\u0b40" },
            { "Brai", "\u0b2c\u0b4d\u0b30\u0b47\u0b32\u0b4d" },
            { "Bugi", "\u0b2c\u0b41\u0b17\u0b3e\u0b28\u0b40\u0b1c\u0b4d" },
            { "Buhd", "\u0b2c\u0b41\u0b39\u0b3f\u0b26\u0b4d" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u0b5f\u0b41\u0b28\u0b3f\u0b2b\u0b3e\u0b0f\u0b21\u0b4d \u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3f\u0b06\u0b28\u0b4d \u0b06\u0b2c\u0b4d\u0b30\u0b4b\u0b1c\u0b3f\u0b28\u0b3e\u0b32\u0b4d \u0b38\u0b3f\u0b32\u0b3e\u0b2c\u0b3f\u0b15\u0b38\u0b4d" },
            { "Cari", "\u0b15\u0b48\u0b30\u0b28\u0b4d" },
            { "Cham", "\u0b1b\u0b2e\u0b4d" },
            { "Cher", "\u0b1a\u0b3f\u0b30\u0b41\u0b15\u0b40" },
            { "Cirt", "\u0b38\u0b3f\u0b30\u0b4d\u0b25" },
            { "Copt", "\u0b15\u0b2a\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Cprt", "\u0b38\u0b3f\u0b2a\u0b4d\u0b30\u0b05\u0b1f\u0b4d" },
            { "Cyrl", "\u0b38\u0b3f\u0b30\u0b3f\u0b32\u0b3f\u0b15\u0b4d" },
            { "Cyrs", "\u0b13\u0b32\u0b4d\u0b21 \u0b1a\u0b30\u0b4d\u0b1a\u0b4d\u0b1a \u0b38\u0b3e\u0b32\u0b2d\u0b4b\u0b28\u0b3f\u0b15\u0b4d \u0b38\u0b3f\u0b30\u0b3f\u0b32\u0b3f\u0b15\u0b4d" },
            { "Deva", "\u0b26\u0b47\u0b2c\u0b28\u0b17\u0b30\u0b40" },
            { "Dsrt", "\u0b21\u0b47\u0b38\u0b30\u0b4d\u0b1f" },
            { "Egyd", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f\u0b3f\u0b06\u0b28\u0b4d \u0b21\u0b47\u0b2e\u0b4b\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Egyh", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f\u0b3f\u0b06\u0b28\u0b4d \u0b39\u0b3e\u0b07\u0b05\u0b30\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Egyp", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f\u0b3f\u0b06\u0b28\u0b4d \u0b39\u0b3e\u0b05\u0b30\u0b17\u0b4d\u0b32\u0b3f\u0b2a\u0b38\u0b4d" },
            { "Ethi", "\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b15\u0b4d\u200c" },
            { "Geok", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06\u0b28\u0b4d \u0b16\u0b41\u0b1f\u0b38\u0b41\u0b30\u0b40" },
            { "Geor", metaValue_ka },
            { "Glag", "\u0b17\u0b4d\u0b32\u0b3e\u0b17\u0b4d\u0b32\u0b4b\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0b17\u0b41\u0b30\u0b2e\u0b41\u0b16\u0b40" },
            { "Hanb", "\u0b2c\u0b4b\u0b2a\u0b4b\u0b2e\u0b4b\u0b2b\u0b4b \u0b38\u0b39\u0b3f\u0b24 \u0b39\u0b3e\u0b28\u0b4d\u200c" },
            { "Hang", "\u0b39\u0b3e\u0b19\u0b4d\u0b17\u0b41\u0b32\u0b4d" },
            { "Hani", "\u0b39\u0b3e\u0b28\u0b4d" },
            { "Hano", "\u0b39\u0b3e\u0b28\u0b41\u0b28\u0b4d" },
            { "Hans", "\u0b38\u0b30\u0b33\u0b40\u0b15\u0b43\u0b24" },
            { "Hant", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15" },
            { "Hebr", "\u0b39\u0b3f\u0b2c\u0b43" },
            { "Hira", "\u0b39\u0b3f\u0b30\u0b3e\u0b17\u0b3e\u0b28\u0b3e" },
            { "Hmng", "\u0b2a\u0b3e\u0b39\u0b4b \u0b39\u0b4b\u0b19\u0b4d\u0b17" },
            { "Hrkt", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40 \u0b38\u0b3f\u0b32\u0b3e\u0b2c\u0b30\u0b3f\u0b1c\u0b4d\u200c" },
            { "Hung", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "Inds", "\u0b38\u0b3f\u0b28\u0b4d\u0b27\u0b41" },
            { "Ital", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b07\u0b1f\u0b3e\u0b32\u0b40" },
            { "Jamo", "\u0b1c\u0b3e\u0b2e\u0b4b" },
            { "Java", metaValue_jv },
            { "Jpan", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40\u0b1c\u0b4d" },
            { "Kali", "\u0b15\u0b3e\u0b5f\u0b3e\u0b39\u0b3e \u0b32\u0b40" },
            { "Kana", "\u0b15\u0b3e\u0b24\u0b3e\u0b15\u0b3e\u0b28\u0b3e" },
            { "Khar", "\u0b16\u0b3e\u0b30\u0b4b\u0b38\u0b4d\u0b25\u0b3f" },
            { "Khmr", "\u0b16\u0b2e\u0b47\u0b30\u0b4d" },
            { "Knda", "\u0b15\u0b28\u0b4d\u0b28\u0b21\u0b3c" },
            { "Kore", metaValue_ko },
            { "Kthi", "\u0b15\u0b48\u0b25\u0b3f" },
            { "Lana", "\u0b32\u0b3e\u0b28\u0b3e" },
            { "Laoo", metaValue_lo },
            { "Latf", "\u0b2b\u0b4d\u0b30\u0b3e\u0b15\u0b25\u0b41\u0b30\u0b4d \u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d" },
            { "Latg", "\u0b17\u0b3e\u0b0f\u0b32\u0b3f\u0b15\u0b4d \u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d" },
            { "Latn", metaValue_la },
            { "Lepc", "\u0b32\u0b47\u0b2a\u0b1a\u0b3e" },
            { "Limb", "\u0b32\u0b3f\u0b2e\u0b4d\u0b2c\u0b41" },
            { "Lina", "\u0b32\u0b3f\u0b28\u0b3f\u0b5f\u0b30\u0b4d" },
            { "Linb", "\u0b32\u0b3f\u0b28\u0b3f\u0b5f\u0b30\u0b4d \u0b2c\u0b3f" },
            { "Lyci", "\u0b32\u0b3f\u0b36\u0b3f\u0b5f\u0b28\u0b4d" },
            { "Lydi", "\u0b32\u0b3f\u0b21\u0b3f\u0b5f\u0b28\u0b4d" },
            { "Mand", "\u0b2e\u0b3e\u0b28\u0b21\u0b47\u0b28\u0b4d" },
            { "Mani", "\u0b2e\u0b28\u0b36\u0b40\u0b28\u0b4d" },
            { "Maya", "\u0b2e\u0b5f\u0b3e\u0b28\u0b4d \u0b39\u0b3e\u0b5f\u0b30\u0b32\u0b1c\u0b3f\u0b15\u0b38\u0b4d" },
            { "Mero", "\u0b2e\u0b47\u0b30\u0b4b\u0b07\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Mlym", metaValue_ml },
            { "Mong", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b3f\u0b06\u0b28\u0b4d" },
            { "Moon", "\u0b1a\u0b28\u0b4d\u0b26\u0b4d\u0b30" },
            { "Mtei", "\u0b2e\u0b3e\u0b0f\u0b24\u0b3f \u0b2e\u0b3e\u0b5f\u0b47\u0b15\u0b4d" },
            { "Mymr", "\u0b2e\u0b4d\u0b5f\u0b3e\u0b28\u0b2e\u0b3e\u0b30\u0b4d" },
            { "Nkoo", "\u0b0f\u0b28\u0b4d \u0b15\u0b4b" },
            { "Ogam", "\u0b13\u0b18\u0b3e\u0b2e\u0b3e" },
            { "Olck", "\u0b13\u0b32\u0b4d \u0b1a\u0b3f\u0b15\u0b3f" },
            { "Orkh", "\u0b13\u0b30\u0b4b\u0b16\u0b28\u0b4d" },
            { "Orya", metaValue_or },
            { "Osma", "\u0b13\u0b38\u0b4b\u0b2e\u0b3e\u0b28\u0b3f\u0b5f\u0b3e" },
            { "Perm", "\u0b13\u0b32\u0b4d\u0b21 \u0b2a\u0b30\u0b2e\u0b3f\u0b15\u0b4d" },
            { "Phag", "\u0b2b\u0b3e\u0b17\u0b38\u0b4d-\u0b2a\u0b3e" },
            { "Phli", "\u0b07\u0b28\u0b38\u0b4d\u0b15\u0b4d\u0b30\u0b40\u0b2a\u0b38\u0b3e\u0b28\u0b32\u0b4d \u0b2a\u0b3e\u0b39\u0b3e\u0b32\u0b3e\u0b71\u0b40" },
            { "Phlp", "\u0b38\u0b4d\u0b32\u0b3e\u0b1f\u0b30\u0b4d \u0b2a\u0b3e\u0b39\u0b3e\u0b32\u0b3e\u0b71\u0b40" },
            { "Phlv", "\u0b2c\u0b41\u0b15\u0b4d \u0b2a\u0b3e\u0b39\u0b3e\u0b32\u0b3e\u0b71\u0b40" },
            { "Phnx", "\u0b2b\u0b47\u0b28\u0b4b\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "Plrd", "\u0b2a\u0b4b\u0b32\u0b3e\u0b30\u0b4d\u0b21 \u0b2b\u0b4b\u0b28\u0b47\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Prti", "\u0b07\u0b28\u0b38\u0b4d\u0b15\u0b4d\u0b30\u0b40\u0b2a\u0b38\u0b3e\u0b28\u0b32\u0b4d \u0b2a\u0b3e\u0b30\u0b4d\u0b25\u0b3f\u0b06\u0b28\u0b4d" },
            { "Rjng", "\u0b30\u0b47\u0b1c\u0b3e\u0b19\u0b4d\u0b17" },
            { "Rohg", "\u0b30\u0b4b\u0b39\u0b17" },
            { "Roro", "\u0b30\u0b4b\u0b19\u0b4d\u0b17\u0b4b\u0b30\u0b4b\u0b19\u0b4d\u0b17\u0b4b" },
            { "Runr", "\u0b30\u0b28\u0b3f\u0b15\u0b4d" },
            { "Samr", "\u0b38\u0b2e\u0b4c\u0b30\u0b3f\u0b1f\u0b28\u0b4d" },
            { "Sara", "\u0b38\u0b3e\u0b30\u0b3e\u0b24\u0b3f" },
            { "Saur", "\u0b38\u0b4c\u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30" },
            { "Sgnw", "\u0b38\u0b3e\u0b19\u0b4d\u0b15\u0b47\u0b24\u0b3f\u0b15 \u0b32\u0b3f\u0b16" },
            { "Shaw", "\u0b38\u0b3e\u0b2c\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "\u0b38\u0b40\u0b32\u0b3f\u0b24\u0b4b \u0b28\u0b17\u0b30\u0b40" },
            { "Syrc", "\u0b38\u0b3f\u0b30\u0b3f\u0b5f\u0b3e\u0b15\u0b4d" },
            { "Syre", "\u0b0f\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3e\u0b19\u0b4d\u0b17\u0b47\u0b32\u0b4b \u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "Syrj", "\u0b71\u0b47\u0b37\u0b4d\u0b1f\u0b30\u0b4d\u0b28 \u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "Syrn", "\u0b07\u0b37\u0b4d\u0b1f\u0b30\u0b4d\u0b28 \u0b38\u0b3f\u0b30\u0b3f\u0b15\u0b4d" },
            { "Tagb", "\u0b24\u0b17\u0b2c\u0b3e\u0b28\u0b4d\u0b71\u0b3e" },
            { "Tale", "\u0b24\u0b3e\u0b07 \u0b32\u0b47" },
            { "Talu", "\u0b28\u0b42\u0b24\u0b28 \u0b24\u0b3e\u0b07 \u0b32\u0b41\u0b0f" },
            { "Taml", metaValue_ta },
            { "Tavt", "\u0b24\u0b3e\u0b07 \u0b2d\u0b3f\u0b0f\u0b24\u0b4d" },
            { "Telu", metaValue_te },
            { "Teng", "\u0b24\u0b47\u0b19\u0b4d\u0b17\u0b71\u0b3e\u0b30\u0b4d" },
            { "Tfng", "\u0b24\u0b3f\u0b2b\u0b3f\u0b19\u0b4d\u0b18\u0b3e" },
            { "Tglg", "\u0b1f\u0b3e\u0b17\u0b3e\u0b32\u0b4b\u0b17\u0b4d" },
            { "Thaa", "\u0b25\u0b3e\u0b28\u0b3e" },
            { "Thai", metaValue_th },
            { "Tibt", "\u0b24\u0b3f\u0b2c\u0b47\u0b24\u0b3e\u0b28\u0b4d" },
            { "Ugar", "\u0b5f\u0b41\u0b17\u0b3e\u0b30\u0b3f\u0b1f\u0b3f\u0b15\u0b4d" },
            { "Vaii", "\u0b71\u0b3e\u0b07" },
            { "Visp", "\u0b2d\u0b3f\u0b1c\u0b3f\u0b2c\u0b32\u0b4d \u0b38\u0b4d\u0b2a\u0b3f\u0b1a\u0b4d" },
            { "Xpeo", "\u0b2a\u0b41\u0b30\u0b41\u0b23\u0b3e \u0b2b\u0b30\u0b3e\u0b38\u0b40" },
            { "Xsux", "\u0b38\u0b41\u0b2e\u0b47\u0b30\u0b4b-\u0b06\u0b15\u0b4d\u0b15\u0b3e\u0b21\u0b3f\u0b06\u0b28\u0b4d \u0b38\u0b41\u0b28\u0b3f\u0b2b\u0b30\u0b4d\u0b2e" },
            { "Yiii", "\u0b5f\u0b40" },
            { "Zinh", "\u0b2c\u0b02\u0b36\u0b17\u0b24" },
            { "Zmth", "\u0b17\u0b3e\u0b23\u0b3f\u0b24\u0b3f\u0b15 \u0b28\u0b4b\u0b1f\u0b47\u0b38\u0b28\u0b4d" },
            { "Zsye", "\u0b07\u0b2e\u0b4b\u0b1c\u0b3f" },
            { "Zsym", "\u0b38\u0b19\u0b4d\u0b15\u0b47\u0b24\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "Zxxx", "\u0b05\u0b32\u0b3f\u0b16\u0b3f\u0b24" },
            { "Zyyy", "\u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23" },
            { "Zzzz", "\u0b05\u0b1c\u0b23\u0b3e \u0b32\u0b3f\u0b2a\u0b3f" },
            { "de_AT", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3f\u0b06\u0b28\u0b4d \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28" },
            { "de_CH", "\u0b38\u0b4d\u0b71\u0b3f\u0b38\u0b4d\u200c \u0b39\u0b3e\u0b07 \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28" },
            { "en_AU", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b3f\u0b5f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "en_CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3f\u0b5f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "en_GB", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d\u200c \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "en_US", "\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b40\u0b5f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "es_ES", "\u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b40\u0b5f \u0b38\u0b4d\u0b2a\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u200c" },
            { "es_MX", "\u0b2e\u0b47\u0b15\u0b4d\u0b38\u0b3f\u0b15\u0b3e\u0b28 \u0b38\u0b4d\u0b2a\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u200c" },
            { "fa_AF", "\u0b26\u0b3e\u0b30\u0b3f" },
            { "fr_CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3f\u0b5f \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a" },
            { "fr_CH", "\u0b38\u0b4d\u0b71\u0b3f\u0b38\u0b4d \u0b2b\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a" },
            { "nl_BE", "\u0b2b\u0b4d\u0b32\u0b47\u0b2e\u0b3f\u0b36\u0b4d" },
            { "pt_BR", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b32\u0b3f\u0b06\u0b28\u0b4d \u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d" },
            { "pt_PT", "\u0b5f\u0b41\u0b30\u0b4b\u0b2a\u0b40\u0b5f \u0b2a\u0b30\u0b4d\u0b24\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d\u200c" },
            { "ro_MD", "\u0b2e\u0b4b\u0b32\u0b21\u0b4b\u0b2d\u0b3f\u0b06\u0b28\u0b4d" },
            { "sw_CD", "\u0b15\u0b19\u0b4d\u0b17\u0b4b \u0b38\u0b4d\u0b71\u0b3e\u0b39\u0b3f\u0b32\u0b3f" },
            { "%%1901", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28 \u0b2c\u0b30\u0b4d\u0b23\u0b4d\u0b23\u0b2a\u0b4d\u0b30\u0b15\u0b30\u0b23" },
            { "%%1996", "1996\u0b30 \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28 \u0b2c\u0b30\u0b4d\u0b23\u0b4d\u0b23\u0b2a\u0b4d\u0b30\u0b15\u0b30\u0b23" },
            { "ar_001", "\u0b06\u0b27\u0b41\u0b28\u0b3f\u0b15 \u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b06\u0b30\u0b2c\u0b40\u0b5f" },
            { "es_419", "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d\u200c \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b40\u0b5f \u0b38\u0b4d\u0b2a\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u200c" },
            { "key.ca", "\u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d" },
            { "key.cf", "\u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e \u0b2b\u0b30\u0b4d\u0b2e\u0b3e\u0b1f\u0b4d\u200c" },
            { "key.co", "\u0b38\u0b30\u0b4d\u0b1f\u0b4d\u200c \u0b15\u0b4d\u0b30\u0b2e" },
            { "key.cu", "\u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e" },
            { "key.hc", "\u0b18\u0b23\u0b4d\u0b1f\u0b3e \u0b1a\u0b15\u0b4d\u0b30 (12 \u0b2c\u0b28\u0b3e\u0b2e 24)" },
            { "key.lb", "\u0b27\u0b3e\u0b21\u0b3c\u0b3f \u0b2c\u0b3f\u0b30\u0b24\u0b3f \u0b36\u0b48\u0b33\u0b40" },
            { "key.ms", "\u0b2e\u0b3e\u0b2a \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f" },
            { "key.nu", "\u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "%%ALUKU", "\u0b06\u0b32\u0b41\u0b15\u0b41 \u0b09\u0b2a\u0b2d\u0b3e\u0b37\u0b3e" },
            { "hi_Latn", "\u0b39\u0b3f\u0b28\u0b4d\u0b26\u0b40 (\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d)" },
            { "zh_Hans", "\u0b38\u0b30\u0b33\u0b40\u0b15\u0b43\u0b24 \u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c" },
            { "zh_Hant", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c" },
            { "%%UNIFON", "\u0b5f\u0b41\u0b28\u0b3f\u0b2b\u0b28\u0b4d \u0b2b\u0b28\u0b47\u0b1f\u0b3f\u0b15\u0b4d \u0b06\u0b32\u0b2b\u0b3e\u0b2c\u0b47\u0b1f\u0b4d" },
            { "%%VAIDIKA", "\u0b2c\u0b48\u0b26\u0b3f\u0b15" },
            { "%%1694ACAD", "\u0b06\u0b26\u0b4d\u0b5f \u0b06\u0b27\u0b41\u0b28\u0b3f\u0b15 \u0b2b\u0b30\u0b3e\u0b38\u0b40" },
            { "%%1959ACAD", "\u0b0f\u0b15\u0b3e\u0b21\u0b47\u0b2e\u0b3f\u0b15" },
            { "%%VALENCIA", "\u0b2d\u0b47\u0b32\u0b47\u0b28\u0b38\u0b3f\u0b06\u0b28\u0b4d" },
            { "type.ca.roc", "\u0b2e\u0b3f\u0b19\u0b4d\u0b17\u0b4b\u0b13 \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.hc.h11", "12 \u0b18\u0b23\u0b4d\u0b1f\u0b3f\u0b06 \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f (0\u201311)" },
            { "type.hc.h12", "12 \u0b18\u0b23\u0b4d\u0b1f\u0b3f\u0b06 \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f (1\u201312)" },
            { "type.hc.h23", "24 \u0b18\u0b23\u0b4d\u0b1f\u0b3f\u0b06 \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f (0\u201323)" },
            { "type.hc.h24", "24 \u0b18\u0b23\u0b4d\u0b1f\u0b3f\u0b06 \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f (1\u201324)" },
            { "type.nu.arab", "\u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d\u200c-\u0b07\u0b23\u0b4d\u0b21\u0b3f\u0b15\u0b4d\u200c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.armn", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b5f \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.beng", "\u0b2c\u0b19\u0b4d\u0b17\u0b33\u0b3e \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.cakm", "\u0b1a\u0b15\u0b2e\u0b3e \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.deva", "\u0b26\u0b47\u0b2c\u0b28\u0b3e\u0b17\u0b30\u0b40 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.ethi", "\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b15\u0b4d\u200c \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.geor", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06\u0b28\u0b4d\u200c \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.grek", "\u0b17\u0b4d\u0b30\u0b40\u0b15\u0b4d\u200c \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.gujr", "\u0b17\u0b41\u0b1c\u0b30\u0b3e\u0b1f\u0b40 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.guru", "\u0b17\u0b41\u0b30\u0b2e\u0b41\u0b16\u0b40 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.hans", "\u0b38\u0b30\u0b33\u0b40\u0b15\u0b43\u0b24 \u0b1a\u0b3f\u0b28\u0b3f \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.hant", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b1a\u0b3f\u0b28\u0b3f \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.hebr", "\u0b39\u0b3f\u0b2c\u0b43 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.java", "\u0b1c\u0b3e\u0b2d\u0b3e\u0b28\u0b3f\u0b1c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.jpan", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.khmr", "\u0b16\u0b3f\u0b2e\u0b30\u0b4d\u200c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.knda", "\u0b15\u0b28\u0b4d\u0b28\u0b21\u0b3c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.laoo", "\u0b32\u0b3e\u0b13 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.latn", "\u0b2a\u0b3e\u0b36\u0b4d\u0b1a\u0b3e\u0b24\u0b4d\u0b5f \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.mlym", "\u0b2e\u0b32\u0b5f\u0b3e\u0b32\u0b2e\u0b4d \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.mong", "\u0b2e\u0b19\u0b4d\u0b17\u0b4b\u0b32\u0b40\u0b5f \u0b21\u0b3f\u0b1c\u0b3f\u0b1f\u0b4d" },
            { "type.nu.mtei", "\u0b2e\u0b3f\u0b24\u0b47\u0b07 \u0b2e\u0b3e\u0b5f\u0b47\u0b15 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.mymr", "\u0b2e\u0b3f\u0b06\u0b01\u0b2e\u0b3e\u0b30\u0b4d\u200c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.olck", "\u0b13\u0b32\u0b4d \u0b1a\u0b3f\u0b15\u0b3f \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.orya", "\u0b13\u0b21\u0b3c\u0b3f\u0b06 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.taml", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b24\u0b3e\u0b2e\u0b3f\u0b32\u0b4d \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.telu", "\u0b24\u0b47\u0b32\u0b41\u0b17\u0b41 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.thai", "\u0b25\u0b3e\u0b07 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.tibt", "\u0b24\u0b3f\u0b2c\u0b24\u0b40 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.vaii", "\u0b2d\u0b3e\u0b07 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.ca.dangi", "\u0b26\u0b3e\u0b19\u0b4d\u0b17\u0b3f \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.co.ducet", "\u0b21\u0b3f\u0b2b\u0b32\u0b4d\u0b1f \u0b5f\u0b41\u0b28\u0b3f\u0b15\u0b4b\u0b21\u0b4d\u200c \u0b38\u0b30\u0b4d\u0b1f\u0b4d\u200c \u0b15\u0b4d\u0b30\u0b2e" },
            { "type.lb.loose", "\u0b22\u0b3f\u0b32\u0b3e \u0b27\u0b3e\u0b21\u0b3c\u0b3f \u0b2c\u0b3f\u0b30\u0b24\u0b3f \u0b36\u0b48\u0b33\u0b40" },
            { "type.nu.roman", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b4d\u200c \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.ca.coptic", metaValue_cop },
            { "type.ca.hebrew", "\u0b39\u0b3f\u0b2c\u0b43 \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.ca.indian", "\u0b07\u0b23\u0b4d\u0b24\u0b3f\u0b06\u0b28\u0b4d" },
            { "type.co.search", "\u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23 \u0b09\u0b26\u0b4d\u0b26\u0b47\u0b36\u0b4d\u0b5f-\u0b2c\u0b3f\u0b36\u0b3f\u0b37\u0b4d\u0b1f \u0b38\u0b28\u0b4d\u0b27\u0b3e\u0b28" },
            { "type.lb.normal", "\u0b38\u0b3e\u0b27\u0b3e\u0b30\u0b23 \u0b27\u0b3e\u0b21\u0b3c\u0b3f \u0b2c\u0b3f\u0b30\u0b24\u0b3f \u0b36\u0b48\u0b33\u0b40" },
            { "type.lb.strict", "\u0b15\u0b20\u0b4b\u0b30 \u0b27\u0b3e\u0b21\u0b3c\u0b3f \u0b2c\u0b3f\u0b30\u0b24\u0b3f \u0b36\u0b48\u0b33\u0b40" },
            { "type.ms.metric", "\u0b2e\u0b47\u0b1f\u0b4d\u0b30\u0b3f\u0b15\u0b4d\u200c \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f" },
            { "type.ca.chinese", "\u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.ca.islamic", "\u0b07\u0b38\u0b32\u0b3e\u0b2e\u0b3f\u0b15\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.ca.iso8601", "ISO-8601 \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.ca.persian", "\u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b06\u0b28\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.cf.account", "\u0b0f\u0b15\u0b3e\u0b09\u0b23\u0b4d\u0b1f\u0b3f\u0b02 \u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e \u0b2b\u0b30\u0b4d\u0b2e\u0b3e\u0b1f\u0b4d\u200c" },
            { "type.nu.arabext", "\u0b2a\u0b30\u0b3f\u0b2c\u0b30\u0b4d\u0b26\u0b4d\u0b27\u0b3f\u0b24 \u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d\u200c-\u0b07\u0b23\u0b4d\u0b21\u0b3f\u0b15\u0b4d\u200c \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.armnlow", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b5f \u0b1b\u0b4b\u0b1f \u0b05\u0b15\u0b4d\u0b37\u0b30 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.greklow", "\u0b17\u0b4d\u0b30\u0b40\u0b15\u0b4d\u200c \u0b1b\u0b4b\u0b1f \u0b05\u0b15\u0b4d\u0b37\u0b30 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.hanidec", "\u0b1a\u0b3f\u0b28\u0b3f \u0b26\u0b36\u0b2e\u0b3f\u0b15 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.hansfin", "\u0b38\u0b30\u0b33\u0b40\u0b15\u0b43\u0b24 \u0b1a\u0b3f\u0b28\u0b3f \u0b06\u0b30\u0b4d\u0b25\u0b3f\u0b15 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.hantfin", "\u0b2a\u0b3e\u0b30\u0b2e\u0b4d\u0b2a\u0b30\u0b3f\u0b15 \u0b1a\u0b3f\u0b28\u0b3f \u0b06\u0b30\u0b4d\u0b25\u0b3f\u0b15 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.jpanfin", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b40 \u0b06\u0b30\u0b4d\u0b25\u0b3f\u0b15 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.tamldec", "\u0b24\u0b3e\u0b2e\u0b3f\u0b32\u0b4d \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.ca.buddhist", "\u0b2c\u0b4c\u0b26\u0b4d\u0b27\u0b27\u0b30\u0b4d\u0b2e\u0b3e\u0b32\u0b2e\u0b4d\u0b2c\u0b40\u0b19\u0b4d\u0b15 \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.ca.ethiopic", "\u0b07\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b15\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.ca.japanese", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b3f\u0b1c\u0b4d\u200c \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d\u200c" },
            { "type.cf.standard", "\u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3e \u0b2b\u0b30\u0b4d\u0b2e\u0b3e\u0b1f\u0b4d\u200c" },
            { "type.co.standard", "\u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b38\u0b30\u0b4d\u0b1f\u0b4d\u200c \u0b15\u0b4d\u0b30\u0b2e" },
            { "type.ms.uksystem", "\u0b38\u0b3e\u0b2e\u0b4d\u0b30\u0b3e\u0b1c\u0b4d\u0b5f \u0b38\u0b2e\u0b4d\u0b2c\u0b28\u0b4d\u0b27\u0b40\u0b5f \u0b2e\u0b3e\u0b2a \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f" },
            { "type.ms.ussystem", "\u0b5f\u0b41\u0b0f\u0b38\u0b4d\u200c \u0b2e\u0b3e\u0b2a \u0b2a\u0b26\u0b4d\u0b27\u0b24\u0b3f" },
            { "type.nu.fullwide", "\u0b2a\u0b42\u0b30\u0b4d\u0b23\u0b4d\u0b23-\u0b2a\u0b4d\u0b30\u0b38\u0b4d\u0b25 \u0b05\u0b19\u0b4d\u0b15\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.nu.romanlow", "\u0b30\u0b4b\u0b2e\u0b3e\u0b28\u0b4d\u200c \u0b1b\u0b4b\u0b1f \u0b05\u0b15\u0b4d\u0b37\u0b30 \u0b38\u0b02\u0b16\u0b4d\u0b5f\u0b3e\u0b17\u0b41\u0b21\u0b3c\u0b3f\u0b15" },
            { "type.ca.gregorian", "\u0b17\u0b4d\u0b30\u0b47\u0b17\u0b4b\u0b30\u0b3f\u0b5f \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d" },
            { "type.ca.islamic-civil", "\u0b07\u0b38\u0b32\u0b3e\u0b2e\u0b3f\u0b15\u0b4d \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d (\u0b1f\u0b3e\u0b2c\u0b41\u0b32\u0b3e\u0b30\u0b4d, \u0b28\u0b3e\u0b17\u0b30\u0b3f\u0b15 \u0b2f\u0b41\u0b17)" },
            { "type.ca.islamic-umalqura", "\u0b07\u0b38\u0b32\u0b3e\u0b2e\u0b3f\u0b15\u0b4d \u0b15\u0b4d\u0b5f\u0b3e\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30\u0b4d (\u0b09\u0b2e\u0b4d \u0b05\u0b32\u0b4d-\u0b15\u0b41\u0b30\u0b3e)" },
            { "type.ca.ethiopic-amete-alem", "\u0b0f\u0b25\u0b3f\u0b13\u0b2a\u0b3f\u0b15\u0b4d-\u0b06\u0b2e\u0b47\u0b1f\u0b4d-\u0b06\u0b32\u0b47\u0b2e\u0b4d" },
        };
        return data;
    }
}
