/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.clientregistration;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.keycloak.exportimport.ClientDescriptionConverter;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.saml.clientregistration.EntityDescriptorClientRegistrationContext;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientregistration.AbstractClientRegistrationProvider;

public class EntityDescriptorClientRegistrationProvider
extends AbstractClientRegistrationProvider {
    public EntityDescriptorClientRegistrationProvider(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response createSaml(String descriptor) {
        ClientRepresentation client = ((ClientDescriptionConverter)this.session.getProvider(ClientDescriptionConverter.class, "saml2-entity-descriptor")).convertToInternal(descriptor);
        EntityDescriptorClientRegistrationContext context = new EntityDescriptorClientRegistrationContext(this.session, client, this);
        client = this.create(context);
        this.validateClient(client, true);
        URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(client.getClientId()).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)client).build();
    }
}

