/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.spi.tracing.Extractors;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public interface TagExtractor<T> {
    public static <T> TagExtractor<T> empty() {
        return Extractors.EMPTY;
    }

    default public int len(T obj) {
        return 0;
    }

    default public String name(T obj, int index) {
        throw new IndexOutOfBoundsException("Invalid tag index " + index);
    }

    default public String value(T obj, int index) {
        throw new IndexOutOfBoundsException("Invalid tag index " + index);
    }

    default public Map<String, String> extract(T obj) {
        HashMap<String, String> tags = new HashMap<String, String>();
        this.extractTo(obj, tags);
        return tags;
    }

    default public void extractTo(T obj, Map<String, String> tags) {
        int len = this.len(obj);
        for (int idx = 0; idx < len; ++idx) {
            tags.put(this.name(obj, idx), this.value(obj, idx));
        }
    }

    default public void extractTo(T obj, BiConsumer<String, String> consumer) {
        int len = this.len(obj);
        for (int idx = 0; idx < len; ++idx) {
            consumer.accept(this.name(obj, idx), this.value(obj, idx));
        }
    }
}

