/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.exceptions.AssemblyStackTraceException;
import rx.internal.operators.OnSubscribeOnAssembly;

public final class OnSubscribeOnAssemblyCompletable<T>
implements Completable.OnSubscribe {
    final Completable.OnSubscribe source;
    final String stacktrace;
    public static volatile boolean fullStackTrace;

    public OnSubscribeOnAssemblyCompletable(Completable.OnSubscribe source) {
        this.source = source;
        this.stacktrace = OnSubscribeOnAssembly.createStacktrace();
    }

    @Override
    public void call(CompletableSubscriber t) {
        this.source.call(new OnAssemblyCompletableSubscriber(t, this.stacktrace));
    }

    static final class OnAssemblyCompletableSubscriber
    implements CompletableSubscriber {
        final CompletableSubscriber actual;
        final String stacktrace;

        public OnAssemblyCompletableSubscriber(CompletableSubscriber actual, String stacktrace) {
            this.actual = actual;
            this.stacktrace = stacktrace;
        }

        @Override
        public void onSubscribe(Subscription d) {
            this.actual.onSubscribe(d);
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            new AssemblyStackTraceException(this.stacktrace).attachTo(e);
            this.actual.onError(e);
        }
    }
}

