/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.index;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.commons.notifications.action.CreateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.CreateNotificationConfigResponse;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigRequest;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigResponse;
import org.opensearch.commons.notifications.action.GetChannelListRequest;
import org.opensearch.commons.notifications.action.GetChannelListResponse;
import org.opensearch.commons.notifications.action.GetNotificationConfigRequest;
import org.opensearch.commons.notifications.action.GetNotificationConfigResponse;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigResponse;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.Channel;
import org.opensearch.commons.notifications.model.ChannelList;
import org.opensearch.commons.notifications.model.Chime;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.Email;
import org.opensearch.commons.notifications.model.EmailGroup;
import org.opensearch.commons.notifications.model.MicrosoftTeams;
import org.opensearch.commons.notifications.model.NotificationConfig;
import org.opensearch.commons.notifications.model.NotificationConfigInfo;
import org.opensearch.commons.notifications.model.NotificationConfigSearchResult;
import org.opensearch.commons.notifications.model.SesAccount;
import org.opensearch.commons.notifications.model.Slack;
import org.opensearch.commons.notifications.model.SmtpAccount;
import org.opensearch.commons.notifications.model.Sns;
import org.opensearch.commons.notifications.model.Webhook;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.notifications.index.ConfigIndexingActions;
import org.opensearch.notifications.index.ConfigOperations;
import org.opensearch.notifications.metrics.Metrics;
import org.opensearch.notifications.model.DocMetadata;
import org.opensearch.notifications.model.NotificationConfigDoc;
import org.opensearch.notifications.model.NotificationConfigDocInfo;
import org.opensearch.notifications.security.UserAccess;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J \u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010$J\u001a\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J \u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u0002002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u00101J \u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0086@\u00a2\u0006\u0002\u00106J \u00107\u001a\u0002082\u0006\u00104\u001a\u0002092\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0086@\u00a2\u0006\u0002\u0010:J \u0010;\u001a\u00020<2\u0006\u00104\u001a\u00020=2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0086@\u00a2\u0006\u0002\u0010>J \u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020A2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010BJ&\u0010?\u001a\u00020<2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020A0D2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010EJ \u0010F\u001a\u00020<2\u0006\u00104\u001a\u00020=2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010>J \u0010G\u001a\u00020H2\u0006\u00104\u001a\u00020I2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0086@\u00a2\u0006\u0002\u0010JJ\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020A0LH\u0002J \u0010M\u001a\u00020N2\u0006\u0010@\u001a\u00020A2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010BJ&\u0010M\u001a\u00020N2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020A0D2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010EJ \u0010M\u001a\u00020N2\u0006\u00104\u001a\u00020O2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0086@\u00a2\u0006\u0002\u0010PR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/opensearch/notifications/index/ConfigIndexingActions;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "operations", "Lorg/opensearch/notifications/index/ConfigOperations;", "userAccess", "Lorg/opensearch/notifications/security/UserAccess;", "initialize", "", "validateSlackConfig", "slack", "Lorg/opensearch/commons/notifications/model/Slack;", "user", "Lorg/opensearch/commons/authuser/User;", "validateChimeConfig", "chime", "Lorg/opensearch/commons/notifications/model/Chime;", "validateMicrosoftTeamsConfig", "microsoftTeams", "Lorg/opensearch/commons/notifications/model/MicrosoftTeams;", "validateWebhookConfig", "webhook", "Lorg/opensearch/commons/notifications/model/Webhook;", "validateSnsConfig", "sns", "Lorg/opensearch/commons/notifications/model/Sns;", "validateEmailConfig", "email", "Lorg/opensearch/commons/notifications/model/Email;", "(Lorg/opensearch/commons/notifications/model/Email;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateSmtpAccountConfig", "smtpAccount", "Lorg/opensearch/commons/notifications/model/SmtpAccount;", "validateSesAccountConfig", "sesAccount", "Lorg/opensearch/commons/notifications/model/SesAccount;", "validateEmailGroupConfig", "emailGroup", "Lorg/opensearch/commons/notifications/model/EmailGroup;", "validateConfig", "config", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "(Lorg/opensearch/commons/notifications/model/NotificationConfig;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "create", "Lorg/opensearch/commons/notifications/action/CreateNotificationConfigResponse;", "request", "Lorg/opensearch/commons/notifications/action/CreateNotificationConfigRequest;", "(Lorg/opensearch/commons/notifications/action/CreateNotificationConfigRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigResponse;", "Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigRequest;", "(Lorg/opensearch/commons/notifications/action/UpdateNotificationConfigRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigResponse;", "Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;", "(Lorg/opensearch/commons/notifications/action/GetNotificationConfigRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "info", "configId", "", "(Ljava/lang/String;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configIds", "", "(Ljava/util/Set;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAll", "getChannelList", "Lorg/opensearch/commons/notifications/action/GetChannelListResponse;", "Lorg/opensearch/commons/notifications/action/GetChannelListRequest;", "(Lorg/opensearch/commons/notifications/action/GetChannelListRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSupportedChannelList", "", "delete", "Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigResponse;", "Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigRequest;", "(Lorg/opensearch/commons/notifications/action/DeleteNotificationConfigRequest;Lorg/opensearch/commons/authuser/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-notifications"})
@SourceDebugExtension(value={"SMAP\nConfigIndexingActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigIndexingActions.kt\norg/opensearch/notifications/index/ConfigIndexingActions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,474:1\n1563#2:475\n1634#2,3:476\n827#2:479\n855#2,2:480\n1869#2,2:482\n1869#2,2:484\n1869#2,2:486\n1563#2:488\n1634#2,3:489\n1563#2:492\n1634#2,3:493\n1869#2,2:496\n1869#2,2:498\n*S KotlinDebug\n*F\n+ 1 ConfigIndexingActions.kt\norg/opensearch/notifications/index/ConfigIndexingActions\n*L\n97#1:475\n97#1:476,3\n99#1:479\n99#1:480,2\n103#1:482,2\n308#1:484,2\n315#1:486,2\n325#1:488\n325#1:489,3\n369#1:492\n369#1:493,3\n438#1:496,2\n445#1:498,2\n*E\n"})
public final class ConfigIndexingActions {
    @NotNull
    public static final ConfigIndexingActions INSTANCE = new ConfigIndexingActions();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ConfigIndexingActions.class);
    private static ConfigOperations operations;
    private static UserAccess userAccess;

    private ConfigIndexingActions() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull ConfigOperations operations, @NotNull UserAccess userAccess) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        Intrinsics.checkNotNullParameter((Object)userAccess, (String)"userAccess");
        ConfigIndexingActions.operations = operations;
        ConfigIndexingActions.userAccess = userAccess;
    }

    private final void validateSlackConfig(Slack slack, User user) {
        CharSequence charSequence = slack.getUrl();
        if (!new Regex("https://hooks\\.(?:gov-)?slack\\.com/services").containsMatchIn(charSequence)) {
            boolean bl = false;
            String string = "Wrong Slack url. Should contain \"hooks.slack.com/services/\" or \"hooks.gov-slack.com/services/\"";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateChimeConfig(Chime chime, User user) {
        CharSequence charSequence = chime.getUrl();
        if (!new Regex("https://hooks\\.chime\\.aws/incomingwebhooks/.*\\?token=").containsMatchIn(charSequence)) {
            boolean bl = false;
            String string = "Wrong Chime url. Should contain \"hooks.chime.aws/incomingwebhooks/\" and \"?token=\"";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateMicrosoftTeamsConfig(MicrosoftTeams microsoftTeams, User user) {
        CharSequence charSequence = microsoftTeams.getUrl();
        if (!new Regex("https://.*\\.webhook\\.office\\.com").containsMatchIn(charSequence)) {
            boolean bl = false;
            String string = "Wrong Microsoft Teams url. Should contain \"webhook.office.com\"";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateWebhookConfig(Webhook webhook, User user) {
    }

    private final void validateSnsConfig(Sns sns, User user) {
    }

    /*
     * Unable to fully structure code
     */
    private final Object validateEmailConfig(Email email, User user, Continuation<? super Unit> $completion) {
        if (!($completion instanceof validateEmailConfig.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$validateEmailConfig(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var22_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (email.getEmailGroupIds().contains(email.getEmailAccountID())) {
                    throw new OpenSearchStatusException("Config IDs " + email.getEmailAccountID() + " is in both emailAccountID and emailGroupIds", RestStatus.BAD_REQUEST, new Object[0]);
                }
                configIds = CollectionsKt.union((Iterable)SetsKt.setOf((Object)email.getEmailAccountID()), (Iterable)email.getEmailGroupIds());
                v0 = ConfigIndexingActions.operations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v0 = null;
                }
                $continuation.L$0 = email;
                $continuation.L$1 = user;
                $continuation.L$2 = configIds;
                $continuation.label = 1;
                v1 = v0.getNotificationConfigs(configIds, (Continuation<? super List<NotificationConfigDocInfo>>)$continuation);
                if (v1 == var22_6) {
                    return var22_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                configIds = (Set)$continuation.L$2;
                user = (User)$continuation.L$1;
                email = (Email)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                if ((configDocs = (List)v1).size() != configIds.size()) {
                    $this$map$iv = configDocs;
                    $i$f$map = false;
                    var9_13 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_22 = (NotificationConfigDocInfo)item$iv$iv;
                        var16_24 = destination$iv$iv;
                        $i$a$-map-ConfigIndexingActions$validateEmailConfig$availableIds$1 = false;
                        var16_24.add(it.getDocInfo().getId());
                    }
                    availableIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    $this$filterNot$iv = configIds;
                    $i$f$filterNot = false;
                    $this$mapTo$iv$iv = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        it = (String)element$iv$iv;
                        $i$a$-filterNot-ConfigIndexingActions$validateEmailConfig$2 = false;
                        if (availableIds.contains(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    var19_27 = new Object[]{};
                    var20_28 = RestStatus.NOT_FOUND;
                    var21_29 = "Config IDs not found:" + (List)destination$iv$iv;
                    throw new OpenSearchStatusException(var21_29, var20_28, var19_27);
                }
                $this$forEach$iv = configDocs;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (NotificationConfigDocInfo)element$iv;
                    $i$a$-forEach-ConfigIndexingActions$validateEmailConfig$3 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[it.getConfigDoc().getConfig().getConfigType().ordinal()]) {
                        case 1: {
                            if (!Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                            Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_ACCOUNT_ID.getCounter().increment();
                            throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email account ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                        }
                        case 2: {
                            if (Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                            Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_GROUP_ID.getCounter().increment();
                            throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                        }
                        case 3: {
                            if (Intrinsics.areEqual((Object)it.getDocInfo().getId(), (Object)email.getEmailAccountID())) break;
                            Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_GROUP_ID.getCounter().increment();
                            throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                        }
                        default: {
                            Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_NEITHER_EMAIL_NOR_GROUP.getCounter().increment();
                            throw new OpenSearchStatusException("configId " + it.getDocInfo().getId() + " is not a valid email group ID or email account ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                        }
                    }
                    currentMetadata = it.getConfigDoc().getMetadata();
                    v2 = ConfigIndexingActions.userAccess;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                        v2 = null;
                    }
                    if (v2.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void validateSmtpAccountConfig(SmtpAccount smtpAccount, User user) {
    }

    private final void validateSesAccountConfig(SesAccount sesAccount, User user) {
    }

    private final void validateEmailGroupConfig(EmailGroup emailGroup, User user) {
    }

    private final Object validateConfig(NotificationConfig config, User user, Continuation<? super Unit> $completion) {
        switch (WhenMappings.$EnumSwitchMapping$0[config.getConfigType().ordinal()]) {
            case 4: {
                throw new OpenSearchStatusException("NotificationConfig with type NONE is not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
            }
            case 5: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Slack");
                this.validateSlackConfig((Slack)baseConfigData, user);
                break;
            }
            case 6: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Chime");
                this.validateChimeConfig((Chime)baseConfigData, user);
                break;
            }
            case 7: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.MicrosoftTeams");
                this.validateMicrosoftTeamsConfig((MicrosoftTeams)baseConfigData, user);
                break;
            }
            case 8: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Webhook");
                this.validateWebhookConfig((Webhook)baseConfigData, user);
                break;
            }
            case 9: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Email");
                Object object = this.validateEmailConfig((Email)baseConfigData, user, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 2: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.SmtpAccount");
                this.validateSmtpAccountConfig((SmtpAccount)baseConfigData, user);
                break;
            }
            case 3: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.SesAccount");
                this.validateSesAccountConfig((SesAccount)baseConfigData, user);
                break;
            }
            case 1: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.EmailGroup");
                this.validateEmailGroupConfig((EmailGroup)baseConfigData, user);
                break;
            }
            case 10: {
                BaseConfigData baseConfigData = config.getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Sns");
                this.validateSnsConfig((Sns)baseConfigData, user);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object create(@NotNull CreateNotificationConfigRequest request, @Nullable User user, @NotNull Continuation<? super CreateNotificationConfigResponse> $completion) {
        if (!($completion instanceof create.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.create(null, null, (Continuation<? super CreateNotificationConfigResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-create");
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                $continuation.L$0 = request;
                $continuation.L$1 = user;
                $continuation.label = 1;
                v1 = this.validateConfig(request.getNotificationConfig(), user, (Continuation<? super Unit>)$continuation);
                if (v1 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                user = (User)$continuation.L$1;
                request = (CreateNotificationConfigRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                currentTime = Instant.now();
                Intrinsics.checkNotNull((Object)currentTime);
                v2 = ConfigIndexingActions.userAccess;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v2 = null;
                }
                metadata = new DocMetadata(currentTime, currentTime, v2.getAllAccessInfo(user));
                configDoc = new NotificationConfigDoc(metadata, request.getNotificationConfig());
                v3 = ConfigIndexingActions.operations;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v3 = null;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)user);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)currentTime);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)configDoc);
                $continuation.label = 2;
                v4 = v3.createNotificationConfig(configDoc, request.getConfigId(), (Continuation<? super String>)$continuation);
                if (v4 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl60
            }
            case 2: {
                configDoc = (NotificationConfigDoc)$continuation.L$4;
                metadata = (DocMetadata)$continuation.L$3;
                currentTime = (Instant)$continuation.L$2;
                user = (User)$continuation.L$1;
                request = (CreateNotificationConfigRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl60:
                // 2 sources

                if ((docId = (String)v4) == null) {
                    $this$create_u24lambda_u240 = this;
                    $i$a$-run-ConfigIndexingActions$create$2 = false;
                    Metrics.NOTIFICATIONS_CONFIG_CREATE_SYSTEM_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                return new CreateNotificationConfigResponse(docId);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object update(@NotNull UpdateNotificationConfigRequest request, @Nullable User user, @NotNull Continuation<? super UpdateNotificationConfigResponse> $completion) {
        if (!($completion instanceof update.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.update(null, null, (Continuation<? super UpdateNotificationConfigResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-update " + request.getConfigId());
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                $continuation.L$0 = request;
                $continuation.L$1 = user;
                $continuation.label = 1;
                v1 = this.validateConfig(request.getNotificationConfig(), user, (Continuation<? super Unit>)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                user = (User)$continuation.L$1;
                request = (UpdateNotificationConfigRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                if ((v2 = ConfigIndexingActions.operations) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v2 = null;
                }
                $continuation.L$0 = request;
                $continuation.L$1 = user;
                $continuation.label = 2;
                v3 = v2.getNotificationConfig(request.getConfigId(), (Continuation<? super NotificationConfigDocInfo>)$continuation);
                if (v3 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl45
            }
            case 2: {
                user = (User)$continuation.L$1;
                request = (UpdateNotificationConfigRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl45:
                // 2 sources

                if ((currentConfigDoc = (NotificationConfigDocInfo)v3) == null) {
                    $this$update_u24lambda_u240 = this;
                    $i$a$-run-ConfigIndexingActions$update$2 = false;
                    Metrics.NOTIFICATIONS_CONFIG_UPDATE_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + request.getConfigId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                currentMetadata = currentConfigDoc.getConfigDoc().getMetadata();
                v4 = ConfigIndexingActions.userAccess;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v4 = null;
                }
                if (!v4.doesUserHaveAccess(user, currentMetadata.getAccess())) {
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + request.getConfigId(), RestStatus.FORBIDDEN, new Object[0]);
                }
                if (currentConfigDoc.getConfigDoc().getConfig().getConfigType() != request.getNotificationConfig().getConfigType()) {
                    throw new OpenSearchStatusException("Config type cannot be changed after creation", RestStatus.CONFLICT, new Object[0]);
                }
                v5 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"now(...)");
                newMetadata = DocMetadata.copy$default(currentMetadata, v5, null, null, 6, null);
                newConfigData = new NotificationConfigDoc(newMetadata, request.getNotificationConfig());
                v6 = ConfigIndexingActions.operations;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v6 = null;
                }
                $continuation.L$0 = request;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)user);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)currentConfigDoc);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)currentMetadata);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)newMetadata);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)newConfigData);
                $continuation.label = 3;
                v7 = v6.updateNotificationConfig(request.getConfigId(), newConfigData, (Continuation<? super Boolean>)$continuation);
                if (v7 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl88
            }
            case 3: {
                newConfigData = (NotificationConfigDoc)$continuation.L$5;
                newMetadata = (DocMetadata)$continuation.L$4;
                currentMetadata = (DocMetadata)$continuation.L$3;
                currentConfigDoc = (NotificationConfigDocInfo)$continuation.L$2;
                user = (User)$continuation.L$1;
                request = (UpdateNotificationConfigRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl88:
                // 2 sources

                if (!((Boolean)v7).booleanValue()) {
                    Metrics.NOTIFICATIONS_CONFIG_UPDATE_SYSTEM_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig Update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                return new UpdateNotificationConfigResponse(request.getConfigId());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object get(@NotNull GetNotificationConfigRequest request, @Nullable User user, @NotNull Continuation<? super GetNotificationConfigResponse> $completion) {
        this.getLog().info("notifications:NotificationConfig-get " + request);
        UserAccess userAccess = ConfigIndexingActions.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        userAccess.validateUser(user);
        switch (request.getConfigIds().size()) {
            case 0: {
                return this.getAll(request, user, $completion);
            }
            case 1: {
                return this.info((String)CollectionsKt.first((Iterable)request.getConfigIds()), user, $completion);
            }
        }
        return this.info(request.getConfigIds(), user, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object info(String configId, User user, Continuation<? super GetNotificationConfigResponse> $completion) {
        if (!($completion instanceof info.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$info(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-info " + configId);
                v0 = ConfigIndexingActions.operations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v0 = null;
                }
                $continuation.L$0 = configId;
                $continuation.L$1 = user;
                $continuation.label = 1;
                v1 = v0.getNotificationConfig(configId, (Continuation<? super NotificationConfigDocInfo>)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                user = (User)$continuation.L$1;
                configId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                if ((configDoc = (NotificationConfigDocInfo)v1) == null) {
                    $this$info_u24lambda_u240 = this;
                    $i$a$-run-ConfigIndexingActions$info$2 = false;
                    Metrics.NOTIFICATIONS_CONFIG_INFO_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + configId + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                metadata = configDoc.getConfigDoc().getMetadata();
                v2 = ConfigIndexingActions.userAccess;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v2 = null;
                }
                if (!v2.doesUserHaveAccess(user, metadata.getAccess())) {
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + configId, RestStatus.FORBIDDEN, new Object[0]);
                }
                configInfo = new NotificationConfigInfo(configId, metadata.getLastUpdateTime(), metadata.getCreatedTime(), configDoc.getConfigDoc().getConfig());
                return new GetNotificationConfigResponse(new NotificationConfigSearchResult(configInfo));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object info(Set<String> configIds, User user, Continuation<? super GetNotificationConfigResponse> $completion) {
        if (!($completion instanceof info.3)) ** GOTO lbl-1000
        var17_4 = $completion;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$info(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-info " + configIds);
                v0 = ConfigIndexingActions.operations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v0 = null;
                }
                $continuation.L$0 = configIds;
                $continuation.L$1 = user;
                $continuation.label = 1;
                v1 = v0.getNotificationConfigs(configIds, (Continuation<? super List<NotificationConfigDocInfo>>)$continuation);
                if (v1 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                user = (User)$continuation.L$1;
                configIds = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                if ((configDocs = (List)v1).size() != configIds.size()) {
                    mutableSet = CollectionsKt.toMutableSet((Iterable)configIds);
                    $this$forEach$iv = configDocs;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (NotificationConfigDocInfo)element$iv;
                        $i$a$-forEach-ConfigIndexingActions$info$4 = false;
                        var12_24 = mutableSet;
                        var13_26 = it.getDocInfo().getId();
                        TypeIntrinsics.asMutableCollection((Object)var12_24).remove(var13_26);
                    }
                    Metrics.NOTIFICATIONS_CONFIG_INFO_USER_ERROR_SET_NOT_FOUND.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + mutableSet + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                $this$forEach$iv = configDocs;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (NotificationConfigDocInfo)element$iv /* !! */ ;
                    $i$a$-forEach-ConfigIndexingActions$info$5 = false;
                    currentMetadata = it.getConfigDoc().getMetadata();
                    v2 = ConfigIndexingActions.userAccess;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                        v2 = null;
                    }
                    if (v2.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
                }
                $this$map$iv = configDocs;
                $i$f$map = false;
                element$iv /* !! */  = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var13_27 = (NotificationConfigDocInfo)item$iv$iv;
                    var15_29 = destination$iv$iv;
                    $i$a$-map-ConfigIndexingActions$info$configSearchResult$1 = false;
                    v3 = it.getDocInfo().getId();
                    Intrinsics.checkNotNull((Object)v3);
                    var15_29.add(new NotificationConfigInfo(v3, it.getConfigDoc().getMetadata().getLastUpdateTime(), it.getConfigDoc().getMetadata().getCreatedTime(), it.getConfigDoc().getConfig()));
                }
                configSearchResult = (List)destination$iv$iv;
                return new GetNotificationConfigResponse(new NotificationConfigSearchResult(configSearchResult));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getAll(GetNotificationConfigRequest request, User user, Continuation<? super GetNotificationConfigResponse> $completion) {
        if (!($completion instanceof getAll.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$getAll(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-getAll");
                v0 = ConfigIndexingActions.operations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v0 = null;
                }
                if ((v1 = ConfigIndexingActions.userAccess) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v1 = null;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)user);
                $continuation.label = 1;
                v2 = v0.getAllNotificationConfigs(v1.getSearchAccessInfo(user), request, (Continuation<? super NotificationConfigSearchResult>)$continuation);
                if (v2 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                user = (User)$continuation.L$1;
                request = (GetNotificationConfigRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl32:
                // 2 sources

                searchResult = (NotificationConfigSearchResult)v2;
                return new GetNotificationConfigResponse(searchResult);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getChannelList(@NotNull GetChannelListRequest request, @Nullable User user, @NotNull Continuation<? super GetChannelListResponse> $completion) {
        if (!($completion instanceof getChannelList.1)) ** GOTO lbl-1000
        var22_4 = $completion;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getChannelList(null, null, (Continuation<? super GetChannelListResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:getChannelList " + request);
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                supportedChannelListString = CollectionsKt.joinToString$default((Iterable)this.getSupportedChannelList(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                filterParams = MapsKt.mapOf((Pair)new Pair((Object)"config_type", (Object)supportedChannelListString));
                getAllRequest = new GetNotificationConfigRequest(null, 0, 0, null, null, filterParams, 31, null);
                v1 = ConfigIndexingActions.operations;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v1 = null;
                }
                if ((v2 = ConfigIndexingActions.userAccess) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v2 = null;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)user);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)supportedChannelListString);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)filterParams);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)getAllRequest);
                $continuation.label = 1;
                v3 = v1.getAllNotificationConfigs(v2.getSearchAccessInfo(user), getAllRequest, (Continuation<? super NotificationConfigSearchResult>)$continuation);
                if (v3 == var23_6) {
                    return var23_6;
                }
                ** GOTO lbl46
            }
            case 1: {
                getAllRequest = (GetNotificationConfigRequest)$continuation.L$4;
                filterParams = (Map)$continuation.L$3;
                supportedChannelListString = (String)$continuation.L$2;
                user = (User)$continuation.L$1;
                request = (GetChannelListRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl46:
                // 2 sources

                getAllResult = (NotificationConfigSearchResult)v3;
                $this$map$iv = getAllResult.getObjectList();
                $i$f$map = false;
                var11_13 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var16_18 = (NotificationConfigInfo)item$iv$iv;
                    var20_22 = destination$iv$iv;
                    $i$a$-map-ConfigIndexingActions$getChannelList$searchResult$1 = false;
                    configId = it.getConfigId();
                    config = it.getNotificationConfig();
                    var20_22.add(new Channel(configId, config.getName(), config.getDescription(), config.getConfigType(), config.isEnabled()));
                }
                searchResult = (List)destination$iv$iv;
                ChannelList = new ChannelList(searchResult);
                return new GetChannelListResponse(ChannelList);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<String> getSupportedChannelList() {
        Object[] objectArray = new String[]{ConfigType.SLACK.getTag(), ConfigType.CHIME.getTag(), ConfigType.MICROSOFT_TEAMS.getTag(), ConfigType.WEBHOOK.getTag(), ConfigType.EMAIL.getTag(), ConfigType.SNS.getTag()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Unable to fully structure code
     */
    private final Object delete(String configId, User user, Continuation<? super DeleteNotificationConfigResponse> $completion) {
        if (!($completion instanceof delete.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$delete(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-delete " + configId);
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                v1 = ConfigIndexingActions.operations;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v1 = null;
                }
                $continuation.L$0 = configId;
                $continuation.L$1 = user;
                $continuation.label = 1;
                v2 = v1.getNotificationConfig(configId, (Continuation<? super NotificationConfigDocInfo>)$continuation);
                if (v2 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl34
            }
            case 1: {
                user = (User)$continuation.L$1;
                configId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl34:
                // 2 sources

                if ((currentConfigDoc = (NotificationConfigDocInfo)v2) == null) {
                    $this$delete_u24lambda_u240 = this;
                    $i$a$-run-ConfigIndexingActions$delete$2 = false;
                    Metrics.NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + configId + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                currentMetadata = currentConfigDoc.getConfigDoc().getMetadata();
                v3 = ConfigIndexingActions.userAccess;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v3 = null;
                }
                if (!v3.doesUserHaveAccess(user, currentMetadata.getAccess())) {
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + configId, RestStatus.FORBIDDEN, new Object[0]);
                }
                v4 = ConfigIndexingActions.operations;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v4 = null;
                }
                $continuation.L$0 = configId;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)user);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)currentConfigDoc);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)currentMetadata);
                $continuation.label = 2;
                v5 = v4.deleteNotificationConfig(configId, (Continuation<? super Boolean>)$continuation);
                if (v5 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl67
            }
            case 2: {
                currentMetadata = (DocMetadata)$continuation.L$3;
                currentConfigDoc = (NotificationConfigDocInfo)$continuation.L$2;
                user = (User)$continuation.L$1;
                configId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl67:
                // 2 sources

                if (!((Boolean)v5).booleanValue()) {
                    Metrics.NOTIFICATIONS_CONFIG_DELETE_SYSTEM_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + configId + " delete failed", RestStatus.REQUEST_TIMEOUT, new Object[0]);
                }
                return new DeleteNotificationConfigResponse(MapsKt.mapOf((Pair)new Pair((Object)configId, (Object)RestStatus.OK)));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object delete(Set<String> configIds, User user, Continuation<? super DeleteNotificationConfigResponse> $completion) {
        if (!($completion instanceof delete.3)) ** GOTO lbl-1000
        var15_4 = $completion;
        if ((var15_4.label & -2147483648) != 0) {
            var15_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConfigIndexingActions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConfigIndexingActions.access$delete(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:NotificationConfig-delete " + configIds);
                v0 = ConfigIndexingActions.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                v1 = ConfigIndexingActions.operations;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v1 = null;
                }
                $continuation.L$0 = configIds;
                $continuation.L$1 = user;
                $continuation.label = 1;
                v2 = v1.getNotificationConfigs(configIds, (Continuation<? super List<NotificationConfigDocInfo>>)$continuation);
                if (v2 == var16_6) {
                    return var16_6;
                }
                ** GOTO lbl34
            }
            case 1: {
                user = (User)$continuation.L$1;
                configIds = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl34:
                // 2 sources

                if ((configDocs = (List)v2).size() != configIds.size()) {
                    mutableSet = CollectionsKt.toMutableSet((Iterable)configIds);
                    $this$forEach$iv = configDocs;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (NotificationConfigDocInfo)element$iv;
                        $i$a$-forEach-ConfigIndexingActions$delete$4 = false;
                        var12_23 = mutableSet;
                        var13_24 = it.getDocInfo().getId();
                        TypeIntrinsics.asMutableCollection((Object)var12_23).remove(var13_24);
                    }
                    Metrics.NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_SET_NOT_FOUND.getCounter().increment();
                    throw new OpenSearchStatusException("NotificationConfig " + mutableSet + " not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                $this$forEach$iv = configDocs;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (NotificationConfigDocInfo)element$iv;
                    $i$a$-forEach-ConfigIndexingActions$delete$5 = false;
                    currentMetadata = it.getConfigDoc().getMetadata();
                    v3 = ConfigIndexingActions.userAccess;
                    if (v3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                        v3 = null;
                    }
                    if (v3.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
                    Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
                    throw new OpenSearchStatusException("Permission denied for NotificationConfig " + it.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
                }
                v4 = ConfigIndexingActions.operations;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"operations");
                    v4 = null;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)configIds);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)user);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)configDocs);
                $continuation.label = 2;
                v5 = v4.deleteNotificationConfigs(configIds, (Continuation<? super Map<String, ? extends RestStatus>>)$continuation);
                if (v5 == var16_6) {
                    return var16_6;
                }
                ** GOTO lbl80
            }
            case 2: {
                configDocs = (List)$continuation.L$2;
                user = (User)$continuation.L$1;
                configIds = (Set)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl80:
                // 2 sources

                deleteStatus = (Map)v5;
                return new DeleteNotificationConfigResponse(deleteStatus);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object delete(@NotNull DeleteNotificationConfigRequest request, @Nullable User user, @NotNull Continuation<? super DeleteNotificationConfigResponse> $completion) {
        this.getLog().info("notifications:NotificationConfig-delete " + request.getConfigIds());
        if (request.getConfigIds().size() == 1) {
            return this.delete((String)CollectionsKt.first((Iterable)request.getConfigIds()), user, $completion);
        }
        return this.delete(request.getConfigIds(), user, $completion);
    }

    public static final /* synthetic */ Object access$validateEmailConfig(ConfigIndexingActions $this, Email email, User user, Continuation $completion) {
        return $this.validateEmailConfig(email, user, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$validateConfig(ConfigIndexingActions $this, NotificationConfig config, User user, Continuation $completion) {
        return $this.validateConfig(config, user, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$info(ConfigIndexingActions $this, String configId, User user, Continuation $completion) {
        return $this.info(configId, user, (Continuation<? super GetNotificationConfigResponse>)$completion);
    }

    public static final /* synthetic */ Object access$info(ConfigIndexingActions $this, Set configIds, User user, Continuation $completion) {
        return $this.info(configIds, user, (Continuation<? super GetNotificationConfigResponse>)$completion);
    }

    public static final /* synthetic */ Object access$getAll(ConfigIndexingActions $this, GetNotificationConfigRequest request, User user, Continuation $completion) {
        return $this.getAll(request, user, (Continuation<? super GetNotificationConfigResponse>)$completion);
    }

    public static final /* synthetic */ Object access$delete(ConfigIndexingActions $this, String configId, User user, Continuation $completion) {
        return $this.delete(configId, user, (Continuation<? super DeleteNotificationConfigResponse>)$completion);
    }

    public static final /* synthetic */ Object access$delete(ConfigIndexingActions $this, Set configIds, User user, Continuation $completion) {
        return $this.delete(configIds, user, (Continuation<? super DeleteNotificationConfigResponse>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigType.values().length];
            try {
                nArray[ConfigType.EMAIL_GROUP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SMTP_ACCOUNT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SES_ACCOUNT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SLACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.CHIME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.MICROSOFT_TEAMS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.WEBHOOK.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.EMAIL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SNS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

