/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.transport.handler.SearchHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchWorkflowTransportAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    private final Logger logger = LogManager.getLogger(SearchWorkflowTransportAction.class);
    private SearchHandler searchHandler;

    @Inject
    public SearchWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, SearchHandler searchHandler) {
        super("cluster:admin/opensearch/flow_framework/workflow/search", transportService, actionFilters, SearchRequest::new);
        this.searchHandler = searchHandler;
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> actionListener) {
        try {
            String tenantId = null;
            if (request.preference() != null) {
                tenantId = request.preference();
                request.preference(null);
            }
            this.searchHandler.search(request, tenantId, "workflow", actionListener);
        }
        catch (Exception e) {
            String errorMessage = "Failed to search workflows in global context";
            this.logger.error(errorMessage, (Throwable)e);
            actionListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
        }
    }
}

