/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) & (- 0u)) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(66u, 72u, 87u, 75u) & (- 6u)) => uvec4(66u, 72u, 82u, 74u)
 * (uvec4(66u, 72u, 87u, 75u) & (- 12u)) => uvec4(64u, 64u, 84u, 64u)
 * (uvec4(66u, 72u, 87u, 75u) & (- 32u)) => uvec4(64u, 64u, 64u, 64u)
 * (uvec4(66u, 72u, 87u, 75u) & (- 74u)) => uvec4(2u, 0u, 22u, 2u)
 * (uvec4(24u, 40u, 23u, 74u) & (- 0u)) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(24u, 40u, 23u, 74u) & (- 6u)) => uvec4(24u, 40u, 18u, 74u)
 * (uvec4(24u, 40u, 23u, 74u) & (- 12u)) => uvec4(16u, 32u, 20u, 64u)
 * (uvec4(24u, 40u, 23u, 74u) & (- 32u)) => uvec4(0u, 32u, 0u, 64u)
 * (uvec4(24u, 40u, 23u, 74u) & (- 74u)) => uvec4(16u, 32u, 22u, 2u)
 */
#version 150

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (- 0u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (- 6u)), uvec4(66u, 72u, 82u, 74u))) ? 1 : -1] array1;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (- 12u)), uvec4(64u, 64u, 84u, 64u))) ? 1 : -1] array2;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (- 32u)), uvec4(64u, 64u, 64u, 64u))) ? 1 : -1] array3;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (- 74u)), uvec4(2u, 0u, 22u, 2u))) ? 1 : -1] array4;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (- 0u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array5;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (- 6u)), uvec4(24u, 40u, 18u, 74u))) ? 1 : -1] array6;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (- 12u)), uvec4(16u, 32u, 20u, 64u))) ? 1 : -1] array7;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (- 32u)), uvec4(0u, 32u, 0u, 64u))) ? 1 : -1] array8;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (- 74u)), uvec4(16u, 32u, 22u, 2u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
