/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.path;

import java.util.function.BiConsumer;
import java.util.function.IntPredicate;

public enum PathType {
    LEGACY("$", (currentPath, token) -> currentPath.append(".").append(PathType.replaceCommonSpecialCharactersIfPresent(token)), (currentPath, index) -> currentPath.append("[").append(index).append("]")),
    JSON_PATH("$", (currentPath, token) -> {
        if (token.isEmpty()) {
            throw new IllegalArgumentException("A JSONPath selector cannot be empty");
        }
        if (JSONPath.isShorthand(token)) {
            currentPath.append(".").append((String)token);
            return;
        }
        if (token.indexOf(39) != -1) {
            token = token.replace("'", "\\'");
        }
        token = PathType.replaceCommonSpecialCharactersIfPresent(token);
        currentPath.append("['").append((String)token).append("']");
    }, (currentPath, index) -> currentPath.append("[").append(index).append("]")),
    JSON_POINTER("", (currentPath, token) -> {
        if (token.indexOf(126) != -1) {
            token = token.replace("~", "~0");
        }
        if (token.indexOf(47) != -1) {
            token = token.replace("/", "~1");
        }
        token = PathType.replaceCommonSpecialCharactersIfPresent(token);
        currentPath.append("/").append((String)token);
    }, (currentPath, index) -> currentPath.append("/").append(index)),
    URI_REFERENCE("", (currentPath, token) -> {
        if (currentPath.length() != 0) {
            currentPath.append("/").append((String)token);
        } else {
            currentPath.append((String)token);
        }
    }, (currentPath, index) -> currentPath.append("/").append(index));

    public static final PathType DEFAULT;
    private final String rootToken;
    private final BiConsumer<StringBuilder, String> appendTokenFn;
    private final BiConsumer<StringBuilder, Integer> appendIndexFn;

    private PathType(String rootToken, BiConsumer<StringBuilder, String> appendTokenFn, BiConsumer<StringBuilder, Integer> appendIndexFn) {
        this.rootToken = rootToken;
        this.appendTokenFn = appendTokenFn;
        this.appendIndexFn = appendIndexFn;
    }

    private static String replaceCommonSpecialCharactersIfPresent(String token) {
        if (token.indexOf(10) != -1) {
            token = token.replace("\n", "\\n");
        }
        if (token.indexOf(9) != -1) {
            token = token.replace("\t", "\\t");
        }
        if (token.indexOf(13) != -1) {
            token = token.replace("\r", "\\r");
        }
        if (token.indexOf(8) != -1) {
            token = token.replace("\b", "\\b");
        }
        if (token.indexOf(12) != -1) {
            token = token.replace("\f", "\\f");
        }
        return token;
    }

    public void append(StringBuilder currentPath, String child) {
        this.appendTokenFn.accept(currentPath, child);
    }

    public void append(StringBuilder currentPath, int index) {
        this.appendIndexFn.accept(currentPath, index);
    }

    public String getRoot() {
        return this.rootToken;
    }

    public String convertToJsonPointer(String path) {
        switch (this.ordinal()) {
            case 2: {
                return path;
            }
            case 1: {
                return PathType.fromJsonPath(path);
            }
        }
        return PathType.fromLegacy(path);
    }

    static String fromLegacy(String path) {
        return path.replace("\"", "").replace("]", "").replace('[', '/').replace('.', '/').replace("$", "");
    }

    static String fromJsonPath(String str) {
        if (null == str || str.isEmpty() || '$' != str.charAt(0)) {
            throw new IllegalArgumentException("JSON Path must start with '$'");
        }
        String tail = str.substring(1);
        if (tail.isEmpty()) {
            return "";
        }
        int len = tail.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        block4: while (i < len) {
            char c = tail.charAt(i);
            switch (c) {
                case '.': {
                    sb.append('/');
                    i = PathType.parseShorthand(sb, tail, i + 1);
                    continue block4;
                }
                case '[': {
                    sb.append('/');
                    i = PathType.parseSelector(sb, tail, i + 1);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("JSONPath must reference a property or array index");
        }
        return sb.toString();
    }

    static int parseShorthand(StringBuilder sb, String s, int pos) {
        int i;
        int len = s.length();
        block3: for (i = pos; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '.': 
                case '[': {
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return i;
    }

    static int parseSelector(StringBuilder sb, String s, int pos) {
        int close = s.indexOf(93, pos);
        if (-1 == close) {
            throw new IllegalArgumentException("JSONPath contains an unterminated selector");
        }
        if ('\'' == s.charAt(pos)) {
            PathType.parseQuote(sb, s, pos + 1);
        } else {
            sb.append(s, pos, close);
        }
        return close + 1;
    }

    static int parseQuote(StringBuilder sb, String s, int pos) {
        int close = pos;
        do {
            if (-1 != (close = s.indexOf(39, close))) continue;
            throw new IllegalArgumentException("JSONPath contains an unterminated quoted string");
        } while ('\\' == s.charAt(close - 1));
        sb.append(s, pos, close);
        return close + 1;
    }

    static {
        DEFAULT = LEGACY;
    }

    static class JSONPath {
        public static final IntPredicate ALPHA = c -> c >= 97 && c <= 122 || c >= 65 && c <= 90;
        public static final IntPredicate DIGIT = c -> c >= 48 && c <= 57;
        public static final IntPredicate NON_ASCII = c -> c >= 128 && c <= 0x10FFFF;
        public static final IntPredicate UNDERSCORE = c -> 95 == c;
        public static final IntPredicate NAME_FIRST = ALPHA.or(UNDERSCORE).or(NON_ASCII);
        public static final IntPredicate NAME_CHAR = NAME_FIRST.or(DIGIT);

        JSONPath() {
        }

        public static boolean isShorthand(String selector) {
            if (null == selector || selector.isEmpty()) {
                throw new IllegalArgumentException("A JSONPath selector cannot be empty");
            }
            return NAME_FIRST.test(selector.codePointAt(0)) && selector.codePoints().skip(1L).allMatch(NAME_CHAR);
        }
    }
}

