/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.Error;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.resource.ClasspathResourceLoader;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.IriResourceLoader;
import com.networknt.schema.resource.MetaSchemaIdResolver;
import com.networknt.schema.resource.ResourceLoader;
import com.networknt.schema.resource.ResourceLoaders;
import com.networknt.schema.resource.SchemaIdResolver;
import com.networknt.schema.resource.SchemaIdResolvers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SchemaLoader {
    private static final MetaSchemaIdResolver META_SCHEMA_ID_RESOLVER = MetaSchemaIdResolver.getInstance();
    private static final ClasspathResourceLoader CLASSPATH_RESOURCE_LOADER = ClasspathResourceLoader.getInstance();
    protected final List<ResourceLoader> resourceLoaders;
    protected final List<SchemaIdResolver> schemaIdResolvers;
    protected final Predicate<AbsoluteIri> allow;
    protected final Predicate<AbsoluteIri> block;

    public static SchemaLoader getDefault() {
        return DefaultHolder.DEFAULT;
    }

    public static SchemaLoader getRemoteFetcher() {
        return RemoteFetcher.REMOTE_FETCHER;
    }

    public SchemaLoader(ResourceLoader resourceLoader) {
        this(Collections.emptyList(), Collections.singletonList(resourceLoader));
    }

    public SchemaLoader(SchemaIdResolver schemaIdResolver, ResourceLoader resourceLoader) {
        this(Collections.singletonList(schemaIdResolver), Collections.singletonList(resourceLoader));
    }

    public SchemaLoader(List<SchemaIdResolver> schemaIdResolvers, List<ResourceLoader> resourceLoaders) {
        this(schemaIdResolvers, resourceLoaders, null, null);
    }

    public SchemaLoader(List<SchemaIdResolver> schemaIdResolvers, List<ResourceLoader> resourceLoaders, Predicate<AbsoluteIri> allow, Predicate<AbsoluteIri> block) {
        this.schemaIdResolvers = schemaIdResolvers;
        this.resourceLoaders = resourceLoaders;
        this.allow = allow;
        this.block = block;
    }

    public SchemaLoader(SchemaLoader copy) {
        this(new ArrayList<SchemaIdResolver>(copy.schemaIdResolvers), new ArrayList<ResourceLoader>(copy.resourceLoaders));
    }

    public InputStreamSource getSchemaResource(AbsoluteIri absoluteIri) {
        InputStreamSource result;
        if (this.allow != null && !this.allow.test(absoluteIri)) {
            throw new InvalidSchemaException(((Error.Builder)((Error.Builder)Error.builder().message("Schema from ''{0}'' is not allowed to be loaded.")).arguments(absoluteIri)).build());
        }
        if (this.block != null && this.block.test(absoluteIri)) {
            throw new InvalidSchemaException(((Error.Builder)((Error.Builder)Error.builder().message("Schema from ''{0}'' is not allowed to be loaded.")).arguments(absoluteIri)).build());
        }
        AbsoluteIri mappedResult = absoluteIri;
        for (SchemaIdResolver mapper : this.schemaIdResolvers) {
            AbsoluteIri mapped = mapper.resolve(mappedResult);
            if (mapped == null) continue;
            mappedResult = mapped;
        }
        AbsoluteIri mapped = this.resolveMetaSchemaId(absoluteIri);
        if (mapped != null) {
            mappedResult = mapped;
        }
        if ((result = this.getClasspathResource(mappedResult)) != null) {
            return result;
        }
        for (ResourceLoader loader : this.resourceLoaders) {
            result = loader.getResource(mappedResult);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected AbsoluteIri resolveMetaSchemaId(AbsoluteIri absoluteIri) {
        return META_SCHEMA_ID_RESOLVER.resolve(absoluteIri);
    }

    protected InputStreamSource getClasspathResource(AbsoluteIri absoluteIri) {
        return CLASSPATH_RESOURCE_LOADER.getResource(absoluteIri);
    }

    public List<ResourceLoader> getResourceLoaders() {
        return this.resourceLoaders;
    }

    public List<SchemaIdResolver> getSchemaIdResolvers() {
        return this.schemaIdResolvers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaLoader copy) {
        Builder builder = new Builder();
        if (!copy.getResourceLoaders().isEmpty()) {
            builder.resourceLoaders(r -> r.values(c -> c.addAll(copy.resourceLoaders)));
        }
        if (!copy.getSchemaIdResolvers().isEmpty()) {
            builder.schemaIdResolvers(r -> r.values(c -> c.addAll(copy.schemaIdResolvers)));
        }
        builder.allow(copy.allow);
        builder.block(copy.block);
        return builder;
    }

    private static class DefaultHolder {
        private static final SchemaLoader DEFAULT = new SchemaLoader(Collections.emptyList(), Collections.emptyList());

        private DefaultHolder() {
        }
    }

    private static class RemoteFetcher {
        private static final SchemaLoader REMOTE_FETCHER = SchemaLoader.builder().fetchRemoteResources().build();

        private RemoteFetcher() {
        }
    }

    public static class Builder {
        private SchemaIdResolvers.Builder schemaIdResolversBuilder = new SchemaIdResolvers.Builder();
        private ResourceLoaders.Builder resourceLoadersBuilder = new ResourceLoaders.Builder();
        private Predicate<AbsoluteIri> allow = null;
        private Predicate<AbsoluteIri> block = null;
        private boolean fetchRemoteResources = false;

        public Builder schemaIdResolvers(Consumer<SchemaIdResolvers.Builder> customizer) {
            customizer.accept(this.schemaIdResolversBuilder);
            return this;
        }

        public Builder resourceLoaders(Consumer<ResourceLoaders.Builder> customizer) {
            customizer.accept(this.resourceLoadersBuilder);
            return this;
        }

        public Builder allow(Predicate<AbsoluteIri> allow) {
            this.allow = allow;
            return this;
        }

        public Builder block(Predicate<AbsoluteIri> block) {
            this.block = block;
            return this;
        }

        public Builder fetchRemoteResources(boolean fetch) {
            this.fetchRemoteResources = fetch;
            return this;
        }

        public Builder fetchRemoteResources() {
            return this.fetchRemoteResources(true);
        }

        public SchemaIdResolvers.Builder getSchemaIdResolversBuilder() {
            return this.schemaIdResolversBuilder;
        }

        public ResourceLoaders.Builder getResourceLoadersBuilder() {
            return this.resourceLoadersBuilder;
        }

        public SchemaLoader build() {
            if (this.fetchRemoteResources) {
                this.resourceLoadersBuilder.add(IriResourceLoader.getInstance());
            }
            return new SchemaLoader(this.schemaIdResolversBuilder.build(), this.resourceLoadersBuilder.build(), this.allow, this.block);
        }
    }
}

