/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class PayArrearsMessage
extends AttributeMessage {
    public static final String TAG = "payArrears";
    private static final String GOODS_TYPE_TAG = "goodsType";

    public PayArrearsMessage(GoodsType type) {
        super(TAG, GOODS_TYPE_TAG, type.getId());
    }

    public PayArrearsMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, GOODS_TYPE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        GoodsType goodsType = freeColServer.getSpecification().getGoodsType(this.getStringAttribute(GOODS_TYPE_TAG));
        return this.igc(freeColServer).payArrears(serverPlayer, goodsType);
    }
}

