/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.news;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.i2p.util.SystemVersion;

public abstract class RFC3339Date {
    private static final SimpleDateFormat OUTPUT_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private static final String TZF1;
    private static final String TZF2;
    private static final SimpleDateFormat[] rfc3339DateFormats;

    public static synchronized long parse3339Date(String s) {
        s = s.trim();
        int len = s.length();
        if (!(SystemVersion.isJava7() && !SystemVersion.isAndroid() || s.charAt(len - 1) == 'Z' || s.charAt(len - 3) != ':' || s.charAt(len - 6) != '+' && s.charAt(len - 6) != '-')) {
            s = s.substring(0, len - 3) + s.substring(len - 2);
        }
        for (int i = 0; i < rfc3339DateFormats.length; ++i) {
            try {
                Date date = rfc3339DateFormats[i].parse(s);
                if (date == null) continue;
                return date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static synchronized String to3339Date(long t) {
        return OUTPUT_FORMAT.format(new Date(t));
    }

    static {
        if (SystemVersion.isJava7() && !SystemVersion.isAndroid()) {
            TZF1 = "yyyy-MM-dd'T'HH:mm:ssXXX";
            TZF2 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
        } else {
            TZF1 = "yyyy-MM-dd'T'HH:mm:ssZZZZZ";
            TZF2 = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ";
        }
        rfc3339DateFormats = new SimpleDateFormat[]{OUTPUT_FORMAT, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US), new SimpleDateFormat(TZF1, Locale.US), new SimpleDateFormat(TZF2, Locale.US), new SimpleDateFormat("yyyy-MM-dd", Locale.US), new SimpleDateFormat("yyyy/MM/dd", Locale.US)};
        TimeZone utc = TimeZone.getTimeZone("GMT");
        for (int i = 0; i < rfc3339DateFormats.length; ++i) {
            rfc3339DateFormats[i].setTimeZone(utc);
        }
    }
}

