/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.ResolveState;
import org.jetbrains.annotations.NotNull;

public enum PatternResolveState {
    WHEN_TRUE,
    WHEN_FALSE,
    WHEN_BOTH,
    WHEN_NONE;

    public static final Key<PatternResolveState> KEY;

    public static PatternResolveState fromBoolean(boolean value) {
        return value ? WHEN_TRUE : WHEN_FALSE;
    }

    public PatternResolveState invert() {
        switch (this) {
            case WHEN_TRUE: {
                return WHEN_FALSE;
            }
            case WHEN_FALSE: {
                return WHEN_TRUE;
            }
        }
        return this;
    }

    public ResolveState putInto(ResolveState rs) {
        return rs.put(KEY, (Object)this);
    }

    @NotNull
    public static PatternResolveState stateAtParent(PsiPatternVariable element, PsiExpression parent) {
        PsiPattern pattern = element.getPattern();
        PatternResolveState state = WHEN_TRUE;
        PsiPattern prev = pattern;
        PsiElement current = prev.getParent();
        while (prev != parent) {
            if (!(current instanceof PsiInstanceOfExpression || current instanceof PsiParenthesizedExpression || current instanceof PsiDeconstructionList || current instanceof PsiDeconstructionPattern || current instanceof PsiPolyadicExpression && (((PsiPolyadicExpression)current).getOperationTokenType() == JavaTokenType.ANDAND || ((PsiPolyadicExpression)current).getOperationTokenType() == JavaTokenType.OROR))) {
                if (current instanceof PsiPrefixExpression && ((PsiPrefixExpression)current).getOperationTokenType() == JavaTokenType.EXCL) {
                    state = state.invert();
                } else {
                    PatternResolveState patternResolveState = WHEN_NONE;
                    if (patternResolveState == null) {
                        PatternResolveState.$$$reportNull$$$0(0);
                    }
                    return patternResolveState;
                }
            }
            prev = current;
            current = current.getParent();
        }
        PatternResolveState patternResolveState = state;
        if (patternResolveState == null) {
            PatternResolveState.$$$reportNull$$$0(1);
        }
        return patternResolveState;
    }

    static {
        KEY = Key.create((String)"JavaPatternDeclarationHint");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/PatternResolveState", "stateAtParent"));
    }
}

