/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.SideBorder;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBDefaultTabsBorder;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs;", "Lcom/intellij/execution/ui/layout/impl/JBRunnerTabs;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "createTabBorder", "Lcom/intellij/ui/tabs/JBTabsBorder;", "addClosableTab", "", "tab", "Lcom/intellij/ui/tabs/TabInfo;", "select", "", "adjust", "tabInfo", "createCloseGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "CloseTabLabelAction", "Companion", "intellij.profiler.common"})
public final class JBRunnerClosableTabs
extends JBRunnerTabs {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public JBRunnerClosableTabs(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(project, parent);
        this.setPopupGroup((ActionGroup)this.createCloseGroup(), "RunnerClosableTabsCloseGroup", true);
        this.setTabDraggingEnabled(true);
        this.addTabMouseListener(new MouseAdapter(){
            private TabInfo tabToRemove;

            @Override
            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    this.tabToRemove = this.findInfo(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Object object = this.tabToRemove;
                if (object != null) {
                    TabInfo tabInfo;
                    TabInfo it = tabInfo = object;
                    boolean bl = false;
                    object = Companion.isClosable(it) ? tabInfo : null;
                    if (object != null) {
                        tabInfo = object;
                        JBRunnerClosableTabs jBRunnerClosableTabs = this;
                        TabInfo p0 = tabInfo;
                        boolean bl2 = false;
                        jBRunnerClosableTabs.removeTab(p0);
                    }
                }
                this.tabToRemove = null;
            }
        });
        this.addListener(new TabsListener(){

            public void tabRemoved(TabInfo tabToRemove) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)tabToRemove, (String)"tabToRemove");
                    JComponent jComponent = tabToRemove.getComponent();
                    Disposable disposable = jComponent instanceof Disposable ? (Disposable)jComponent : null;
                    if (disposable == null) break block0;
                    Disposable p0 = disposable;
                    boolean bl = false;
                    Disposer.dispose((Disposable)p0);
                }
            }
        });
    }

    @NotNull
    protected JBTabsBorder createTabBorder() {
        return (JBTabsBorder)new JBDefaultTabsBorder((JBTabsImpl)this);
    }

    public final void addClosableTab(@NotNull TabInfo tab, boolean select) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        AnAction[] anActionArray = new AnAction[]{new CloseTabLabelAction(tab)};
        DefaultActionGroup tabLabelActions = new DefaultActionGroup(anActionArray);
        if (tab.getTabLabelActions() != null) {
            tabLabelActions.addSeparator();
            ActionGroup actionGroup = tab.getTabLabelActions();
            if (actionGroup != null) {
                ActionGroup it = actionGroup;
                boolean bl = false;
                tabLabelActions.addAll(it);
            }
        }
        tab.setTabLabelActions((ActionGroup)tabLabelActions, "unknown");
        this.addTab(tab);
        if (select) {
            this.select(tab, true);
        }
    }

    public static /* synthetic */ void addClosableTab$default(JBRunnerClosableTabs jBRunnerClosableTabs, TabInfo tabInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        jBRunnerClosableTabs.addClosableTab(tabInfo, bl);
    }

    protected void adjust(@NotNull TabInfo tabInfo) {
        Intrinsics.checkNotNullParameter((Object)tabInfo, (String)"tabInfo");
        JComponent c = tabInfo.getComponent();
        JBIterable jBIterable = ((JBTreeTraverser)UIUtil.uiTraverser((Component)c).expand(arg_0 -> JBRunnerClosableTabs.adjust$lambda$2(arg_0 -> JBRunnerClosableTabs.adjust$lambda$1(c, arg_0), arg_0))).filter(JScrollPane.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable scrollPanes = jBIterable;
        for (JScrollPane scrollPane : scrollPanes) {
            if (scrollPane.getBorder() instanceof ScrollableContentBorder) continue;
            scrollPane.setBorder((Border)new SideBorder(NamedColorUtil.getBoundsColor(), 0));
        }
    }

    private final DefaultActionGroup createCloseGroup() {
        AnAction[] anActionArray = new AnAction[2];
        String string = CommonProfilerBundleKt.profilerMessage("ui.tabs.close", new Object[0]);
        Icon icon2 = AllIcons.Actions.Close;
        anActionArray[0] = new DumbAwareAction(this, string, icon2){
            final /* synthetic */ JBRunnerClosableTabs this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
                this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CloseContent"), $receiver.getComponent());
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TabInfo tabInfo = this.this$0.getTargetInfo();
                boolean bl = tabInfo != null ? com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, tabInfo) : false;
                if (bl) {
                    this.this$0.removeTab(this.this$0.getTargetInfo());
                }
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TabInfo tabInfo = this.this$0.getTargetInfo();
                e.getPresentation().setEnabledAndVisible(tabInfo != null ? com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, tabInfo) : false);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        string = CommonProfilerBundleKt.profilerMessage("ui.tabs.closeOthers", new Object[0]);
        anActionArray[1] = new DumbAwareAction(this, string){
            final /* synthetic */ JBRunnerClosableTabs this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable iterable = this.this$0.getTabs();
                JBRunnerClosableTabs jBRunnerClosableTabs = this.this$0;
                boolean $i$f$filter = false;
                Iterator<T> iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TabInfo it = (TabInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, it) && !Intrinsics.areEqual((Object)it, (Object)jBRunnerClosableTabs.getTargetInfo()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                jBRunnerClosableTabs = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TabInfo it = (TabInfo)element$iv;
                    boolean bl = false;
                    jBRunnerClosableTabs.removeTab(it);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void update(AnActionEvent e) {
                boolean bl;
                Presentation presentation;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Iterable iterable = this.this$0.getTabs();
                    JBRunnerClosableTabs jBRunnerClosableTabs = this.this$0;
                    presentation = e.getPresentation();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TabInfo it = (TabInfo)element$iv;
                            boolean bl2 = false;
                            if (!(com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, it) && !Intrinsics.areEqual((Object)it, (Object)jBRunnerClosableTabs.getTargetInfo()))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl3 = bl;
                presentation.setVisible(bl3);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        return new DefaultActionGroup(anActionArray);
    }

    private static final boolean adjust$lambda$1(JComponent $c, Component o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return o == $c || o instanceof JPanel || o instanceof JLayeredPane;
    }

    private static final boolean adjust$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs$CloseTabLabelAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "tabInfo", "Lcom/intellij/ui/tabs/TabInfo;", "<init>", "(Lcom/intellij/profiler/ui/JBRunnerClosableTabs;Lcom/intellij/ui/tabs/TabInfo;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.profiler.common"})
    private final class CloseTabLabelAction
    extends DumbAwareAction {
        @NotNull
        private final TabInfo tabInfo;

        public CloseTabLabelAction(TabInfo tabInfo) {
            Intrinsics.checkNotNullParameter((Object)tabInfo, (String)"tabInfo");
            super(CommonProfilerBundleKt.profilerMessage("ui.tabs.close", new Object[0]), null, AllIcons.Actions.Close);
            this.tabInfo = tabInfo;
            this.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JBRunnerClosableTabs.this.removeTab(this.tabInfo);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs$Companion;", "", "<init>", "()V", "isClosable", "", "Lcom/intellij/ui/tabs/TabInfo;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nJBRunnerClosableTabs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBRunnerClosableTabs.kt\ncom/intellij/profiler/ui/JBRunnerClosableTabs$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,137:1\n12637#2,2:138\n*S KotlinDebug\n*F\n+ 1 JBRunnerClosableTabs.kt\ncom/intellij/profiler/ui/JBRunnerClosableTabs$Companion\n*L\n134#1:138,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isClosable(TabInfo $this$isClosable) {
            boolean bl;
            ActionGroup actionGroup = $this$isClosable.getTabLabelActions();
            AnAction[] anActionArray = actionGroup instanceof DefaultActionGroup ? (AnAction[])actionGroup : null;
            if (anActionArray != null && (anActionArray = anActionArray.getChildActionsOrStubs()) != null) {
                boolean bl2;
                block3: {
                    AnAction[] $this$any$iv = anActionArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        AnAction element$iv;
                        AnAction it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!(it instanceof CloseTabLabelAction)) continue;
                        bl2 = true;
                        break block3;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

