/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l = 34913532517566L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-256635060 - -22678, -256635060 + -1670, (int)l));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-256635060 - -22679, -256635060 - -11592, (int)l));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l;
            block2: {
                l = 111146580124132L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.p();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1416473490 - 20696, -1416473490 - -19048, (int)l) + string + WindowsNamedPipeAgentIpc.b(1416473490 - 20695, -1416473490 - -29785, (int)l) + thread3 + WindowsNamedPipeAgentIpc.b(1416473490 - 20694, -1416473490 - -((char)-26939), (int)l) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l;
        block14: {
            block15: {
                l = 74367854061923L;
                Object object = this.lock;
                String string = SshAgentIpcService.p();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(495313530 + 28608, -495313530 + -25612, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(495313530 + 28607, 495313530 + 25398, (int)l) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(495313530 + 28606, 495313530 + 11893, (int)l));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(495313530 + 28605, 495313530 + 8999, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(495313530 + 28604, 495313530 + (char)-28737, (int)l) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(495313530 + 28603, -495313530 + -26247, (int)l));
            logger.info(WindowsNamedPipeAgentIpc.b(495313530 + 28605, 495313530 + 8999, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(495313530 + 28602, -495313530 + -15887, (int)l));
            if (ActionTimestamp.p() != null) {
                SshAgentIpcService.p("QE1QV");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l = 87248210526492L;
                    string = SshAgentIpcService.p();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l;
        block27: {
            block28: {
                l = 106454386039696L;
                String string2 = SshAgentIpcService.p();
                this.assertConnectionThread();
                string = string2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1892), -673437660 - -((char)-4457), (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1888), -673306590 + -((char)-20272), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1891), 673437660 - (char)-9235, (int)l) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1888), -673306590 + -((char)-20272), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1890), -673306590 + -((char)-2022), (int)l) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1892), -673437660 - -((char)-4457), (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1888), -673306590 + -((char)-20272), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1889), -673306590 + -((char)-1793), (int)l));
                    object2 = Kernel32.INSTANCE;
                    if (string == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1892), -673437660 - -((char)-4457), (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1888), -673306590 + -((char)-20272), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1864), -673306590 + -((char)-9136), (int)l));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1888), -673306590 + -((char)-20272), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1863), 673306590 + (char)-9600, (int)l) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string4 = WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1888), -673306590 + -((char)-20272), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1890), -673306590 + -((char)-2022), (int)l) + this.state;
                throw new IllegalArgumentException(string4.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1892), -673437660 - -((char)-4457), (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1888), -673306590 + -((char)-20272), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-673437660 - -((char)-1862), -673306590 + -((char)-60), (int)l));
        long l2 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l2);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l = 118953160380874L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(253882590 - (char)-19909, 253882590 - (char)-11094, (int)l));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l = 19500663593283L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1512023520 + -25589, -1512023520 + -((char)-15662), (int)l));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "&\u00ef\u00a7\u00e5\u001c=\u00fd\u0083\u00e5Io\u00a9!9o\u001bY>\u00f6\u0014#\u00ba\u0007I\u0013ja\u00ec\u00f4\u00a2\u0088\u0000\u001f\u00f5i\tt\u00baT\u0004";
                        var4_3 = "&\u00ef\u00a7\u00e5\u001c=\u00fd\u0083\u00e5Io\u00a9!9o\u001bY>\u00f6\u0014#\u00ba\u0007I\u0013ja\u00ec\u00f4\u00a2\u0088\u0000\u001f\u00f5i\tt\u00baT\u0004".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 74;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 47;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 81;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 20;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 54;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 16;
                                        break;
                                    }
                                    default: {
                                        v11 = 109;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFAF69) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 223;
                            case 1 -> 158;
                            case 2 -> 252;
                            case 3 -> 72;
                            case 4 -> 132;
                            case 5 -> 251;
                            case 6 -> 115;
                            case 7 -> 240;
                            case 8 -> 31;
                            case 9 -> 164;
                            case 10 -> 165;
                            case 11 -> 83;
                            case 12 -> 16;
                            case 13 -> 37;
                            case 14 -> 224;
                            case 15 -> 250;
                            case 16 -> 145;
                            case 17 -> 151;
                            case 18 -> 194;
                            case 19 -> 27;
                            case 20 -> 1;
                            case 21 -> 217;
                            case 22 -> 220;
                            case 23 -> 124;
                            case 24 -> 86;
                            case 25 -> 211;
                            case 26 -> 213;
                            case 27 -> 127;
                            case 28 -> 126;
                            case 29 -> 189;
                            case 30 -> 206;
                            case 31 -> 167;
                            case 32 -> 15;
                            case 33 -> 212;
                            case 34 -> 159;
                            case 35 -> 47;
                            case 36 -> 196;
                            case 37 -> 100;
                            case 38 -> 93;
                            case 39 -> 89;
                            case 40 -> 175;
                            case 41 -> 14;
                            case 42 -> 33;
                            case 43 -> 186;
                            case 44 -> 98;
                            case 45 -> 150;
                            case 46 -> 236;
                            case 47 -> 254;
                            case 48 -> 82;
                            case 49 -> 249;
                            case 50 -> 42;
                            case 51 -> 234;
                            case 52 -> 107;
                            case 53 -> 170;
                            case 54 -> 88;
                            case 55 -> 193;
                            case 56 -> 241;
                            case 57 -> 173;
                            case 58 -> 144;
                            case 59 -> 75;
                            case 60 -> 25;
                            case 61 -> 130;
                            case 62 -> 179;
                            case 63 -> 231;
                            case 64 -> 29;
                            case 65 -> 28;
                            case 66 -> 10;
                            case 67 -> 209;
                            case 68 -> 166;
                            case 69 -> 18;
                            case 70 -> 229;
                            case 71 -> 55;
                            case 72 -> 147;
                            case 73 -> 161;
                            case 74 -> 122;
                            case 75 -> 58;
                            case 76 -> 103;
                            case 77 -> 79;
                            case 78 -> 52;
                            case 79 -> 157;
                            case 80 -> 94;
                            case 81 -> 239;
                            case 82 -> 48;
                            case 83 -> 112;
                            case 84 -> 204;
                            case 85 -> 190;
                            case 86 -> 225;
                            case 87 -> 36;
                            case 88 -> 232;
                            case 89 -> 201;
                            case 90 -> 154;
                            case 91 -> 95;
                            case 92 -> 162;
                            case 93 -> 120;
                            case 94 -> 156;
                            case 95 -> 131;
                            case 96 -> 56;
                            case 97 -> 64;
                            case 98 -> 208;
                            case 99 -> 87;
                            case 100 -> 44;
                            case 101 -> 138;
                            case 102 -> 129;
                            case 103 -> 19;
                            case 104 -> 73;
                            case 105 -> 102;
                            case 106 -> 105;
                            case 107 -> 21;
                            case 108 -> 180;
                            case 109 -> 20;
                            case 110 -> 243;
                            case 111 -> 171;
                            case 112 -> 34;
                            case 113 -> 60;
                            case 114 -> 99;
                            case 115 -> 90;
                            case 116 -> 5;
                            case 117 -> 61;
                            case 118 -> 65;
                            case 119 -> 85;
                            case 120 -> 255;
                            case 121 -> 221;
                            case 122 -> 242;
                            case 123 -> 230;
                            case 124 -> 117;
                            case 125 -> 218;
                            case 126 -> 155;
                            case 127 -> 92;
                            case 128 -> 49;
                            case 129 -> 46;
                            case 130 -> 116;
                            case 131 -> 63;
                            case 132 -> 40;
                            case 133 -> 128;
                            case 134 -> 39;
                            case 135 -> 71;
                            case 136 -> 96;
                            case 137 -> 199;
                            case 138 -> 2;
                            case 139 -> 228;
                            case 140 -> 182;
                            case 141 -> 134;
                            case 142 -> 57;
                            case 143 -> 68;
                            case 144 -> 7;
                            case 145 -> 32;
                            case 146 -> 69;
                            case 147 -> 8;
                            case 148 -> 237;
                            case 149 -> 11;
                            case 150 -> 203;
                            case 151 -> 148;
                            case 152 -> 187;
                            case 153 -> 84;
                            case 154 -> 35;
                            case 155 -> 135;
                            case 156 -> 153;
                            case 157 -> 202;
                            case 158 -> 233;
                            case 159 -> 123;
                            case 160 -> 109;
                            case 161 -> 149;
                            case 162 -> 142;
                            case 163 -> 51;
                            case 164 -> 9;
                            case 165 -> 13;
                            case 166 -> 205;
                            case 167 -> 222;
                            case 168 -> 235;
                            case 169 -> 125;
                            case 170 -> 244;
                            case 171 -> 183;
                            case 172 -> 54;
                            case 173 -> 66;
                            case 174 -> 38;
                            case 175 -> 185;
                            case 176 -> 214;
                            case 177 -> 110;
                            case 178 -> 24;
                            case 179 -> 45;
                            case 180 -> 26;
                            case 181 -> 133;
                            case 182 -> 114;
                            case 183 -> 227;
                            case 184 -> 200;
                            case 185 -> 74;
                            case 186 -> 177;
                            case 187 -> 77;
                            case 188 -> 163;
                            case 189 -> 197;
                            case 190 -> 97;
                            case 191 -> 188;
                            case 192 -> 248;
                            case 193 -> 121;
                            case 194 -> 210;
                            case 195 -> 168;
                            case 196 -> 22;
                            case 197 -> 178;
                            case 198 -> 247;
                            case 199 -> 192;
                            case 200 -> 81;
                            case 201 -> 139;
                            case 202 -> 70;
                            case 203 -> 118;
                            case 204 -> 169;
                            case 205 -> 111;
                            case 206 -> 216;
                            case 207 -> 30;
                            case 208 -> 141;
                            case 209 -> 78;
                            case 210 -> 23;
                            case 211 -> 253;
                            case 212 -> 160;
                            case 213 -> 245;
                            case 214 -> 195;
                            case 215 -> 67;
                            case 216 -> 106;
                            case 217 -> 91;
                            case 218 -> 76;
                            case 219 -> 104;
                            case 220 -> 152;
                            case 221 -> 246;
                            case 222 -> 119;
                            case 223 -> 219;
                            case 224 -> 50;
                            case 225 -> 12;
                            case 226 -> 207;
                            case 227 -> 181;
                            case 228 -> 238;
                            case 229 -> 140;
                            case 230 -> 226;
                            case 231 -> 4;
                            case 232 -> 198;
                            case 233 -> 143;
                            case 234 -> 41;
                            case 235 -> 215;
                            case 236 -> 172;
                            case 237 -> 0;
                            case 238 -> 191;
                            case 239 -> 174;
                            case 240 -> 43;
                            case 241 -> 62;
                            case 242 -> 17;
                            case 243 -> 59;
                            case 244 -> 136;
                            case 245 -> 3;
                            case 246 -> 184;
                            case 247 -> 108;
                            case 248 -> 53;
                            case 249 -> 80;
                            case 250 -> 6;
                            case 251 -> 137;
                            case 252 -> 146;
                            case 253 -> 113;
                            case 254 -> 176;
                            default -> 101;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string == null) {
                ActionTimestamp.p(new String[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l2;
            block2: {
                block3: {
                    l2 = 45776605861250L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.p();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(844352940 + (char)-7898, 844352940 + (char)-13571, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(844352940 + (char)-7894, 844484010 - (char)-11158, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(844352940 + (char)-7903, 844352940 + (char)-15620, (int)l2) + uLONG);
                    l = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(844352940 + (char)-7898, 844352940 + (char)-13571, (int)l2));
            logger.warn(WindowsNamedPipeAgentIpc.b(844352940 + (char)-7894, 844484010 - (char)-11158, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(844352940 + (char)-7906, 844352940 + (char)-11360, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
            l = -1L;
        }
        long l3 = l;
        return l3;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l = 137853043990838L;
                        String string3 = SshAgentIpcService.p();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1773639240 + 1079, 1773639240 + 26586, (int)l));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1773639240 + 1076, -1773639240 + -9525, (int)l);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l;
        block25: {
            block26: {
                l = 101603425039149L;
                String string2 = SshAgentIpcService.p();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    string = string2;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11405, 1678744560 - (char)-25110, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11401, 1678744560 - (char)-1023, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11382, -1678744560 - -((char)-8889), (int)l));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11401, 1678744560 - (char)-1023, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11407, 1678744560 - (char)-15557, (int)l) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11405, 1678744560 - (char)-25110, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11401, 1678744560 - (char)-1023, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11385, -1678613490 + -((char)-7008), (int)l));
                    object = Kernel32.INSTANCE;
                    if (string == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11405, 1678744560 - (char)-25110, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11401, 1678744560 - (char)-1023, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11384, -1678744560 - -((char)-19385), (int)l) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11405, 1678744560 - (char)-25110, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11401, 1678744560 - (char)-1023, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1678744560 - (char)-11387, 1678744560 - (char)-22716, (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l;
            block15: {
                String string;
                block16: {
                    l = 62247552629185L;
                    Object object = this.lock;
                    string = SshAgentIpcService.p();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(591649980 - (char)-26069, 591649980 - 26578, (int)l));
                                logger.info(WindowsNamedPipeAgentIpc.b(591649980 - (char)-26073, 591649980 - (char)-14407, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(591649980 - (char)-26058, -591649980 - -((char)-32174), (int)l) + this.state + WindowsNamedPipeAgentIpc.b(591649980 - (char)-26053, 591649980 - (char)-28874, (int)l));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(591649980 - (char)-26069, 591649980 - 26578, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(591649980 - (char)-26073, 591649980 - (char)-14407, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(591649980 - (char)-26052, 591649980 - (char)-20475, (int)l));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(591649980 - (char)-26069, 591649980 - 26578, (int)l));
                        logger.info(WindowsNamedPipeAgentIpc.b(591649980 - (char)-26073, 591649980 - (char)-14407, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(591649980 - (char)-26055, -591649980 - -((char)-29105), (int)l) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(591649980 - (char)-26069, 591649980 - 26578, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(591649980 - (char)-26073, 591649980 - (char)-14407, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(591649980 - (char)-26054, -591649980 - -29364, (int)l));
                    if (string == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(591649980 - (char)-26069, 591649980 - 26578, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(591649980 - (char)-26073, 591649980 - (char)-14407, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(591649980 - (char)-26113, 591649980 - 25222, (int)l) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(591649980 - (char)-26112, -591649980 - -30802, (int)l));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00abPL\u00d1\u00e8\u00c0X\u00e7\u0014%B\u00a5t+\u00fc\u008fz?\u008d\u0012\u00d3\u00db\u0098;\u00e2\u00a5v\u00c7\u001c\u0006\u0092Hk\u00d2f\u00e1\u0018\u0015b\u00c3@e\u00bfD\u00d2\u008e\u00e5+\u00ae\u009a\u00c8AjC\u000e5\u008epa\u00da\u00ef\t\u00b5\u00f2I\u00e3_T\u001b\u00e7Y\u0005Q\u00bf\u0013,s\bQ\u008a\u0013\u00fbQ\u00a3ii\u0014\u00de\u00e6\u00a2{\u00a6\u0015\u000b\u00d0\u00c1\u0005fv\u001f\u008f\u0018\u00ed\u00d3D\u00f0\u0018\u0005V\u00a7\u00f3/o\u001e_8\u00c7\u00b8td\u00c4\u00d3;\u00d1\u00d6\u00afi\u00c8\u009d\u000e9\u0013\u00a8\u00d9o\u00a45\u009a\u0004\u0094M\u00aa=\u00a0\u0010\u009e\u00e7\u001b\u0086\u00b8\u0091\u00ab\u0094\u00ab\u008bI\u0019\u009cK\u008c\u00e1\t\u00da\\r'k\u00eb\u00bb\u008f\u00a3\u00103-\u00ae\u00df\u000e\u00ba}\u00f1q'\u0012\u008c\u00f7\u00f9\u00e1\u00b7?\u0088\u00cd5\u0006'\u00ba+d\u00b7\u00f6\u0002\u00b0L\u00dd\u0004\u0095\u00cf\u0005\u000b\u00de\u0095\u0016\u0011\u00aa\u0090z\u00d2\u00c3\u00f9\u00db\u008f\u00d7\u001c\u00f7\u00a0D\u00ccT\u0010\u00e6\u00df\u001c\u00eb\u008c+H\u00e6\u008c\u0015\u00d0\u00af\u0003ePC1h\u00f4j\u0018\u008cy=\b\u008a\u00bdh\u001d>\u007f\u0084\u00f2\fh\u00cd$\b\u00aa\u00bf\u00f8\u00ed\u00e8\u00ecs\u00f1F\u0086\u00b4\u00f9'\u0011Z\u008fQ\u0006w\u00a4F\u000e\u000bSi\u00d9\u00fd\u00c9n\u00dfR[\u0010\u00ef\u0006\u00ceG\u00c5b2\u00dc\u0097 \u0013\u009f`b.\u00e4\u008bI\u00ea\u00dd\u00d5\u00e7m\u0004\u00839\u001b\u0094\u001c4z\u00a6\u00d0r\u00ebt\u008f\u009d\u0001\u0083B\u00e3+\u00b2\u001d\u001c\u001f-\u00ac\u0089*\u00bd6\u00fd\u0099\u001c\u00982\u0086\u00f5\u00f0\u0005\u00b8Q-\u00d8\u00d4\u00aa\u0085Z\u0015\u0088\u00b5\u00cbB\u00f0L\u0096\u000bv\u00ff\u00e7N\u00d2w\u00f7\u00f4\t\u00c3E\u0015\u00c9\u0080\u0010\u00a2+\u0082$7M[\u00055\u00ad*\u0013\u00b5h\u0018\"\u000b\u00c3)-3\u0089\u00d9\u00bdH\u00fdV\u001ca2\u00b9\u00f1\u001d\u001b\u0000\u00cd\u00b2\u0090\u0080Sw\u00a3S\u00d84\u0016\nd\u00b1\u0086\u0098\u00ff\rx\u00b7\u0013z\u00cbN\u0094\u0007\u00b7\u00be\u00d0r\u00b2`\u0087\u0007{\u0015-k\u00ea\u00ac\u009a(6\u0089\u00a6\u00af\u00e8\u00ec\u00a1\u00e5\u00e7\u00c0g\u00bbx\u00dch\u00bb\u00a4h\u0013\u0098BJ\u00ee?\u00e1\u0005\u0087Waz\u00fd\u00f8kjt\u00f6(/?\u0017\u000f\u009cA\u00bd\u009fc\u0086uk\b\u009c;aS\u00d3\u0093\"k|A0\u00a4u\u00de\u00f1x\u0095\u00be'c\u00c2-5\u00e0=\u00bf3\\\u0001\u00e2\u00cdc\u00b3\u00ac$\u0017FJaH\u00c1\u000e\u00b1\u009f\u0018D\u00d7\u00fd\u00e3\u0004\u00daqa\u00dc\u0014n\u001b\u00cd\u00f2\u0090\u00ec=]+L\u0094\u00ff%\f\u00ccB\u00fe32WX\u00e2\u009b\u000fi\u00aaY2\u00be\n\u00d2\u0095\u00b7\u0007\u00cd\u00c4\u00e6U\u0086\u00be\u0018\u0010\u00d7+EK\u00d4\u00c4#w\u00db\u009b\u0017\u00a2r\u00cf\u0014c\u00b2\u00a5'\\\u00fc\u00ca\u0087)<\u0092\u00ab\u00ed\u00f9\u00ceu\u0086\r{\u0010\u00fa\u00b1|\u008cWA-\u00de\u00b6\u00a0\u00a1\u0094\u0085K|\u00f9\u00ef\u00caQ\u00e8\u0015\u0017b\u00b0\u00ce\u00d4q3/\u008b\t8\u00cb.\u00cb\u00ea\u00b9\u00dd\u009e\u00d2";
                var4_3 = "\u00abPL\u00d1\u00e8\u00c0X\u00e7\u0014%B\u00a5t+\u00fc\u008fz?\u008d\u0012\u00d3\u00db\u0098;\u00e2\u00a5v\u00c7\u001c\u0006\u0092Hk\u00d2f\u00e1\u0018\u0015b\u00c3@e\u00bfD\u00d2\u008e\u00e5+\u00ae\u009a\u00c8AjC\u000e5\u008epa\u00da\u00ef\t\u00b5\u00f2I\u00e3_T\u001b\u00e7Y\u0005Q\u00bf\u0013,s\bQ\u008a\u0013\u00fbQ\u00a3ii\u0014\u00de\u00e6\u00a2{\u00a6\u0015\u000b\u00d0\u00c1\u0005fv\u001f\u008f\u0018\u00ed\u00d3D\u00f0\u0018\u0005V\u00a7\u00f3/o\u001e_8\u00c7\u00b8td\u00c4\u00d3;\u00d1\u00d6\u00afi\u00c8\u009d\u000e9\u0013\u00a8\u00d9o\u00a45\u009a\u0004\u0094M\u00aa=\u00a0\u0010\u009e\u00e7\u001b\u0086\u00b8\u0091\u00ab\u0094\u00ab\u008bI\u0019\u009cK\u008c\u00e1\t\u00da\\r'k\u00eb\u00bb\u008f\u00a3\u00103-\u00ae\u00df\u000e\u00ba}\u00f1q'\u0012\u008c\u00f7\u00f9\u00e1\u00b7?\u0088\u00cd5\u0006'\u00ba+d\u00b7\u00f6\u0002\u00b0L\u00dd\u0004\u0095\u00cf\u0005\u000b\u00de\u0095\u0016\u0011\u00aa\u0090z\u00d2\u00c3\u00f9\u00db\u008f\u00d7\u001c\u00f7\u00a0D\u00ccT\u0010\u00e6\u00df\u001c\u00eb\u008c+H\u00e6\u008c\u0015\u00d0\u00af\u0003ePC1h\u00f4j\u0018\u008cy=\b\u008a\u00bdh\u001d>\u007f\u0084\u00f2\fh\u00cd$\b\u00aa\u00bf\u00f8\u00ed\u00e8\u00ecs\u00f1F\u0086\u00b4\u00f9'\u0011Z\u008fQ\u0006w\u00a4F\u000e\u000bSi\u00d9\u00fd\u00c9n\u00dfR[\u0010\u00ef\u0006\u00ceG\u00c5b2\u00dc\u0097 \u0013\u009f`b.\u00e4\u008bI\u00ea\u00dd\u00d5\u00e7m\u0004\u00839\u001b\u0094\u001c4z\u00a6\u00d0r\u00ebt\u008f\u009d\u0001\u0083B\u00e3+\u00b2\u001d\u001c\u001f-\u00ac\u0089*\u00bd6\u00fd\u0099\u001c\u00982\u0086\u00f5\u00f0\u0005\u00b8Q-\u00d8\u00d4\u00aa\u0085Z\u0015\u0088\u00b5\u00cbB\u00f0L\u0096\u000bv\u00ff\u00e7N\u00d2w\u00f7\u00f4\t\u00c3E\u0015\u00c9\u0080\u0010\u00a2+\u0082$7M[\u00055\u00ad*\u0013\u00b5h\u0018\"\u000b\u00c3)-3\u0089\u00d9\u00bdH\u00fdV\u001ca2\u00b9\u00f1\u001d\u001b\u0000\u00cd\u00b2\u0090\u0080Sw\u00a3S\u00d84\u0016\nd\u00b1\u0086\u0098\u00ff\rx\u00b7\u0013z\u00cbN\u0094\u0007\u00b7\u00be\u00d0r\u00b2`\u0087\u0007{\u0015-k\u00ea\u00ac\u009a(6\u0089\u00a6\u00af\u00e8\u00ec\u00a1\u00e5\u00e7\u00c0g\u00bbx\u00dch\u00bb\u00a4h\u0013\u0098BJ\u00ee?\u00e1\u0005\u0087Waz\u00fd\u00f8kjt\u00f6(/?\u0017\u000f\u009cA\u00bd\u009fc\u0086uk\b\u009c;aS\u00d3\u0093\"k|A0\u00a4u\u00de\u00f1x\u0095\u00be'c\u00c2-5\u00e0=\u00bf3\\\u0001\u00e2\u00cdc\u00b3\u00ac$\u0017FJaH\u00c1\u000e\u00b1\u009f\u0018D\u00d7\u00fd\u00e3\u0004\u00daqa\u00dc\u0014n\u001b\u00cd\u00f2\u0090\u00ec=]+L\u0094\u00ff%\f\u00ccB\u00fe32WX\u00e2\u009b\u000fi\u00aaY2\u00be\n\u00d2\u0095\u00b7\u0007\u00cd\u00c4\u00e6U\u0086\u00be\u0018\u0010\u00d7+EK\u00d4\u00c4#w\u00db\u009b\u0017\u00a2r\u00cf\u0014c\u00b2\u00a5'\\\u00fc\u00ca\u0087)<\u0092\u00ab\u00ed\u00f9\u00ceu\u0086\r{\u0010\u00fa\u00b1|\u008cWA-\u00de\u00b6\u00a0\u00a1\u0094\u0085K|\u00f9\u00ef\u00caQ\u00e8\u0015\u0017b\u00b0\u00ce\u00d4q3/\u008b\t8\u00cb.\u00cb\u00ea\u00b9\u00dd\u009e\u00d2".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 104;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u009d\r\u00fc}p\u00bf'\u00cb$\u00b1V\u00c0\u001aX\u009a\u00b0\u00e0\u00be\u00d9#vO\u00de\u00e5\u00ca\u000f;\u00a7a\u0014\u007f\u00d3\u008d%M\u00b5 0\u00a9\u00a7\u00a3\u00f5\u008e?\u00f2u\u00ff\u00e7\u00efM";
                    var4_3 = "\u009d\r\u00fc}p\u00bf'\u00cb$\u00b1V\u00c0\u001aX\u009a\u00b0\u00e0\u00be\u00d9#vO\u00de\u00e5\u00ca\u000f;\u00a7a\u0014\u007f\u00d3\u008d%M\u00b5 0\u00a9\u00a7\u00a3\u00f5\u008e?\u00f2u\u00ff\u00e7\u00efM".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 107;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 16;
                            break;
                        }
                        case 1: {
                            v15 = 110;
                            break;
                        }
                        case 2: {
                            v15 = 80;
                            break;
                        }
                        case 3: {
                            v15 = 82;
                            break;
                        }
                        case 4: {
                            v15 = 32;
                            break;
                        }
                        case 5: {
                            v15 = 125;
                            break;
                        }
                        default: {
                            v15 = 10;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x7B5C) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 7;
                case 1 -> 220;
                case 2 -> 219;
                case 3 -> 69;
                case 4 -> 10;
                case 5 -> 20;
                case 6 -> 163;
                case 7 -> 235;
                case 8 -> 197;
                case 9 -> 94;
                case 10 -> 226;
                case 11 -> 2;
                case 12 -> 171;
                case 13 -> 153;
                case 14 -> 154;
                case 15 -> 89;
                case 16 -> 137;
                case 17 -> 144;
                case 18 -> 202;
                case 19 -> 81;
                case 20 -> 223;
                case 21 -> 8;
                case 22 -> 59;
                case 23 -> 0;
                case 24 -> 136;
                case 25 -> 211;
                case 26 -> 56;
                case 27 -> 91;
                case 28 -> 105;
                case 29 -> 242;
                case 30 -> 82;
                case 31 -> 98;
                case 32 -> 30;
                case 33 -> 76;
                case 34 -> 169;
                case 35 -> 244;
                case 36 -> 66;
                case 37 -> 119;
                case 38 -> 80;
                case 39 -> 61;
                case 40 -> 205;
                case 41 -> 192;
                case 42 -> 135;
                case 43 -> 31;
                case 44 -> 4;
                case 45 -> 206;
                case 46 -> 100;
                case 47 -> 43;
                case 48 -> 110;
                case 49 -> 93;
                case 50 -> 174;
                case 51 -> 48;
                case 52 -> 190;
                case 53 -> 86;
                case 54 -> 228;
                case 55 -> 41;
                case 56 -> 157;
                case 57 -> 150;
                case 58 -> 39;
                case 59 -> 9;
                case 60 -> 127;
                case 61 -> 148;
                case 62 -> 245;
                case 63 -> 166;
                case 64 -> 191;
                case 65 -> 97;
                case 66 -> 149;
                case 67 -> 203;
                case 68 -> 212;
                case 69 -> 5;
                case 70 -> 64;
                case 71 -> 129;
                case 72 -> 250;
                case 73 -> 16;
                case 74 -> 6;
                case 75 -> 255;
                case 76 -> 176;
                case 77 -> 14;
                case 78 -> 12;
                case 79 -> 147;
                case 80 -> 11;
                case 81 -> 221;
                case 82 -> 254;
                case 83 -> 198;
                case 84 -> 58;
                case 85 -> 95;
                case 86 -> 40;
                case 87 -> 170;
                case 88 -> 194;
                case 89 -> 122;
                case 90 -> 199;
                case 91 -> 13;
                case 92 -> 180;
                case 93 -> 22;
                case 94 -> 111;
                case 95 -> 57;
                case 96 -> 251;
                case 97 -> 225;
                case 98 -> 224;
                case 99 -> 151;
                case 100 -> 42;
                case 101 -> 132;
                case 102 -> 188;
                case 103 -> 28;
                case 104 -> 36;
                case 105 -> 196;
                case 106 -> 37;
                case 107 -> 73;
                case 108 -> 229;
                case 109 -> 214;
                case 110 -> 87;
                case 111 -> 204;
                case 112 -> 38;
                case 113 -> 231;
                case 114 -> 227;
                case 115 -> 21;
                case 116 -> 107;
                case 117 -> 68;
                case 118 -> 29;
                case 119 -> 207;
                case 120 -> 160;
                case 121 -> 240;
                case 122 -> 99;
                case 123 -> 222;
                case 124 -> 177;
                case 125 -> 230;
                case 126 -> 72;
                case 127 -> 104;
                case 128 -> 134;
                case 129 -> 165;
                case 130 -> 34;
                case 131 -> 103;
                case 132 -> 155;
                case 133 -> 26;
                case 134 -> 237;
                case 135 -> 252;
                case 136 -> 189;
                case 137 -> 195;
                case 138 -> 239;
                case 139 -> 133;
                case 140 -> 145;
                case 141 -> 54;
                case 142 -> 184;
                case 143 -> 249;
                case 144 -> 77;
                case 145 -> 114;
                case 146 -> 182;
                case 147 -> 96;
                case 148 -> 253;
                case 149 -> 75;
                case 150 -> 24;
                case 151 -> 71;
                case 152 -> 123;
                case 153 -> 53;
                case 154 -> 116;
                case 155 -> 236;
                case 156 -> 113;
                case 157 -> 112;
                case 158 -> 32;
                case 159 -> 33;
                case 160 -> 23;
                case 161 -> 217;
                case 162 -> 124;
                case 163 -> 156;
                case 164 -> 218;
                case 165 -> 92;
                case 166 -> 167;
                case 167 -> 238;
                case 168 -> 130;
                case 169 -> 46;
                case 170 -> 193;
                case 171 -> 216;
                case 172 -> 18;
                case 173 -> 45;
                case 174 -> 158;
                case 175 -> 65;
                case 176 -> 141;
                case 177 -> 159;
                case 178 -> 179;
                case 179 -> 115;
                case 180 -> 248;
                case 181 -> 200;
                case 182 -> 63;
                case 183 -> 183;
                case 184 -> 25;
                case 185 -> 164;
                case 186 -> 209;
                case 187 -> 70;
                case 188 -> 84;
                case 189 -> 172;
                case 190 -> 120;
                case 191 -> 44;
                case 192 -> 51;
                case 193 -> 102;
                case 194 -> 118;
                case 195 -> 168;
                case 196 -> 117;
                case 197 -> 143;
                case 198 -> 79;
                case 199 -> 131;
                case 200 -> 162;
                case 201 -> 142;
                case 202 -> 108;
                case 203 -> 62;
                case 204 -> 201;
                case 205 -> 246;
                case 206 -> 125;
                case 207 -> 85;
                case 208 -> 78;
                case 209 -> 121;
                case 210 -> 232;
                case 211 -> 213;
                case 212 -> 19;
                case 213 -> 243;
                case 214 -> 1;
                case 215 -> 234;
                case 216 -> 55;
                case 217 -> 247;
                case 218 -> 241;
                case 219 -> 186;
                case 220 -> 146;
                case 221 -> 47;
                case 222 -> 215;
                case 223 -> 140;
                case 224 -> 74;
                case 225 -> 187;
                case 226 -> 90;
                case 227 -> 17;
                case 228 -> 101;
                case 229 -> 161;
                case 230 -> 27;
                case 231 -> 49;
                case 232 -> 3;
                case 233 -> 88;
                case 234 -> 152;
                case 235 -> 15;
                case 236 -> 109;
                case 237 -> 60;
                case 238 -> 67;
                case 239 -> 35;
                case 240 -> 181;
                case 241 -> 210;
                case 242 -> 208;
                case 243 -> 106;
                case 244 -> 138;
                case 245 -> 173;
                case 246 -> 50;
                case 247 -> 175;
                case 248 -> 52;
                case 249 -> 139;
                case 250 -> 178;
                case 251 -> 233;
                case 252 -> 128;
                case 253 -> 185;
                case 254 -> 126;
                default -> 83;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l = 105408369653859L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1282257810 - -833, 1282257810 + 12696, (int)l));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l = 100340791378091L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.p();
                            try {
                                hANDLE2 = hANDLE;
                                if (string == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1765381830 + -((char)-20012), 1765381830 + (char)-17278, (int)l));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1765381830 + -((char)-20011), -1765381830 + -((char)-28586), (int)l) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1765381830 + -((char)-20010), -1765381830 + -((char)-30077), (int)l));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0093\u00c7Y\u00beJ\u00b1\u0011\u00ef\u0010\u00faq\u0085\u00c9k\u00e4\u00cc\u001c\u00ee\u0088|y\u00a6Z\u00edj";
                    var4_3 = "\u0093\u00c7Y\u00beJ\u00b1\u0011\u00ef\u0010\u00faq\u0085\u00c9k\u00e4\u00cc\u001c\u00ee\u0088|y\u00a6Z\u00edj".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 55;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "#\u008a\u00ab\u00f3\u00805c\u0082\u00b4\u009e\u00b1\u00d3k\u00b5\u0089\u00e2\u00e6\u0010\u00e6y\u0004`'\u000be\u00f6\u00bdT\u00f5@\u0014l%\u00d2U\u0084=\u0002R\u0089\u0094\b\u00c2\u0001\u00ec\u00c3\u0088nTg\u007f\u00a7z\u009b\u00cb\u0006*\n\u00e9";
                        var4_3 = "#\u008a\u00ab\u00f3\u00805c\u0082\u00b4\u009e\u00b1\u00d3k\u00b5\u0089\u00e2\u00e6\u0010\u00e6y\u0004`'\u000be\u00f6\u00bdT\u00f5@\u0014l%\u00d2U\u0084=\u0002R\u0089\u0094\b\u00c2\u0001\u00ec\u00c3\u0088nTg\u007f\u00a7z\u009b\u00cb\u0006*\n\u00e9".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 122;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 15;
                                break;
                            }
                            case 1: {
                                v15 = 54;
                                break;
                            }
                            case 2: {
                                v15 = 21;
                                break;
                            }
                            case 3: {
                                v15 = 112;
                                break;
                            }
                            case 4: {
                                v15 = 60;
                                break;
                            }
                            case 5: {
                                v15 = 17;
                                break;
                            }
                            default: {
                                v15 = 32;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB7CC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 152;
                    case 1 -> 124;
                    case 2 -> 3;
                    case 3 -> 139;
                    case 4 -> 218;
                    case 5 -> 191;
                    case 6 -> 106;
                    case 7 -> 225;
                    case 8 -> 52;
                    case 9 -> 73;
                    case 10 -> 58;
                    case 11 -> 164;
                    case 12 -> 79;
                    case 13 -> 170;
                    case 14 -> 75;
                    case 15 -> 76;
                    case 16 -> 248;
                    case 17 -> 93;
                    case 18 -> 42;
                    case 19 -> 214;
                    case 20 -> 241;
                    case 21 -> 158;
                    case 22 -> 240;
                    case 23 -> 144;
                    case 24 -> 1;
                    case 25 -> 91;
                    case 26 -> 17;
                    case 27 -> 207;
                    case 28 -> 165;
                    case 29 -> 5;
                    case 30 -> 243;
                    case 31 -> 15;
                    case 32 -> 125;
                    case 33 -> 131;
                    case 34 -> 157;
                    case 35 -> 249;
                    case 36 -> 102;
                    case 37 -> 153;
                    case 38 -> 221;
                    case 39 -> 57;
                    case 40 -> 118;
                    case 41 -> 156;
                    case 42 -> 174;
                    case 43 -> 12;
                    case 44 -> 133;
                    case 45 -> 253;
                    case 46 -> 155;
                    case 47 -> 120;
                    case 48 -> 239;
                    case 49 -> 206;
                    case 50 -> 201;
                    case 51 -> 119;
                    case 52 -> 56;
                    case 53 -> 95;
                    case 54 -> 46;
                    case 55 -> 97;
                    case 56 -> 87;
                    case 57 -> 159;
                    case 58 -> 215;
                    case 59 -> 135;
                    case 60 -> 66;
                    case 61 -> 161;
                    case 62 -> 99;
                    case 63 -> 96;
                    case 64 -> 38;
                    case 65 -> 47;
                    case 66 -> 182;
                    case 67 -> 140;
                    case 68 -> 136;
                    case 69 -> 254;
                    case 70 -> 212;
                    case 71 -> 250;
                    case 72 -> 8;
                    case 73 -> 122;
                    case 74 -> 123;
                    case 75 -> 81;
                    case 76 -> 134;
                    case 77 -> 59;
                    case 78 -> 178;
                    case 79 -> 60;
                    case 80 -> 24;
                    case 81 -> 126;
                    case 82 -> 193;
                    case 83 -> 70;
                    case 84 -> 210;
                    case 85 -> 224;
                    case 86 -> 41;
                    case 87 -> 109;
                    case 88 -> 209;
                    case 89 -> 111;
                    case 90 -> 150;
                    case 91 -> 208;
                    case 92 -> 2;
                    case 93 -> 162;
                    case 94 -> 251;
                    case 95 -> 132;
                    case 96 -> 16;
                    case 97 -> 229;
                    case 98 -> 223;
                    case 99 -> 190;
                    case 100 -> 230;
                    case 101 -> 205;
                    case 102 -> 217;
                    case 103 -> 61;
                    case 104 -> 37;
                    case 105 -> 163;
                    case 106 -> 220;
                    case 107 -> 68;
                    case 108 -> 28;
                    case 109 -> 199;
                    case 110 -> 78;
                    case 111 -> 30;
                    case 112 -> 232;
                    case 113 -> 26;
                    case 114 -> 23;
                    case 115 -> 35;
                    case 116 -> 121;
                    case 117 -> 180;
                    case 118 -> 69;
                    case 119 -> 184;
                    case 120 -> 67;
                    case 121 -> 189;
                    case 122 -> 13;
                    case 123 -> 169;
                    case 124 -> 113;
                    case 125 -> 94;
                    case 126 -> 128;
                    case 127 -> 197;
                    case 128 -> 65;
                    case 129 -> 127;
                    case 130 -> 138;
                    case 131 -> 11;
                    case 132 -> 48;
                    case 133 -> 101;
                    case 134 -> 238;
                    case 135 -> 146;
                    case 136 -> 92;
                    case 137 -> 21;
                    case 138 -> 173;
                    case 139 -> 130;
                    case 140 -> 14;
                    case 141 -> 114;
                    case 142 -> 185;
                    case 143 -> 80;
                    case 144 -> 204;
                    case 145 -> 88;
                    case 146 -> 233;
                    case 147 -> 245;
                    case 148 -> 108;
                    case 149 -> 244;
                    case 150 -> 151;
                    case 151 -> 227;
                    case 152 -> 64;
                    case 153 -> 187;
                    case 154 -> 89;
                    case 155 -> 43;
                    case 156 -> 172;
                    case 157 -> 141;
                    case 158 -> 228;
                    case 159 -> 143;
                    case 160 -> 74;
                    case 161 -> 236;
                    case 162 -> 33;
                    case 163 -> 219;
                    case 164 -> 55;
                    case 165 -> 211;
                    case 166 -> 175;
                    case 167 -> 149;
                    case 168 -> 7;
                    case 169 -> 235;
                    case 170 -> 183;
                    case 171 -> 110;
                    case 172 -> 188;
                    case 173 -> 40;
                    case 174 -> 246;
                    case 175 -> 194;
                    case 176 -> 226;
                    case 177 -> 179;
                    case 178 -> 90;
                    case 179 -> 44;
                    case 180 -> 168;
                    case 181 -> 177;
                    case 182 -> 112;
                    case 183 -> 72;
                    case 184 -> 222;
                    case 185 -> 77;
                    case 186 -> 115;
                    case 187 -> 160;
                    case 188 -> 142;
                    case 189 -> 231;
                    case 190 -> 71;
                    case 191 -> 107;
                    case 192 -> 154;
                    case 193 -> 255;
                    case 194 -> 62;
                    case 195 -> 4;
                    case 196 -> 202;
                    case 197 -> 84;
                    case 198 -> 31;
                    case 199 -> 83;
                    case 200 -> 0;
                    case 201 -> 129;
                    case 202 -> 20;
                    case 203 -> 200;
                    case 204 -> 27;
                    case 205 -> 18;
                    case 206 -> 203;
                    case 207 -> 196;
                    case 208 -> 103;
                    case 209 -> 22;
                    case 210 -> 19;
                    case 211 -> 85;
                    case 212 -> 34;
                    case 213 -> 176;
                    case 214 -> 186;
                    case 215 -> 100;
                    case 216 -> 145;
                    case 217 -> 247;
                    case 218 -> 213;
                    case 219 -> 86;
                    case 220 -> 242;
                    case 221 -> 198;
                    case 222 -> 51;
                    case 223 -> 181;
                    case 224 -> 234;
                    case 225 -> 36;
                    case 226 -> 9;
                    case 227 -> 54;
                    case 228 -> 104;
                    case 229 -> 167;
                    case 230 -> 148;
                    case 231 -> 105;
                    case 232 -> 117;
                    case 233 -> 195;
                    case 234 -> 116;
                    case 235 -> 137;
                    case 236 -> 166;
                    case 237 -> 6;
                    case 238 -> 216;
                    case 239 -> 252;
                    case 240 -> 25;
                    case 241 -> 53;
                    case 242 -> 63;
                    case 243 -> 39;
                    case 244 -> 10;
                    case 245 -> 192;
                    case 246 -> 82;
                    case 247 -> 32;
                    case 248 -> 49;
                    case 249 -> 147;
                    case 250 -> 50;
                    case 251 -> 45;
                    case 252 -> 29;
                    case 253 -> 98;
                    case 254 -> 171;
                    default -> 237;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 24901966285151L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u001d8,\u0000aS(D\t\u001a2?\n,\u00115Xt";
                    var5_4 = "\u001d8,\u0000aS(D\t\u001a2?\n,\u00115Xt".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 106;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 28;
                                    break;
                                }
                                case 1: {
                                    v11 = 55;
                                    break;
                                }
                                case 2: {
                                    v11 = 52;
                                    break;
                                }
                                case 3: {
                                    v11 = 4;
                                    break;
                                }
                                case 4: {
                                    v11 = 110;
                                    break;
                                }
                                case 5: {
                                    v11 = 85;
                                    break;
                                }
                                default: {
                                    v11 = 113;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 122688760772012L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "c\t\u001d~\u0000\u0012Q\u0004e\u0017\u0011d\ni\b\u001ad\f\u0010IC\t\u0013\ti\b\u001ad\f\u0010IO\u0003\rn\u000e\u0007i\u0006\u001dSO\u0004\u0000c\u0007\u0014";
                    var5_4 = "c\t\u001d~\u0000\u0012Q\u0004e\u0017\u0011d\ni\b\u001ad\f\u0010IC\t\u0013\ti\b\u001ad\f\u0010IO\u0003\rn\u000e\u0007i\u0006\u001dSO\u0004\u0000c\u0007\u0014".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 44;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0003aq\u0013jw0\u0006\u0003aq\u0013f}";
                        var5_4 = "\u0003aq\u0013jw0\u0006\u0003aq\u0013f}".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 70;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 6;
                                break;
                            }
                            case 1: {
                                v15 = 75;
                                break;
                            }
                            case 2: {
                                v15 = 88;
                                break;
                            }
                            case 3: {
                                v15 = 38;
                                break;
                            }
                            case 4: {
                                v15 = 69;
                                break;
                            }
                            case 5: {
                                v15 = 95;
                                break;
                            }
                            default: {
                                v15 = 17;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 4425609570103L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1793168670 + (char)-3992, -1793299740 - -((char)-15526), (int)l));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 35723845410138L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "z \u00a9\u00f9=\u0003\u00bd_\u00e5\u0005\u00ee\u00db\u001dBH\r\u001c-u\u00d6\u00b0\u00002\u00d9\u009e_\u00ee4\u0080\u0010|v\u00beV\u00f6\u0085\u00d1T+j\u00bb\u00df\u00cc \u00c4C\u0005\u00e9\u00e9\u00fd\u0004T3\u00cbi\u00a8c\u00e1g\u0003\u001c\f\u009e\u00d4h\u00e7\u0087\u008d\u00a8)\u0092\u00cd\u00b3Ez\u000e\u0002;\u00a5_\u00f7$\u0016#\u0096N\u00cb\u00bd\u00ab\u009f8l\u00f0s\u0018\u00ba\u0019\u00dc\u0081~\u0003\u0088\u00a50";
                    var4_3 = "z \u00a9\u00f9=\u0003\u00bd_\u00e5\u0005\u00ee\u00db\u001dBH\r\u001c-u\u00d6\u00b0\u00002\u00d9\u009e_\u00ee4\u0080\u0010|v\u00beV\u00f6\u0085\u00d1T+j\u00bb\u00df\u00cc \u00c4C\u0005\u00e9\u00e9\u00fd\u0004T3\u00cbi\u00a8c\u00e1g\u0003\u001c\f\u009e\u00d4h\u00e7\u0087\u008d\u00a8)\u0092\u00cd\u00b3Ez\u000e\u0002;\u00a5_\u00f7$\u0016#\u0096N\u00cb\u00bd\u00ab\u009f8l\u00f0s\u0018\u00ba\u0019\u00dc\u0081~\u0003\u0088\u00a50".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 106;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ac\u0094^\u00f0\u0010\u00ab\u00f7k\u0015w\u0086\u0086\u0091\u00f1\u0095\u0083L\u00b3{J\u00c7\u00b8\u0085\u008c\u00c0\u00f3\u0091\u00f6\u00e3\u0091\u00d3\u0006\u00be\u00a7{\u0019\u0082M\u00c2\u00dfM\u00d8]\u00fc\u00d4P\u00c1\u00b8\u00f9\u00d72\u0005r@'W\u008f\u00d8\u00f0\u00fa\u0083;\u00f6\u00b3/9\u00ee\u0014v%'@d\u00b4\u00bf=PR\u00fc\u0007b\u00c2\u00dc\u00d94\u001e\u00d2\u00a1N\u00bcZw1";
                        var4_3 = "\u00ac\u0094^\u00f0\u0010\u00ab\u00f7k\u0015w\u0086\u0086\u0091\u00f1\u0095\u0083L\u00b3{J\u00c7\u00b8\u0085\u008c\u00c0\u00f3\u0091\u00f6\u00e3\u0091\u00d3\u0006\u00be\u00a7{\u0019\u0082M\u00c2\u00dfM\u00d8]\u00fc\u00d4P\u00c1\u00b8\u00f9\u00d72\u0005r@'W\u008f\u00d8\u00f0\u00fa\u0083;\u00f6\u00b3/9\u00ee\u0014v%'@d\u00b4\u00bf=PR\u00fc\u0007b\u00c2\u00dc\u00d94\u001e\u00d2\u00a1N\u00bcZw1".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 30;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 60;
                                break;
                            }
                            case 1: {
                                v15 = 32;
                                break;
                            }
                            case 2: {
                                v15 = 110;
                                break;
                            }
                            case 3: {
                                v15 = 59;
                                break;
                            }
                            case 4: {
                                v15 = 95;
                                break;
                            }
                            case 5: {
                                v15 = 28;
                                break;
                            }
                            default: {
                                v15 = 20;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x62B1) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 216;
                    case 1 -> 153;
                    case 2 -> 195;
                    case 3 -> 77;
                    case 4 -> 24;
                    case 5 -> 196;
                    case 6 -> 142;
                    case 7 -> 71;
                    case 8 -> 66;
                    case 9 -> 236;
                    case 10 -> 49;
                    case 11 -> 218;
                    case 12 -> 183;
                    case 13 -> 7;
                    case 14 -> 122;
                    case 15 -> 220;
                    case 16 -> 146;
                    case 17 -> 35;
                    case 18 -> 159;
                    case 19 -> 221;
                    case 20 -> 0;
                    case 21 -> 161;
                    case 22 -> 123;
                    case 23 -> 92;
                    case 24 -> 151;
                    case 25 -> 116;
                    case 26 -> 181;
                    case 27 -> 205;
                    case 28 -> 130;
                    case 29 -> 59;
                    case 30 -> 202;
                    case 31 -> 39;
                    case 32 -> 148;
                    case 33 -> 252;
                    case 34 -> 74;
                    case 35 -> 5;
                    case 36 -> 253;
                    case 37 -> 199;
                    case 38 -> 232;
                    case 39 -> 117;
                    case 40 -> 222;
                    case 41 -> 126;
                    case 42 -> 127;
                    case 43 -> 28;
                    case 44 -> 188;
                    case 45 -> 191;
                    case 46 -> 157;
                    case 47 -> 44;
                    case 48 -> 223;
                    case 49 -> 254;
                    case 50 -> 177;
                    case 51 -> 175;
                    case 52 -> 11;
                    case 53 -> 53;
                    case 54 -> 225;
                    case 55 -> 61;
                    case 56 -> 154;
                    case 57 -> 88;
                    case 58 -> 100;
                    case 59 -> 20;
                    case 60 -> 76;
                    case 61 -> 18;
                    case 62 -> 168;
                    case 63 -> 149;
                    case 64 -> 104;
                    case 65 -> 1;
                    case 66 -> 38;
                    case 67 -> 118;
                    case 68 -> 67;
                    case 69 -> 14;
                    case 70 -> 141;
                    case 71 -> 174;
                    case 72 -> 204;
                    case 73 -> 89;
                    case 74 -> 68;
                    case 75 -> 36;
                    case 76 -> 135;
                    case 77 -> 2;
                    case 78 -> 128;
                    case 79 -> 211;
                    case 80 -> 214;
                    case 81 -> 60;
                    case 82 -> 82;
                    case 83 -> 217;
                    case 84 -> 95;
                    case 85 -> 54;
                    case 86 -> 152;
                    case 87 -> 171;
                    case 88 -> 138;
                    case 89 -> 93;
                    case 90 -> 112;
                    case 91 -> 245;
                    case 92 -> 43;
                    case 93 -> 58;
                    case 94 -> 103;
                    case 95 -> 249;
                    case 96 -> 90;
                    case 97 -> 160;
                    case 98 -> 27;
                    case 99 -> 147;
                    case 100 -> 15;
                    case 101 -> 189;
                    case 102 -> 193;
                    case 103 -> 121;
                    case 104 -> 233;
                    case 105 -> 51;
                    case 106 -> 42;
                    case 107 -> 8;
                    case 108 -> 201;
                    case 109 -> 190;
                    case 110 -> 185;
                    case 111 -> 203;
                    case 112 -> 208;
                    case 113 -> 167;
                    case 114 -> 235;
                    case 115 -> 80;
                    case 116 -> 25;
                    case 117 -> 239;
                    case 118 -> 206;
                    case 119 -> 210;
                    case 120 -> 55;
                    case 121 -> 91;
                    case 122 -> 62;
                    case 123 -> 106;
                    case 124 -> 108;
                    case 125 -> 247;
                    case 126 -> 97;
                    case 127 -> 40;
                    case 128 -> 41;
                    case 129 -> 231;
                    case 130 -> 83;
                    case 131 -> 198;
                    case 132 -> 29;
                    case 133 -> 119;
                    case 134 -> 23;
                    case 135 -> 165;
                    case 136 -> 170;
                    case 137 -> 228;
                    case 138 -> 16;
                    case 139 -> 3;
                    case 140 -> 166;
                    case 141 -> 31;
                    case 142 -> 250;
                    case 143 -> 162;
                    case 144 -> 94;
                    case 145 -> 26;
                    case 146 -> 125;
                    case 147 -> 52;
                    case 148 -> 46;
                    case 149 -> 48;
                    case 150 -> 207;
                    case 151 -> 246;
                    case 152 -> 12;
                    case 153 -> 98;
                    case 154 -> 124;
                    case 155 -> 6;
                    case 156 -> 109;
                    case 157 -> 86;
                    case 158 -> 114;
                    case 159 -> 243;
                    case 160 -> 182;
                    case 161 -> 213;
                    case 162 -> 10;
                    case 163 -> 73;
                    case 164 -> 99;
                    case 165 -> 179;
                    case 166 -> 34;
                    case 167 -> 69;
                    case 168 -> 22;
                    case 169 -> 242;
                    case 170 -> 227;
                    case 171 -> 244;
                    case 172 -> 75;
                    case 173 -> 144;
                    case 174 -> 200;
                    case 175 -> 209;
                    case 176 -> 145;
                    case 177 -> 173;
                    case 178 -> 45;
                    case 179 -> 180;
                    case 180 -> 9;
                    case 181 -> 194;
                    case 182 -> 47;
                    case 183 -> 57;
                    case 184 -> 129;
                    case 185 -> 139;
                    case 186 -> 140;
                    case 187 -> 226;
                    case 188 -> 230;
                    case 189 -> 132;
                    case 190 -> 133;
                    case 191 -> 184;
                    case 192 -> 172;
                    case 193 -> 234;
                    case 194 -> 197;
                    case 195 -> 255;
                    case 196 -> 176;
                    case 197 -> 120;
                    case 198 -> 237;
                    case 199 -> 164;
                    case 200 -> 155;
                    case 201 -> 169;
                    case 202 -> 178;
                    case 203 -> 17;
                    case 204 -> 113;
                    case 205 -> 158;
                    case 206 -> 4;
                    case 207 -> 163;
                    case 208 -> 50;
                    case 209 -> 186;
                    case 210 -> 78;
                    case 211 -> 219;
                    case 212 -> 212;
                    case 213 -> 240;
                    case 214 -> 215;
                    case 215 -> 224;
                    case 216 -> 156;
                    case 217 -> 56;
                    case 218 -> 33;
                    case 219 -> 70;
                    case 220 -> 32;
                    case 221 -> 229;
                    case 222 -> 136;
                    case 223 -> 102;
                    case 224 -> 110;
                    case 225 -> 87;
                    case 226 -> 79;
                    case 227 -> 81;
                    case 228 -> 96;
                    case 229 -> 248;
                    case 230 -> 13;
                    case 231 -> 105;
                    case 232 -> 63;
                    case 233 -> 238;
                    case 234 -> 131;
                    case 235 -> 192;
                    case 236 -> 37;
                    case 237 -> 72;
                    case 238 -> 137;
                    case 239 -> 241;
                    case 240 -> 115;
                    case 241 -> 107;
                    case 242 -> 150;
                    case 243 -> 101;
                    case 244 -> 30;
                    case 245 -> 84;
                    case 246 -> 85;
                    case 247 -> 134;
                    case 248 -> 19;
                    case 249 -> 65;
                    case 250 -> 21;
                    case 251 -> 143;
                    case 252 -> 187;
                    case 253 -> 64;
                    case 254 -> 111;
                    default -> 251;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 18576097175073L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-363588180 + -19383, -363588180 + -6299, (int)l));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l = 104550021950065L;
                    String string = SshAgentIpcService.p();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1928039700 - -21176, 1928039700 - 25519, (int)l));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 20521444753272L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "n\u00ac\u00f7_\u00b3\u0003\u00d0\u00d1v";
                var4_3 = "n\u00ac\u00f7_\u00b3\u0003\u00d0\u00d1v".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 119;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 69;
                                break;
                            }
                            case 1: {
                                v11 = 20;
                                break;
                            }
                            case 2: {
                                v11 = 35;
                                break;
                            }
                            case 3: {
                                v11 = 52;
                                break;
                            }
                            case 4: {
                                v11 = 13;
                                break;
                            }
                            case 5: {
                                v11 = 73;
                                break;
                            }
                            default: {
                                v11 = 99;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFAFD4) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 236;
                    case 1 -> 95;
                    case 2 -> 228;
                    case 3 -> 144;
                    case 4 -> 39;
                    case 5 -> 122;
                    case 6 -> 200;
                    case 7 -> 91;
                    case 8 -> 195;
                    case 9 -> 212;
                    case 10 -> 238;
                    case 11 -> 98;
                    case 12 -> 196;
                    case 13 -> 117;
                    case 14 -> 207;
                    case 15 -> 104;
                    case 16 -> 6;
                    case 17 -> 85;
                    case 18 -> 134;
                    case 19 -> 70;
                    case 20 -> 150;
                    case 21 -> 1;
                    case 22 -> 76;
                    case 23 -> 241;
                    case 24 -> 176;
                    case 25 -> 231;
                    case 26 -> 129;
                    case 27 -> 214;
                    case 28 -> 115;
                    case 29 -> 148;
                    case 30 -> 173;
                    case 31 -> 78;
                    case 32 -> 188;
                    case 33 -> 28;
                    case 34 -> 164;
                    case 35 -> 16;
                    case 36 -> 49;
                    case 37 -> 197;
                    case 38 -> 147;
                    case 39 -> 216;
                    case 40 -> 224;
                    case 41 -> 22;
                    case 42 -> 163;
                    case 43 -> 145;
                    case 44 -> 59;
                    case 45 -> 201;
                    case 46 -> 80;
                    case 47 -> 17;
                    case 48 -> 211;
                    case 49 -> 167;
                    case 50 -> 184;
                    case 51 -> 81;
                    case 52 -> 149;
                    case 53 -> 227;
                    case 54 -> 171;
                    case 55 -> 65;
                    case 56 -> 226;
                    case 57 -> 44;
                    case 58 -> 154;
                    case 59 -> 52;
                    case 60 -> 156;
                    case 61 -> 246;
                    case 62 -> 193;
                    case 63 -> 132;
                    case 64 -> 83;
                    case 65 -> 27;
                    case 66 -> 18;
                    case 67 -> 30;
                    case 68 -> 121;
                    case 69 -> 179;
                    case 70 -> 24;
                    case 71 -> 219;
                    case 72 -> 35;
                    case 73 -> 166;
                    case 74 -> 68;
                    case 75 -> 254;
                    case 76 -> 235;
                    case 77 -> 181;
                    case 78 -> 93;
                    case 79 -> 31;
                    case 80 -> 60;
                    case 81 -> 213;
                    case 82 -> 64;
                    case 83 -> 86;
                    case 84 -> 36;
                    case 85 -> 178;
                    case 86 -> 128;
                    case 87 -> 72;
                    case 88 -> 230;
                    case 89 -> 198;
                    case 90 -> 105;
                    case 91 -> 120;
                    case 92 -> 243;
                    case 93 -> 106;
                    case 94 -> 210;
                    case 95 -> 136;
                    case 96 -> 51;
                    case 97 -> 110;
                    case 98 -> 141;
                    case 99 -> 19;
                    case 100 -> 255;
                    case 101 -> 32;
                    case 102 -> 99;
                    case 103 -> 174;
                    case 104 -> 111;
                    case 105 -> 157;
                    case 106 -> 191;
                    case 107 -> 186;
                    case 108 -> 75;
                    case 109 -> 143;
                    case 110 -> 125;
                    case 111 -> 116;
                    case 112 -> 0;
                    case 113 -> 142;
                    case 114 -> 146;
                    case 115 -> 74;
                    case 116 -> 47;
                    case 117 -> 161;
                    case 118 -> 172;
                    case 119 -> 247;
                    case 120 -> 192;
                    case 121 -> 217;
                    case 122 -> 222;
                    case 123 -> 118;
                    case 124 -> 229;
                    case 125 -> 21;
                    case 126 -> 133;
                    case 127 -> 223;
                    case 128 -> 56;
                    case 129 -> 252;
                    case 130 -> 53;
                    case 131 -> 242;
                    case 132 -> 96;
                    case 133 -> 50;
                    case 134 -> 253;
                    case 135 -> 29;
                    case 136 -> 54;
                    case 137 -> 234;
                    case 138 -> 13;
                    case 139 -> 94;
                    case 140 -> 240;
                    case 141 -> 250;
                    case 142 -> 119;
                    case 143 -> 187;
                    case 144 -> 102;
                    case 145 -> 127;
                    case 146 -> 177;
                    case 147 -> 215;
                    case 148 -> 130;
                    case 149 -> 140;
                    case 150 -> 153;
                    case 151 -> 8;
                    case 152 -> 87;
                    case 153 -> 159;
                    case 154 -> 218;
                    case 155 -> 5;
                    case 156 -> 20;
                    case 157 -> 109;
                    case 158 -> 155;
                    case 159 -> 152;
                    case 160 -> 180;
                    case 161 -> 190;
                    case 162 -> 138;
                    case 163 -> 55;
                    case 164 -> 233;
                    case 165 -> 182;
                    case 166 -> 206;
                    case 167 -> 7;
                    case 168 -> 107;
                    case 169 -> 40;
                    case 170 -> 38;
                    case 171 -> 45;
                    case 172 -> 100;
                    case 173 -> 151;
                    case 174 -> 2;
                    case 175 -> 41;
                    case 176 -> 4;
                    case 177 -> 9;
                    case 178 -> 225;
                    case 179 -> 139;
                    case 180 -> 34;
                    case 181 -> 114;
                    case 182 -> 245;
                    case 183 -> 58;
                    case 184 -> 25;
                    case 185 -> 113;
                    case 186 -> 203;
                    case 187 -> 79;
                    case 188 -> 48;
                    case 189 -> 135;
                    case 190 -> 244;
                    case 191 -> 67;
                    case 192 -> 77;
                    case 193 -> 165;
                    case 194 -> 169;
                    case 195 -> 251;
                    case 196 -> 183;
                    case 197 -> 97;
                    case 198 -> 33;
                    case 199 -> 239;
                    case 200 -> 112;
                    case 201 -> 249;
                    case 202 -> 103;
                    case 203 -> 202;
                    case 204 -> 37;
                    case 205 -> 123;
                    case 206 -> 221;
                    case 207 -> 137;
                    case 208 -> 232;
                    case 209 -> 90;
                    case 210 -> 73;
                    case 211 -> 66;
                    case 212 -> 69;
                    case 213 -> 160;
                    case 214 -> 101;
                    case 215 -> 175;
                    case 216 -> 46;
                    case 217 -> 84;
                    case 218 -> 15;
                    case 219 -> 205;
                    case 220 -> 63;
                    case 221 -> 185;
                    case 222 -> 162;
                    case 223 -> 124;
                    case 224 -> 11;
                    case 225 -> 248;
                    case 226 -> 131;
                    case 227 -> 108;
                    case 228 -> 42;
                    case 229 -> 26;
                    case 230 -> 71;
                    case 231 -> 237;
                    case 232 -> 10;
                    case 233 -> 199;
                    case 234 -> 14;
                    case 235 -> 43;
                    case 236 -> 82;
                    case 237 -> 194;
                    case 238 -> 209;
                    case 239 -> 204;
                    case 240 -> 61;
                    case 241 -> 89;
                    case 242 -> 208;
                    case 243 -> 189;
                    case 244 -> 88;
                    case 245 -> 220;
                    case 246 -> 92;
                    case 247 -> 168;
                    case 248 -> 12;
                    case 249 -> 158;
                    case 250 -> 57;
                    case 251 -> 170;
                    case 252 -> 23;
                    case 253 -> 62;
                    case 254 -> 126;
                    default -> 3;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

