/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RegExpRedundantEscapeInspection
extends LocalInspectionTool {
    public boolean ignoreEscapedMetaCharacters = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreEscapedMetaCharacters", (String)RegExpBundle.message("inspection.option.ignore.escaped.closing.brackets", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RegExpRedundantEscapeInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public RegExpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RegExpRedundantEscapeInspection.$$$reportNull$$$0(1);
        }
        return new RedundantEscapeVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/RegExpRedundantEscapeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/RegExpRedundantEscapeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class RedundantEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RedundantEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            String text = ch.getUnescapedText();
            if (!text.startsWith("\\") || !RegExpLanguageHosts.getInstance().isRedundantEscape(ch, text)) {
                return;
            }
            if (text.equals("\\{") && !(ch.getParent() instanceof RegExpClass)) {
                return;
            }
            if (RegExpRedundantEscapeInspection.this.ignoreEscapedMetaCharacters && (text.equals("\\}") || text.equals("\\]")) && !(ch.getParent() instanceof RegExpClass)) {
                return;
            }
            ASTNode astNode = ch.getNode().getFirstChildNode();
            if (astNode == null || astNode.getElementType() != RegExpTT.REDUNDANT_ESCAPE) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, RegExpBundle.message("inspection.warning.redundant.character.escape.0.in.regexp", ch.getText()), new LocalQuickFix[]{new RemoveRedundantEscapeFix()});
        }
    }

    private static class RemoveRedundantEscapeFix
    extends PsiUpdateModCommandQuickFix {
        private RemoveRedundantEscapeFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("inspection.quick.fix.remove.redundant.escape", new Object[0]);
            if (string == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof RegExpChar)) {
                return;
            }
            RegExpChar regExpChar = (RegExpChar)element;
            RegExpReplacementUtil.replaceInContext(element, RemoveRedundantEscapeFix.replacement(regExpChar));
        }

        @NotNull
        private static String replacement(RegExpChar aChar) {
            int codePoint = aChar.getValue();
            Object object = Character.isSupplementaryCodePoint(codePoint) ? Character.toString(Character.highSurrogate(codePoint)) + Character.lowSurrogate(codePoint) : Character.toString((char)codePoint);
            if (object == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/RegExpRedundantEscapeInspection$RemoveRedundantEscapeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/RegExpRedundantEscapeInspection$RemoveRedundantEscapeFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

