/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.debug;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerActionListener;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.profiler.PerformanceHintsManager;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcess;
import com.intellij.profiler.ultimate.debug.ProfileOnRunToCursorStateObserver;
import com.intellij.profiler.ultimate.jfr.JFRFileParser;
import com.sun.jdi.Field;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u00012\u00020\u0002:\u000201B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\b*\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0016\u0010&\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\"H\u0016J\u0006\u0010)\u001a\u00020\u0012J\u0006\u0010*\u001a\u00020\u0012J\u0018\u0010+\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030,H\u0002R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u00a8\u00062"}, d2={"Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener;", "Lcom/intellij/debugger/engine/DebugProcessListener;", "Lcom/intellij/debugger/engine/DebuggerActionListener;", "profilerProcess", "Lcom/intellij/profiler/ultimate/async/AsyncProfilerProcess;", "<init>", "(Lcom/intellij/profiler/ultimate/async/AsyncProfilerProcess;)V", "lastRunToCursorStartMs", "", "lock", "", "isR2CActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "getCs$annotations", "()V", "processAttached", "", "process", "Lcom/intellij/debugger/engine/DebugProcess;", "onRunToCursor", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "doResume", "tid", "threadId", "(Lcom/intellij/debugger/engine/SuspendContextImpl;)Ljava/lang/Long;", "paused", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContext;", "resumeProfilerThreads", "Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Either;", "allThreadsResumed", "", "threadNames", "", "", "winAsyncThreadsResumed", "processDetached", "closedByUser", "recordingEnabled", "recordingDisabled", "showPerformanceHints", "Lcom/intellij/profiler/api/ProfilerProcess;", "profilerData", "Lcom/intellij/profiler/api/ProfilerData;", "dismissPerformanceHints", "Either", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nProfileOnRunToCursorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileOnRunToCursorListener.kt\ncom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n24#2:220\n24#2:221\n24#2:222\n24#2:223\n24#2:231\n774#3:224\n865#3,2:225\n1563#3:227\n1634#3,3:228\n*S KotlinDebug\n*F\n+ 1 ProfileOnRunToCursorListener.kt\ncom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener\n*L\n65#1:220\n89#1:221\n92#1:222\n95#1:223\n113#1:231\n124#1:224\n124#1:225,2\n132#1:227\n132#1:228,3\n*E\n"})
public final class ProfileOnRunToCursorListener
implements DebugProcessListener,
DebuggerActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AsyncProfilerProcess<?> profilerProcess;
    private long lastRunToCursorStartMs;
    @NotNull
    private final Object lock;
    @NotNull
    private final AtomicBoolean isR2CActive;
    @NotNull
    private final CoroutineScope cs;
    private static final long NOT_MUCH_TIME_PASSED_THRESHOLD_MS = 200L;
    @NotNull
    private static final String ATTACH_LISTENER = "Attach Listener";
    @NotNull
    private static final String ASYNC_PROFILER_TIMER = "Async-profiler Timer";
    @NotNull
    private static final String ASYNC_PROFILER_SAMPLER = "Async-profiler Sampler";
    @NotNull
    private static final String WALL_CLOCK_SAMPLER = "Wall clock sampler";
    @NotNull
    private static final String JAVA_THREADS_SAMPLER = "Java threads sampler";
    @NotNull
    private static final String CPU_THREADS_SAMPLER = "Native threads sampler";
    @NotNull
    private static final List<String> allProfilerThreads;

    public ProfileOnRunToCursorListener(@NotNull AsyncProfilerProcess<?> profilerProcess) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        this.profilerProcess = profilerProcess;
        this.lastRunToCursorStartMs = -1L;
        this.lock = new Object();
        this.isR2CActive = new AtomicBoolean(false);
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (String)("Profiler on R2C listener for " + this.profilerProcess.getAgentConfiguration$intellij_profiler_ultimate()), null, (boolean)false, (int)6, null);
        Disposer.register((Disposable)((Disposable)this.profilerProcess), () -> ProfileOnRunToCursorListener._init_$lambda$0(this));
    }

    private static /* synthetic */ void getCs$annotations() {
    }

    public void processAttached(@NotNull DebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        ProfileOnRunToCursorStateObserver.Companion.getInstance().addListener(process, this);
        this.profilerProcess.startNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRunToCursor(@Nullable SuspendContextImpl context2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!ProfileOnRunToCursorStateObserver.Companion.getInstance().getEnabled()) {
                return;
            }
            this.isR2CActive.set(true);
            Object object2 = context2;
            if (object2 == null || (object2 = this.threadId((SuspendContextImpl)object2)) == null) {
                return;
            }
            long tid = (Long)object2;
            if (this.lastRunToCursorStartMs >= 0L && Intrinsics.areEqual((Object)this.profilerProcess.getState(), (Object)Attached.INSTANCE)) {
                this.profilerProcess.suspend((Function1<ProgressIndicator, Unit>)((Function1)arg_0 -> ProfileOnRunToCursorListener.onRunToCursor$lambda$3$lambda$2(this, tid, arg_0)));
                return;
            }
            this.doResume(tid);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void doResume(long tid) {
        AsyncProfilerProcess<?> asyncProfilerProcess;
        ProfileOnRunToCursorListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ProfileOnRunToCursorListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Run to Cursor launched, starting profiling");
        AsyncProfilerProcess<?> $this$doResume_u24lambda_u244 = asyncProfilerProcess = this.profilerProcess;
        boolean bl = false;
        $this$doResume_u24lambda_u244.getAgentConfiguration$intellij_profiler_ultimate().replaceSnapshot(true);
        this.lastRunToCursorStartMs = System.currentTimeMillis();
        $this$doResume_u24lambda_u244.resume(tid);
    }

    private final Long threadId(SuspendContextImpl $this$threadId) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = $this$threadId.getThread();
        if (threadReferenceProxyImpl == null) {
            return null;
        }
        ThreadReferenceProxyImpl thread = threadReferenceProxyImpl;
        Comparable<ReferenceType> comparable = thread.referenceType();
        if (comparable == null || (comparable = comparable.fieldByName("tid")) == null) {
            return null;
        }
        Comparable<ReferenceType> nativeIdField = comparable;
        ObjectReference objectReference = thread.getObjectReference();
        Value value = objectReference != null ? objectReference.getValue((Field)nativeIdField) : null;
        LongValue longValue = value instanceof LongValue ? (LongValue)value : null;
        return longValue != null ? Long.valueOf(longValue.value()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paused(@NotNull SuspendContext suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Object object = this.lock;
        synchronized (object) {
            long pauseStartMs;
            block9: {
                block8: {
                    boolean bl = false;
                    pauseStartMs = System.currentTimeMillis();
                    if (this.lastRunToCursorStartMs < 0L) break block8;
                    if (this.isR2CActive.compareAndSet(true, false)) break block9;
                }
                return;
            }
            ProfilerUsageTriggerCollector.INSTANCE.logProfilingDuringRunToCursorPaused(this.profilerProcess.getProject());
            Either result = this.resumeProfilerThreads(suspendContext);
            if (result instanceof Either.Failure) {
                ProfileOnRunToCursorListener $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ProfileOnRunToCursorListener.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(((Either.Failure)result).getValue());
                return;
            }
            ProfileOnRunToCursorListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ProfileOnRunToCursorListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.debug.ProfileOnRunToCursorListener.Either.Success");
            logger.info(((Either.Success)result).getValue());
            if (pauseStartMs - this.lastRunToCursorStartMs < 200L) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(ProfileOnRunToCursorListener.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.info("Skip suspend -- too short time since last run to cursor: " + (pauseStartMs - this.lastRunToCursorStartMs) + "ms");
                return;
            }
            this.lastRunToCursorStartMs = -1L;
            AsyncProfilerProcess<?> $this$paused_u24lambda_u248_u24lambda_u247 = this.profilerProcess;
            boolean bl = false;
            boolean bl2 = $this$paused_u24lambda_u248_u24lambda_u247.suspend((Function1<ProgressIndicator, Unit>)((Function1)arg_0 -> ProfileOnRunToCursorListener.paused$lambda$8$lambda$7$lambda$6(this, $this$paused_u24lambda_u248_u24lambda_u247, pauseStartMs, arg_0)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Either resumeProfilerThreads(SuspendContext suspendContext) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv2;
        SuspendContextImpl suspendContextImpl = suspendContext instanceof SuspendContextImpl ? (SuspendContextImpl)suspendContext : null;
        VirtualMachineProxyImpl virtualMachineProxyImpl = suspendContextImpl != null ? suspendContextImpl.getVirtualMachineProxy() : null;
        Object object = virtualMachineProxyImpl instanceof VirtualMachineProxyImpl ? virtualMachineProxyImpl : null;
        if (object == null) {
            return new Either.Failure("Couldn't find VM proxy");
        }
        VirtualMachineProxyImpl vm = object;
        Collection collection = vm.allThreads();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"allThreads(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ThreadReferenceProxyImpl it = (ThreadReferenceProxyImpl)element$iv$iv;
            boolean bl = false;
            if (!allProfilerThreads.contains(it.name())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List threadsToResume = (List)destination$iv$iv2;
        for (ThreadReferenceProxyImpl thread : threadsToResume) {
            thread.setIgnoreModelSuspendCount(true);
            int $this$filterTo$iv$iv2 = thread.getSuspendCount();
            int destination$iv$iv2 = 0;
            while (destination$iv$iv2 < $this$filterTo$iv$iv2) {
                int it = destination$iv$iv2++;
                boolean bl = false;
                thread.resume();
            }
        }
        Iterable $this$map$iv = threadsToResume;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThreadReferenceProxyImpl bl = (ThreadReferenceProxyImpl)item$iv$iv;
            Collection collection2 = destination$iv$iv3;
            boolean bl2 = false;
            collection2.add(it.name());
        }
        List threadNames = (List)destination$iv$iv3;
        if (this.allThreadsResumed(threadNames)) {
            return new Either.Success("Resumed " + threadNames.size() + " threads: " + CollectionsKt.joinToString$default((Iterable)threadNames, null, null, null, (int)0, null, null, (int)63, null));
        }
        return new Either.Failure("Couldn't find all required threads. Found only " + threadNames.size() + ": " + CollectionsKt.joinToString$default((Iterable)threadNames, null, null, null, (int)0, null, null, (int)63, null));
    }

    private final boolean allThreadsResumed(List<String> threadNames) {
        Object[] objectArray = new String[]{ATTACH_LISTENER, ASYNC_PROFILER_TIMER};
        if (!threadNames.containsAll(CollectionsKt.listOf((Object[])objectArray))) {
            return false;
        }
        if (SystemInfo.isWindows && !this.winAsyncThreadsResumed(threadNames)) {
            return false;
        }
        return !SystemInfo.isIbmJvm || threadNames.contains(ASYNC_PROFILER_SAMPLER);
    }

    private final boolean winAsyncThreadsResumed(List<String> threadNames) {
        return threadNames.contains(WALL_CLOCK_SAMPLER) || threadNames.contains(CPU_THREADS_SAMPLER) && threadNames.contains(JAVA_THREADS_SAMPLER);
    }

    public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        AsyncProfilerProcess<?> $this$processDetached_u24lambda_u2412 = this.profilerProcess;
        boolean bl = false;
        this.dismissPerformanceHints((ProfilerProcess)$this$processDetached_u24lambda_u2412);
        Disposer.dispose((Disposable)((Disposable)$this$processDetached_u24lambda_u2412));
        $this$processDetached_u24lambda_u2412.getAgentConfiguration$intellij_profiler_ultimate().replaceSnapshot(false);
        ProfileOnRunToCursorStateObserver.Companion.getInstance().removeListener(process);
    }

    public final void recordingEnabled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordingDisabled() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.lastRunToCursorStartMs = -1L;
            this.profilerProcess.getAgentConfiguration$intellij_profiler_ultimate().replaceSnapshot(false);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void showPerformanceHints(ProfilerProcess<?> $this$showPerformanceHints, ProfilerData profilerData) {
        ApplicationManager.getApplication().invokeLater(() -> ProfileOnRunToCursorListener.showPerformanceHints$lambda$14($this$showPerformanceHints, profilerData));
    }

    private final void dismissPerformanceHints(ProfilerProcess<?> $this$dismissPerformanceHints) {
        ApplicationManager.getApplication().invokeLater(() -> ProfileOnRunToCursorListener.dismissPerformanceHints$lambda$15($this$dismissPerformanceHints));
    }

    private static final void _init_$lambda$0(ProfileOnRunToCursorListener this$0) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.cs, null, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit onRunToCursor$lambda$3$lambda$2(ProfileOnRunToCursorListener this$0, long $tid, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.doResume($tid);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit paused$lambda$8$lambda$7$lambda$6(ProfileOnRunToCursorListener this$0, AsyncProfilerProcess $this_with, long $pauseStartMs, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object object = this$0.lock;
        synchronized (object) {
            ProfilerDumpFileParsingResult result;
            File dumpFile;
            block4: {
                boolean bl = false;
                dumpFile = $this_with.getAgentConfiguration$intellij_profiler_ultimate().getResultSnapshot().getDumpFile();
                result = new JFRFileParser($this_with.getProject()).parse(dumpFile, indicator);
                if (result instanceof Success) break block4;
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            ProfilerUsageTriggerCollector.INSTANCE.logProfileDuringRunToCursorSnapshotGenerated($this_with.getProject(), dumpFile.length(), System.currentTimeMillis() - $pauseStartMs);
            AsyncProfilerProcess $this$thisLogger$iv = $this_with;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AsyncProfilerProcess.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Data is ready, showing performance hints");
            this$0.showPerformanceHints((ProfilerProcess)$this_with, ((Success)result).getData());
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final void showPerformanceHints$lambda$14(ProfilerProcess $this_showPerformanceHints, ProfilerData $profilerData) {
        PerformanceHintsManager.Companion.getInstance($this_showPerformanceHints.getProject()).onProfilerDumpOpen($profilerData, (Object)$this_showPerformanceHints);
    }

    private static final void dismissPerformanceHints$lambda$15(ProfilerProcess $this_dismissPerformanceHints) {
        PerformanceHintsManager.Companion.getInstance($this_dismissPerformanceHints.getProject()).onProfilerDumpClosed((Object)$this_dismissPerformanceHints);
    }

    static {
        Object[] objectArray = new String[]{ATTACH_LISTENER, ASYNC_PROFILER_TIMER, ASYNC_PROFILER_SAMPLER, WALL_CLOCK_SAMPLER, JAVA_THREADS_SAMPLER, CPU_THREADS_SAMPLER};
        allProfilerThreads = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Companion;", "", "<init>", "()V", "NOT_MUCH_TIME_PASSED_THRESHOLD_MS", "", "ATTACH_LISTENER", "", "ASYNC_PROFILER_TIMER", "ASYNC_PROFILER_SAMPLER", "WALL_CLOCK_SAMPLER", "JAVA_THREADS_SAMPLER", "CPU_THREADS_SAMPLER", "allProfilerThreads", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Either;", "", "<init>", "()V", "Success", "Failure", "Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Either$Failure;", "Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Either$Success;", "intellij.profiler.ultimate"})
    private static abstract class Either {
        private Either() {
        }

        public /* synthetic */ Either(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Either$Failure;", "Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Either;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "intellij.profiler.ultimate"})
        public static final class Failure
        extends Either {
            @NotNull
            private final String value;

            public Failure(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Either$Success;", "Lcom/intellij/profiler/ultimate/debug/ProfileOnRunToCursorListener$Either;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "intellij.profiler.ultimate"})
        public static final class Success
        extends Either {
            @NotNull
            private final String value;

            public Success(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }
        }
    }
}

