/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiThread;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewComponentTab;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.util.Arrays;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u00052\u00020\u0006B+\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/SummarySnapshotPanel;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewComponentTab;", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getSnapshot", "()Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getTabName", "", "createRightComponent", "Ljavax/swing/JComponent;", "createCenterComponent", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nSummarySnapshotPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummarySnapshotPanel.kt\ncom/intellij/profiler/ultimate/hprof/ui/SummarySnapshotPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1869#2:67\n1869#2,2:68\n1870#2:70\n*S KotlinDebug\n*F\n+ 1 SummarySnapshotPanel.kt\ncom/intellij/profiler/ultimate/hprof/ui/SummarySnapshotPanel\n*L\n39#1:67\n46#1:68,2\n39#1:70\n*E\n"})
public final class SummarySnapshotPanel<T extends MuiType, I extends MuiInstance>
extends BorderLayoutPanel
implements MemoryViewComponentTab {
    @NotNull
    private final MuiSnapshot<T, I> snapshot;
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;

    public SummarySnapshotPanel(@NotNull MuiSnapshot<T, I> snapshot, @NotNull Project project, @NotNull Disposable disposable) {
        StringBuilder text;
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.snapshot = snapshot;
        this.project = project;
        this.disposable = disposable;
        ConsoleViewImpl panel2 = new ConsoleViewImpl(this.project, true);
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)panel2));
        this.add(panel2.getComponent());
        StringBuilder stringBuilder = text = new StringBuilder();
        Object object = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.bytes", new Object[0]) + ": %,d";
        Object[] objectArray = new Object[]{this.snapshot.getTotalBytes()};
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        object = string;
        stringBuilder.append((String)object).append('\n');
        stringBuilder = text;
        object = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.classes", new Object[0]) + ": %,d";
        objectArray = new Object[]{this.snapshot.getTypeCount()};
        String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        object = string2;
        stringBuilder.append((String)object).append('\n');
        stringBuilder = text;
        object = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.instances", new Object[0]) + ": %,d";
        objectArray = new Object[]{this.snapshot.getTotalInstances() - this.snapshot.getTypeCount()};
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        object = string3;
        stringBuilder.append((String)object).append('\n');
        stringBuilder = text;
        object = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.classloaders", new Object[0]) + ": %,d";
        objectArray = new Object[]{this.snapshot.getClassLoaderCount()};
        String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        object = string4;
        stringBuilder.append((String)object).append('\n');
        stringBuilder = text;
        object = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.roots", new Object[0]) + ": %,d";
        objectArray = new Object[]{this.snapshot.getRootCount()};
        String string5 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        object = string5;
        stringBuilder.append((String)object).append('\n');
        text.append('\n');
        String string6 = text.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        panel2.print(string6, consoleViewContentType);
        String string7 = UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.thread.loading", new Object[0]);
        ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"NORMAL_OUTPUT");
        panel2.print(string7, consoleViewContentType2);
        panel2.scrollTo(0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> SummarySnapshotPanel._init_$lambda$3(this, text, panel2));
    }

    @NotNull
    public final MuiSnapshot<T, I> getSnapshot() {
        return this.snapshot;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @Override
    @NotNull
    public String getTabName() {
        return UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary", new Object[0]);
    }

    @Override
    @Nullable
    public JComponent createRightComponent() {
        return null;
    }

    @NotNull
    public SummarySnapshotPanel<T, I> createCenterComponent() {
        return this;
    }

    private static final void lambda$3$lambda$2$lambda$1(ConsoleViewImpl $panel, StringBuilder $text) {
        $panel.clear();
        String string = $text.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        $panel.print(string, consoleViewContentType);
        $panel.scrollTo(0);
    }

    private static final void _init_$lambda$3(SummarySnapshotPanel this$0, StringBuilder $text, ConsoleViewImpl $panel) {
        Iterable $this$forEach$iv = this$0.snapshot.getThreads();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MuiThread it = (MuiThread)element$iv;
            boolean bl = false;
            if (((CharSequence)it.getName()).length() == 0) {
                var9_9 = $text;
                var10_11 = new Object[]{it.getTid()};
                v0 = var9_9.append(UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.thread", var10_11)).append('\n');
            } else {
                var9_9 = $text;
                var10_11 = new Object[]{it.getName(), it.getTid()};
                v0 = var9_9.append(UltimateProfilerBundleKt.profilerMessage("hprof.tab.summary.threadWithName", var10_11)).append('\n');
            }
            Iterable $this$forEach$iv2 = it.getFrames();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String frame = (String)element$iv2;
                boolean bl2 = false;
                StringBuilder stringBuilder = $text.append("\t");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                stringBuilder.append(frame).append('\n');
            }
            $text.append('\n');
            ApplicationManager.getApplication().invokeLater(() -> SummarySnapshotPanel.lambda$3$lambda$2$lambda$1($panel, $text));
        }
    }
}

