/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntFloatAssociativeContainer;
import com.carrotsearch.hppc.IntFloatHashMap;
import com.carrotsearch.hppc.IntFloatMap;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.comparators.IntComparator;
import com.carrotsearch.hppc.comparators.IntFloatComparator;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.IntFloatPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.IntFloatProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationIntFloatHashMap
implements IntFloatMap {
    public final IntFloatHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationIntFloatHashMap(IntFloatHashMap delegate, IntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationIntFloatHashMap(IntFloatHashMap delegate, IntFloatComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        int[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, IntComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            int[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final IntFloatComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final int[] keys;
            final float[] values;
            {
                this.keys = SortedIterationIntFloatHashMap.this.delegate.keys;
                this.values = SortedIterationIntFloatHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<IntFloatCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(IntContainer container) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntFloatPredicate predicate) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public <T extends IntFloatProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntFloatPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public IntCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public FloatContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public float get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public float getOrDefault(int key, float defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public float put(int key, float value) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(IntFloatAssociativeContainer container) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends IntFloatCursor> iterable) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public float putOrAdd(int key, float putValue, float incrementValue) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public float addTo(int key, float additionValue) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public float remove(int key) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public int indexOf(int key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public float indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public float indexReplace(int index, float newValue) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, int key, float value) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public float indexRemove(int index) {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationIntFloatHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<IntFloatCursor> {
        private final IntFloatCursor cursor = new IntFloatCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected IntFloatCursor fetch() {
            if (this.index < SortedIterationIntFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationIntFloatHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationIntFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntFloatCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final SortedIterationIntFloatHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationIntFloatHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationIntFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final SortedIterationIntFloatHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationIntFloatHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            for (IntFloatCursor c : this.owner) {
                if (Float.floatToIntBits(value) != Float.floatToIntBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(float e) {
            throw SortedIterationIntFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            throw SortedIterationIntFloatHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationIntFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected FloatCursor fetch() {
            if (this.index < SortedIterationIntFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntFloatHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

