/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ByteContentRetriever {
    private final LocalHistoryFacade myVcs;
    private final FileRevisionTimestampComparator myComparator;
    @NotNull
    private final String myPath;
    private long myCurrentFileTimestamp;
    private Content myCurrentFileContent;

    public ByteContentRetriever(IdeaGateway gateway, LocalHistoryFacade vcs, VirtualFile file, FileRevisionTimestampComparator c) {
        this.myPath = file.getPath();
        this.myVcs = vcs;
        this.myComparator = c;
        Entry e = gateway.createTransientEntry(file);
        this.myCurrentFileContent = e.getContent();
        this.myCurrentFileTimestamp = e.getTimestamp();
    }

    public byte[] getResult() {
        if (this.myComparator.isSuitable(this.myCurrentFileTimestamp)) {
            return this.myCurrentFileContent.getBytesIfAvailable();
        }
        List<ChangeSet> changes = this.collectChanges();
        if (changes.isEmpty() && this.myComparator.isSuitable(this.myCurrentFileTimestamp)) {
            return this.myCurrentFileContent.getBytesIfAvailable();
        }
        for (ChangeSet c : changes) {
            if (this.myComparator.isSuitable(this.myCurrentFileTimestamp)) {
                return this.myCurrentFileContent.getBytesIfAvailable();
            }
            this.recordContentAndTimestamp(c);
        }
        return null;
    }

    @NotNull
    private List<ChangeSet> collectChanges() {
        final ArrayList<ChangeSet> changes = new ArrayList<ChangeSet>();
        this.myVcs.accept(new ChangeVisitor(){

            @Override
            public void begin(ChangeSet c) {
                if (c.anyChangeMatches(change -> change.affectsPath(ByteContentRetriever.this.myPath))) {
                    changes.add(c);
                }
            }
        });
        ArrayList<ChangeSet> arrayList = changes;
        if (arrayList == null) {
            ByteContentRetriever.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private void recordContentAndTimestamp(ChangeSet c) {
        for (Change each : c.getChanges()) {
            ContentChange cc;
            if (!(each instanceof ContentChange) || !(cc = (ContentChange)each).affectsPath(this.myPath)) continue;
            this.myCurrentFileTimestamp = cc.getOldTimestamp();
            this.myCurrentFileContent = cc.getOldContent();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/ByteContentRetriever", "collectChanges"));
    }
}

