/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.front.tiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.core.commons.data.DataType;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.FormatterUtil;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.Stat;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;
import org.jetbrains.letsPlot.core.plot.base.theme.ExponentFormat;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.ContextualMappingProvider;
import org.jetbrains.letsPlot.core.plot.builder.MarginalLayerUtil;
import org.jetbrains.letsPlot.core.plot.builder.VarBinding;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GeomLayerBuilder;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssembler;
import org.jetbrains.letsPlot.core.plot.builder.assemble.geom.GeomProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.conf.GeomInteraction;
import org.jetbrains.letsPlot.core.spec.config.LayerConfig;
import org.jetbrains.letsPlot.core.spec.front.GeomInteractionUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004J0\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b0\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016JF\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002JR\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u001c\u0010 \u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001c\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/spec/front/tiles/PlotGeomTilesUtil;", "", "()V", "buildLayerScaleMap", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "layerConfig", "Lorg/jetbrains/letsPlot/core/spec/config/LayerConfig;", "commonScales", "createDefaultFormatters", "Lkotlin/Function1;", "", "exponentFormat", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ExponentFormat;", "createLayerBuilder", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/GeomLayerBuilder;", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "geomInteraction", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/conf/GeomInteraction;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "createScalesForPositionalStatVariables", "layerVarBindings", "", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "isYOrientation", "", "commonScaleMap", "geomInteractionByLayer", "layerConfigs", "scaleMapByLayer", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "isLiveMap", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nPlotGeomTilesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotGeomTilesUtil.kt\norg/jetbrains/letsPlot/core/spec/front/tiles/PlotGeomTilesUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,211:1\n766#2:212\n857#2,2:213\n819#2:215\n847#2,2:216\n766#2:218\n857#2,2:219\n1179#2,2:221\n1253#2,4:223\n1559#2:227\n1590#2,3:228\n777#2:231\n788#2:232\n1864#2,2:233\n789#2,2:235\n1866#2:237\n791#2:238\n1747#2,3:239\n1593#2:242\n1238#2,4:245\n1238#2,4:251\n1179#2,2:255\n1253#2,4:257\n453#3:243\n403#3:244\n453#3:249\n403#3:250\n*S KotlinDebug\n*F\n+ 1 PlotGeomTilesUtil.kt\norg/jetbrains/letsPlot/core/spec/front/tiles/PlotGeomTilesUtil\n*L\n70#1:212\n70#1:213,2\n71#1:215\n71#1:216,2\n72#1:218\n72#1:219,2\n74#1:221,2\n74#1:223,4\n92#1:227\n92#1:228,3\n98#1:231\n98#1:232\n98#1:233,2\n98#1:235,2\n98#1:237\n98#1:238\n99#1:239,3\n92#1:242\n121#1:245,4\n122#1:251,4\n126#1:255,2\n126#1:257,4\n121#1:243\n121#1:244\n122#1:249\n122#1:250\n*E\n"})
public final class PlotGeomTilesUtil {
    @NotNull
    public static final PlotGeomTilesUtil INSTANCE = new PlotGeomTilesUtil();

    private PlotGeomTilesUtil() {
    }

    @NotNull
    public final Map<Aes<?>, Scale> buildLayerScaleMap(@NotNull LayerConfig layerConfig, @NotNull Map<Aes<?>, ? extends Scale> commonScales) {
        Map<Aes<?>, Scale> map2;
        Map<Aes<?>, ? extends Scale> map3;
        Intrinsics.checkNotNullParameter((Object)layerConfig, (String)"layerConfig");
        Intrinsics.checkNotNullParameter(commonScales, (String)"commonScales");
        boolean bl = layerConfig.isMarginal();
        if (bl) {
            map3 = MarginalLayerUtil.INSTANCE.toMarginalScaleMap(commonScales, layerConfig.getMarginalSide(), false);
        } else if (!bl) {
            map3 = commonScales;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Map<Aes<?>, ? extends Scale> layerCommonScales = map3;
        Map<Aes<?>, Scale> scaleByAes = this.createScalesForPositionalStatVariables(layerConfig.getVarBindings(), layerConfig.isYOrientation(), commonScales);
        boolean bl2 = false;
        boolean bl3 = layerConfig.isMarginal();
        if (bl3) {
            map2 = MarginalLayerUtil.INSTANCE.toMarginalScaleMap(scaleByAes, layerConfig.getMarginalSide(), layerConfig.isYOrientation());
        } else if (!bl3) {
            map2 = scaleByAes;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Map<Aes<?>, Scale> layerAddedScales = map2;
        return MapsKt.plus(layerCommonScales, layerAddedScales);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Aes<?>, Scale> createScalesForPositionalStatVariables(List<VarBinding> layerVarBindings, boolean isYOrientation, Map<Aes<?>, ? extends Scale> commonScaleMap) {
        void $this$associateTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        VarBinding it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = layerVarBindings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VarBinding)element$iv$iv;
            boolean bl = false;
            if (!it.getVariable().isStat()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (VarBinding)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getAes(), Aes.Companion.getX()) || Intrinsics.areEqual(it.getAes(), Aes.Companion.getY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VarBinding)element$iv$iv;
            boolean bl = false;
            if (!Aes.Companion.isPositionalXY(it.getAes())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List statPositionalBindings = (List)destination$iv$iv;
        Iterable $this$associate$iv = statPositionalBindings;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Aes<Double> aes2;
            Map map2 = destination$iv$iv2;
            VarBinding binding = (VarBinding)element$iv$iv;
            boolean bl = false;
            boolean bl2 = isYOrientation;
            if (bl2) {
                aes2 = Aes.Companion.isPositionalX(binding.getAes()) ? Aes.Companion.getY() : Aes.Companion.getX();
            } else if (!bl2) {
                aes2 = Aes.Companion.isPositionalX(binding.getAes()) ? Aes.Companion.getX() : Aes.Companion.getY();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Aes<Double> positionalAes = aes2;
            Scale scaleProto = (Scale)MapsKt.getValue(commonScaleMap, positionalAes);
            Scale aesScale = scaleProto.with().name(binding.getVariable().getLabel()).build();
            Pair pair2 = TuplesKt.to(binding.getAes(), (Object)aesScale);
            map2.put(pair2.getFirst(), pair2.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GeomInteraction> geomInteractionByLayer(@NotNull List<LayerConfig> layerConfigs, @NotNull List<? extends Map<Aes<?>, ? extends Scale>> scaleMapByLayer, @NotNull CoordProvider coordProvider, @NotNull Theme theme, boolean isLiveMap) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(layerConfigs, (String)"layerConfigs");
        Intrinsics.checkNotNullParameter(scaleMapByLayer, (String)"scaleMapByLayer");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Iterable $this$mapIndexed$iv = layerConfigs;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            GeomInteraction geomInteraction;
            void layerConfig;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LayerConfig layerConfig2 = (LayerConfig)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (layerConfig.isMarginal()) {
                geomInteraction = null;
            } else {
                boolean bl2;
                void layerIndex;
                block9: {
                    void $this$any$iv;
                    void $this$filterIndexedTo$iv$iv;
                    Iterable $this$filterIndexed$iv;
                    Iterable iterable2 = layerConfigs;
                    boolean $i$f$filterIndexed = false;
                    Iterator iterator2 = $this$filterIndexed$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIndexedTo = false;
                    void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv$iv$iv = 0;
                    for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                        void element$iv$iv;
                        int n3;
                        if ((n3 = index$iv$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Object t = item$iv$iv$iv;
                        int index$iv$iv2 = n3;
                        boolean bl3 = false;
                        LayerConfig cfr_ignored_0 = (LayerConfig)element$iv$iv;
                        int index = index$iv$iv2;
                        boolean bl4 = false;
                        if (!(index != layerIndex)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filterIndexed$iv = (List)destination$iv$iv2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Collection collection2;
                            LayerConfig layer = (LayerConfig)element$iv;
                            boolean bl5 = false;
                            boolean bl6 = !((Collection)layer.getVarBindings()).isEmpty() && !layer.getTooltips().hideTooltips() || !((collection2 = (Collection)layer.getTooltips().getTooltipLinePatterns()) == null || collection2.isEmpty());
                            if (!bl6) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                boolean otherLayerWithTooltips = bl2;
                geomInteraction = GeomInteractionUtil.INSTANCE.configGeomTargets$plot_stem((LayerConfig)layerConfig, scaleMapByLayer.get((int)layerIndex), otherLayerWithTooltips, isLiveMap, coordProvider.isPolar(), theme);
            }
            collection.add(geomInteraction);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Object, Function1<Object, String>> createDefaultFormatters(LayerConfig layerConfig, ExponentFormat exponentFormat) {
        Map map2;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable $this$mapValuesTo$iv$iv;
        Function1<Object, String> function1;
        Map map3;
        Object k;
        Object object;
        void $this$mapValuesTo$iv$iv2;
        StringFormat.ExponentFormat expFormat = PlotAssembler.Companion.extractExponentFormat(exponentFormat);
        Map<String, DataType> $this$mapValues$iv = layerConfig.getDtypes();
        boolean $i$f$mapValues = false;
        Map<String, DataType> map4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map3 = object;
            boolean bl2 = false;
            DataType dtype = (DataType)((Object)entry2.getValue());
            function1 = FormatterUtil.INSTANCE.byDataType(dtype, expFormat);
            map3.put(k, function1);
        }
        Map dataFormatters = destination$iv$iv;
        Map $this$mapValues$iv2 = Stats.INSTANCE.getVARS();
        boolean $i$f$mapValues2 = false;
        destination$iv$iv = $this$mapValues$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map3 = map5;
            boolean bl3 = false;
            function1 = FormatterUtil.INSTANCE.byDataType(DataType.FLOATING, expFormat);
            map3.put(k, function1);
        }
        Map statFormatters = destination$iv$iv2;
        Map varFormatters = MapsKt.plus(dataFormatters, (Map)statFormatters);
        $this$mapValuesTo$iv$iv = layerConfig.getVarBindings();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map6 = destination$iv$iv3;
            VarBinding it = (VarBinding)element$iv$iv;
            boolean bl = false;
            Aes<?> aes2 = it.getAes();
            Function1<Object, String> function12 = (Function1<Object, String>)varFormatters.get(it.getVariable().getName());
            if (function12 == null) {
                function12 = FormatterUtil.INSTANCE.byDataType(DataType.UNKNOWN, expFormat);
            }
            Pair pair2 = TuplesKt.to(aes2, (Object)function12);
            map6.put(pair2.getFirst(), pair2.getSecond());
        }
        Map aesFormatters = destination$iv$iv3;
        String string = layerConfig.getLabelFormat();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Function1 fmt2 = (Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default(StringFormat.Companion, it, null, null, null, 14, null)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((StringFormat)this.receiver).format(p0);
                }
            };
            map2 = MapsKt.mapOf((Pair)TuplesKt.to(Aes.Companion.getLABEL(), (Object)fmt2));
        } else {
            map2 = null;
        }
        Map labelFormat2 = map2;
        Map map7 = MapsKt.plus((Map)varFormatters, (Map)aesFormatters);
        Map map8 = labelFormat2;
        if (map8 == null) {
            map8 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map7, map8);
    }

    @NotNull
    public final GeomLayerBuilder createLayerBuilder(@NotNull LayerConfig layerConfig, @NotNull FontFamilyRegistry fontFamilyRegistry, @Nullable GeomInteraction geomInteraction, @NotNull Theme theme) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)layerConfig, (String)"layerConfig");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        GeomProvider geomProvider = layerConfig.getGeomProto().geomProvider(layerConfig, layerConfig.getAopConversion(), theme.getExponentFormat());
        Stat stat2 = layerConfig.getStat();
        GeomLayerBuilder layerBuilder = new GeomLayerBuilder(geomProvider, stat2, layerConfig.getPosProvider(), fontFamilyRegistry).yOrientation(layerConfig.isYOrientation()).marginal(layerConfig.isMarginal(), layerConfig.getMarginalSide(), layerConfig.getMarginalSize());
        layerBuilder.colorByAes(layerConfig.getColorByAes()).fillByAes(layerConfig.getFillByAes());
        layerBuilder.geomTheme(theme.geometries(layerConfig.getGeomProto().getGeomKind()));
        Map<Aes<?>, Object> constantAesMap = layerConfig.getConstantsMap();
        for (Aes<?> aes2 : constantAesMap.keySet()) {
            Intrinsics.checkNotNull(aes2, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.Aes<kotlin.Any>");
            Object object = constantAesMap.get(aes2);
            Intrinsics.checkNotNull((Object)object);
            layerBuilder.addConstantAes(aes2, object);
        }
        if (layerConfig.hasExplicitGrouping()) {
            String string = layerConfig.getExplicitGroupingVarName();
            Intrinsics.checkNotNull((Object)string);
            layerBuilder.groupingVarName(string);
        }
        DataFrame.Variable variable = DataFrameUtil.INSTANCE.variables(layerConfig.getCombinedData()).get("__geo_id__");
        if (variable != null) {
            it = variable;
            boolean bl = false;
            layerBuilder.pathIdVarName("__geo_id__");
        }
        List<VarBinding> bindings = layerConfig.getVarBindings();
        for (VarBinding binding : bindings) {
            layerBuilder.addBinding(binding);
        }
        layerBuilder.disableLegend(layerConfig.isLegendDisabled()).customLegendOptions(layerConfig.getCustomLegendOptions());
        GeomInteraction geomInteraction2 = geomInteraction;
        if (geomInteraction2 != null) {
            it = geomInteraction2;
            boolean bl = false;
            layerBuilder.locatorLookupSpec(((GeomInteraction)it).createLookupSpec()).contextualMappingProvider((ContextualMappingProvider)it);
        }
        layerBuilder.annotationSpecification(layerConfig.getAnnotations(), theme.annotations().textStyle(), theme.annotations().useCustomColor());
        layerBuilder.defaultFormatters(this.createDefaultFormatters(layerConfig, theme.getExponentFormat()));
        return layerBuilder;
    }
}

