/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.util.ArrayList;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;
import org.jetbrains.kotlinx.jupyter.api.ResultsKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.ExecutionHost;
import org.jetbrains.kotlinx.jupyter.api.outputs.DisplayHandler;
import org.jetbrains.kotlinx.jupyter.messaging.DisplayDataMessage;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactory;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketBase;
import org.jetbrains.kotlinx.jupyter.repl.ResultsRenderingKt;
import org.jetbrains.kotlinx.jupyter.repl.notebook.MutableCodeCell;
import org.jetbrains.kotlinx.jupyter.repl.notebook.MutableDisplayContainer;
import org.jetbrains.kotlinx.jupyter.repl.notebook.MutableDisplayResultWithCell;
import org.jetbrains.kotlinx.jupyter.repl.notebook.MutableNotebook;
import org.jetbrains.kotlinx.jupyter.util.SerializersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\"\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/messaging/SocketDisplayHandler;", "Lorg/jetbrains/kotlinx/jupyter/api/outputs/DisplayHandler;", "communicationFacility", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/repl/notebook/MutableNotebook;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;Lorg/jetbrains/kotlinx/jupyter/repl/notebook/MutableNotebook;)V", "socket", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocketBase;", "sendMessage", "", "type", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageType;", "content", "Lorg/jetbrains/kotlinx/jupyter/messaging/DisplayDataMessage;", "handleDisplay", "value", "", "host", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ExecutionHost;", "id", "", "handleUpdate", "createResponse", "json", "Lkotlinx/serialization/json/JsonObject;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nSocketDisplayHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketDisplayHandler.kt\norg/jetbrains/kotlinx/jupyter/messaging/SocketDisplayHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1#2:74\n1669#3,8:75\n1869#3,2:83\n*S KotlinDebug\n*F\n+ 1 SocketDisplayHandler.kt\norg/jetbrains/kotlinx/jupyter/messaging/SocketDisplayHandler\n*L\n55#1:75,8\n55#1:83,2\n*E\n"})
public final class SocketDisplayHandler
implements DisplayHandler {
    @NotNull
    private final JupyterCommunicationFacility communicationFacility;
    @NotNull
    private final MutableNotebook notebook;
    @NotNull
    private final JupyterSocketBase socket;

    public SocketDisplayHandler(@NotNull JupyterCommunicationFacility communicationFacility, @NotNull MutableNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)communicationFacility, (String)"communicationFacility");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.communicationFacility = communicationFacility;
        this.notebook = notebook;
        this.socket = this.communicationFacility.getSocketManager().getIopub();
    }

    private final void sendMessage(MessageType type2, DisplayDataMessage content) {
        MessageFactory messageFactory = this.communicationFacility.getMessageFactory();
        Message message = MessageFactoryKt.makeReplyMessage$default(messageFactory, type2, null, null, null, null, content, 30, null);
        JupyterConnectionInternalKt.sendMessage(this.socket, message);
    }

    @Override
    public void handleDisplay(@NotNull Object value, @NotNull ExecutionHost host, @Nullable String id) {
        DisplayResult displayResult;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                displayResult = ResultsRenderingKt.renderValue(this.notebook, host, value, id);
                if (displayResult == null) break block4;
                DisplayResult it = displayResult;
                boolean bl = false;
                String string = id;
                DisplayResult displayResult2 = string != null ? ResultsKt.withId(it, string) : it;
                displayResult = displayResult2;
                if (displayResult2 != null) break block5;
            }
            return;
        }
        DisplayResult display = displayResult;
        JsonObject json = display.toJson(SerializersKt.getEMPTY((Json)Json.Default), null);
        MutableCodeCell mutableCodeCell = this.notebook.getCurrentCell();
        if (mutableCodeCell != null) {
            mutableCodeCell.addDisplay(display);
        }
        DisplayDataMessage response = this.createResponse(json);
        this.sendMessage(MessageType.DISPLAY_DATA, response);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleUpdate(@NotNull Object value, @NotNull ExecutionHost host, @Nullable String id) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        DisplayResult displayResult = ResultsRenderingKt.renderValue(this.notebook, host, value, id);
        if (displayResult == null) {
            return;
        }
        DisplayResult display = displayResult;
        JsonObject json = display.toJson(SerializersKt.getEMPTY((Json)Json.Default), id);
        if (id == null || !ResultsKt.containsDisplayId(json, id)) {
            throw new RuntimeException("`update_display_data` response should provide an id of data being updated");
        }
        MutableDisplayContainer container = this.notebook.getDisplays();
        container.update(id, display);
        Iterable $this$distinctBy$iv = container.getById(id);
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            MutableDisplayResultWithCell it = (MutableDisplayResultWithCell)e$iv;
            boolean bl = false;
            Integer key$iv = it.getCell().getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableDisplayResultWithCell it = (MutableDisplayResultWithCell)element$iv;
            boolean bl = false;
            it.getCell().getDisplays().update(id, display);
        }
        DisplayDataMessage response = this.createResponse(json);
        this.sendMessage(MessageType.UPDATE_DISPLAY_DATA, response);
    }

    private final DisplayDataMessage createResponse(JsonObject json) {
        DisplayDataMessage content = new DisplayDataMessage((JsonElement)json.get((Object)"data"), (JsonElement)json.get((Object)"metadata"), (JsonElement)json.get((Object)"transient"));
        return content;
    }
}

