/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.keybinding.ProofValidator;
import org.keycloak.protocol.oid4vc.model.KeyAttestationsRequired;
import org.keycloak.protocol.oid4vc.model.SupportedProofTypeData;
import org.keycloak.util.JsonSerialization;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProofTypesSupported {
    protected Map<String, SupportedProofTypeData> supportedProofTypes = new HashMap<String, SupportedProofTypeData>();

    public static ProofTypesSupported parse(KeycloakSession keycloakSession, List<String> globalSupportedSigningAlgorithms) {
        ProofTypesSupported proofTypesSupported = new ProofTypesSupported();
        keycloakSession.getAllProviders(ProofValidator.class).forEach(proofValidator -> {
            String type = proofValidator.getProofType();
            KeyAttestationsRequired keyAttestationsRequired = new KeyAttestationsRequired();
            SupportedProofTypeData supportedProofTypeData = new SupportedProofTypeData(globalSupportedSigningAlgorithms, keyAttestationsRequired);
            proofTypesSupported.getSupportedProofTypes().put(type, supportedProofTypeData);
        });
        return proofTypesSupported;
    }

    public static ProofTypesSupported fromJsonString(String jsonString) {
        try {
            return (ProofTypesSupported)JsonSerialization.readValue((String)jsonString, ProofTypesSupported.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonAnyGetter
    public Map<String, SupportedProofTypeData> getSupportedProofTypes() {
        return this.supportedProofTypes;
    }

    @JsonAnySetter
    public ProofTypesSupported setSupportedProofTypes(String name, SupportedProofTypeData value) {
        this.supportedProofTypes.put(name, value);
        return this;
    }

    public String toJsonString() {
        try {
            return JsonSerialization.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ProofTypesSupported)) {
            return false;
        }
        ProofTypesSupported that = (ProofTypesSupported)o;
        return Objects.equals(this.supportedProofTypes, that.supportedProofTypes);
    }

    public int hashCode() {
        return Objects.hashCode(this.supportedProofTypes);
    }
}

