/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.type.BindableType;

public class ValueBindJpaCriteriaParameter<T>
extends JpaCriteriaParameter<T> {
    private final T value;

    public ValueBindJpaCriteriaParameter(BindableType<? super T> type, T value, NodeBuilder nodeBuilder) {
        super(null, type, false, nodeBuilder);
        SqmBindableType bindable;
        assert (value == null || type == null || (type instanceof SqmBindableType ? (bindable = (SqmBindableType)type).getExpressibleJavaType().isInstance(value) : type.getJavaType().isInstance(value)));
        this.value = value;
    }

    private ValueBindJpaCriteriaParameter(ValueBindJpaCriteriaParameter<T> original) {
        super(original);
        this.value = original.value;
    }

    @Override
    public ValueBindJpaCriteriaParameter<T> copy(SqmCopyContext context) {
        ValueBindJpaCriteriaParameter<T> existing = context.getCopy(this);
        return existing != null ? existing : context.registerCopy(this, new ValueBindJpaCriteriaParameter<T>(this));
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        SqmLiteral.appendHqlString(hql, this.getJavaTypeDescriptor(), this.value);
    }

    @Override
    public int compareTo(SqmParameter<T> parameter) {
        return this == parameter ? 0 : 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueBindJpaCriteriaParameter)) return false;
        ValueBindJpaCriteriaParameter that = (ValueBindJpaCriteriaParameter)object;
        if (!Objects.equals(this.value, that.value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }
}

