/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.metric;

import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.metric.MetricScorer;
import java.util.Arrays;

public class PrecisionScorer
extends MetricScorer {
    public PrecisionScorer() {
        this.k = 10;
    }

    public PrecisionScorer(int k) {
        this.k = k;
    }

    @Override
    public double score(RankList rl) {
        int count = 0;
        int size = this.k;
        if (this.k > rl.size() || this.k <= 0) {
            size = rl.size();
        }
        for (int i = 0; i < size; ++i) {
            if (!((double)rl.get(i).getLabel() > 0.0)) continue;
            ++count;
        }
        return (double)count / (double)size;
    }

    @Override
    public MetricScorer copy() {
        return new PrecisionScorer();
    }

    @Override
    public String name() {
        return "P@" + this.k;
    }

    @Override
    public double[][] swapChange(RankList rl) {
        int i;
        int size = rl.size() > this.k ? this.k : rl.size();
        double[][] changes = new double[rl.size()][];
        for (i = 0; i < rl.size(); ++i) {
            changes[i] = new double[rl.size()];
            Arrays.fill(changes[i], 0.0);
        }
        for (i = 0; i < size; ++i) {
            for (int j = size; j < rl.size(); ++j) {
                int c = this.getBinaryRelevance(rl.get(j).getLabel()) - this.getBinaryRelevance(rl.get(i).getLabel());
                double d = (float)c / (float)size;
                changes[j][i] = d;
                changes[i][j] = d;
            }
        }
        return changes;
    }

    private int getBinaryRelevance(float label) {
        if ((double)label > 0.0) {
            return 1;
        }
        return 0;
    }
}

