/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.threshold;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import java.util.List;
import lombok.Generated;

public class BasicThresholder {
    public static double DEFAULT_ELASTICITY = 0.01;
    public static double DEFAULT_HORIZON = 0.5;
    public static double DEFAULT_HORIZON_ONED = 0.75;
    public static int DEFAULT_MINIMUM_SCORES = 10;
    public static double DEFAULT_ABSOLUTE_SCORE_FRACTION = 0.5;
    public static double DEFAULT_UPPER_THRESHOLD = 2.0;
    public static double DEFAULT_LOWER_THRESHOLD = 1.0;
    public static double DEFAULT_LOWER_THRESHOLD_ONED = 1.1;
    public static double DEFAULT_LOWER_THRESHOLD_NORMALIZED = 0.9;
    public static double DEFAULT_INITIAL_THRESHOLD = 1.5;
    public static double DEFAULT_Z_FACTOR = 2.5;
    public static double DEFAULT_UPPER_FACTOR = 5.0;
    public static boolean DEFAULT_AUTO_ADJUST_LOWER_THRESHOLD = false;
    public static double DEFAULT_THRESHOLD_STEP = 0.1;
    protected double elasticity = DEFAULT_ELASTICITY;
    protected int count = 0;
    protected double horizon = DEFAULT_HORIZON;
    protected int minimumScores = DEFAULT_MINIMUM_SCORES;
    protected Deviation primaryDeviation;
    protected Deviation secondaryDeviation;
    protected Deviation thresholdDeviation;
    protected boolean autoThreshold = DEFAULT_AUTO_ADJUST_LOWER_THRESHOLD;
    protected double absoluteThreshold;
    protected double absoluteScoreFraction = DEFAULT_ABSOLUTE_SCORE_FRACTION;
    protected double upperThreshold = DEFAULT_UPPER_THRESHOLD;
    protected double lowerThreshold = DEFAULT_LOWER_THRESHOLD;
    protected double initialThreshold = DEFAULT_INITIAL_THRESHOLD;
    protected double zFactor = DEFAULT_Z_FACTOR;
    protected double upperZfactor = DEFAULT_UPPER_FACTOR;
    protected boolean inPotentialAnomaly;

    public BasicThresholder(double discount, boolean adjust) {
        this.primaryDeviation = new Deviation(discount);
        this.secondaryDeviation = new Deviation(discount);
        this.thresholdDeviation = new Deviation(discount / 2.0);
        this.autoThreshold = adjust;
    }

    public BasicThresholder(double discount) {
        this(discount, false);
    }

    public BasicThresholder(Deviation primary, Deviation secondary, Deviation threshold) {
        this.primaryDeviation = primary;
        this.secondaryDeviation = secondary;
        this.thresholdDeviation = threshold;
    }

    public BasicThresholder(List<Double> scores, double futureAnomalyRate) {
        this.primaryDeviation = new Deviation(0.0);
        this.secondaryDeviation = new Deviation(0.0);
        this.thresholdDeviation = new Deviation(0.0);
        if (scores != null) {
            scores.forEach(s -> this.update((double)s, (double)s));
        }
        this.primaryDeviation.setDiscount(futureAnomalyRate);
        this.secondaryDeviation.setDiscount(futureAnomalyRate);
        this.thresholdDeviation.setDiscount(futureAnomalyRate / 2.0);
    }

    public boolean isDeviationReady() {
        if (this.count < this.minimumScores) {
            return false;
        }
        if (this.horizon == 0.0) {
            return this.secondaryDeviation.getCount() >= this.minimumScores;
        }
        if (this.horizon == 1.0) {
            return this.primaryDeviation.getCount() >= this.minimumScores;
        }
        return this.secondaryDeviation.getCount() >= this.minimumScores && this.primaryDeviation.getCount() >= this.minimumScores;
    }

    protected double intermediateTermFraction() {
        if (this.count < this.minimumScores) {
            return 0.0;
        }
        if (this.count > 2 * this.minimumScores) {
            return 1.0;
        }
        return (double)(this.count - this.minimumScores) * 1.0 / (double)this.minimumScores;
    }

    protected double notLongTermThreshold(double factor, double intermediateTermFraction) {
        if (!this.isDeviationReady()) {
            return Math.max(this.initialThreshold, this.lowerThreshold);
        }
        return Math.max(this.lowerThreshold, intermediateTermFraction * this.longTermThreshold(factor) + (1.0 - intermediateTermFraction) * this.initialThreshold);
    }

    public double threshold() {
        return this.longTermThreshold(this.zFactor);
    }

    protected double longTermThreshold(double factor) {
        return Math.max(this.lowerThreshold, this.primaryDeviation.getMean() + factor * this.longTermDeviation());
    }

    protected double longTermDeviation() {
        double a = this.primaryDeviation.getDeviation();
        double b = this.secondaryDeviation.getDeviation();
        return this.horizon * a + (1.0 - this.horizon) * b;
    }

    public double getAnomalyGrade(double score, boolean previous, double factor) {
        CommonUtils.checkArgument((factor >= this.zFactor ? 1 : 0) != 0, (String)"incorrect call");
        double elasticScore = previous ? this.elasticity : 0.0;
        double intermediateTermFraction = this.intermediateTermFraction();
        if (intermediateTermFraction == 1.0) {
            if (score < this.longTermThreshold(factor) - elasticScore) {
                return 0.0;
            }
            double tFactor = this.upperZfactor;
            double longTermDeviation = this.longTermDeviation();
            if (longTermDeviation > 0.0) {
                tFactor = Math.min(tFactor, (score - this.primaryDeviation.getMean()) / longTermDeviation);
            }
            return (tFactor - this.zFactor) / (this.upperZfactor - this.zFactor);
        }
        double t = this.notLongTermThreshold(factor, intermediateTermFraction);
        if (score < t - elasticScore) {
            return 0.0;
        }
        double upper = Math.max(this.upperThreshold, 2.0 * t);
        double quasiScore = Math.min(score, upper);
        return (quasiScore - t) / (upper - t);
    }

    public double getAnomalyGrade(double score, boolean previous) {
        return this.getAnomalyGrade(score, previous, this.zFactor);
    }

    protected void updateThreshold(double score) {
        double gap = score > this.lowerThreshold ? 1.0 : 0.0;
        this.thresholdDeviation.update(gap);
        if (this.autoThreshold && this.thresholdDeviation.getCount() > this.minimumScores) {
            if (this.thresholdDeviation.getMean() > this.thresholdDeviation.getDiscount()) {
                this.setLowerThreshold(this.lowerThreshold + DEFAULT_THRESHOLD_STEP, this.autoThreshold);
                this.thresholdDeviation.setCount(0);
            } else if (this.thresholdDeviation.getMean() < this.thresholdDeviation.getDiscount() / 4.0) {
                this.setLowerThreshold(this.lowerThreshold - DEFAULT_THRESHOLD_STEP, this.autoThreshold);
                this.thresholdDeviation.setCount(0);
            }
        }
    }

    protected void updatePrimary(double score) {
        this.primaryDeviation.update(score);
        this.updateThreshold(score);
        ++this.count;
    }

    public void update(double primary, double secondary) {
        this.primaryDeviation.update(primary);
        this.secondaryDeviation.update(secondary);
        this.updateThreshold(primary);
        ++this.count;
    }

    public void update(double score, double secondScore, double lastScore, boolean flag) {
        this.update(score, secondScore - lastScore);
        this.inPotentialAnomaly = flag;
    }

    public Deviation getPrimaryDeviation() {
        return this.primaryDeviation;
    }

    public Deviation getSecondaryDeviation() {
        return this.secondaryDeviation;
    }

    public void setZfactor(double factor) {
        this.zFactor = Math.max(factor, DEFAULT_Z_FACTOR);
        this.upperZfactor = Math.max(this.upperZfactor, 2.0 * this.zFactor);
    }

    public void setUpperZfactor(double factor) {
        this.upperZfactor = Math.max(factor, 2.0 * this.zFactor);
    }

    public void setLowerThreshold(double lower, boolean adjust) {
        this.lowerThreshold = Math.max(lower, this.absoluteThreshold);
        this.autoThreshold = adjust;
        this.initialThreshold = Math.max(this.initialThreshold, this.lowerThreshold);
        this.upperThreshold = Math.max(this.upperThreshold, 2.0 * this.lowerThreshold);
    }

    public void setAbsoluteThreshold(double value) {
        this.absoluteThreshold = value;
        this.setLowerThreshold(this.absoluteThreshold, this.autoThreshold);
    }

    public void setInitialThreshold(double initial) {
        this.initialThreshold = Math.max(initial, this.lowerThreshold);
        this.upperThreshold = Math.max(this.upperThreshold, initial);
    }

    public void setUpperThreshold(double upper) {
        this.upperThreshold = Math.max(upper, this.initialThreshold);
        this.upperThreshold = Math.max(this.upperThreshold, 2.0 * this.lowerThreshold);
    }

    public void setHorizon(double horizon) {
        CommonUtils.checkArgument((horizon >= 0.0 && horizon <= 1.0 ? 1 : 0) != 0, (String)"incorrect horizon parameter");
        this.horizon = horizon;
    }

    @Generated
    public double getElasticity() {
        return this.elasticity;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public double getHorizon() {
        return this.horizon;
    }

    @Generated
    public int getMinimumScores() {
        return this.minimumScores;
    }

    @Generated
    public Deviation getThresholdDeviation() {
        return this.thresholdDeviation;
    }

    @Generated
    public boolean isAutoThreshold() {
        return this.autoThreshold;
    }

    @Generated
    public double getAbsoluteThreshold() {
        return this.absoluteThreshold;
    }

    @Generated
    public double getAbsoluteScoreFraction() {
        return this.absoluteScoreFraction;
    }

    @Generated
    public double getUpperThreshold() {
        return this.upperThreshold;
    }

    @Generated
    public double getLowerThreshold() {
        return this.lowerThreshold;
    }

    @Generated
    public double getInitialThreshold() {
        return this.initialThreshold;
    }

    @Generated
    public double getZFactor() {
        return this.zFactor;
    }

    @Generated
    public double getUpperZfactor() {
        return this.upperZfactor;
    }

    @Generated
    public boolean isInPotentialAnomaly() {
        return this.inPotentialAnomaly;
    }

    @Generated
    public void setElasticity(double elasticity) {
        this.elasticity = elasticity;
    }

    @Generated
    public void setCount(int count) {
        this.count = count;
    }

    @Generated
    public void setMinimumScores(int minimumScores) {
        this.minimumScores = minimumScores;
    }

    @Generated
    public void setPrimaryDeviation(Deviation primaryDeviation) {
        this.primaryDeviation = primaryDeviation;
    }

    @Generated
    public void setSecondaryDeviation(Deviation secondaryDeviation) {
        this.secondaryDeviation = secondaryDeviation;
    }

    @Generated
    public void setThresholdDeviation(Deviation thresholdDeviation) {
        this.thresholdDeviation = thresholdDeviation;
    }

    @Generated
    public void setAutoThreshold(boolean autoThreshold) {
        this.autoThreshold = autoThreshold;
    }

    @Generated
    public void setAbsoluteScoreFraction(double absoluteScoreFraction) {
        this.absoluteScoreFraction = absoluteScoreFraction;
    }

    @Generated
    public void setLowerThreshold(double lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    @Generated
    public void setInPotentialAnomaly(boolean inPotentialAnomaly) {
        this.inPotentialAnomaly = inPotentialAnomaly;
    }
}

