/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(vec2(-2.0, -2.0), vec2(-3.0, -3.0), bvec2(true, false)) => vec2(-3.0, -2.0)
 * mix(vec2(-2.0, -2.0), vec2(3.0, 3.0), bvec2(true, false)) => vec2(3.0, -2.0)
 * mix(vec2(2.0, 2.0), vec2(-3.0, -3.0), bvec2(true, false)) => vec2(-3.0, 2.0)
 * mix(vec2(2.0, 2.0), vec2(3.0, 3.0), bvec2(true, false)) => vec2(3.0, 2.0)
 */
#version 130

void main()
{
  float[distance(mix(vec2(-2.0, -2.0), vec2(-3.0, -3.0), bvec2(true, false)), vec2(-3.0, -2.0)) <= 3.6055513e-05 ? 1 : -1] array0;
  float[distance(mix(vec2(-2.0, -2.0), vec2(3.0, 3.0), bvec2(true, false)), vec2(3.0, -2.0)) <= 3.6055513e-05 ? 1 : -1] array1;
  float[distance(mix(vec2(2.0, 2.0), vec2(-3.0, -3.0), bvec2(true, false)), vec2(-3.0, 2.0)) <= 3.6055513e-05 ? 1 : -1] array2;
  float[distance(mix(vec2(2.0, 2.0), vec2(3.0, 3.0), bvec2(true, false)), vec2(3.0, 2.0)) <= 3.6055513e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
