/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u ^ uvec4(66u, 72u, 87u, 75u)) => uvec4(66u, 72u, 87u, 75u)
 * (0u ^ uvec4(24u, 40u, 23u, 74u)) => uvec4(24u, 40u, 23u, 74u)
 * (6u ^ uvec4(66u, 72u, 87u, 75u)) => uvec4(68u, 78u, 81u, 77u)
 * (6u ^ uvec4(24u, 40u, 23u, 74u)) => uvec4(30u, 46u, 17u, 76u)
 * (12u ^ uvec4(66u, 72u, 87u, 75u)) => uvec4(78u, 68u, 91u, 71u)
 * (12u ^ uvec4(24u, 40u, 23u, 74u)) => uvec4(20u, 36u, 27u, 70u)
 * (32u ^ uvec4(66u, 72u, 87u, 75u)) => uvec4(98u, 104u, 119u, 107u)
 * (32u ^ uvec4(24u, 40u, 23u, 74u)) => uvec4(56u, 8u, 55u, 106u)
 * (74u ^ uvec4(66u, 72u, 87u, 75u)) => uvec4(8u, 2u, 29u, 1u)
 * (74u ^ uvec4(24u, 40u, 23u, 74u)) => uvec4(82u, 98u, 93u, 0u)
 */
#version 130

void main()
{
  float[all(equal((0u ^ uvec4(66u, 72u, 87u, 75u)), uvec4(66u, 72u, 87u, 75u))) ? 1 : -1] array0;
  float[all(equal((0u ^ uvec4(24u, 40u, 23u, 74u)), uvec4(24u, 40u, 23u, 74u))) ? 1 : -1] array1;
  float[all(equal((6u ^ uvec4(66u, 72u, 87u, 75u)), uvec4(68u, 78u, 81u, 77u))) ? 1 : -1] array2;
  float[all(equal((6u ^ uvec4(24u, 40u, 23u, 74u)), uvec4(30u, 46u, 17u, 76u))) ? 1 : -1] array3;
  float[all(equal((12u ^ uvec4(66u, 72u, 87u, 75u)), uvec4(78u, 68u, 91u, 71u))) ? 1 : -1] array4;
  float[all(equal((12u ^ uvec4(24u, 40u, 23u, 74u)), uvec4(20u, 36u, 27u, 70u))) ? 1 : -1] array5;
  float[all(equal((32u ^ uvec4(66u, 72u, 87u, 75u)), uvec4(98u, 104u, 119u, 107u))) ? 1 : -1] array6;
  float[all(equal((32u ^ uvec4(24u, 40u, 23u, 74u)), uvec4(56u, 8u, 55u, 106u))) ? 1 : -1] array7;
  float[all(equal((74u ^ uvec4(66u, 72u, 87u, 75u)), uvec4(8u, 2u, 29u, 1u))) ? 1 : -1] array8;
  float[all(equal((74u ^ uvec4(24u, 40u, 23u, 74u)), uvec4(82u, 98u, 93u, 0u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
