<?php

/*
 | !!!! DO NOT EDIT THIS FILE !!!!
 |
 | You can change settings by setting them in the environment or .env
 | If there is something you need to change, but is not available as an environment setting,
 | request an environment variable to be created upstream or send a pull request.
 */

use Illuminate\Support\Facades\Facade;

return [

    'timezone' => ini_get('date.timezone') ?: 'UTC', // use existing timezone

    'default_locale' => env('APP_LOCALE', 'en'), // just a holder for the system set locale

    'aliases' => Facade::defaultAliases()->merge([
        'DeviceCache' => App\Facades\DeviceCache::class,
        'Permissions' => App\Facades\Permissions::class,
        'PortCache' => App\Facades\PortCache::class,
        'PluginManager' => App\Facades\PluginManager::class,
        'Rrd' => App\Facades\Rrd::class,
        'SnmpQuery' => App\Facades\FacadeAccessorSnmp::class,
        'LibrenmsConfig' => App\Facades\LibrenmsConfig::class,
    ])->forget([
        'Http', // don't use Laravel Http facade, LibreNMS has its own wrapper
    ])->toArray(),

    'charset' => env('CHARSET', ini_get('php.output_encoding') ?: ini_get('default_charset') ?: 'UTF-8'),

    'name' => 'LibreNMS',
];
