/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.credentials.Credentials;

public interface HttpProxySettings {
    public HttpProxy getProxy();

    @NonNullApi
    public static class HttpProxyCredentials
    implements Credentials {
        private final String username;
        private final String password;

        public HttpProxyCredentials(String username, @Nullable String password) {
            this.username = (String)Preconditions.checkNotNull((Object)username);
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        @Nullable
        public String getPassword() {
            return this.password;
        }
    }

    public static class HttpProxy {
        public final String host;
        public final int port;
        public final HttpProxyCredentials credentials;

        public HttpProxy(String host, int port, String username, String password) {
            this.host = host;
            this.port = port;
            this.credentials = username == null || username.isEmpty() ? null : new HttpProxyCredentials(username, password);
        }
    }
}

