﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Collections.Generic;
using Microsoft.CodeAnalysis.Operations;

namespace Microsoft.CodeAnalysis.FlowAnalysis;

internal static partial class BasicBlockExtensions
{
    public static IEnumerable<IOperation> DescendantOperations(this BasicBlock basicBlock)
    {
        foreach (var statement in basicBlock.Operations)
        {
            foreach (var operation in statement.DescendantsAndSelf())
            {
                yield return operation;
            }
        }

        if (basicBlock.BranchValue != null)
        {
            foreach (var operation in basicBlock.BranchValue.DescendantsAndSelf())
            {
                yield return operation;
            }
        }
    }
}
