// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the resource counts across accounts and regions that are present in
// your Config aggregator. You can request the resource counts by providing filters
// and GroupByKey.
//
// For example, if the input contains accountID 12345678910 and region us-east-1
// in filters, the API returns the count of resources in account ID 12345678910 and
// region us-east-1. If the input contains ACCOUNT_ID as a GroupByKey, the API
// returns resource counts for all source accounts that are present in your
// aggregator.
func (c *Client) GetAggregateDiscoveredResourceCounts(ctx context.Context, params *GetAggregateDiscoveredResourceCountsInput, optFns ...func(*Options)) (*GetAggregateDiscoveredResourceCountsOutput, error) {
	if params == nil {
		params = &GetAggregateDiscoveredResourceCountsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAggregateDiscoveredResourceCounts", params, optFns, c.addOperationGetAggregateDiscoveredResourceCountsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAggregateDiscoveredResourceCountsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAggregateDiscoveredResourceCountsInput struct {

	// The name of the configuration aggregator.
	//
	// This member is required.
	ConfigurationAggregatorName *string

	// Filters the results based on the ResourceCountFilters object.
	Filters *types.ResourceCountFilters

	// The key to group the resource counts.
	GroupByKey types.ResourceCountGroupKey

	// The maximum number of GroupedResourceCount objects returned on each page. The default is 1000. You
	// cannot specify a number greater than 1000. If you specify 0, Config uses the
	// default.
	Limit int32

	// The nextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	noSmithyDocumentSerde
}

type GetAggregateDiscoveredResourceCountsOutput struct {

	// The total number of resources that are present in an aggregator with the
	// filters that you provide.
	//
	// This member is required.
	TotalDiscoveredResources int64

	// The key passed into the request object. If GroupByKey is not provided, the
	// result will be empty.
	GroupByKey *string

	// Returns a list of GroupedResourceCount objects.
	GroupedResourceCounts []types.GroupedResourceCount

	// The nextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAggregateDiscoveredResourceCountsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetAggregateDiscoveredResourceCounts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetAggregateDiscoveredResourceCounts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAggregateDiscoveredResourceCounts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetAggregateDiscoveredResourceCountsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAggregateDiscoveredResourceCounts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetAggregateDiscoveredResourceCountsPaginatorOptions is the paginator options
// for GetAggregateDiscoveredResourceCounts
type GetAggregateDiscoveredResourceCountsPaginatorOptions struct {
	// The maximum number of GroupedResourceCount objects returned on each page. The default is 1000. You
	// cannot specify a number greater than 1000. If you specify 0, Config uses the
	// default.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetAggregateDiscoveredResourceCountsPaginator is a paginator for
// GetAggregateDiscoveredResourceCounts
type GetAggregateDiscoveredResourceCountsPaginator struct {
	options   GetAggregateDiscoveredResourceCountsPaginatorOptions
	client    GetAggregateDiscoveredResourceCountsAPIClient
	params    *GetAggregateDiscoveredResourceCountsInput
	nextToken *string
	firstPage bool
}

// NewGetAggregateDiscoveredResourceCountsPaginator returns a new
// GetAggregateDiscoveredResourceCountsPaginator
func NewGetAggregateDiscoveredResourceCountsPaginator(client GetAggregateDiscoveredResourceCountsAPIClient, params *GetAggregateDiscoveredResourceCountsInput, optFns ...func(*GetAggregateDiscoveredResourceCountsPaginatorOptions)) *GetAggregateDiscoveredResourceCountsPaginator {
	if params == nil {
		params = &GetAggregateDiscoveredResourceCountsInput{}
	}

	options := GetAggregateDiscoveredResourceCountsPaginatorOptions{}
	if params.Limit != 0 {
		options.Limit = params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetAggregateDiscoveredResourceCountsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetAggregateDiscoveredResourceCountsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetAggregateDiscoveredResourceCounts page.
func (p *GetAggregateDiscoveredResourceCountsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetAggregateDiscoveredResourceCountsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.Limit = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetAggregateDiscoveredResourceCounts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetAggregateDiscoveredResourceCountsAPIClient is a client that implements the
// GetAggregateDiscoveredResourceCounts operation.
type GetAggregateDiscoveredResourceCountsAPIClient interface {
	GetAggregateDiscoveredResourceCounts(context.Context, *GetAggregateDiscoveredResourceCountsInput, ...func(*Options)) (*GetAggregateDiscoveredResourceCountsOutput, error)
}

var _ GetAggregateDiscoveredResourceCountsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetAggregateDiscoveredResourceCounts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAggregateDiscoveredResourceCounts",
	}
}
