# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AgeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Age Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified time period"""
    YEAR = "Year"
    """Time period of a year"""
    MONTH = "Month"
    """Time period of a month"""
    WEEK = "Week"
    """Time period of a week"""
    DAY = "Day"
    """Time period of a day"""


class AnalyzeTextErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    """Invalid request error"""
    INVALID_ARGUMENT = "InvalidArgument"
    """Invalid argument error"""
    UNAUTHORIZED = "Unauthorized"
    """Unauthorized access error"""
    FORBIDDEN = "Forbidden"
    """Forbidden access error"""
    NOT_FOUND = "NotFound"
    """Not found error"""
    PROJECT_NOT_FOUND = "ProjectNotFound"
    """Project not found error"""
    OPERATION_NOT_FOUND = "OperationNotFound"
    """Operation not found error"""
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    """Azure Cognitive Search not found error"""
    AZURE_COGNITIVE_SEARCH_INDEX_NOT_FOUND = "AzureCognitiveSearchIndexNotFound"
    """Azure Cognitive Search index not found error"""
    TOO_MANY_REQUESTS = "TooManyRequests"
    """Too many requests error"""
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    """Azure Cognitive Search throttling error"""
    AZURE_COGNITIVE_SEARCH_INDEX_LIMIT_REACHED = "AzureCognitiveSearchIndexLimitReached"
    """Azure Cognitive Search index limit reached error"""
    INTERNAL_SERVER_ERROR = "InternalServerError"
    """Internal server error"""
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    """Service unavailable error"""
    TIMEOUT = "Timeout"
    """Timeout error"""
    QUOTA_EXCEEDED = "QuotaExceeded"
    """Quota exceeded error"""
    CONFLICT = "Conflict"
    """Conflict error"""
    WARNING = "Warning"
    """Warning error"""


class AnalyzeTextInputKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the analyze-text tasks supported."""

    SENTIMENT_ANALYSIS = "SentimentAnalysis"
    """Sentiment analysis task"""
    ENTITY_RECOGNITION = "EntityRecognition"
    """Entity recognition task"""
    PII_ENTITY_RECOGNITION = "PiiEntityRecognition"
    """PII entity recognition task"""
    KEY_PHRASE_EXTRACTION = "KeyPhraseExtraction"
    """Key phrase extraction task"""
    LANGUAGE_DETECTION = "LanguageDetection"
    """Language detection task"""
    ENTITY_LINKING = "EntityLinking"
    """Entity linking task"""


class AnalyzeTextOperationActionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the long running analyze text tasks supported."""

    SENTIMENT_ANALYSIS = "SentimentAnalysis"
    """Sentiment analysis task"""
    ENTITY_RECOGNITION = "EntityRecognition"
    """Entity recognition task"""
    PII_ENTITY_RECOGNITION = "PiiEntityRecognition"
    """PII entity recognition task"""
    KEY_PHRASE_EXTRACTION = "KeyPhraseExtraction"
    """Key phrase extraction task"""
    ENTITY_LINKING = "EntityLinking"
    """Entity linking task"""
    HEALTHCARE = "Healthcare"
    """Healthcare task"""
    CUSTOM_ENTITY_RECOGNITION = "CustomEntityRecognition"
    """Custom entity recognition task"""
    CUSTOM_SINGLE_LABEL_CLASSIFICATION = "CustomSingleLabelClassification"
    """Custom single label classification task"""
    CUSTOM_MULTI_LABEL_CLASSIFICATION = "CustomMultiLabelClassification"
    """Custom multi label classification task"""
    EXTRACTIVE_SUMMARIZATION = "ExtractiveSummarization"
    """Extractive summarization task"""
    ABSTRACTIVE_SUMMARIZATION = "AbstractiveSummarization"
    """Abstractive summarization task"""


class AnalyzeTextOperationResultsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the response object returned by the analyze-text long running task."""

    SENTIMENT_ANALYSIS_OPERATION_RESULTS = "SentimentAnalysisLROResults"
    """Sentiment analysis LRO results"""
    ENTITY_RECOGNITION_OPERATION_RESULTS = "EntityRecognitionLROResults"
    """Entity recognition LRO results"""
    PII_ENTITY_RECOGNITION_OPERATION_RESULTS = "PiiEntityRecognitionLROResults"
    """PII entity recognition LRO results"""
    KEY_PHRASE_EXTRACTION_OPERATION_RESULTS = "KeyPhraseExtractionLROResults"
    """Key phrase extraction LRO results"""
    ENTITY_LINKING_OPERATION_RESULTS = "EntityLinkingLROResults"
    """Entity linking LRO results"""
    HEALTHCARE_OPERATION_RESULTS = "HealthcareLROResults"
    """Healthcare LRO results"""
    CUSTOM_ENTITY_RECOGNITION_OPERATION_RESULTS = "CustomEntityRecognitionLROResults"
    """Custom entity recognition LRO results"""
    CUSTOM_SINGLE_LABEL_CLASSIFICATION_OPERATION_RESULTS = "CustomSingleLabelClassificationLROResults"
    """Custom single label classification LRO results"""
    CUSTOM_MULTI_LABEL_CLASSIFICATION_OPERATION_RESULTS = "CustomMultiLabelClassificationLROResults"
    """Custom multi label classification LRO results"""
    EXTRACTIVE_SUMMARIZATION_OPERATION_RESULTS = "ExtractiveSummarizationLROResults"
    """Extractive summarization LRO results"""
    ABSTRACTIVE_SUMMARIZATION_OPERATION_RESULTS = "AbstractiveSummarizationLROResults"
    """Abstractive summarization LRO results"""


class AnalyzeTextResultsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the response object returned by the analyze-text task."""

    SENTIMENT_ANALYSIS_RESULTS = "SentimentAnalysisResults"
    """Sentiment analysis results"""
    ENTITY_RECOGNITION_RESULTS = "EntityRecognitionResults"
    """Entity recognition results"""
    PII_ENTITY_RECOGNITION_RESULTS = "PiiEntityRecognitionResults"
    """PII entity recognition results"""
    KEY_PHRASE_EXTRACTION_RESULTS = "KeyPhraseExtractionResults"
    """Key phrase extraction results"""
    LANGUAGE_DETECTION_RESULTS = "LanguageDetectionResults"
    """Language detection results"""
    ENTITY_LINKING_RESULTS = "EntityLinkingResults"
    """Entity linking results"""


class AreaUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The area unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified area unit"""
    SQUARE_KILOMETER = "SquareKilometer"
    """Area unit in square kilometers"""
    SQUARE_HECTOMETER = "SquareHectometer"
    """Area unit in square hectometers"""
    SQUARE_DECAMETER = "SquareDecameter"
    """Area unit in square decameters"""
    SQUARE_DECIMETER = "SquareDecimeter"
    """Area unit in square decimeters"""
    SQUARE_METER = "SquareMeter"
    """Area unit in square meters"""
    SQUARE_CENTIMETER = "SquareCentimeter"
    """Area unit in square centimeters"""
    SQUARE_MILLIMETER = "SquareMillimeter"
    """Area unit in square millimeters"""
    SQUARE_INCH = "SquareInch"
    """Area unit in square inches"""
    SQUARE_FOOT = "SquareFoot"
    """Area unit in square feet"""
    SQUARE_MILE = "SquareMile"
    """Area unit in square miles"""
    SQUARE_YARD = "SquareYard"
    """Area unit in square yards"""
    ACRE = "Acre"
    """Area unit in acres"""


class DocumentSentiment(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Predicted sentiment for document (Negative, Neutral, Positive, or Mixed)."""

    POSITIVE = "positive"
    """Positive statement"""
    NEUTRAL = "neutral"
    """Neutral statement"""
    NEGATIVE = "negative"
    """Negative statement"""
    MIXED = "mixed"
    """Mixed statement"""


class EntityCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Contains all the entity categories detected by entity recognition."""

    ADDRESS = "Address"
    """Specific street-level mentions of locations: house/building numbers, streets, avenues,
    highways, intersections referenced by name."""
    NUMERIC = "Numeric"
    """Numeric values, including digits and number words."""
    AGE = "Age"
    """Age-related values."""
    CURRENCY = "Currency"
    """Currency-related values."""
    NUMBER = "Number"
    """Numbers without a unit"""
    NUMBER_RANGE = "NumberRange"
    """Range of Numbers"""
    PERCENTAGE = "Percentage"
    """Percentage-related values."""
    ORDINAL = "Ordinal"
    """Ordinal numbers."""
    TEMPERATURE = "Temperature"
    """Temperature-related values."""
    DIMENSION = "Dimension"
    """Dimension of measurements"""
    LENGTH = "Length"
    """Length of an object."""
    WEIGHT = "Weight"
    """Weight of an object."""
    HEIGHT = "Height"
    """Height of an object."""
    SPEED = "Speed"
    """Speed of an object."""
    AREA = "Area"
    """Area of an object."""
    VOLUME = "Volume"
    """Volume of an object."""
    INFORMATION = "Information"
    """Unit of measure for digital information."""
    TEMPORAL = "Temporal"
    """Items relating to time."""
    DATE = "Date"
    """Calendar dates."""
    TIME = "Time"
    """Times of day."""
    DATE_TIME = "DateTime"
    """Calendar dates with time."""
    DATE_RANGE = "DateRange"
    """Range of dates."""
    TIME_RANGE = "TimeRange"
    """Range of times."""
    DATE_TIME_RANGE = "DateTimeRange"
    """Range of date and time."""
    DURATION = "Duration"
    """Duration of time."""
    SET_TEMPORAL = "SetTemporal"
    """Set of time-related values."""
    EVENT = "Event"
    """Social, sports, business, political, educational, natural, historical, criminal, violent,
    legal, military events with a timed period."""
    SPORTS_EVENT = "SportsEvent"
    """Sports event-related values."""
    CULTURAL_EVENT = "CulturalEvent"
    """Cultural event-related values."""
    NATURAL_EVENT = "NaturalEvent"
    """Natural event-related values."""
    LOCATION = "Location"
    """Particular point or place in physical space."""
    GEO_POLITICAL_ENTITY = "GPE"
    """Cities, countries/regions, states."""
    CITY = "City"
    """City-related values."""
    STATE = "State"
    """State-related values."""
    COUNTRY_REGION = "CountryRegion"
    """Country or region-related values."""
    CONTINENT = "Continent"
    """Continent-related values."""
    STRUCTURAL = "Structural"
    """Manmade structures."""
    AIRPORT = "Airport"
    """Airports."""
    GEOLOGICAL = "Geological"
    """Geographic and natural features such as rivers, oceans, and deserts."""
    ORGANIZATION = "Organization"
    """Corporations, agencies, and other groups of people defined by some established organizational
    structure. These labels can include companies, political parties/movements, musical bands,
    sport clubs, government bodies, and public organizations. Nationalities or religions are not
    ORGANIZATION."""
    ORGANIZATION_MEDICAL = "OrganizationMedical"
    """Medical companies and groups."""
    ORGANIZATION_STOCK_EXCHANGE = "OrganizationStockExchange"
    """Stock exchange groups."""
    ORGANIZATION_SPORTS = "OrganizationSports"
    """Sports-related organizations."""
    PERSON = "Person"
    """First, last, and middle names, names of fictional characters, and aliases. Titles, such as
    'Mr.' or 'President', are not considered part of the named entity."""
    PERSON_TYPE = "PersonType"
    """Human roles classified by a group membership."""
    EMAIL = "Email"
    """Email addresses."""
    URI = "URL"
    """URLs to websites."""
    IP_ADDRESS = "IP"
    """network IP addresses."""
    PHONE_NUMBER = "PhoneNumber"
    """Phone numbers (US and EU phone numbers only)."""
    PRODUCT = "Product"
    """Single or group of commercial, consumable objects, electronics, vehicles, food groups."""
    COMPUTING_PRODUCT = "ComputingProduct"
    """Computing products."""
    SKILL = "Skill"
    """A capability, skill, or expertise."""


class ExtractiveSummarizationSortingCriteria(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sorting criteria to use for the results of Extractive Summarization."""

    OFFSET = "Offset"
    """Indicates that results should be sorted in order of appearance in the text."""
    RANK = "Rank"
    """Indicates that results should be sorted in order of importance (i.e. rank score) according to
    the model."""


class FhirVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The FHIR Spec version."""

    ENUM_4_0_1 = "4.0.1"
    """Version 4.0.1"""


class HealthcareAssertionAssociation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes if the entity is the subject of the text or if it describes someone else."""

    SUBJECT = "subject"
    """Subject association"""
    OTHER = "other"
    """Other association"""


class HealthcareAssertionCertainty(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the entities certainty and polarity."""

    POSITIVE = "positive"
    """Positive certainty"""
    POSITIVE_POSSIBLE = "positivePossible"
    """Possibly positive certainty"""
    NEUTRAL_POSSIBLE = "neutralPossible"
    """Possibly neutral certainty"""
    NEGATIVE_POSSIBLE = "negativePossible"
    """Possibly negative certainty"""
    NEGATIVE = "negative"
    """Negative certainty"""


class HealthcareAssertionConditionality(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes any conditionality on the entity."""

    HYPOTHETICAL = "hypothetical"
    """Hypothetical conditionality"""
    CONDITIONAL = "conditional"
    """Conditional conditionality"""


class HealthcareAssertionTemporality(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes temporal information regarding the entity."""

    CURRENT = "current"
    """Current temporality"""
    PAST = "past"
    """Past temporality"""
    FUTURE = "future"
    """Future temporality"""


class HealthcareDocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Document type."""

    NONE = "None"
    """None document type"""
    CLINICAL_TRIAL = "ClinicalTrial"
    """Clinical trial document type"""
    DISCHARGE_SUMMARY = "DischargeSummary"
    """Discharge summary document type"""
    PROGRESS_NOTE = "ProgressNote"
    """Progress note document type"""
    HISTORY_AND_PHYSICAL = "HistoryAndPhysical"
    """History and physical document type"""
    CONSULT = "Consult"
    """Consult document type"""
    IMAGING = "Imaging"
    """Imaging document type"""
    PATHOLOGY = "Pathology"
    """Pathology document type"""
    PROCEDURE_NOTE = "ProcedureNote"
    """Procedure note document type"""


class HealthcareEntityCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Healthcare Entity Category."""

    BODY_STRUCTURE = "BodyStructure"
    """Body structure"""
    AGE = "Age"
    """Age"""
    GENDER = "Gender"
    """Gender"""
    EXAMINATION_NAME = "ExaminationName"
    """Examination name"""
    DATE = "Date"
    """Date"""
    DIRECTION = "Direction"
    """Direction"""
    FREQUENCY = "Frequency"
    """Frequency"""
    MEASUREMENT_VALUE = "MeasurementValue"
    """Measurement value"""
    MEASUREMENT_UNIT = "MeasurementUnit"
    """Measurement unit"""
    RELATIONAL_OPERATOR = "RelationalOperator"
    """Relational operator"""
    TIME = "Time"
    """Time"""
    GENE_OR_PROTEIN = "GeneOrProtein"
    """Gene or protein"""
    VARIANT = "Variant"
    """Variant"""
    ADMINISTRATIVE_EVENT = "AdministrativeEvent"
    """Administrative event"""
    CARE_ENVIRONMENT = "CareEnvironment"
    """Care environment"""
    HEALTHCARE_PROFESSION = "HealthcareProfession"
    """Healthcare profession"""
    DIAGNOSIS = "Diagnosis"
    """Diagnosis"""
    SYMPTOM_OR_SIGN = "SymptomOrSign"
    """Symptom or sign"""
    CONDITION_QUALIFIER = "ConditionQualifier"
    """Condition qualifier"""
    MEDICATION_CLASS = "MedicationClass"
    """Medication class"""
    MEDICATION_NAME = "MedicationName"
    """Medication name"""
    DOSAGE = "Dosage"
    """Dosage"""
    MEDICATION_FORM = "MedicationForm"
    """Medication form"""
    MEDICATION_ROUTE = "MedicationRoute"
    """Medication route"""
    FAMILY_RELATION = "FamilyRelation"
    """Family relation"""
    TREATMENT_NAME = "TreatmentName"
    """Treatment name"""
    ETHNICITY = "Ethnicity"
    """Ethnicity"""
    COURSE = "Course"
    """Course"""
    EXPRESSION = "Expression"
    """Expression"""
    MUTATION_TYPE = "MutationType"
    """Mutation type"""
    CONDITION_SCALE = "ConditionScale"
    """Condition scale"""
    ALLERGEN = "Allergen"
    """Allergen"""
    EMPLOYMENT = "Employment"
    """Employment"""
    LIVING_STATUS = "LivingStatus"
    """Living status"""
    SUBSTANCE_USE = "SubstanceUse"
    """Substance use"""
    SUBSTANCE_USE_AMOUNT = "SubstanceUseAmount"
    """Substance use amount"""


class InformationUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The information (data) Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified data size unit"""
    BIT = "Bit"
    """Data size unit in bits"""
    KILOBIT = "Kilobit"
    """Data size unit in kilobits"""
    MEGABIT = "Megabit"
    """Data size unit in megabits"""
    GIGABIT = "Gigabit"
    """Data size unit in gigabits"""
    TERABIT = "Terabit"
    """Data size unit in terabits"""
    PETABIT = "Petabit"
    """Data size unit in petabits"""
    BYTE = "Byte"
    """Data size unit in bytes"""
    KILOBYTE = "Kilobyte"
    """Data size unit in kilobytes"""
    MEGABYTE = "Megabyte"
    """Data size unit in megabytes"""
    GIGABYTE = "Gigabyte"
    """Data size unit in gigabytes"""
    TERABYTE = "Terabyte"
    """Data size unit in terabytes"""
    PETABYTE = "Petabyte"
    """Data size unit in petabytes"""


class InnerErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    """Invalid request error"""
    INVALID_PARAMETER_VALUE = "InvalidParameterValue"
    """Invalid parameter value error"""
    KNOWLEDGE_BASE_NOT_FOUND = "KnowledgeBaseNotFound"
    """Knowledge base not found error"""
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    """Azure Cognitive Search not found error"""
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    """Azure Cognitive Search throttling error"""
    EXTRACTION_FAILURE = "ExtractionFailure"
    """Extraction failure error"""
    INVALID_REQUEST_BODY_FORMAT = "InvalidRequestBodyFormat"
    """Invalid request body format error"""
    EMPTY_REQUEST = "EmptyRequest"
    """Empty request error"""
    MISSING_INPUT_DOCUMENTS = "MissingInputDocuments"
    """Missing input documents error"""
    INVALID_DOCUMENT = "InvalidDocument"
    """Invalid document error"""
    MODEL_VERSION_INCORRECT = "ModelVersionIncorrect"
    """Model version incorrect error"""
    INVALID_DOCUMENT_BATCH = "InvalidDocumentBatch"
    """Invalid document batch error"""
    UNSUPPORTED_LANGUAGE_CODE = "UnsupportedLanguageCode"
    """Unsupported language code error"""
    INVALID_COUNTRY_HINT = "InvalidCountryHint"
    """Invalid country hint error"""


class LengthUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The length unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified length unit."""
    KILOMETER = "Kilometer"
    """Length unit in kilometers."""
    HECTOMETER = "Hectometer"
    """Length unit in hectometers."""
    DECAMETER = "Decameter"
    """Length unit in decameters."""
    METER = "Meter"
    """Length unit in meters."""
    DECIMETER = "Decimeter"
    """Length unit in decimeters."""
    CENTIMETER = "Centimeter"
    """Length unit in centimeters."""
    MILLIMETER = "Millimeter"
    """Length unit in millimeters."""
    MICROMETER = "Micrometer"
    """Length unit in micrometers."""
    NANOMETER = "Nanometer"
    """Length unit in nanometers."""
    PICOMETER = "Picometer"
    """Length unit in picometers."""
    MILE = "Mile"
    """Length unit in miles."""
    YARD = "Yard"
    """Length unit in yards."""
    INCH = "Inch"
    """Length unit in inches."""
    FOOT = "Foot"
    """Length unit in feet."""
    LIGHT_YEAR = "LightYear"
    """Length unit in light years."""
    POINT = "Point"
    """Length unit in points."""


class MetadataKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The entity Metadata object kind."""

    DATE_METADATA = "DateMetadata"
    """Metadata for date-related values."""
    DATE_TIME_METADATA = "DateTimeMetadata"
    """Metadata for date and time-related values."""
    TIME_METADATA = "TimeMetadata"
    """Metadata for time-related values."""
    TEMPORAL_SET_METADATA = "TemporalSetMetadata"
    """Metadata for set of time-related values."""
    NUMBER_METADATA = "NumberMetadata"
    """Metadata for numeric values."""
    ORDINAL_METADATA = "OrdinalMetadata"
    """Metadata for ordinal numbers."""
    SPEED_METADATA = "SpeedMetadata"
    """Metadata for speed-related values."""
    WEIGHT_METADATA = "WeightMetadata"
    """Metadata for weight-related values."""
    LENGTH_METADATA = "LengthMetadata"
    """Metadata for length-related values."""
    VOLUME_METADATA = "VolumeMetadata"
    """Metadata for volume-related values."""
    AREA_METADATA = "AreaMetadata"
    """Metadata for area-related values."""
    AGE_METADATA = "AgeMetadata"
    """Metadata for age-related values."""
    INFORMATION_METADATA = "InformationMetadata"
    """Metadata for information-related values."""
    TEMPERATURE_METADATA = "TemperatureMetadata"
    """Metadata for temperature-related values."""
    CURRENCY_METADATA = "CurrencyMetadata"
    """Metadata for currency-related values."""
    NUMERIC_RANGE_METADATA = "NumericRangeMetadata"
    """Metadata for numeric range values."""
    TEMPORAL_SPAN_METADATA = "TemporalSpanMetadata"
    """Metadata for temporal span values."""


class NumberKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the extracted number entity."""

    INTEGER = "Integer"
    """Integer number"""
    DECIMAL = "Decimal"
    """Decimal number"""
    POWER = "Power"
    """Power number"""
    FRACTION = "Fraction"
    """Fraction number"""
    PERCENT = "Percent"
    """Percent number"""
    UNSPECIFIED = "Unspecified"
    """Unspecified number kind"""


class PiiCategoriesExclude(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """(Optional) describes the PII categories to return."""

    ABA_ROUTING_NUMBER = "ABARoutingNumber"
    """ABA Routing number"""
    AR_NATIONAL_IDENTITY_NUMBER = "ARNationalIdentityNumber"
    """AR National Identity Number"""
    AU_BANK_ACCOUNT_NUMBER = "AUBankAccountNumber"
    """AT Bank Account Number"""
    AU_DRIVERS_LICENSE_NUMBER = "AUDriversLicenseNumber"
    """AU Driver's License Number"""
    AU_MEDICAL_ACCOUNT_NUMBER = "AUMedicalAccountNumber"
    """AU Medical Account Number"""
    AU_PASSPORT_NUMBER = "AUPassportNumber"
    """AU Passport Number"""
    AU_TAX_FILE_NUMBER = "AUTaxFileNumber"
    """AU Tax File Number"""
    AU_BUSINESS_NUMBER = "AUBusinessNumber"
    """AU Business Number"""
    AU_COMPANY_NUMBER = "AUCompanyNumber"
    """AU Company Number"""
    AT_IDENTITY_CARD = "ATIdentityCard"
    """AT Identity Card"""
    AT_TAX_IDENTIFICATION_NUMBER = "ATTaxIdentificationNumber"
    """AT Tax Identification Number"""
    AT_VALUE_ADDED_TAX_NUMBER = "ATValueAddedTaxNumber"
    """AT Value Added Tax Number"""
    AZURE_DOCUMENT_DBAUTH_KEY = "AzureDocumentDBAuthKey"
    """Azure Document DB Auth Key"""
    AZURE_IAAS_DATABASE_CONNECTION_AND_SQL_STRING = "AzureIAASDatabaseConnectionAndSQLString"
    """Azure IAAS Database Connection And SQL String"""
    AZURE_IO_T_CONNECTION_STRING = "AzureIoTConnectionString"
    """Azure IoT Connection String"""
    AZURE_PUBLISH_SETTING_PASSWORD = "AzurePublishSettingPassword"
    """Azure Publish Setting Password"""
    AZURE_REDIS_CACHE_STRING = "AzureRedisCacheString"
    """Azure Redis Cache String"""
    AZURE_SAS = "AzureSAS"
    """Azure SAS"""
    AZURE_SERVICE_BUS_STRING = "AzureServiceBusString"
    """Azure Service Bus String"""
    AZURE_STORAGE_ACCOUNT_KEY = "AzureStorageAccountKey"
    """Azure Storage Account Key"""
    AZURE_STORAGE_ACCOUNT_GENERIC = "AzureStorageAccountGeneric"
    """Azure Storage Account Generic"""
    BE_NATIONAL_NUMBER = "BENationalNumber"
    """BE National Number"""
    BE_NATIONAL_NUMBER_V2 = "BENationalNumberV2"
    """BE National Number V2"""
    BE_VALUE_ADDED_TAX_NUMBER = "BEValueAddedTaxNumber"
    """BE Value Added Tax Number"""
    BR_CPF_NUMBER = "BRCPFNumber"
    """BR CPF Number"""
    BR_LEGAL_ENTITY_NUMBER = "BRLegalEntityNumber"
    """BR Legal Entity Number"""
    BR_NATIONAL_ID_RG = "BRNationalIDRG"
    """BR National ID RG"""
    BG_UNIFORM_CIVIL_NUMBER = "BGUniformCivilNumber"
    """BG Uniform Civil Number"""
    CA_BANK_ACCOUNT_NUMBER = "CABankAccountNumber"
    """CA Bank Account Number"""
    CA_DRIVERS_LICENSE_NUMBER = "CADriversLicenseNumber"
    """CA Driver's License Number"""
    CA_HEALTH_SERVICE_NUMBER = "CAHealthServiceNumber"
    """CA Health Service Number"""
    CA_PASSPORT_NUMBER = "CAPassportNumber"
    """CA Passport Number"""
    CA_PERSONAL_HEALTH_IDENTIFICATION = "CAPersonalHealthIdentification"
    """CA Personal Health Identification"""
    CA_SOCIAL_INSURANCE_NUMBER = "CASocialInsuranceNumber"
    """CA Social Insurance Number"""
    CL_IDENTITY_CARD_NUMBER = "CLIdentityCardNumber"
    """CL Identity Card Number"""
    CN_RESIDENT_IDENTITY_CARD_NUMBER = "CNResidentIdentityCardNumber"
    """CN Resident Identity Card Number"""
    CREDIT_CARD_NUMBER = "CreditCardNumber"
    """Credit Card Number"""
    HR_IDENTITY_CARD_NUMBER = "HRIdentityCardNumber"
    """HR Identity Card Number"""
    HR_NATIONAL_ID_NUMBER = "HRNationalIDNumber"
    """HR National ID Number"""
    HR_PERSONAL_IDENTIFICATION_NUMBER = "HRPersonalIdentificationNumber"
    """HR Personal Identification Number"""
    HR_PERSONAL_IDENTIFICATION_OIB_NUMBER_V2 = "HRPersonalIdentificationOIBNumberV2"
    """HR Personal Identification OIB Number V2"""
    CY_IDENTITY_CARD = "CYIdentityCard"
    """CY Identity Card"""
    CY_TAX_IDENTIFICATION_NUMBER = "CYTaxIdentificationNumber"
    """CY Tax Identification Number"""
    CZ_PERSONAL_IDENTITY_NUMBER = "CZPersonalIdentityNumber"
    """CZ Personal Identity Number"""
    CZ_PERSONAL_IDENTITY_V2 = "CZPersonalIdentityV2"
    """CZ Personal Identity V2"""
    DK_PERSONAL_IDENTIFICATION_NUMBER = "DKPersonalIdentificationNumber"
    """DK Personal Identification Number"""
    DK_PERSONAL_IDENTIFICATION_V2 = "DKPersonalIdentificationV2"
    """DK Personal Identification V2"""
    DRUG_ENFORCEMENT_AGENCY_NUMBER = "DrugEnforcementAgencyNumber"
    """Drug Enforcement Agency Number"""
    EE_PERSONAL_IDENTIFICATION_CODE = "EEPersonalIdentificationCode"
    """EE Personal Identification Code"""
    EU_DEBIT_CARD_NUMBER = "EUDebitCardNumber"
    """EU Debit Card Number"""
    EU_DRIVERS_LICENSE_NUMBER = "EUDriversLicenseNumber"
    """EU Driver's License Number"""
    EU_GPS_COORDINATES = "EUGPSCoordinates"
    """EU GPS Coordinates"""
    EU_NATIONAL_IDENTIFICATION_NUMBER = "EUNationalIdentificationNumber"
    """EU National Identification Number"""
    EU_PASSPORT_NUMBER = "EUPassportNumber"
    """EU Passport Number"""
    EU_SOCIAL_SECURITY_NUMBER = "EUSocialSecurityNumber"
    """EU Social Security Number"""
    EU_TAX_IDENTIFICATION_NUMBER = "EUTaxIdentificationNumber"
    """EU Tax Identification Number"""
    FI_EUROPEAN_HEALTH_NUMBER = "FIEuropeanHealthNumber"
    """FI European Health Number"""
    FI_NATIONAL_ID = "FINationalID"
    """FI National ID"""
    FI_NATIONAL_ID_V2 = "FINationalIDV2"
    """FI National ID V2"""
    FI_PASSPORT_NUMBER = "FIPassportNumber"
    """FI Passport Number"""
    FR_DRIVERS_LICENSE_NUMBER = "FRDriversLicenseNumber"
    """FR Driver's License Number"""
    FR_HEALTH_INSURANCE_NUMBER = "FRHealthInsuranceNumber"
    """FR Health Insurance Number"""
    FR_NATIONAL_ID = "FRNationalID"
    """FR National ID"""
    FR_PASSPORT_NUMBER = "FRPassportNumber"
    """FR Passport Number"""
    FR_SOCIAL_SECURITY_NUMBER = "FRSocialSecurityNumber"
    """FR Social Security Number"""
    FR_TAX_IDENTIFICATION_NUMBER = "FRTaxIdentificationNumber"
    """FR Tax Identification Number"""
    FR_VALUE_ADDED_TAX_NUMBER = "FRValueAddedTaxNumber"
    """FR Value Added Tax Number"""
    DE_DRIVERS_LICENSE_NUMBER = "DEDriversLicenseNumber"
    """DE Driver's License Number"""
    DE_PASSPORT_NUMBER = "DEPassportNumber"
    """DE Passport Number"""
    DE_IDENTITY_CARD_NUMBER = "DEIdentityCardNumber"
    """DE Identity Card Number"""
    DE_TAX_IDENTIFICATION_NUMBER = "DETaxIdentificationNumber"
    """DE Tax Identification Number"""
    DE_VALUE_ADDED_NUMBER = "DEValueAddedNumber"
    """DE Value Added Number"""
    GR_NATIONAL_ID_CARD = "GRNationalIDCard"
    """GR National ID Card"""
    GR_NATIONAL_ID_V2 = "GRNationalIDV2"
    """GR National ID V2"""
    GR_TAX_IDENTIFICATION_NUMBER = "GRTaxIdentificationNumber"
    """GR Tax Identification Number"""
    HK_IDENTITY_CARD_NUMBER = "HKIdentityCardNumber"
    """HK Identity Card Number"""
    HU_VALUE_ADDED_NUMBER = "HUValueAddedNumber"
    """HU Value Added Number"""
    HU_PERSONAL_IDENTIFICATION_NUMBER = "HUPersonalIdentificationNumber"
    """HU Personal Identification Number"""
    HU_TAX_IDENTIFICATION_NUMBER = "HUTaxIdentificationNumber"
    """HU Tax Identification Number"""
    IN_PERMANENT_ACCOUNT = "INPermanentAccount"
    """IN Permanent Account"""
    IN_UNIQUE_IDENTIFICATION_NUMBER = "INUniqueIdentificationNumber"
    """IN Unique Identification Number"""
    ID_IDENTITY_CARD_NUMBER = "IDIdentityCardNumber"
    """ID Identity Card Number"""
    INTERNATIONAL_BANKING_ACCOUNT_NUMBER = "InternationalBankingAccountNumber"
    """International Banking Account Number"""
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER = "IEPersonalPublicServiceNumber"
    """IE Personal Public Service Number"""
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER_V2 = "IEPersonalPublicServiceNumberV2"
    """IE Personal Public Service Number V2"""
    IL_BANK_ACCOUNT_NUMBER = "ILBankAccountNumber"
    """IL Bank Account Number"""
    IL_NATIONAL_ID = "ILNationalID"
    """IL National ID"""
    IT_DRIVERS_LICENSE_NUMBER = "ITDriversLicenseNumber"
    """IT Driver's License Number"""
    IT_FISCAL_CODE = "ITFiscalCode"
    """IT Fiscal Code"""
    IT_VALUE_ADDED_TAX_NUMBER = "ITValueAddedTaxNumber"
    """IT Value Added Tax Number"""
    JP_BANK_ACCOUNT_NUMBER = "JPBankAccountNumber"
    """JP Bank Account Number"""
    JP_DRIVERS_LICENSE_NUMBER = "JPDriversLicenseNumber"
    """JP Driver's License Number"""
    JP_PASSPORT_NUMBER = "JPPassportNumber"
    """JP Passport Number"""
    JP_RESIDENT_REGISTRATION_NUMBER = "JPResidentRegistrationNumber"
    """JP Resident Registration Number"""
    JP_SOCIAL_INSURANCE_NUMBER = "JPSocialInsuranceNumber"
    """JP Social Insurance Number"""
    JP_MY_NUMBER_CORPORATE = "JPMyNumberCorporate"
    """JP My Number Corporate"""
    JP_MY_NUMBER_PERSONAL = "JPMyNumberPersonal"
    """JP My Number Personal"""
    JP_RESIDENCE_CARD_NUMBER = "JPResidenceCardNumber"
    """JP Residence Card Number"""
    LV_PERSONAL_CODE = "LVPersonalCode"
    """LV Personal Code"""
    LT_PERSONAL_CODE = "LTPersonalCode"
    """LT Personal Code"""
    LU_NATIONAL_IDENTIFICATION_NUMBER_NATURAL = "LUNationalIdentificationNumberNatural"
    """LU National Identification Number Natural"""
    LU_NATIONAL_IDENTIFICATION_NUMBER_NON_NATURAL = "LUNationalIdentificationNumberNonNatural"
    """LU National Identification Number Non Natural"""
    MY_IDENTITY_CARD_NUMBER = "MYIdentityCardNumber"
    """MY Identity Card Number"""
    MT_IDENTITY_CARD_NUMBER = "MTIdentityCardNumber"
    """MT Identity Card Number"""
    MT_TAX_ID_NUMBER = "MTTaxIDNumber"
    """MT Tax ID Number"""
    NL_CITIZENS_SERVICE_NUMBER = "NLCitizensServiceNumber"
    """NL Citizens Service Number"""
    NL_CITIZENS_SERVICE_NUMBER_V2 = "NLCitizensServiceNumberV2"
    """NL Citizens Service Number V2"""
    NL_TAX_IDENTIFICATION_NUMBER = "NLTaxIdentificationNumber"
    """NL Tax Identification Number"""
    NL_VALUE_ADDED_TAX_NUMBER = "NLValueAddedTaxNumber"
    """NL Value Added Tax Number"""
    NZ_BANK_ACCOUNT_NUMBER = "NZBankAccountNumber"
    """NZ Bank Account Number"""
    NZ_DRIVERS_LICENSE_NUMBER = "NZDriversLicenseNumber"
    """NZ Driver's License Number"""
    NZ_INLAND_REVENUE_NUMBER = "NZInlandRevenueNumber"
    """NZ Inland Revenue Number"""
    NZ_MINISTRY_OF_HEALTH_NUMBER = "NZMinistryOfHealthNumber"
    """NZ Ministry Of Health Number"""
    NZ_SOCIAL_WELFARE_NUMBER = "NZSocialWelfareNumber"
    """NZ Social Welfare Number"""
    NO_IDENTITY_NUMBER = "NOIdentityNumber"
    """NO Identity Number"""
    PH_UNIFIED_MULTI_PURPOSE_ID_NUMBER = "PHUnifiedMultiPurposeIDNumber"
    """PH Unified Multi Purpose ID Number"""
    PL_IDENTITY_CARD = "PLIdentityCard"
    """PL Identity Card"""
    PL_NATIONAL_ID = "PLNationalID"
    """PL National ID"""
    PL_NATIONAL_ID_V2 = "PLNationalIDV2"
    """PL National ID V2"""
    PL_PASSPORT_NUMBER = "PLPassportNumber"
    """PL Passport Number"""
    PL_TAX_IDENTIFICATION_NUMBER = "PLTaxIdentificationNumber"
    """PL Tax Identification Number"""
    PL_REGON_NUMBER = "PLREGONNumber"
    """PL REGON Number"""
    PT_CITIZEN_CARD_NUMBER = "PTCitizenCardNumber"
    """PT Citizen Card Number"""
    PT_CITIZEN_CARD_NUMBER_V2 = "PTCitizenCardNumberV2"
    """PT Citizen Card Number V2"""
    PT_TAX_IDENTIFICATION_NUMBER = "PTTaxIdentificationNumber"
    """PT Tax Identification Number"""
    RO_PERSONAL_NUMERICAL_CODE = "ROPersonalNumericalCode"
    """RO Personal Numerical Code"""
    RU_PASSPORT_NUMBER_DOMESTIC = "RUPassportNumberDomestic"
    """RU Passport Number Domestic"""
    RU_PASSPORT_NUMBER_INTERNATIONAL = "RUPassportNumberInternational"
    """RU Passport Number International"""
    SA_NATIONAL_ID = "SANationalID"
    """SA National ID"""
    SG_NATIONAL_REGISTRATION_IDENTITY_CARD_NUMBER = "SGNationalRegistrationIdentityCardNumber"
    """SG National Registration Identity Card Number"""
    SK_PERSONAL_NUMBER = "SKPersonalNumber"
    """SK Personal Number"""
    SI_TAX_IDENTIFICATION_NUMBER = "SITaxIdentificationNumber"
    """SI Tax Identification Number"""
    SI_UNIQUE_MASTER_CITIZEN_NUMBER = "SIUniqueMasterCitizenNumber"
    """SI Unique Master Citizen Number"""
    ZA_IDENTIFICATION_NUMBER = "ZAIdentificationNumber"
    """ZA Identification Number"""
    KR_RESIDENT_REGISTRATION_NUMBER = "KRResidentRegistrationNumber"
    """KR Resident Registration Number"""
    ES_DNI = "ESDNI"
    """ES DNI"""
    ES_SOCIAL_SECURITY_NUMBER = "ESSocialSecurityNumber"
    """ES Social Security Number"""
    ES_TAX_IDENTIFICATION_NUMBER = "ESTaxIdentificationNumber"
    """ES Tax Identification Number"""
    SQL_SERVER_CONNECTION_STRING = "SQLServerConnectionString"
    """SQL Server Connection String"""
    SE_NATIONAL_ID = "SENationalID"
    """SE National ID"""
    SE_NATIONAL_ID_V2 = "SENationalIDV2"
    """SE National ID V2"""
    SE_PASSPORT_NUMBER = "SEPassportNumber"
    """SE Passport Number"""
    SE_TAX_IDENTIFICATION_NUMBER = "SETaxIdentificationNumber"
    """SE Tax Identification Number"""
    SWIFT_CODE = "SWIFTCode"
    """SWIFT Code"""
    CH_SOCIAL_SECURITY_NUMBER = "CHSocialSecurityNumber"
    """CH Social Security Number"""
    TW_NATIONAL_ID = "TWNationalID"
    """TW National ID"""
    TW_PASSPORT_NUMBER = "TWPassportNumber"
    """TW Passport Number"""
    TW_RESIDENT_CERTIFICATE = "TWResidentCertificate"
    """TW Resident Certificate"""
    TH_POPULATION_IDENTIFICATION_CODE = "THPopulationIdentificationCode"
    """TH Population Identification Code"""
    TR_NATIONAL_IDENTIFICATION_NUMBER = "TRNationalIdentificationNumber"
    """TR National Identification Number"""
    UK_DRIVERS_LICENSE_NUMBER = "UKDriversLicenseNumber"
    """UK Driver's License Number"""
    UK_ELECTORAL_ROLL_NUMBER = "UKElectoralRollNumber"
    """UK Electoral Roll Number"""
    UK_NATIONAL_HEALTH_NUMBER = "UKNationalHealthNumber"
    """UK National Health Number"""
    UK_NATIONAL_INSURANCE_NUMBER = "UKNationalInsuranceNumber"
    """UK National Insurance Number"""
    UK_UNIQUE_TAXPAYER_NUMBER = "UKUniqueTaxpayerNumber"
    """UK Unique Taxpayer Number"""
    US_UK_PASSPORT_NUMBER = "USUKPassportNumber"
    """US UK Passport Number"""
    US_BANK_ACCOUNT_NUMBER = "USBankAccountNumber"
    """US Bank Account Number"""
    US_DRIVERS_LICENSE_NUMBER = "USDriversLicenseNumber"
    """US Driver's License Number"""
    US_INDIVIDUAL_TAXPAYER_IDENTIFICATION = "USIndividualTaxpayerIdentification"
    """US Individual Taxpayer Identification"""
    US_SOCIAL_SECURITY_NUMBER = "USSocialSecurityNumber"
    """US Social Security Number"""
    UA_PASSPORT_NUMBER_DOMESTIC = "UAPassportNumberDomestic"
    """UA Passport Number Domestic"""
    UA_PASSPORT_NUMBER_INTERNATIONAL = "UAPassportNumberInternational"
    """UA Passport Number International"""
    ORGANIZATION = "Organization"
    """Organization"""
    EMAIL = "Email"
    """Email"""
    URL = "URL"
    """URL"""
    AGE = "Age"
    """Age"""
    PHONE_NUMBER = "PhoneNumber"
    """Phone Number"""
    IP_ADDRESS = "IPAddress"
    """IP Address"""
    DATE = "Date"
    """Date"""
    PERSON = "Person"
    """Person"""
    ADDRESS = "Address"
    """Address"""
    DATE_OF_BIRTH = "DateOfBirth"
    """Date Of Birth"""
    BANK_ACCOUNT_NUMBER = "BankAccountNumber"
    """Bank Account Number"""
    PASSPORT_NUMBER = "PassportNumber"
    """Passport Number"""
    DRIVERS_LICENSE_NUMBER = "DriversLicenseNumber"
    """Drivers License Number"""
    NEIGHBORHOOD = "Neighborhood"
    """Neighborhood"""
    SORT_CODE = "SortCode"
    """Sort Code. 6-digit number used in the UK to identify a specific bank and branch where a bank
    account is held"""
    PIN = "PIN"
    """PIN"""
    VIN = "VIN"
    """VIN"""
    LICENSE_PLATE = "LicensePlate"
    """License Plate"""


class PiiCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """(Optional) describes the PII categories to return."""

    ABA_ROUTING_NUMBER = "ABARoutingNumber"
    """ABA Routing number"""
    AR_NATIONAL_IDENTITY_NUMBER = "ARNationalIdentityNumber"
    """AR National Identity Number"""
    AU_BANK_ACCOUNT_NUMBER = "AUBankAccountNumber"
    """AT Bank Account Number"""
    AU_DRIVERS_LICENSE_NUMBER = "AUDriversLicenseNumber"
    """AU Driver's License Number"""
    AU_MEDICAL_ACCOUNT_NUMBER = "AUMedicalAccountNumber"
    """AU Medical Account Number"""
    AU_PASSPORT_NUMBER = "AUPassportNumber"
    """AU Passport Number"""
    AU_TAX_FILE_NUMBER = "AUTaxFileNumber"
    """AU Tax File Number"""
    AU_BUSINESS_NUMBER = "AUBusinessNumber"
    """AU Business Number"""
    AU_COMPANY_NUMBER = "AUCompanyNumber"
    """AU Company Number"""
    AT_IDENTITY_CARD = "ATIdentityCard"
    """AT Identity Card"""
    AT_TAX_IDENTIFICATION_NUMBER = "ATTaxIdentificationNumber"
    """AT Tax Identification Number"""
    AT_VALUE_ADDED_TAX_NUMBER = "ATValueAddedTaxNumber"
    """AT Value Added Tax Number"""
    AZURE_DOCUMENT_DBAUTH_KEY = "AzureDocumentDBAuthKey"
    """Azure Document DB Auth Key"""
    AZURE_IAAS_DATABASE_CONNECTION_AND_SQL_STRING = "AzureIAASDatabaseConnectionAndSQLString"
    """Azure IAAS Database Connection And SQL String"""
    AZURE_IO_T_CONNECTION_STRING = "AzureIoTConnectionString"
    """Azure IoT Connection String"""
    AZURE_PUBLISH_SETTING_PASSWORD = "AzurePublishSettingPassword"
    """Azure Publish Setting Password"""
    AZURE_REDIS_CACHE_STRING = "AzureRedisCacheString"
    """Azure Redis Cache String"""
    AZURE_SAS = "AzureSAS"
    """Azure SAS"""
    AZURE_SERVICE_BUS_STRING = "AzureServiceBusString"
    """Azure Service Bus String"""
    AZURE_STORAGE_ACCOUNT_KEY = "AzureStorageAccountKey"
    """Azure Storage Account Key"""
    AZURE_STORAGE_ACCOUNT_GENERIC = "AzureStorageAccountGeneric"
    """Azure Storage Account Generic"""
    BE_NATIONAL_NUMBER = "BENationalNumber"
    """BE National Number"""
    BE_NATIONAL_NUMBER_V2 = "BENationalNumberV2"
    """BE National Number V2"""
    BE_VALUE_ADDED_TAX_NUMBER = "BEValueAddedTaxNumber"
    """BE Value Added Tax Number"""
    BR_CPF_NUMBER = "BRCPFNumber"
    """BR CPF Number"""
    BR_LEGAL_ENTITY_NUMBER = "BRLegalEntityNumber"
    """BR Legal Entity Number"""
    BR_NATIONAL_ID_RG = "BRNationalIDRG"
    """BR National ID RG"""
    BG_UNIFORM_CIVIL_NUMBER = "BGUniformCivilNumber"
    """BG Uniform Civil Number"""
    CA_BANK_ACCOUNT_NUMBER = "CABankAccountNumber"
    """CA Bank Account Number"""
    CA_DRIVERS_LICENSE_NUMBER = "CADriversLicenseNumber"
    """CA Driver's License Number"""
    CA_HEALTH_SERVICE_NUMBER = "CAHealthServiceNumber"
    """CA Health Service Number"""
    CA_PASSPORT_NUMBER = "CAPassportNumber"
    """CA Passport Number"""
    CA_PERSONAL_HEALTH_IDENTIFICATION = "CAPersonalHealthIdentification"
    """CA Personal Health Identification"""
    CA_SOCIAL_INSURANCE_NUMBER = "CASocialInsuranceNumber"
    """CA Social Insurance Number"""
    CL_IDENTITY_CARD_NUMBER = "CLIdentityCardNumber"
    """CL Identity Card Number"""
    CN_RESIDENT_IDENTITY_CARD_NUMBER = "CNResidentIdentityCardNumber"
    """CN Resident Identity Card Number"""
    CREDIT_CARD_NUMBER = "CreditCardNumber"
    """Credit Card Number"""
    HR_IDENTITY_CARD_NUMBER = "HRIdentityCardNumber"
    """HR Identity Card Number"""
    HR_NATIONAL_ID_NUMBER = "HRNationalIDNumber"
    """HR National ID Number"""
    HR_PERSONAL_IDENTIFICATION_NUMBER = "HRPersonalIdentificationNumber"
    """HR Personal Identification Number"""
    HR_PERSONAL_IDENTIFICATION_OIB_NUMBER_V2 = "HRPersonalIdentificationOIBNumberV2"
    """HR Personal Identification OIB Number V2"""
    CY_IDENTITY_CARD = "CYIdentityCard"
    """CY Identity Card"""
    CY_TAX_IDENTIFICATION_NUMBER = "CYTaxIdentificationNumber"
    """CY Tax Identification Number"""
    CZ_PERSONAL_IDENTITY_NUMBER = "CZPersonalIdentityNumber"
    """CZ Personal Identity Number"""
    CZ_PERSONAL_IDENTITY_V2 = "CZPersonalIdentityV2"
    """CZ Personal Identity V2"""
    DK_PERSONAL_IDENTIFICATION_NUMBER = "DKPersonalIdentificationNumber"
    """DK Personal Identification Number"""
    DK_PERSONAL_IDENTIFICATION_V2 = "DKPersonalIdentificationV2"
    """DK Personal Identification V2"""
    DRUG_ENFORCEMENT_AGENCY_NUMBER = "DrugEnforcementAgencyNumber"
    """Drug Enforcement Agency Number"""
    EE_PERSONAL_IDENTIFICATION_CODE = "EEPersonalIdentificationCode"
    """EE Personal Identification Code"""
    EU_DEBIT_CARD_NUMBER = "EUDebitCardNumber"
    """EU Debit Card Number"""
    EU_DRIVERS_LICENSE_NUMBER = "EUDriversLicenseNumber"
    """EU Driver's License Number"""
    EU_GPS_COORDINATES = "EUGPSCoordinates"
    """EU GPS Coordinates"""
    EU_NATIONAL_IDENTIFICATION_NUMBER = "EUNationalIdentificationNumber"
    """EU National Identification Number"""
    EU_PASSPORT_NUMBER = "EUPassportNumber"
    """EU Passport Number"""
    EU_SOCIAL_SECURITY_NUMBER = "EUSocialSecurityNumber"
    """EU Social Security Number"""
    EU_TAX_IDENTIFICATION_NUMBER = "EUTaxIdentificationNumber"
    """EU Tax Identification Number"""
    FI_EUROPEAN_HEALTH_NUMBER = "FIEuropeanHealthNumber"
    """FI European Health Number"""
    FI_NATIONAL_ID = "FINationalID"
    """FI National ID"""
    FI_NATIONAL_ID_V2 = "FINationalIDV2"
    """FI National ID V2"""
    FI_PASSPORT_NUMBER = "FIPassportNumber"
    """FI Passport Number"""
    FR_DRIVERS_LICENSE_NUMBER = "FRDriversLicenseNumber"
    """FR Driver's License Number"""
    FR_HEALTH_INSURANCE_NUMBER = "FRHealthInsuranceNumber"
    """FR Health Insurance Number"""
    FR_NATIONAL_ID = "FRNationalID"
    """FR National ID"""
    FR_PASSPORT_NUMBER = "FRPassportNumber"
    """FR Passport Number"""
    FR_SOCIAL_SECURITY_NUMBER = "FRSocialSecurityNumber"
    """FR Social Security Number"""
    FR_TAX_IDENTIFICATION_NUMBER = "FRTaxIdentificationNumber"
    """FR Tax Identification Number"""
    FR_VALUE_ADDED_TAX_NUMBER = "FRValueAddedTaxNumber"
    """FR Value Added Tax Number"""
    DE_DRIVERS_LICENSE_NUMBER = "DEDriversLicenseNumber"
    """DE Driver's License Number"""
    DE_PASSPORT_NUMBER = "DEPassportNumber"
    """DE Passport Number"""
    DE_IDENTITY_CARD_NUMBER = "DEIdentityCardNumber"
    """DE Identity Card Number"""
    DE_TAX_IDENTIFICATION_NUMBER = "DETaxIdentificationNumber"
    """DE Tax Identification Number"""
    DE_VALUE_ADDED_NUMBER = "DEValueAddedNumber"
    """DE Value Added Number"""
    GR_NATIONAL_ID_CARD = "GRNationalIDCard"
    """GR National ID Card"""
    GR_NATIONAL_ID_V2 = "GRNationalIDV2"
    """GR National ID V2"""
    GR_TAX_IDENTIFICATION_NUMBER = "GRTaxIdentificationNumber"
    """GR Tax Identification Number"""
    HK_IDENTITY_CARD_NUMBER = "HKIdentityCardNumber"
    """HK Identity Card Number"""
    HU_VALUE_ADDED_NUMBER = "HUValueAddedNumber"
    """HU Value Added Number"""
    HU_PERSONAL_IDENTIFICATION_NUMBER = "HUPersonalIdentificationNumber"
    """HU Personal Identification Number"""
    HU_TAX_IDENTIFICATION_NUMBER = "HUTaxIdentificationNumber"
    """HU Tax Identification Number"""
    IN_PERMANENT_ACCOUNT = "INPermanentAccount"
    """IN Permanent Account"""
    IN_UNIQUE_IDENTIFICATION_NUMBER = "INUniqueIdentificationNumber"
    """IN Unique Identification Number"""
    ID_IDENTITY_CARD_NUMBER = "IDIdentityCardNumber"
    """ID Identity Card Number"""
    INTERNATIONAL_BANKING_ACCOUNT_NUMBER = "InternationalBankingAccountNumber"
    """International Banking Account Number"""
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER = "IEPersonalPublicServiceNumber"
    """IE Personal Public Service Number"""
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER_V2 = "IEPersonalPublicServiceNumberV2"
    """IE Personal Public Service Number V2"""
    IL_BANK_ACCOUNT_NUMBER = "ILBankAccountNumber"
    """IL Bank Account Number"""
    IL_NATIONAL_ID = "ILNationalID"
    """IL National ID"""
    IT_DRIVERS_LICENSE_NUMBER = "ITDriversLicenseNumber"
    """IT Driver's License Number"""
    IT_FISCAL_CODE = "ITFiscalCode"
    """IT Fiscal Code"""
    IT_VALUE_ADDED_TAX_NUMBER = "ITValueAddedTaxNumber"
    """IT Value Added Tax Number"""
    JP_BANK_ACCOUNT_NUMBER = "JPBankAccountNumber"
    """JP Bank Account Number"""
    JP_DRIVERS_LICENSE_NUMBER = "JPDriversLicenseNumber"
    """JP Driver's License Number"""
    JP_PASSPORT_NUMBER = "JPPassportNumber"
    """JP Passport Number"""
    JP_RESIDENT_REGISTRATION_NUMBER = "JPResidentRegistrationNumber"
    """JP Resident Registration Number"""
    JP_SOCIAL_INSURANCE_NUMBER = "JPSocialInsuranceNumber"
    """JP Social Insurance Number"""
    JP_MY_NUMBER_CORPORATE = "JPMyNumberCorporate"
    """JP My Number Corporate"""
    JP_MY_NUMBER_PERSONAL = "JPMyNumberPersonal"
    """JP My Number Personal"""
    JP_RESIDENCE_CARD_NUMBER = "JPResidenceCardNumber"
    """JP Residence Card Number"""
    LV_PERSONAL_CODE = "LVPersonalCode"
    """LV Personal Code"""
    LT_PERSONAL_CODE = "LTPersonalCode"
    """LT Personal Code"""
    LU_NATIONAL_IDENTIFICATION_NUMBER_NATURAL = "LUNationalIdentificationNumberNatural"
    """LU National Identification Number Natural"""
    LU_NATIONAL_IDENTIFICATION_NUMBER_NON_NATURAL = "LUNationalIdentificationNumberNonNatural"
    """LU National Identification Number Non Natural"""
    MY_IDENTITY_CARD_NUMBER = "MYIdentityCardNumber"
    """MY Identity Card Number"""
    MT_IDENTITY_CARD_NUMBER = "MTIdentityCardNumber"
    """MT Identity Card Number"""
    MT_TAX_ID_NUMBER = "MTTaxIDNumber"
    """MT Tax ID Number"""
    NL_CITIZENS_SERVICE_NUMBER = "NLCitizensServiceNumber"
    """NL Citizens Service Number"""
    NL_CITIZENS_SERVICE_NUMBER_V2 = "NLCitizensServiceNumberV2"
    """NL Citizens Service Number V2"""
    NL_TAX_IDENTIFICATION_NUMBER = "NLTaxIdentificationNumber"
    """NL Tax Identification Number"""
    NL_VALUE_ADDED_TAX_NUMBER = "NLValueAddedTaxNumber"
    """NL Value Added Tax Number"""
    NZ_BANK_ACCOUNT_NUMBER = "NZBankAccountNumber"
    """NZ Bank Account Number"""
    NZ_DRIVERS_LICENSE_NUMBER = "NZDriversLicenseNumber"
    """NZ Driver's License Number"""
    NZ_INLAND_REVENUE_NUMBER = "NZInlandRevenueNumber"
    """NZ Inland Revenue Number"""
    NZ_MINISTRY_OF_HEALTH_NUMBER = "NZMinistryOfHealthNumber"
    """NZ Ministry Of Health Number"""
    NZ_SOCIAL_WELFARE_NUMBER = "NZSocialWelfareNumber"
    """NZ Social Welfare Number"""
    NO_IDENTITY_NUMBER = "NOIdentityNumber"
    """NO Identity Number"""
    PH_UNIFIED_MULTI_PURPOSE_ID_NUMBER = "PHUnifiedMultiPurposeIDNumber"
    """PH Unified Multi Purpose ID Number"""
    PL_IDENTITY_CARD = "PLIdentityCard"
    """PL Identity Card"""
    PL_NATIONAL_ID = "PLNationalID"
    """PL National ID"""
    PL_NATIONAL_ID_V2 = "PLNationalIDV2"
    """PL National ID V2"""
    PL_PASSPORT_NUMBER = "PLPassportNumber"
    """PL Passport Number"""
    PL_TAX_IDENTIFICATION_NUMBER = "PLTaxIdentificationNumber"
    """PL Tax Identification Number"""
    PL_REGON_NUMBER = "PLREGONNumber"
    """PL REGON Number"""
    PT_CITIZEN_CARD_NUMBER = "PTCitizenCardNumber"
    """PT Citizen Card Number"""
    PT_CITIZEN_CARD_NUMBER_V2 = "PTCitizenCardNumberV2"
    """PT Citizen Card Number V2"""
    PT_TAX_IDENTIFICATION_NUMBER = "PTTaxIdentificationNumber"
    """PT Tax Identification Number"""
    RO_PERSONAL_NUMERICAL_CODE = "ROPersonalNumericalCode"
    """RO Personal Numerical Code"""
    RU_PASSPORT_NUMBER_DOMESTIC = "RUPassportNumberDomestic"
    """RU Passport Number Domestic"""
    RU_PASSPORT_NUMBER_INTERNATIONAL = "RUPassportNumberInternational"
    """RU Passport Number International"""
    SA_NATIONAL_ID = "SANationalID"
    """SA National ID"""
    SG_NATIONAL_REGISTRATION_IDENTITY_CARD_NUMBER = "SGNationalRegistrationIdentityCardNumber"
    """SG National Registration Identity Card Number"""
    SK_PERSONAL_NUMBER = "SKPersonalNumber"
    """SK Personal Number"""
    SI_TAX_IDENTIFICATION_NUMBER = "SITaxIdentificationNumber"
    """SI Tax Identification Number"""
    SI_UNIQUE_MASTER_CITIZEN_NUMBER = "SIUniqueMasterCitizenNumber"
    """SI Unique Master Citizen Number"""
    ZA_IDENTIFICATION_NUMBER = "ZAIdentificationNumber"
    """ZA Identification Number"""
    KR_RESIDENT_REGISTRATION_NUMBER = "KRResidentRegistrationNumber"
    """KR Resident Registration Number"""
    ES_DNI = "ESDNI"
    """ES DNI"""
    ES_SOCIAL_SECURITY_NUMBER = "ESSocialSecurityNumber"
    """ES Social Security Number"""
    ES_TAX_IDENTIFICATION_NUMBER = "ESTaxIdentificationNumber"
    """ES Tax Identification Number"""
    SQL_SERVER_CONNECTION_STRING = "SQLServerConnectionString"
    """SQL Server Connection String"""
    SE_NATIONAL_ID = "SENationalID"
    """SE National ID"""
    SE_NATIONAL_ID_V2 = "SENationalIDV2"
    """SE National ID V2"""
    SE_PASSPORT_NUMBER = "SEPassportNumber"
    """SE Passport Number"""
    SE_TAX_IDENTIFICATION_NUMBER = "SETaxIdentificationNumber"
    """SE Tax Identification Number"""
    SWIFT_CODE = "SWIFTCode"
    """SWIFT Code"""
    CH_SOCIAL_SECURITY_NUMBER = "CHSocialSecurityNumber"
    """CH Social Security Number"""
    TW_NATIONAL_ID = "TWNationalID"
    """TW National ID"""
    TW_PASSPORT_NUMBER = "TWPassportNumber"
    """TW Passport Number"""
    TW_RESIDENT_CERTIFICATE = "TWResidentCertificate"
    """TW Resident Certificate"""
    TH_POPULATION_IDENTIFICATION_CODE = "THPopulationIdentificationCode"
    """TH Population Identification Code"""
    TR_NATIONAL_IDENTIFICATION_NUMBER = "TRNationalIdentificationNumber"
    """TR National Identification Number"""
    UK_DRIVERS_LICENSE_NUMBER = "UKDriversLicenseNumber"
    """UK Driver's License Number"""
    UK_ELECTORAL_ROLL_NUMBER = "UKElectoralRollNumber"
    """UK Electoral Roll Number"""
    UK_NATIONAL_HEALTH_NUMBER = "UKNationalHealthNumber"
    """UK National Health Number"""
    UK_NATIONAL_INSURANCE_NUMBER = "UKNationalInsuranceNumber"
    """UK National Insurance Number"""
    UK_UNIQUE_TAXPAYER_NUMBER = "UKUniqueTaxpayerNumber"
    """UK Unique Taxpayer Number"""
    US_UK_PASSPORT_NUMBER = "USUKPassportNumber"
    """US UK Passport Number"""
    US_BANK_ACCOUNT_NUMBER = "USBankAccountNumber"
    """US Bank Account Number"""
    US_DRIVERS_LICENSE_NUMBER = "USDriversLicenseNumber"
    """US Driver's License Number"""
    US_INDIVIDUAL_TAXPAYER_IDENTIFICATION = "USIndividualTaxpayerIdentification"
    """US Individual Taxpayer Identification"""
    US_SOCIAL_SECURITY_NUMBER = "USSocialSecurityNumber"
    """US Social Security Number"""
    UA_PASSPORT_NUMBER_DOMESTIC = "UAPassportNumberDomestic"
    """UA Passport Number Domestic"""
    UA_PASSPORT_NUMBER_INTERNATIONAL = "UAPassportNumberInternational"
    """UA Passport Number International"""
    ORGANIZATION = "Organization"
    """Organization"""
    EMAIL = "Email"
    """Email"""
    URL = "URL"
    """URL"""
    AGE = "Age"
    """Age"""
    PHONE_NUMBER = "PhoneNumber"
    """Phone Number"""
    IP_ADDRESS = "IPAddress"
    """IP Address"""
    DATE = "Date"
    """Date"""
    PERSON = "Person"
    """Person"""
    ADDRESS = "Address"
    """Address"""
    DATE_OF_BIRTH = "DateOfBirth"
    """Date Of Birth"""
    BANK_ACCOUNT_NUMBER = "BankAccountNumber"
    """Bank Account Number"""
    PASSPORT_NUMBER = "PassportNumber"
    """Passport Number"""
    DRIVERS_LICENSE_NUMBER = "DriversLicenseNumber"
    """Drivers License Number"""
    NEIGHBORHOOD = "Neighborhood"
    """Neighborhood"""
    SORT_CODE = "SortCode"
    """Sort Code. 6-digit number used in the UK to identify a specific bank and branch where a bank
    account is held"""
    PIN = "PIN"
    """PIN"""
    VIN = "VIN"
    """VIN"""
    LICENSE_PLATE = "LicensePlate"
    """License Plate"""
    ALL = "All"
    """All PII categories."""
    DEFAULT = "Default"
    """Default PII categories for the language."""


class PiiDomain(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PII domains."""

    PHI = "phi"
    """Indicates that entities in the Personal Health Information domain should be redacted."""
    NONE = "none"
    """Indicates that no domain is specified."""


class PolicyKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kinds of overlap policies supported."""

    MATCH_LONGEST = "matchLongest"
    """Represents MatchLongestEntityPolicyType"""
    ALLOW_OVERLAP = "allowOverlap"
    """Represents AllowOverlapEntityPolicyType"""


class RangeInclusivity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The range inclusiveness of this property property."""

    NONE_INCLUSIVE = "NoneInclusive"
    """No inclusivity"""
    LEFT_INCLUSIVE = "LeftInclusive"
    """Left side inclusive"""
    RIGHT_INCLUSIVE = "RightInclusive"
    """Right side inclusive"""
    LEFT_RIGHT_INCLUSIVE = "LeftRightInclusive"
    """Both sides inclusive"""


class RangeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the number range entity."""

    NUMBER = "Number"
    """Number range"""
    SPEED = "Speed"
    """Speed range"""
    WEIGHT = "Weight"
    """Weight range"""
    LENGTH = "Length"
    """Length range"""
    VOLUME = "Volume"
    """Volume range"""
    AREA = "Area"
    """Area range"""
    AGE = "Age"
    """Age range"""
    INFORMATION = "Information"
    """Information range"""
    TEMPERATURE = "Temperature"
    """Temperature range"""
    CURRENCY = "Currency"
    """Currency range"""


class RedactionCharacter(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional parameter to use a Custom Character to be used for redaction in PII responses. Default
    character will be * as before. We allow specific ascii characters for redaction.
    """

    EXCLAMATION_POINT = "!"
    """Exclamation point character"""
    NUMBER_SIGN = "#"
    """Number sign character"""
    DOLLAR = "$"
    """Dollar sign character"""
    PER_CENT = "%"
    """Percent sign character"""
    AMPERSAND = "&"
    """Ampersand character"""
    ASTERISK = "*"
    """Asterisk character"""
    PLUS = "+"
    """Plus sign character"""
    MINUS = "-"
    """Minus sign character"""
    EQUALS = "="
    """Equals sign character"""
    QUESTION_MARK = "?"
    """Question mark character"""
    AT_SIGN = "@"
    """At sign character"""
    CARET = "^"
    """Caret character"""
    UNDERSCORE = "_"
    """Underscore character"""
    TILDE = "~"
    """Tilde character"""


class RedactionPolicyKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kinds of redaction policies supported."""

    NO_MASK = "noMask"
    """Do not redact detected entities."""
    CHARACTER_MASK = "characterMask"
    """React detected entities with redaction character."""
    ENTITY_MASK = "entityMask"
    """Redact detected entities with entity type."""


class RelationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of relation. Examples include: ``DosageOfMedication`` or 'FrequencyOfMedication', etc."""

    ABBREVIATION = "Abbreviation"
    """Abbreviation"""
    DIRECTION_OF_BODY_STRUCTURE = "DirectionOfBodyStructure"
    """Direction of body structure"""
    DIRECTION_OF_CONDITION = "DirectionOfCondition"
    """Direction of condition"""
    DIRECTION_OF_EXAMINATION = "DirectionOfExamination"
    """Direction of examination"""
    DIRECTION_OF_TREATMENT = "DirectionOfTreatment"
    """Direction of treatment"""
    DOSAGE_OF_MEDICATION = "DosageOfMedication"
    """Dosage of medication"""
    FORM_OF_MEDICATION = "FormOfMedication"
    """Form of medication"""
    FREQUENCY_OF_MEDICATION = "FrequencyOfMedication"
    """Frequency of medication"""
    FREQUENCY_OF_TREATMENT = "FrequencyOfTreatment"
    """Frequency of treatment"""
    QUALIFIER_OF_CONDITION = "QualifierOfCondition"
    """Qualifier of condition"""
    RELATION_OF_EXAMINATION = "RelationOfExamination"
    """Relation of examination"""
    ROUTE_OF_MEDICATION = "RouteOfMedication"
    """Route of medication"""
    TIME_OF_CONDITION = "TimeOfCondition"
    """Time of condition"""
    TIME_OF_EVENT = "TimeOfEvent"
    """Time of event"""
    TIME_OF_EXAMINATION = "TimeOfExamination"
    """Time of examination"""
    TIME_OF_MEDICATION = "TimeOfMedication"
    """Time of medication"""
    TIME_OF_TREATMENT = "TimeOfTreatment"
    """Time of treatment"""
    UNIT_OF_CONDITION = "UnitOfCondition"
    """Unit of condition"""
    UNIT_OF_EXAMINATION = "UnitOfExamination"
    """Unit of examination"""
    VALUE_OF_CONDITION = "ValueOfCondition"
    """Value of condition"""
    VALUE_OF_EXAMINATION = "ValueOfExamination"
    """Value of examination"""
    BODY_SITE_OF_CONDITION = "BodySiteOfCondition"
    """Body site of condition"""
    BODY_SITE_OF_TREATMENT = "BodySiteOfTreatment"
    """Body site of treatment"""
    COURSE_OF_CONDITION = "CourseOfCondition"
    """Course of condition"""
    COURSE_OF_EXAMINATION = "CourseOfExamination"
    """Course of examination"""
    COURSE_OF_MEDICATION = "CourseOfMedication"
    """Course of medication"""
    COURSE_OF_TREATMENT = "CourseOfTreatment"
    """Course of treatment"""
    EXAMINATION_FINDS_CONDITION = "ExaminationFindsCondition"
    """Examination finds condition"""
    EXPRESSION_OF_GENE = "ExpressionOfGene"
    """Expression of gene"""
    EXPRESSION_OF_VARIANT = "ExpressionOfVariant"
    """Expression of variant"""
    FREQUENCY_OF_CONDITION = "FrequencyOfCondition"
    """Frequency of condition"""
    MUTATION_TYPE_OF_GENE = "MutationTypeOfGene"
    """Mutation type of gene"""
    MUTATION_TYPE_OF_VARIANT = "MutationTypeOfVariant"
    """Mutation type of variant"""
    SCALE_OF_CONDITION = "ScaleOfCondition"
    """Scale of condition"""
    VARIANT_OF_GENE = "VariantOfGene"
    """Variant of gene"""


class RelativeTo(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reference point that the ordinal number denotes."""

    CURRENT = "Current"
    """Current state or position"""
    END = "End"
    """End state or position"""
    START = "Start"
    """Start state or position"""


class ScriptCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifies the script of the input document. Maps to the ISO 15924 standard script code."""

    ARAB = "Arab"
    """Script code for the Arabic script."""
    ARMN = "Armn"
    """Script code for the Armenian script."""
    BENG = "Beng"
    """Script code for the Bangla script."""
    CANS = "Cans"
    """Script code for the UnifiedCanadianAboriginalSyllabics script."""
    CYRL = "Cyrl"
    """Script code for the Cyrillic script."""
    DEVA = "Deva"
    """Script code for the Devanagari script."""
    ETHI = "Ethi"
    """Script code for the Ethiopic script."""
    GEOR = "Geor"
    """Script code for the Georgian script."""
    GREK = "Grek"
    """Script code for the Greek script."""
    GUJR = "Gujr"
    """Script code for the Gujarati script."""
    GURU = "Guru"
    """Script code for the Gurmukhi script."""
    HANG = "Hang"
    """Script code for the Hangul script."""
    HANI = "Hani"
    """Script code for the HanLiteral script."""
    HANS = "Hans"
    """Script code for the HanSimplified script."""
    HANT = "Hant"
    """Script code for the HanTraditional script."""
    HEBR = "Hebr"
    """Script code for the Hebrew script."""
    JPAN = "Jpan"
    """Script code for the Japanese script."""
    KHMR = "Khmr"
    """Script code for the Khmer script."""
    KNDA = "Knda"
    """Script code for the Kannada script."""
    LAOO = "Laoo"
    """Script code for the Lao script."""
    LATN = "Latn"
    """Script code for the Latin script."""
    MLYM = "Mlym"
    """Script code for the Malayalam script."""
    MONG = "Mong"
    """Script code for the Mongolian script."""
    MTEI = "Mtei"
    """Script code for the Meitei script."""
    MYMR = "Mymr"
    """Script code for the Myanmar script."""
    OLCK = "Olck"
    """Script code for the Santali script."""
    ORYA = "Orya"
    """Script code for the Odia script."""
    SINH = "Sinh"
    """Script code for the Sinhala script."""
    SHRD = "Shrd"
    """Script code for the Sharada script."""
    TAML = "Taml"
    """Script code for the Tamil script."""
    TELU = "Telu"
    """Script code for the Telugu script."""
    THAA = "Thaa"
    """Script code for the Thaana script."""
    THAI = "Thai"
    """Script code for the Thai script."""
    TIBT = "Tibt"
    """Script code for the Tibetan script."""


class ScriptKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifies the script of the input document. Maps to the ISO 15924 standard formal name."""

    ARABIC = "Arabic"
    """Script name for the Arabic script."""
    ARMENIAN = "Armenian"
    """Script name for the Armenian script."""
    BANGLA = "Bangla"
    """Script name for the Bangla script."""
    UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = "UnifiedCanadianAboriginalSyllabics"
    """Script name for the UnifiedCanadianAboriginalSyllabics script."""
    CYRILLIC = "Cyrillic"
    """Script name for the Cyrillic script."""
    DEVANAGARI = "Devanagari"
    """Script name for the Devanagari script."""
    ETHIOPIC = "Ethiopic"
    """Script name for the Ethiopic script."""
    GEORGIAN = "Georgian"
    """Script name for the Georgian script."""
    GREEK = "Greek"
    """Script name for the Greek script."""
    GUJARATI = "Gujarati"
    """Script name for the Gujarati script."""
    GURMUKHI = "Gurmukhi"
    """Script name for the Gurmukhi script."""
    HANGUL = "Hangul"
    """Script name for the Hangul script."""
    HAN_LITERAL = "HanLiteral"
    """Script name for the HanLiteral script."""
    HAN_SIMPLIFIED = "HanSimplified"
    """Script name for the HanSimplified script."""
    HAN_TRADITIONAL = "HanTraditional"
    """Script name for the HanTraditional script."""
    HEBREW = "Hebrew"
    """Script name for the Hebrew script."""
    JAPANESE = "Japanese"
    """Script name for the Japanese script."""
    KHMER = "Khmer"
    """Script name for the Khmer script."""
    KANNADA = "Kannada"
    """Script name for the Kannada script."""
    LAO = "Lao"
    """Script name for the Lao script."""
    LATIN = "Latin"
    """Script name for the Latin script."""
    MALAYALAM = "Malayalam"
    """Script name for the Malayalam script."""
    MEITEI = "Meitei"
    """Script name for the Meitei script."""
    MONGOLIAN = "Mongolian"
    """Script name for the Mongolian script."""
    MYANMAR = "Myanmar"
    """Script name for the Myanmar script."""
    ODIA = "Odia"
    """Script name for the Odia script."""
    SANTALI = "Santali"
    """Script name for the Santali script."""
    SHARADA = "Sharada"
    """Script name for the Sharada script."""
    SINHALA = "Sinhala"
    """Script name for the Sinhala script."""
    TAMIL = "Tamil"
    """Script name for the Tamil script."""
    TELUGU = "Telugu"
    """Script name for the Telugu script."""
    THAANA = "Thaana"
    """Script name for the Thaana script."""
    THAI = "Thai"
    """Script name for the Thai script."""
    TIBETAN = "Tibetan"
    """Script name for the Tibetan script."""


class SentenceSentimentValue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The predicted Sentiment for the sentence."""

    POSITIVE = "positive"
    """Positive sentiment"""
    NEUTRAL = "neutral"
    """Neutral sentiment"""
    NEGATIVE = "negative"
    """Negative sentiment"""


class SpeedUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The speed Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified speed unit."""
    METERS_PER_SECOND = "MetersPerSecond"
    """Speed unit in meters per second."""
    KILOMETERS_PER_HOUR = "KilometersPerHour"
    """Speed unit in kilometers per hour."""
    KILOMETERS_PER_MINUTE = "KilometersPerMinute"
    """Speed unit in kilometers per minute."""
    KILOMETERS_PER_SECOND = "KilometersPerSecond"
    """Speed unit in kilometers per second."""
    MILES_PER_HOUR = "MilesPerHour"
    """Speed unit in miles per hour."""
    KNOTS = "Knots"
    """Speed unit in knots."""
    FEET_PER_SECOND = "FeetPerSecond"
    """Speed unit in feet per second."""
    FEET_PER_MINUTE = "FeetPerMinute"
    """Speed unit in feet per minute."""
    YARDS_PER_MINUTE = "YardsPerMinute"
    """Speed unit in yards per minute."""
    YARDS_PER_SECOND = "YardsPerSecond"
    """Speed unit in yards per second."""
    METERS_PER_MILLISECOND = "MetersPerMillisecond"
    """Speed unit in meters per millisecond."""
    CENTIMETERS_PER_MILLISECOND = "CentimetersPerMillisecond"
    """Speed unit in centimeters per millisecond."""
    KILOMETERS_PER_MILLISECOND = "KilometersPerMillisecond"
    """Speed unit in Kilometers per millisecond."""


class StringIndexType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes)
    according to Unicode v8.0.0. For additional information see
    `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_.
    """

    TEXT_ELEMENTS_V8 = "TextElements_v8"
    """Returned offset and length values will correspond to TextElements (Graphemes and Grapheme
    clusters) confirming to the Unicode 8.0.0 standard. Use this option if your application is
    written in .Net Framework or .Net Core and you will be using StringInfo."""
    UNICODE_CODE_POINT = "UnicodeCodePoint"
    """Returned offset and length values will correspond to Unicode code points. Use this option if
    your application is written in a language that support Unicode, for example Python."""
    UTF16_CODE_UNIT = "Utf16CodeUnit"
    """Returned offset and length values will correspond to UTF-16 code units. Use this option if your
    application is written in a language that support Unicode, for example Java, JavaScript."""


class SummaryLengthBucket(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum that defines the length of the output summaries."""

    SHORT = "short"
    """Instructs model to generate shorter length summaries."""
    MEDIUM = "medium"
    """Instructs model to generate medium length summaries."""
    LONG = "long"
    """Instructs model to generate longer length summaries."""


class TargetRelationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type related to the target."""

    ASSESSMENT = "assessment"
    """Assessment relation."""
    TARGET = "target"
    """Target relation."""


class TemperatureUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The temperature Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified temperature unit"""
    FAHRENHEIT = "Fahrenheit"
    """Temperature unit in Fahrenheit"""
    KELVIN = "Kelvin"
    """Temperature unit in Kelvin"""
    RANKINE = "Rankine"
    """Temperature unit in Rankine"""
    CELSIUS = "Celsius"
    """Temperature unit in Celsius"""


class TemporalModifier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An optional modifier of a date/time instance."""

    AFTER_APPROX = "AfterApprox"
    """After an approximate time"""
    BEFORE = "Before"
    """Before a specific time"""
    BEFORE_START = "BeforeStart"
    """Before the start of a time period"""
    APPROX = "Approx"
    """Approximately at a specific time"""
    REFERENCE_UNDEFINED = "ReferenceUndefined"
    """Reference to an undefined time"""
    SINCE_END = "SinceEnd"
    """Since the end of a time period"""
    AFTER_MID = "AfterMid"
    """After the middle of a time period"""
    START = "Start"
    """At the start of a time period"""
    AFTER = "After"
    """After a specific time"""
    BEFORE_END = "BeforeEnd"
    """Before the end of a time period"""
    UNTIL = "Until"
    """Until a specific time"""
    END = "End"
    """At the end of a time period"""
    LESS = "Less"
    """Less than a specific time"""
    SINCE = "Since"
    """Since a specific time"""
    AFTER_START = "AfterStart"
    """After the start of a time period"""
    BEFORE_APPROX = "BeforeApprox"
    """Before an approximate time"""
    MID = "Mid"
    """In the middle of a time period"""
    MORE = "More"
    """More than a specific time"""


class TextActionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the task at the mentioned last update time."""

    NOT_STARTED = "notStarted"
    """Not started status"""
    RUNNING = "running"
    """Running status"""
    SUCCEEDED = "succeeded"
    """Succeeded status"""
    PARTIALLY_COMPLETED = "partiallyCompleted"
    """Partially completed status"""
    FAILED = "failed"
    """Failed status"""
    CANCELLED = "cancelled"
    """Cancelled status"""
    CANCELLING = "cancelling"
    """Cancelling status"""


class TokenSentiment(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The predicted Sentiment for the sentence."""

    POSITIVE = "positive"
    """Positive sentiment"""
    MIXED = "mixed"
    """Mixed sentiment"""
    NEGATIVE = "negative"
    """Negative sentiment"""


class VolumeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Volume Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified volume unit."""
    CUBIC_METER = "CubicMeter"
    """Volume unit in cubic meters."""
    CUBIC_CENTIMETER = "CubicCentimeter"
    """Volume unit in cubic centimeters."""
    CUBIC_MILLIMETER = "CubicMillimeter"
    """Volume unit in cubic millimeters."""
    HECTOLITER = "Hectoliter"
    """Volume unit in hectoliters."""
    DECALITER = "Decaliter"
    """Volume unit in decaliters."""
    LITER = "Liter"
    """Volume unit in liters."""
    CENTILITER = "Centiliter"
    """Volume unit in centiliters."""
    MILLILITER = "Milliliter"
    """Volume unit in milliliters."""
    CUBIC_YARD = "CubicYard"
    """Volume unit in cubic yards."""
    CUBIC_INCH = "CubicInch"
    """Volume unit in cubic inches."""
    CUBIC_FOOT = "CubicFoot"
    """Volume unit in cubic feet."""
    CUBIC_MILE = "CubicMile"
    """Volume unit in cubic miles."""
    FLUID_OUNCE = "FluidOunce"
    """Volume unit in fluid ounces."""
    TEASPOON = "Teaspoon"
    """Volume unit in teaspoons."""
    TABLESPOON = "Tablespoon"
    """Volume unit in tablespoons."""
    PINT = "Pint"
    """Volume unit in pints."""
    QUART = "Quart"
    """Volume unit in quarts."""
    CUP = "Cup"
    """Volume unit in cups."""
    GILL = "Gill"
    """Volume unit in gills."""
    PINCH = "Pinch"
    """Volume unit in pinches."""
    FLUID_DRAM = "FluidDram"
    """Volume unit in fluid drams."""
    BARREL = "Barrel"
    """Volume unit in barrels."""
    MINIM = "Minim"
    """Volume unit in minims."""
    CORD = "Cord"
    """Volume unit in cords."""
    PECK = "Peck"
    """Volume unit in pecks."""
    BUSHEL = "Bushel"
    """Volume unit in bushels."""
    HOGSHEAD = "Hogshead"
    """Volume unit in hogsheads."""


class WarningCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the list of the warning codes."""

    LONG_WORDS_IN_DOCUMENT = "LongWordsInDocument"
    """Long words in document warning"""
    DOCUMENT_TRUNCATED = "DocumentTruncated"
    """Document truncated warning"""


class WeightUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The weight Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified weight unit"""
    KILOGRAM = "Kilogram"
    """Weight unit in kilograms"""
    GRAM = "Gram"
    """Weight unit in grams"""
    MILLIGRAM = "Milligram"
    """Weight unit in milligrams"""
    GALLON = "Gallon"
    """Volume unit in gallons"""
    METRIC_TON = "MetricTon"
    """Weight unit in metric tons"""
    TON = "Ton"
    """Weight unit in tons"""
    POUND = "Pound"
    """Weight unit in pounds"""
    OUNCE = "Ounce"
    """Weight unit in ounces"""
    GRAIN = "Grain"
    """Weight unit in grains"""
    PENNY_WEIGHT = "PennyWeight"
    """Weight unit in pennyweights"""
    LONG_TON_BRITISH = "LongTonBritish"
    """Weight unit in long tons (British)"""
    SHORT_TON_US = "ShortTonUS"
    """Weight unit in short tons (US)"""
    SHORT_HUNDRED_WEIGHT_US = "ShortHundredWeightUS"
    """Weight unit in short hundredweights (US)"""
    STONE = "Stone"
    """Weight unit in stones"""
    DRAM = "Dram"
    """Weight unit in drams"""
