/*
    SPDX-License-Identifier: GPL-2.0-or-later

    SPDX-FileCopyrightText: 2003 Brian Thomas <thomas@mail630.gsfc.nasa.gov>
    SPDX-FileCopyrightText: 2004-2021 Umbrello UML Modeller Authors <umbrello-devel@kde.org>
*/

#ifndef CODEBLOCK_H
#define CODEBLOCK_H

#include "textblock.h"

/**
 * A "chunk" of code within the code document.
 */
class CodeBlock : public TextBlock
{
public:

    /**
     * Describes the creation of the content.
     */
    enum ContentType {
        AutoGenerated=0,  ///< the content was generated by code generation itself
        UserGenerated     ///< the content was entered by the user
    };

    explicit CodeBlock(CodeDocument * parent, const QString & body = QString());
    virtual ~CodeBlock();

    void setContentType(ContentType new_var);
    ContentType contentType() const;

    static QString enumToString(const ContentType& val);

    virtual void saveToXMI(QXmlStreamWriter& writer);
    virtual void loadFromXMI(QDomElement & root);

    virtual void setAttributesFromObject(TextBlock * obj);

    friend QDebug operator<<(QDebug str, const CodeBlock& obj);

protected:

    virtual void setAttributesOnNode(QXmlStreamWriter& writer);
    virtual void setAttributesFromNode(QDomElement & element);

private:

    // specifies whether the content (text) of this object
    // was generated by the code generator or was supplied by the user (or some other way).
    ContentType m_contentType;

};

#endif // CODEBLOCK_H
